/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceManager;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnImageResource
extends AbstractInnerColumn<ImageResource>
implements Cloneable,
Serializable {
    private ResourceNode resourceNode = new ResourceNode();

    public InnerColumnImageResource(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(string, dataGroupValues, cellIdentifierModel, n);
    }

    @Override
    public AbstractInnerColumn<ImageResource> clone(DataGroupValues dataGroupValues) {
        InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)super.clone(dataGroupValues);
        if (this.resourceNode != null) {
            innerColumnImageResource.resourceNode = (ResourceNode)this.resourceNode.clone();
        }
        return innerColumnImageResource;
    }

    @Override
    public Class getGenericSuperClass() {
        return ImageResource.class;
    }

    public ResourceNode getResourceNode() {
        return this.resourceNode;
    }

    @Override
    public ImageResource getValueLocal(int n) {
        if (n >= 0 && n < this.resourceNode.getTreeNodeCount()) {
            return (ImageResource)this.resourceNode.getTreeNodeAt(n);
        }
        return null;
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        int n2 = randomInputStream.ReadBlockInt();
        if (n2 >= 0) {
            randomInputStream.setDataTreeManager(this.parent.getDataTreeManager());
            DataTreeInterface dataTreeInterface = randomInputStream.resolveNodeFromID(null, n2);
            if (dataTreeInterface instanceof ResourceNode) {
                this.resourceNode = (ResourceNode)randomInputStream.resolveNodeFromID(null, n2);
            }
        }
    }

    public void makeTransparent(Color color, Color color2) {
        int n = this.resourceNode.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            ImageResource imageResource = (ImageResource)this.resourceNode.get(i);
            imageResource.makeTransparent(color, color2);
        }
    }

    @Override
    public void removeIndex(int[] nArray) {
        for (int i = this.resourceNode.getTreeNodeCount() - 1; i >= 0; --i) {
            if (nArray[i] != -1) continue;
            this.resourceNode.removeTreeNodeAt(i);
        }
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        if (this.resourceNode != null && this.resourceNode.getID() != null) {
            randomOutputStream.WriteBlockInt(this.resourceNode.getID());
        } else {
            randomOutputStream.WriteBlockInt(-1);
        }
    }

    public void setResourceNode(ResourceNode resourceNode) {
        this.resourceNode = resourceNode;
    }

    public void setValueFromPath(File file, int n, String string) {
        try {
            File file2 = FileDataClass.isAbsolut(string) ? new File(string) : new File(file, string);
            ImageResource imageResource = ResourceManager.loadImage(file2);
            this.setValueLocal(n, imageResource);
        }
        catch (IOException iOException) {
            this.setValueLocal(n, ResourceManager.getEmptyResource());
        }
    }

    @Override
    public void setValueLocal(int n, ImageResource imageResource) {
        if (this.resourceNode.getTreeNodeCount() == n) {
            this.resourceNode.addTreeNode(imageResource);
        } else if (n >= 0 && n < this.resourceNode.getTreeNodeCount()) {
            this.resourceNode.setTreeNode(n, imageResource);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.resourceNode != null) {
            this.resourceNode = null;
        }
    }

    @Override
    protected AbstractInnerColumn<ImageResource> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnImageResource(string, dataGroupValues, abstractDataSource, n);
    }

    @Override
    protected int getSizeLocal() {
        if (this.resourceNode != null) {
            return this.resourceNode.getTreeNodeCount();
        }
        return 0;
    }

    @Override
    protected void insertLocal(int n, int n2) {
    }

    @Override
    protected void setSizeLocal(int n) {
    }
}

