/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnShort
extends AbstractInnerColumn<Integer> {
    protected short[] array;

    public InnerColumnShort(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(string, dataGroupValues, cellIdentifierModel, n);
    }

    @Override
    public AbstractInnerColumn<Integer> clone(DataGroupValues dataGroupValues) {
        InnerColumnShort innerColumnShort = (InnerColumnShort)super.clone(dataGroupValues);
        if (this.array != null) {
            innerColumnShort.array = (short[])this.array.clone();
        }
        return innerColumnShort;
    }

    @Override
    public Class getGenericSuperClass() {
        return Integer.class;
    }

    public short[] getArray() {
        return this.array;
    }

    public boolean getValueBool(int n) {
        if (this.array == null) {
            return false;
        }
        return this.array[n] > 0;
    }

    @Override
    public Integer getValueLocal(int n) {
        if (this.array == null) {
            return 0;
        }
        return this.array[n];
    }

    public short getValueShort(int n) {
        if (this.array != null && n >= 0 && n < this.array.length) {
            return this.array[n];
        }
        return 0;
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        if (n == 0) {
            this.array = new short[this.getRowsLocal()];
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = (short)randomInputStream.ReadBlockInt();
            }
        } else if (n >= 1) {
            int n2 = randomInputStream.ReadBlockInt();
            if (n2 > 0) {
                this.array = new short[n2];
                for (int i = 0; i < n2; ++i) {
                    this.array[i] = randomInputStream.ReadBlockShort();
                }
            } else {
                this.array = null;
            }
        }
    }

    @Override
    public void removeIndex(int[] nArray) {
        if (this.array != null) {
            short[] sArray = new short[this.array.length - nArray[nArray.length - 1]];
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] < 0) continue;
                sArray[i - nArray[i]] = this.array[i];
            }
            this.array = sArray;
        }
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        if (this.array == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            int n2 = this.array.length;
            randomOutputStream.WriteBlockInt(n2);
            for (int i = 0; i < n2; ++i) {
                randomOutputStream.WriteBlockShort(this.array[i]);
            }
        }
    }

    public void setArray(short[] sArray) {
        this.array = sArray;
    }

    @Override
    public void setValueLocal(int n, Integer n2) {
        if (this.array == null) {
            this.array = new short[this.getRowsLocal()];
        }
        this.array[n] = n2.shortValue();
    }

    public void setValueShort(int n, short s) {
        if (this.array == null) {
            this.array = new short[this.getRowsLocal()];
        }
        this.array[n] = s;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.array = null;
    }

    protected int countValue(short s) {
        int n = 0;
        if (this.array != null) {
            for (short s2 : this.array) {
                if (s2 != s) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    protected AbstractInnerColumn<Integer> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnShort(string, dataGroupValues, abstractDataSource, n);
    }

    @Override
    protected FastDecimal getDoubleLocal(int n, FastDecimal fastDecimal) {
        if (this.array == null) {
            fastDecimal.setValue(0.0);
        } else {
            fastDecimal.setValue(this.array[n]);
        }
        return fastDecimal;
    }

    @Override
    protected int getSizeLocal() {
        if (this.array == null) {
            return this.getRowsLocal();
        }
        return this.array.length;
    }

    @Override
    protected void insertLocal(int n, int n2) {
        if (this.array != null) {
            short[] sArray = new short[this.array.length + n2];
            System.arraycopy(this.array, 0, sArray, 0, n);
            System.arraycopy(this.array, n, sArray, n + n2, this.array.length - n);
            this.array = sArray;
        }
    }

    @Override
    protected void setSizeLocal(int n) {
        if (this.array != null && this.array.length < n) {
            short[] sArray = new short[n];
            System.arraycopy(this.array, 0, sArray, 0, Math.min(n, this.array.length));
            this.array = sArray;
        }
    }
}

