/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DNAclass;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnImageResource;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.Smiles;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.ProjectLink;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Test;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Train;
import se.prediktera.map.datasetcontainer.nodecase.ProjectDataSource;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ObservationInfo
extends AbstractDataInfo {
    public ObservationInfo(int n) {
        this(n, true, 0);
    }

    public ObservationInfo(int n, int n2) {
        this(n, true, n2);
    }

    public ObservationInfo(RandomInputStream randomInputStream, AbstractDataInfo abstractDataInfo) throws IOException {
        super(randomInputStream, abstractDataInfo);
    }

    public ObservationInfo(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    private ObservationInfo(int n, boolean bl, int n2) {
        super(n, bl, n2);
        if (bl) {
            this.addColumn("Train", 4);
            this.addColumn("Test", 5);
        }
    }

    @Override
    public Object clone() {
        DataGroupValues[] dataGroupValuesArray;
        ObservationInfo observationInfo = new ObservationInfo(this.getRowCount(), false, this.getGroupID());
        for (DataGroupValues dataGroupValues : dataGroupValuesArray = this.cloneDataGroupValues()) {
            observationInfo.addTreeNode(dataGroupValues);
        }
        return observationInfo;
    }

    @Override
    public void createDataFromModel(CellIdentifierModel cellIdentifierModel, ProgressManager progressManager, int n, int n2) {
        AbstractInnerColumn abstractInnerColumn;
        int n3 = cellIdentifierModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = cellIdentifierModel.getColumnType(i);
            progressManager.incStep();
            String string = null;
            if (n != -1) {
                string = (String)cellIdentifierModel.getValueAt(n, i);
            }
            if ((abstractInnerColumn = this.createInnerColumn(n4, n2 == i, string, cellIdentifierModel, i, true)) == null) continue;
            if (n4 == 3) {
                this.createClasses(cellIdentifierModel, abstractInnerColumn, i, string);
                continue;
            }
            if (n4 == 14) {
                this.createImages(cellIdentifierModel, abstractInnerColumn, i, string);
                continue;
            }
            if (cellIdentifierModel.isDataSource()) continue;
            this.createDescriptions(cellIdentifierModel, (InnerColumnString)abstractInnerColumn, i, n4 == 1);
        }
        if (cellIdentifierModel instanceof ProjectDataSource) {
            abstractInnerColumn = this.createInnerColumn(15, true, "Project Link", cellIdentifierModel, 0, true);
            this.createProjectLink(cellIdentifierModel, abstractInnerColumn, "Project Link");
        }
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public int[] getRef(boolean bl) {
        InnerColumnBooleanIncExc innerColumnBooleanIncExc = (InnerColumnBooleanIncExc)this.getPrimaryColumnByType(bl ? 4 : 5);
        InnerColumnBooleanIncExc innerColumnBooleanIncExc2 = (InnerColumnBooleanIncExc)this.getPrimaryColumnByType(1);
        if (innerColumnBooleanIncExc != null && innerColumnBooleanIncExc2 != null) {
            int n = innerColumnBooleanIncExc2.getSize();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!innerColumnBooleanIncExc2.getValueBool(i) || !innerColumnBooleanIncExc.getValueBool(i)) continue;
                ++n2;
            }
            if (n2 > 0) {
                int[] nArray = new int[n2];
                if (n2 < n) {
                    n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (!innerColumnBooleanIncExc2.getValueBool(i) || !innerColumnBooleanIncExc.getValueBool(i)) continue;
                        nArray[n2++] = i;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = i;
                    }
                }
                return nArray;
            }
        }
        return null;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public boolean isTest(int n) {
        Test test = (Test)this.getGroupColumnByType(5);
        return test.isIncluded(n);
    }

    public boolean isTrain(int n) {
        Train train = (Train)this.getGroupColumnByType(4);
        return train.isIncluded(n);
    }

    public void setTest(int[] nArray, boolean bl) {
        this.setInclude(nArray, (byte)5, bl, true);
    }

    public void setTest(int[] nArray, boolean bl, boolean bl2) {
        this.setInclude(nArray, (byte)5, bl, bl2);
    }

    public void setTrain(int[] nArray, boolean bl) {
        this.setTrain(nArray, bl, true);
    }

    public void setTrain(int[] nArray, boolean bl, boolean bl2) {
        this.setInclude(nArray, (byte)4, bl, bl2);
    }

    public void setTrainTest(int[] nArray, boolean bl, boolean bl2) {
        Test test = (Test)this.getGroupColumnByType(5);
        Train train = (Train)this.getGroupColumnByType(4);
        for (int n : nArray) {
            train.setIncluded(n, bl);
            test.setIncluded(n, bl2);
        }
    }

    @Override
    public String toString() {
        return "Observations";
    }

    @Override
    protected void createGroupValues(int n) {
        super.createGroupValues(n);
        this.addTreeNode(new Train(n));
        this.addTreeNode(new Test(n));
        this.addTreeNode(new Smiles(n));
        this.addTreeNode(new DNAclass(n));
        this.addTreeNode(new DataImage(n));
        this.addTreeNode(new ProjectLink(n));
    }

    private void createClasses(CellIdentifierModel cellIdentifierModel, AbstractInnerColumn abstractInnerColumn, int n, String string) {
        Object object;
        int n2;
        String[] stringArray;
        int n3;
        int n4 = cellIdentifierModel.getRowCount();
        InnerColumnString innerColumnString = (InnerColumnString)this.createInnerColumn(1, false, string, cellIdentifierModel, n, true);
        if (!cellIdentifierModel.isDataSource()) {
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                if (!cellIdentifierModel.isRowTypeData(i)) continue;
                Object object2 = cellIdentifierModel.getValueAt(i, n);
                innerColumnString.setValue(n5++, object2.toString());
            }
        }
        InnerColumnClass innerColumnClass = (InnerColumnClass)abstractInnerColumn;
        ClassTypes classTypes = innerColumnClass.getObject();
        int n6 = -1;
        if (cellIdentifierModel.getReferenceCategorys() > 0) {
            for (n3 = 0; n3 < cellIdentifierModel.getReferenceCategorys(); ++n3) {
                stringArray = cellIdentifierModel.getReferenceCategory(n3);
                if (!stringArray.equals(innerColumnClass.getName())) continue;
                n6 = n3;
                break;
            }
        }
        if (n6 >= 0) {
            classTypes.clear();
            String[] stringArray2 = cellIdentifierModel.getReferenceCategoryClasses(n6);
            stringArray = cellIdentifierModel.getReferenceCategoryColor(n6);
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                object = null;
                if (stringArray != null && n2 < stringArray.length) {
                    try {
                        object = PerfectSpread.getColorFromString(stringArray[n2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                classTypes.addStringNoEvent(stringArray2[n2], (Color)object);
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                if (!cellIdentifierModel.isRowTypeData(n3)) continue;
                classTypes.addSorted((String)cellIdentifierModel.getValueAt(n3, n));
            }
        }
        InnerColumnClass innerColumnClass2 = (InnerColumnClass)abstractInnerColumn;
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (!cellIdentifierModel.isRowTypeData(n2)) continue;
            object = (String)cellIdentifierModel.getValueAt(n2, n);
            innerColumnClass2.setValueShort(n7++, classTypes.getTypeDescriptionIndex((String)object));
        }
    }

    private void createDescriptions(CellIdentifierModel cellIdentifierModel, InnerColumnString innerColumnString, int n, boolean bl) {
        int n2 = cellIdentifierModel.getRowCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!cellIdentifierModel.isRowTypeData(i)) continue;
            innerColumnString.setValue(n3++, String.valueOf(cellIdentifierModel.getValueAt(i, n)));
        }
    }

    private void createImages(CellIdentifierModel cellIdentifierModel, AbstractInnerColumn abstractInnerColumn, int n, String string) {
        int n2 = cellIdentifierModel.getRowCount();
        InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)abstractInnerColumn;
        DataImage dataImage = (DataImage)innerColumnImageResource.getParent();
        dataImage.addTreeNode(innerColumnImageResource.getResourceNode());
        int n3 = 0;
        File file = cellIdentifierModel.getRootFolder();
        for (int i = 0; i < n2; ++i) {
            if (!cellIdentifierModel.isRowTypeData(i)) continue;
            String string2 = (String)cellIdentifierModel.getValueAt(i, n);
            innerColumnImageResource.setValueFromPath(file, n3, string2);
            ++n3;
        }
    }

    private void createProjectLink(CellIdentifierModel cellIdentifierModel, AbstractInnerColumn abstractInnerColumn, String string) {
        int n = cellIdentifierModel.getRowCount();
        InnerColumnString innerColumnString = (InnerColumnString)abstractInnerColumn;
        int n2 = 0;
        ProjectDataSource projectDataSource = (ProjectDataSource)cellIdentifierModel;
        for (int i = 0; i < n; ++i) {
            if (!cellIdentifierModel.isRowTypeData(i)) continue;
            String string2 = projectDataSource.getProjectLink(i);
            innerColumnString.setValue(n2, string2);
            ++n2;
        }
    }

    private void setInclude(int[] nArray, byte by, boolean bl, boolean bl2) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.getPrimaryColumnByType(by);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)this.getPrimaryColumnByType(1);
        int n = innerColumnBoolean2.getRowsLocal();
        if (bl2) {
            if (nArray != null) {
                for (int n2 : nArray) {
                    innerColumnBoolean2.setValueBool(n2, true);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    innerColumnBoolean2.setValueBool(i, true);
                }
            }
        }
        if (nArray != null) {
            for (int n2 : nArray) {
                innerColumnBoolean.setValueBool(n2, bl);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                innerColumnBoolean.setValueBool(i, bl);
            }
        }
    }
}

