/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationDataNode;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.datasettable.AbstractSettings;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MVframe;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.datainfo.varinfo.XYclass;
import se.prediktera.map.datasetcontainer.dataset.DataSetMatrix;
import se.prediktera.map.datasetcontainer.dataset.DataSetPredictionDialog;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetEvent;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetListener;
import se.prediktera.map.datasetcontainer.dataset.selection.AbstractSelectionInfo;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.TransformedReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransformInfo;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransformInfo;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.CategoryInfo;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceInfo;
import se.prediktera.map.datasetcontainer.transform.wizard.TransformationWizard;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.PropertiesElement;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.StringDataClass;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.model.ModelWrapper;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.model.modelgenerator.ModelGeneratorWizard;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.statistic.AbstractStatistic;

public class DataSet
extends PropagationDataNode
implements Cloneable,
DataMatrixListener {
    public static final byte XTR = 0;
    public static final byte XTE = 1;
    public static final byte YTR = 2;
    public static final byte YTE = 3;
    private static final String[] TYPENAME = new String[]{"X Training", "X Test", "Y Training", "Y Test"};
    public static final ImageIcon icon = AbstractPaint.createIcon(1);
    private DataContainer controlContainer;
    protected DataContainer transformedContainer;
    private DataContainer statisticContainer;
    private Case dataSetContainer;
    private AbstractDataInfo[] dataInfo = new AbstractDataInfo[2];
    private final AbstractDataMatrix[] controlMatrix = new AbstractDataMatrix[4];
    private TransformMatrix currentResult = null;
    private boolean iscreated = false;
    private boolean updatelocaltransformation;
    private boolean reload;
    public BitSet originalObs;

    private static int[] createArray(Double[] doubleArray, int n) {
        int[] nArray = new int[doubleArray.length - n];
        for (int i = n; i < doubleArray.length; ++i) {
            nArray[i - n] = Double.isInfinite(doubleArray[i]) ? Integer.MAX_VALUE : doubleArray[i].intValue() - 1;
        }
        return nArray;
    }

    public DataSet() {
        super("DataSet", true);
    }

    public DataSet(Case case_) {
        this(case_, case_.getDataInfo());
    }

    public DataSet(Case case_, int n, int n2) {
        this(case_, new AbstractDataInfo[]{new ObservationInfo(n), new VariablesInfo(n2)});
    }

    public DataSet(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        int n;
        this.dataSetContainer = (Case)mapProperty.resolveNodeFromName(randomInputStream, "parent");
        this.controlContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "cc");
        for (n = 0; n < 4; ++n) {
            this.controlMatrix[n] = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "cm" + n);
        }
        if (this.controlContainer == null) {
            this.controlContainer = new DataContainer("X and Y", -1);
            for (n = 0; n < 4; ++n) {
                this.controlContainer.addTreeNode(this.controlMatrix[n]);
            }
            this.addTreeNode(this.controlContainer);
        }
        this.transformedContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "tc");
        this.statisticContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "sc");
        n = 0;
        if (mapProperty.hasProperty("support")) {
            n = mapProperty.getLVBoolean() ? 1 : 0;
        }
        if (this.dataSetContainer != null) {
            this.initDataSet(this.dataSetContainer);
            if (n != 0) {
                this.dataInfo[0] = (AbstractDataInfo)mapProperty.resolveNodeFromName(randomInputStream, "obsinfo");
                this.dataInfo[1] = (AbstractDataInfo)mapProperty.resolveNodeFromName(randomInputStream, "varinfo");
            } else {
                randomInputStream.beginDataBlock("DataInfo", false);
                this.dataInfo[0] = new ObservationInfo(randomInputStream, this.dataSetContainer.getDataInfo(0));
                this.dataInfo[1] = new VariablesInfo(randomInputStream, this.dataSetContainer.getDataInfo(1));
                randomInputStream.endDataBlock();
                this.addTreeNode(this.dataInfo[0]);
                this.addTreeNode(this.dataInfo[1]);
            }
        }
        this.currentResult = (TransformMatrix)mapProperty.resolveNodeFromName(randomInputStream, "result");
        this.updatelocaltransformation = mapProperty.getPropertyBoolean("ult", false);
    }

    private DataSet(Case case_, AbstractDataInfo[] abstractDataInfoArray) {
        super("DataSet", true);
        this.initiate(case_, abstractDataInfoArray);
    }

    public void addData(int n, int n2, int n3, int n4, boolean bl) {
        if (n2 > 0) {
            this.getObsDataInfo().insertData(n, n2, bl);
        }
        if (n4 > 0) {
            this.getVarDataInfo().insertData(n3, n4, bl);
        }
        this.updateReferences();
    }

    public void addDescription(String[] stringArray, boolean bl) {
        this.dataInfo[bl ? 1 : 0].addDescription(stringArray, this.isProtected());
    }

    public void addToPopupMenu(final Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        if (project_GUI == null) {
            return;
        }
        jPopupMenu.add(project_GUI.getModel_GUI().getModelMenu(this));
        CMenu cMenu = AbstractStatistic.getStatisticMenu(this);
        if (cMenu != null) {
            jPopupMenu.add(cMenu);
        }
        jPopupMenu.add(project_GUI.getData_GUI().getTableMenu(this));
        jPopupMenu.addSeparator();
        CMenu cMenu2 = new CMenu("Apply Template", true);
        ScriptManager.addScriptToMenu(cMenu2, this, this, "table", "dataset");
        jPopupMenu.add(cMenu2);
        jPopupMenu.addSeparator();
        CMenuItem cMenuItem = new CMenuItem((Object)project_GUI.getData_GUI(), true);
        cMenuItem.setText("Clone DataSet");
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/clone.png")));
        cMenuItem.addActionListener(actionEvent -> this.cloneAndShowDataSet(project_GUI));
        jPopupMenu.add(cMenuItem);
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            CMenuItem cMenuItem2 = new CMenuItem((Object)project_GUI.getData_GUI(), true);
            cMenuItem2.setText("Hierarchy DataSet");
            cMenuItem2.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/clone.png")));
            cMenuItem2.addActionListener(actionEvent -> this.createHierarchyDataSet());
            jPopupMenu.add(cMenuItem2);
        }
        cMenuItem = new CMenuItem("Apply Changes", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSet.this.doUpdate(null);
            }
        };
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
        cMenuItem.setEnabled(this.hasChanged());
        jPopupMenu.add(cMenuItem);
        cMenuItem = new CMenuItem((Object)project_GUI, true);
        cMenuItem.setText("Delete");
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        cMenuItem.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete selected data set?", "Really delete?", 2);
            if (n != 0) {
                return;
            }
            Project_GUI project_GUI = this.getProject_GUI();
            this.cleanUp();
            if (project_GUI != null) {
                project_GUI.purgeSignal();
            }
        });
        jPopupMenu.add(cMenuItem);
        cMenuItem = new CMenuItem("Rename", true);
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        cMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for " + DataSet.this.name, DataSet.this.name);
                if (string != null) {
                    DataSet.this.setName(string);
                    DataSet.this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)DataSet.this, string));
                }
            }
        });
        jPopupMenu.add(cMenuItem);
        jPopupMenu.addSeparator();
        cMenuItem = new CMenuItem("Predict DataSet from Model", true);
        cMenuItem.addActionListener(actionEvent -> {
            final jopensaveDialog jopensaveDialog2 = ImportHelper.createModelDialog("Choose calibration model", null, true);
            jopensaveDialog2.setPreview(null, true);
            jopensaveDialog2.setMultiSelectionEnabled(false);
            if (jopensaveDialog2.openshow()) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                    final /* synthetic */ DataSet this$0;
                    {
                        this.this$0 = dataSet;
                    }

                    @Override
                    public Object doWork() {
                        try {
                            ArrayList arrayList;
                            Object object;
                            PropagationDataNode propagationDataNode;
                            File file = jopensaveDialog2.getSelectedFile();
                            PropagationDataNode propagationDataNode2 = new ArrayList();
                            boolean bl = LoadHelper.isProjectFile(file.getName());
                            if (bl) {
                                propagationDataNode = new ArrayList();
                                ModelManager.collectModels(this, file, propagationDataNode);
                                object = new Object[propagationDataNode.size() + 1];
                                object[0] = "All connect models";
                                for (int i = 0; i < propagationDataNode.size(); ++i) {
                                    object[i + 1] = propagationDataNode.get(i);
                                }
                                arrayList = JOptionPane.showInputDialog(this.getWindow(), "Select model from list", "Select model in project", 1, null, (Object[])object, null);
                                if (arrayList == null) {
                                    return null;
                                }
                                if (arrayList instanceof AbstractModel) {
                                    propagationDataNode2.add((AbstractModel)arrayList);
                                } else {
                                    propagationDataNode2 = propagationDataNode;
                                }
                            } else {
                                propagationDataNode2.add(ModelManager.loadModelIntoProject(this, file));
                            }
                            if (propagationDataNode2.isEmpty()) {
                                return null;
                            }
                            if (propagationDataNode2.size() == 1) {
                                propagationDataNode = (AbstractModel)propagationDataNode2.get(0);
                                if (propagationDataNode.getCase() != null) {
                                    propagationDataNode.getCase().setVisibleInTree(false);
                                } else {
                                    propagationDataNode.setVisibleInTree(false);
                                }
                                object = new JComboBoxCell();
                                ScriptManager.addScriptInfoComboBox((JComboBoxCell)object, "prediction", new Object[]{this.this$0, propagationDataNode});
                                arrayList = new ArrayList();
                                for (int i = 0; i < ((JComboBox)object).getItemCount(); ++i) {
                                    if (!(((JComboBox)object).getItemAt(i) instanceof AbstractScriptInfo)) continue;
                                    arrayList.add(((JComboBox)object).getItemAt(i));
                                }
                                DataSetPredictionDialog dataSetPredictionDialog = new DataSetPredictionDialog(this.getWindow(), this.this$0, (AbstractModel)propagationDataNode);
                                if (dataSetPredictionDialog.showModel()) {
                                    if (dataSetPredictionDialog.isNewPrediction()) {
                                        AbstractScriptInfo abstractScriptInfo = dataSetPredictionDialog.getScriptTemplate();
                                        if (abstractScriptInfo == null) {
                                            ((AbstractModel)propagationDataNode).createPrediction(this, this.this$0);
                                        } else {
                                            AbstractScriptInfo abstractScriptInfo2 = abstractScriptInfo;
                                            ScriptManager scriptManager = new ScriptManager(project_GUI);
                                            scriptManager.addVariable(this.this$0, "dataset");
                                            scriptManager.addVariable(propagationDataNode, "calibrationmodel");
                                            if (scriptManager.evaluteScript(this, abstractScriptInfo2.getScript(), false, true)) {
                                                if (propagationDataNode.getCase() != null) {
                                                    propagationDataNode.getCase().setVisibleInTree(true);
                                                } else {
                                                    propagationDataNode.setVisibleInTree(true);
                                                }
                                            } else if (propagationDataNode.getCase() != null) {
                                                propagationDataNode.getCase().cleanUp();
                                            } else {
                                                propagationDataNode.cleanUp();
                                            }
                                        }
                                    } else {
                                        ((AbstractModel)propagationDataNode).addPrediction(this, this.this$0, dataSetPredictionDialog.getPredCategory(), dataSetPredictionDialog.getPredClass());
                                    }
                                }
                            } else {
                                ModelManager.predictWithModelList(this, propagationDataNode2, this.this$0, null);
                            }
                            if (bl) {
                                propagationDataNode = this.this$0.getCase();
                                object = propagationDataNode2.iterator();
                                while (object.hasNext()) {
                                    propagationDataNode.addTreeNode((DataTreeInterface)object.next());
                                }
                            }
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                        return null;
                    }
                };
                IniManager.setWorkDir((byte)5, jopensaveDialog2.getCurrentDirectory());
                progressManagerImpl.invokeNow();
            }
        });
        jPopupMenu.add(cMenuItem);
    }

    public void applyChanges(ProgressManager progressManager) {
        this.applyChanges(progressManager, null);
    }

    public void applyChanges(ProgressManager progressManager, Properties properties) {
        int n = this.getDeciseconds();
        if (ScriptHelper.hasKey(properties, "deciseconds")) {
            this.setDeciseconds(ScriptHelper.getPropertyInt(properties, "deciseconds"));
        }
        this.doUpdate(progressManager);
        this.setDeciseconds(n);
    }

    public void checkApplyChangesNeeded() {
        boolean bl = false;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractModel) || !((AbstractModel)this.getTreeNodeAt(i)).getDatasetchanged()) continue;
            bl = true;
        }
        if (!bl) {
            this.doUpdate(null);
        }
    }

    public void checkMVmatrix(ProgressManager progressManager, byte by, int n, String string, int n2) {
        AbstractDataMatrix abstractDataMatrix = this.controlMatrix[by];
        if (abstractDataMatrix instanceof DataSetMatrix) {
            DataSetMatrix dataSetMatrix = (DataSetMatrix)abstractDataMatrix;
            this.checkMVmatrix(progressManager, dataSetMatrix, n, string, n2);
            this.updateReferences();
        }
    }

    public DataSet cloneAndShowDataSet(Project_GUI project_GUI) {
        return this.cloneAndShowDataSet(null, project_GUI);
    }

    public DataSet cloneAndShowDataSet(ProgressManager progressManager, Project_GUI project_GUI) {
        DataSet dataSet = this.cloneDataSet(progressManager, project_GUI);
        if (dataSet != null) {
            if (project_GUI != null) {
                dataSet.addDataSetToProject(project_GUI);
            }
            project_GUI.selectDataTree(dataSet);
        }
        return dataSet;
    }

    public void addDataSetToProject(Project_GUI project_GUI) {
        this.setCreated(project_GUI, false);
        Data_GUI data_GUI = project_GUI.getData_GUI();
        DataInit dataInit = new DataInit(this);
        DataSetTable dataSetTable = new DataSetTable(dataInit);
        DataSetTable dataSetTable2 = data_GUI.getTableForDataSet(this);
        if (dataSetTable2 != null) {
            dataSetTable.showControlTable(dataSetTable2.isObservationTableVisible());
        }
        data_GUI.addWindow((AbstractWindow)dataSetTable, false, true);
    }

    public DataSet cloneDataSet() {
        return this.cloneDataSet(true);
    }

    public DataSet cloneDataSet(boolean bl) {
        DataTreeManager dataTreeManager = this.getDataTreeManager();
        Project_GUI project_GUI = dataTreeManager != null ? dataTreeManager.getProject() : null;
        DataSet dataSet = this.cloneThisDataSet();
        dataSet.setCreated(project_GUI, false);
        if (bl) {
            DataContainer dataContainer = this.dataSetContainer.getDsContainer();
            String string = dataContainer.getUniqueName(this.toString());
            dataSet.setName(string);
            dataContainer.addTreeNode(dataSet);
        } else {
            dataSet.setDataTreeManager(dataTreeManager, false);
        }
        return dataSet;
    }

    public DataSet cloneDataSet(Component component) {
        return this.cloneDataSet(null, component);
    }

    public DataSet cloneDataSet(ProgressManager progressManager, Component component) {
        return this.cloneDataSet(progressManager, component, true);
    }

    public DataSet cloneDataSet(ProgressManager progressManager, Component component, boolean bl) {
        DataContainer dataContainer = this.dataSetContainer.getDsContainer();
        String string = dataContainer.getUniqueName(this.toString());
        if (bl) {
            string = JOptionPane.showInputDialog(component, "Enter the name for the new dataset", string);
        }
        if (string != null) {
            final DataSet dataSet = this.cloneThisDataSet();
            dataSet.setName(string);
            dataContainer.addTreeNode(dataSet);
            if (progressManager != null) {
                dataSet.doUpdateLocal(progressManager);
            } else {
                progressManager = new ProgressManagerImpl(this){

                    @Override
                    public Object doWork() {
                        dataSet.doUpdateLocal(this);
                        return null;
                    }
                };
                progressManager.invokeLater();
            }
            return dataSet;
        }
        return null;
    }

    public void close() {
        Project_GUI project_GUI = this.getProject_GUI();
        Case case_ = this.getCase();
        if (case_ != null) {
            case_.purge();
            case_.cleanUp();
        }
        if (project_GUI != null) {
            project_GUI.getProperties().clearProperties();
            project_GUI.purgeSignal();
        }
    }

    public void copyTransformations(DataSet dataSet, AbstractTransform.Type type) {
        VariablesInfo variablesInfo = this.getVarDataInfo();
        VariablesInfo variablesInfo2 = dataSet.getVarDataInfo();
        DataTreeInterface dataTreeInterface = variablesInfo.getTransformationNode(type);
        DataTreeInterface dataTreeInterface2 = variablesInfo2.getTransformationNode(type);
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface3 = dataTreeInterface.getTreeNodeAt(i);
            if (!(dataTreeInterface3 instanceof AbstractDataTransform)) continue;
            AbstractDataTransform abstractDataTransform = (AbstractDataTransform)dataTreeInterface3;
            dataTreeInterface2.addTreeNode(abstractDataTransform.cloneThis());
        }
    }

    public AbstractModel createModel(ProgressManager progressManager, String string) {
        return this.createModel(progressManager, string, null, null);
    }

    public AbstractModel createModel(ProgressManager progressManager, String string, Double d) {
        return this.createModel(progressManager, string, d, null);
    }

    public AbstractModel createModel(ProgressManager progressManager, String string, Properties properties) {
        return this.createModel(progressManager, string, null, properties);
    }

    public AbstractModel createModel(ProgressManager progressManager, String string, Double d, Properties properties) {
        this.updateReferences(progressManager, true);
        string = EvinceScriptCommands.removeSpace(string);
        int n = -1;
        if (d != null) {
            n = d.intValue();
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (!ScriptHelper.hasKey(properties, "crossvalidation") && !(this.getOriginalMatrix() instanceof LayerMatrix)) {
            properties.put("crossvalidation", "true");
            properties.put("cvfull", "true");
        }
        Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
        ModelGeneratorWizard.addExternModels(null, vector, null, true);
        for (int i = 0; i < vector.size(); ++i) {
            AbstractModelInfo abstractModelInfo = (AbstractModelInfo)vector.elementAt(i);
            if (!EvinceScriptCommands.removeSpace(abstractModelInfo.getType()).equalsIgnoreCase(string)) continue;
            DataTreeManager dataTreeManager = this.getDataTreeManager();
            if (dataTreeManager == null) {
                return null;
            }
            Project_GUI project_GUI = dataTreeManager.getProject();
            abstractModelInfo.beginWizard();
            AbstractModel abstractModel = abstractModelInfo.createModel(progressManager, this, n, properties);
            AbstractModelContainerWindow abstractModelContainerWindow = project_GUI.getModel_GUI().getModelWindow(abstractModelInfo);
            if (abstractModelContainerWindow != null) {
                abstractModelContainerWindow.getDataContainer().addShortcut(abstractModel);
            }
            return abstractModel;
        }
        throw new RuntimeException("Model " + string + " not found");
    }

    public AbstractTransform createModification(ProgressManager progressManager, String string, String string2) {
        return this.createModification(progressManager, string, string2, (Double[])null);
    }

    public AbstractTransform createModification(ProgressManager progressManager, String string, String string2, Double d) {
        return this.createModification(progressManager, string, string2, new Double[]{d}, null);
    }

    public AbstractTransform createModification(ProgressManager progressManager, String string, String string2, Double[] doubleArray) {
        return this.createModification(progressManager, string, string2, doubleArray, null);
    }

    public AbstractTransform createModification(ProgressManager progressManager, String string, String string2, Double[] doubleArray, Properties properties) {
        AbstractDataInfo abstractDataInfo;
        AbstractDataInfo abstractDataInfo2;
        boolean bl;
        int n = 1;
        if (string.equalsIgnoreCase("obs") || string.equalsIgnoreCase("obsdescr") || string.equalsIgnoreCase("obsid")) {
            bl = false;
            abstractDataInfo2 = this.getObsDataInfo();
            abstractDataInfo = this.getVarDataInfo();
            if (string.equalsIgnoreCase("obsdescr") || string.equalsIgnoreCase("obsid")) {
                n = 0;
            }
        } else if (string.equalsIgnoreCase("var") || string.equalsIgnoreCase("vardescr") || string.equalsIgnoreCase("varid")) {
            bl = true;
            abstractDataInfo2 = this.getVarDataInfo();
            abstractDataInfo = this.getObsDataInfo();
            if (string.equalsIgnoreCase("vardescr") || string.equalsIgnoreCase("varid")) {
                n = 0;
            }
        } else {
            throw new RuntimeException("Direction " + string + " is invalid");
        }
        string2 = EvinceScriptCommands.removeSpace(string2);
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
        TransformationWizard.addExternTransforms(bl, vector, this, abstractDataMatrix);
        for (int i = 0; i < vector.size(); ++i) {
            CleanUpInterface cleanUpInterface;
            CleanUpInterface cleanUpInterface2;
            AbstractTransformInfo abstractTransformInfo = (AbstractTransformInfo)vector.elementAt(i);
            if (!abstractTransformInfo.isType(string2)) continue;
            if (abstractTransformInfo instanceof CategoryInfo) {
                cleanUpInterface2 = (CategoryInfo)abstractTransformInfo;
                ((CategoryInfo)cleanUpInterface2).createWizard(this, abstractDataInfo2, abstractDataInfo);
                if (doubleArray != null && doubleArray.length > 0) {
                    ((CategoryInfo)cleanUpInterface2).setCreateFrom(n, doubleArray);
                } else {
                    ((CategoryInfo)cleanUpInterface2).setUsesettingspanel(false);
                }
            } else if (abstractTransformInfo instanceof ReduceInfo) {
                cleanUpInterface = (ReduceInfo)abstractTransformInfo;
                cleanUpInterface.createWizard(this, abstractDataInfo2, abstractDataInfo);
            } else {
                abstractTransformInfo.createWizard();
            }
            if (abstractTransformInfo instanceof AbstractDataTransformInfo) {
                ((AbstractDataTransformInfo)abstractTransformInfo).setProperties(properties);
            }
            cleanUpInterface2 = abstractTransformInfo.createTransform(abstractDataMatrix, !bl, abstractDataInfo2);
            if (properties != null) {
                ((AbstractTransform)cleanUpInterface2).setExtraArgument(properties);
            }
            cleanUpInterface = (LayerContainer)abstractDataInfo2.getTransformationNode(((AbstractTransform)cleanUpInterface2).getTransformationType());
            ((AbstractTransform)cleanUpInterface2).setCreated(this.getProject_GUI(), abstractDataInfo2);
            ((AbstractLayer)cleanUpInterface2).setLayerVisible(true);
            ((AbstractTransform)cleanUpInterface2).getInnerColumn(abstractDataInfo2.getTransformationNode());
            AbstractSettings.addSortedToPriority((LayerContainer)cleanUpInterface, (AbstractTransform)cleanUpInterface2);
            if (doubleArray != null && cleanUpInterface2 instanceof AbstractDataTransform) {
                ((AbstractDataTransform)cleanUpInterface2).includeFromScript(doubleArray);
            }
            this.doTransformation((AbstractTransform)cleanUpInterface2, progressManager);
            this.updateReferences(progressManager, true);
            ((AbstractTransform)cleanUpInterface2).workDone(null);
            abstractDataInfo2.triggerEvent(new DataInfoEvent(abstractDataInfo2, 0, (AbstractTransform)cleanUpInterface2));
            return cleanUpInterface2;
        }
        throw new RuntimeException("No such modification: " + string2);
    }

    public DataTreeInterface createModification(ProgressManager progressManager, String string, String string2, Properties properties) {
        return this.createModification(progressManager, string, string2, (Double[])null, properties);
    }

    public DataTreeInterface createModification(ProgressManager progressManager, String string, String string2, String string3) {
        return this.createModification(progressManager, string, string2, string3, null);
    }

    public DataTreeInterface createModification(ProgressManager progressManager, String string, String string2, String string3, Properties properties) {
        Double[] doubleArray = null;
        if (string3 == null) {
            ObservationInfo observationInfo = this.getObsDataInfo();
            IncExclude incExclude = (IncExclude)observationInfo.getGroupColumnByType(1);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            doubleArray = new Double[innerColumnBoolean.getNumber(true)];
            int n = 0;
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i)) continue;
                doubleArray[n++] = (double)i + 1.0;
            }
        }
        return this.createModification(progressManager, string, string2, doubleArray, properties);
    }

    public void createResultMatrix(boolean bl) {
        if (this.currentResult == null) {
            this.currentResult = new TransformMatrix(this.getParentMatrix());
            this.currentResult.setName("Transformed matrix");
            this.addTreeNode(this.currentResult);
            this.currentResult.setVisibleInTree(false);
        } else if (bl) {
            this.currentResult.setReferenceMatrix(null, this.getParentMatrix());
        }
        this.currentResult.updateReferences(true);
    }

    public TransformedReferenceMatrix createTransformed(byte by, AbstractDataMatrix abstractDataMatrix) {
        return this.createTransformed(by, this.getMatrix(by), abstractDataMatrix);
    }

    public TransformedReferenceMatrix createTransformed(byte by, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
        if (abstractDataMatrix == null) {
            return new TransformedReferenceMatrix(this.getMatrix(by), abstractDataMatrix2, abstractDataMatrix2);
        }
        return new TransformedReferenceMatrix(this.getMatrix(by), abstractDataMatrix, abstractDataMatrix2);
    }

    public void delete() {
        Project_GUI project_GUI = this.getProject_GUI();
        this.cleanUp();
        if (project_GUI != null) {
            project_GUI.purgeSignal();
        }
    }

    public void deleteModification(String string, AbstractTransform abstractTransform) {
        this.deleteModification(string, null, abstractTransform);
    }

    public void deleteModification(String string, String string2) {
        this.deleteModification(string, string2, null);
    }

    public boolean doTransformation(AbstractTransform abstractTransform) {
        return this.doTransformation(abstractTransform, null);
    }

    public boolean doTransformation(final AbstractTransform abstractTransform, ProgressManager progressManager) {
        if (abstractTransform == null || abstractTransform.isCleaned()) {
            return false;
        }
        if (abstractTransform.getTransformationType() == AbstractTransform.Type.localUpdate) {
            this.currentResult.addTransformation(abstractTransform);
            return true;
        }
        if (progressManager == null) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ DataSet this$0;
                {
                    this.this$0 = dataSet;
                }

                @Override
                public Object doWork() {
                    this.this$0.doTransformationLocal(abstractTransform, this);
                    return null;
                }
            };
            progressManagerImpl.invokeNow();
            return progressManagerImpl.getModalResults() == ProgressManager.Result.ok;
        }
        this.doTransformationLocal(abstractTransform, progressManager);
        return true;
    }

    public void doTransformations() {
        this.doTransformations(null);
    }

    public void doTransformations(ProgressManager progressManager) {
        int n;
        DataTreeInterface dataTreeInterface;
        if (this.getOriginalMatrix() == null) {
            return;
        }
        this.createResultMatrix(true);
        AbstractDataInfo[] abstractDataInfoArray = this.getDataInfo();
        this.clearAddedDescriptions();
        int n2 = 0;
        for (AbstractDataInfo abstractDataInfo : abstractDataInfoArray) {
            for (AbstractTransform.Type type : AbstractTransform.Type.values()) {
                dataTreeInterface = abstractDataInfo.getTransformationNode(type);
                for (n = 0; n < dataTreeInterface.getTreeNodeCount(); ++n) {
                    if (!(dataTreeInterface.getTreeNodeAt(n) instanceof AbstractTransform) || !this.doTransformation((AbstractTransform)dataTreeInterface.getTreeNodeAt(n), progressManager)) continue;
                    ++n2;
                }
            }
        }
        for (AbstractDataInfo abstractDataInfo : abstractDataInfoArray) {
            for (AbstractTransform.Type type : AbstractTransform.Type.values()) {
                dataTreeInterface = abstractDataInfo.getTransformationNode(type);
                for (n = 0; n < dataTreeInterface.getTreeNodeCount(); ++n) {
                    if (!(dataTreeInterface.getTreeNodeAt(n) instanceof AbstractTransform)) continue;
                    ((AbstractTransform)dataTreeInterface.getTreeNodeAt(n)).workDone(null);
                }
            }
        }
        this.transformationsChanged(progressManager, n2 > 0);
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    public void exclude(InteractionArray interactionArray) {
        this.getDataInfo("obs").setIncluded(interactionArray, false, false);
    }

    public void exclude(ProgressManager progressManager, String string) {
        this.exclude(progressManager, string, (Double[])null);
    }

    public void exclude(ProgressManager progressManager, String string, Double[] doubleArray) {
        if (doubleArray != null && doubleArray.length > 0) {
            this.getDataInfo(string).setIncluded(DataSet.createArray(doubleArray, 0), false);
        } else {
            this.getDataInfo(string).setIncluded(null, false);
        }
        this.updateReferences(progressManager, true);
    }

    public void exclude(ProgressManager progressManager, String string, String string2, Properties properties) {
        int n = 1;
        if (ScriptHelper.hasKey(properties, "min_variance")) {
            n = ScriptHelper.getPropertyInt(properties, "min_variance");
        }
        if (ScriptHelper.hasKey(properties, "min_variance_percent")) {
            double d = ScriptHelper.getPropertyDouble(properties, "min_variance_percent");
            AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
            n = (int)(d / 100.0 * (double)abstractDataMatrix.getN());
        }
        this.excludeNonVarying(progressManager, false, n);
    }

    public void exclude(String string, AbstractModel abstractModel, Double d) {
        this.exclude(string, abstractModel, new Double[]{d});
    }

    public void exclude(String string, AbstractModel abstractModel, Double[] doubleArray) {
        this.setByClass((byte)1, false, string, abstractModel, null, null, doubleArray);
    }

    public void exclude(String string, AbstractModel abstractModel, String string2) {
        this.setByClass((byte)1, false, string, abstractModel, null, string2, null);
    }

    public void exclude(String string, Category category, String string2) {
        AbstractDataInfo abstractDataInfo = this.getDataInfo(string);
        InnerColumnClass innerColumnClass = category.getInnerColumn();
        abstractDataInfo.setByClass((byte)1, innerColumnClass, string2, -1, false);
        this.updateReferences();
    }

    public void exclude(String string, String string2, Double d) {
        this.exclude(string, string2, new Double[]{d});
    }

    public void exclude(String string, String string2, Double[] doubleArray) {
        this.setByClass((byte)1, false, string, string2, null, doubleArray);
    }

    public void exclude(String string, String string2, String string3) {
        this.setByClass((byte)1, false, string, string2, string3, null);
    }

    public void excludeMissing(ProgressManager progressManager, String string, Properties properties) {
        int n = 0;
        double d = 0.0;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "no_min")) {
                n = ScriptHelper.getPropertyInt(properties, "no_min");
            }
            if (ScriptHelper.hasKey(properties, "min_ratio")) {
                d = ScriptHelper.getPropertyDouble(properties, "min_ratio");
            }
        }
        AbstractDataMatrix abstractDataMatrix = this.getMatrix(0);
        int n2 = abstractDataMatrix.getN();
        double d2 = abstractDataMatrix.getK();
        ArrayList<int[]> arrayList = new ArrayList<int[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            int n4 = 0;
            while ((double)n4 < d2) {
                double d3;
                double d4;
                if (abstractDataMatrix.isMissing(i, n4)) {
                    ++n3;
                } else if (n4 > 0 && (d4 = abstractDataMatrix.getValue(i, n4 - 1)) == (d3 = abstractDataMatrix.getValue(i, n4))) {
                    ++n3;
                }
                ++n4;
            }
            double d5 = (double)n3 / d2 * 100.0;
            if (!(d5 > d)) continue;
            arrayList.add(new int[]{i, n3});
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, (nArray, nArray2) -> Float.compare(nArray2[1], nArray[1]));
            IncExclude incExclude = (IncExclude)this.getObsDataInfo().getGroupColumnByType(1);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            int n5 = Math.min(arrayList.size(), n2 - n);
            for (int i = 0; i < n5; ++i) {
                int[] nArray3 = (int[])arrayList.get(i);
                innerColumnBoolean.setValueLocal(nArray3[0], false);
            }
            this.updateReferences(progressManager, true);
        }
    }

    public void excludeNonVarying(ProgressManager progressManager, boolean bl) {
        this.excludeNonVarying(progressManager, bl, 1);
    }

    public void excludeNonVarying(ProgressManager progressManager, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = false;
        if (this.excludeNonVarying(this.controlMatrix[0], n)) {
            bl3 = true;
        }
        if (bl && this.excludeNonVarying(this.controlMatrix[2], n)) {
            bl3 = true;
        }
        boolean bl4 = bl2 = bl && this.excludeMissingObservations(this.controlMatrix[2]);
        if (bl3 || bl2) {
            for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
                if (!(this.controlMatrix[n2] instanceof DataSetMatrix)) continue;
                ((DataSetMatrix)this.controlMatrix[n2]).updateReferences(progressManager, true);
            }
            if (bl3 && bl2) {
                Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Variables without variance and observations with missing Y-values were automatically excluded from the dataset", 7);
            } else if (bl2) {
                Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Observations with missing Y-values were automatically excluded from the dataset", 7);
            } else {
                Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Variables without variance were automatically excluded from the dataset", 7);
            }
        }
    }

    public Object get(String string) {
        if ((string = string.toLowerCase()).equalsIgnoreCase("file")) {
            File file;
            AbstractDataSource abstractDataSource = this.getCase().getDataSource();
            if (abstractDataSource != null && (file = abstractDataSource.getDataSourceFile()) != null) {
                return new FileDataClass(file);
            }
            throw new RuntimeException("Filepath is not accessible");
        }
        if (string.equalsIgnoreCase("name")) {
            return this.toString();
        }
        if (string.equalsIgnoreCase("originalmatrix")) {
            return this.getOriginalMatrix();
        }
        if (string.equalsIgnoreCase("case")) {
            return this.getCase();
        }
        if (string.equalsIgnoreCase("type")) {
            if (this instanceof DataSetGroup) {
                return "Group";
            }
            return "Standard";
        }
        if (string.equalsIgnoreCase("darkref") || string.equalsIgnoreCase("whiteref")) {
            AbstractDataSource abstractDataSource = this.getCase().getDataSource();
            return DataTreeManager.getChildByName(abstractDataSource, "Reference (" + (string.equalsIgnoreCase("darkref") ? 0 : 100) + "%)");
        }
        if (string.equalsIgnoreCase("observations")) {
            IncExclude incExclude = (IncExclude)this.getObsDataInfo().getGroupColumnByType(1);
            return (double)incExclude.size();
        }
        if (string.equalsIgnoreCase("variables")) {
            IncExclude incExclude = (IncExclude)this.getVarDataInfo().getGroupColumnByType(1);
            return (double)incExclude.size();
        }
        if (string.equalsIgnoreCase("included") || string.equalsIgnoreCase("noincluded")) {
            IncExclude incExclude = (IncExclude)this.getObsDataInfo().getGroupColumnByType(1);
            IncExclude incExclude2 = (IncExclude)this.getObsDataInfo().getGroupColumnByType(4);
            int n = incExclude2.getActiveTrueSize();
            if (string.equalsIgnoreCase("noincluded")) {
                return (double)n;
            }
            double[] dArray = new double[n];
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
            int n2 = 0;
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i) || !innerColumnBoolean2.getValueBool(i)) continue;
                dArray[n2++] = i + 1;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("yindex")) {
            VariablesInfo variablesInfo = this.getVarDataInfo();
            IncExclude incExclude = (IncExclude)variablesInfo.getGroupColumnByType(1);
            IncExclude incExclude3 = (IncExclude)variablesInfo.getGroupColumnByType(3);
            int n = variablesInfo.getActiveTrueSize(1);
            int n3 = this.getVarDataInfo().getActiveTrueSize(3);
            double[] dArray = new double[n - n3];
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)incExclude3.getPrimaryColumn();
            int n4 = 0;
            for (int i = 0; i < innerColumnBoolean3.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i) || innerColumnBoolean3.getValueBool(i)) continue;
                dArray[n4++] = i + 1;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("selection")) {
            return this.getProject_GUI().getInteractionArray(1, 0);
        }
        if (string.equalsIgnoreCase("projectproperties")) {
            return this.getProject_GUI().getProperties().getProjectPropertiesAll();
        }
        if (string.startsWith("obsindex_")) {
            String string2 = string.substring("obsindex_".length());
            InnerColumnString innerColumnString = (InnerColumnString)this.getObsDataInfo().getPrimaryColumnByType(0);
            for (int i = 0; i < innerColumnString.getSize(); ++i) {
                if (!innerColumnString.getValueLocal(i).equalsIgnoreCase(string2)) continue;
                return (double)(i + 1);
            }
            return null;
        }
        DataTreeInterface dataTreeInterface = this.controlContainer.getNodeByName(string);
        if (dataTreeInterface == null) {
            dataTreeInterface = this.getNodeByName(string);
        }
        if (dataTreeInterface != null) {
            return dataTreeInterface;
        }
        throw new RuntimeException("No such data matrix: " + string);
    }

    @Override
    public Case getCase() {
        if (this.dataSetContainer != null) {
            return this.dataSetContainer;
        }
        return super.getCase();
    }

    public List<InnerColumnClass> getCategories(AbstractDataInfo abstractDataInfo) {
        ArrayList<InnerColumnClass> arrayList = new ArrayList<InnerColumnClass>();
        Transformations transformations = (Transformations)abstractDataInfo.getGroupColumnByType(10);
        if (transformations != null) {
            for (int i = 0; i < transformations.getColumnCount(); ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                arrayList.add((InnerColumnClass)transformations.getInnerColumn(i));
            }
        }
        return arrayList;
    }

    public InnerColumnClass getCategory(AbstractDataInfo abstractDataInfo, String string) {
        for (InnerColumnClass innerColumnClass : this.getCategories(abstractDataInfo)) {
            if (!innerColumnClass.toString().equalsIgnoreCase(string)) continue;
            return innerColumnClass;
        }
        PredictionClasses predictionClasses = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
        if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
            for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                if (!((InnerColumnClass)predictionClasses.getInnerColumn(i)).toString().equalsIgnoreCase(string)) continue;
                return (InnerColumnClass)predictionClasses.getInnerColumn(i);
            }
        }
        throw new NoSuchCategoryException("No such category: " + string);
    }

    public InnerColumnClass getCategory(String string) {
        return this.getCategory(this.getObsDataInfo(), string);
    }

    public InnerColumnClass getCategroy(AbstractModel abstractModel) {
        PredictionClasses predictionClasses = (PredictionClasses)this.getObsDataInfo().getGroupColumnByType(11);
        return predictionClasses.getPredictionClass(abstractModel, "Pred. " + abstractModel.toString());
    }

    public AbstractDataInfo[] getDataInfo() {
        return this.dataInfo;
    }

    public AbstractDataInfo getDataInfo(int n) {
        if (this.dataInfo == null) {
            return null;
        }
        return this.dataInfo[n];
    }

    public Description getDescription(int n) {
        Description description = null;
        TransformMatrix transformMatrix = this.getResultMatrix();
        if (transformMatrix != null && !transformMatrix.hasMatrixChildren()) {
            description = n == 1 ? transformMatrix.getColumnDescription() : transformMatrix.getRowDescription();
        }
        if (description != null) {
            return description;
        }
        return (Description)this.getDataInfo(n).getGroupColumnByType(0);
    }

    public StringDataClass getEnv(String string) {
        Case case_ = this.getCase();
        if (case_ != null) {
            Properties properties = case_.getEnvProperties();
            return new StringDataClass(this.getPropertyIgnoreCase(properties, string, "ENV"));
        }
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return icon;
    }

    @Override
    public String getInformation() {
        VariablesInfo variablesInfo;
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Original Data:</TD><TD>");
        stringBuilder.append(this.getOriginalMatrix() == null ? "None" : this.getOriginalMatrix().toString()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Protection:</TD><TD>").append(this.isProtected() ? "Protected" : "Unprotected").append("</TD></TR>");
        ObservationInfo observationInfo = this.getObsDataInfo();
        if (observationInfo != null) {
            stringBuilder.append("<TR><TD><B>Observations:</B></TD></TR>");
            stringBuilder.append("<TR><TD>No:</TD><TD>").append(observationInfo.getRowCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Included:</TD><TD>");
            stringBuilder.append(observationInfo.getActiveTrueSize(1)).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Test:</TD><TD>");
            stringBuilder.append(observationInfo.getActiveTrueSize(5)).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Train:</TD><TD>");
            stringBuilder.append(observationInfo.getActiveTrueSize(4)).append("</TD></TR>");
        }
        if ((variablesInfo = this.getVarDataInfo()) != null) {
            int n = variablesInfo.getRowCount();
            int n2 = variablesInfo.getActiveTrueSize(1);
            int n3 = variablesInfo.getActiveTrueSize(3);
            stringBuilder.append("<TR><TD><B>Variables:</B></TD></TR>");
            stringBuilder.append("<TR><TD>No:</TD><TD>").append(n).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Included:</TD><TD>").append(n2).append("</TD></TR>");
            stringBuilder.append("<TR><TD>X:</TD><TD>").append(n3).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Y:</TD><TD>").append(n2 - n3).append("</TD></TR>");
        }
        return stringBuilder.toString();
    }

    public AbstractDataMatrix getMatrix(int n) {
        if (this.controlMatrix != null) {
            return this.controlMatrix[n];
        }
        return null;
    }

    public StringDataClass getMeta(String string) {
        Case case_ = this.getCase();
        if (case_ != null) {
            Properties properties = case_.getMetaProperties();
            return new StringDataClass(this.getPropertyIgnoreCase(properties, string, "META"));
        }
        return null;
    }

    public int getNrSubModels() {
        return this.dataSetContainer.getNrOfSubModels();
    }

    public ObservationInfo getObsDataInfo() {
        return (ObservationInfo)this.getDataInfo(0);
    }

    public AbstractDataMatrix getOriginalMatrix() {
        if (this.dataSetContainer != null) {
            return this.dataSetContainer.getOriginalMatrix();
        }
        return null;
    }

    public int getOriginalSize(int n) {
        AbstractDataMatrix abstractDataMatrix = this.getParentMatrix();
        if (abstractDataMatrix == null) {
            return 0;
        }
        if (n == 1) {
            return abstractDataMatrix.getK();
        }
        return abstractDataMatrix.getN();
    }

    public AbstractDataMatrix getParentMatrix() {
        return this.getOriginalMatrix();
    }

    public String getProperty(String string) {
        return this.getProperty(string, "");
    }

    public String getProperty(String string, String string2) {
        PropertiesElement propertiesElement;
        ProjectProperties projectProperties;
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null && (projectProperties = project_GUI.getProperties()) != null && (propertiesElement = projectProperties.getProperty(string)) != null) {
            return propertiesElement.value;
        }
        return string2;
    }

    public StringDataClass getRef(String string) {
        Case case_ = this.getCase();
        if (case_ != null) {
            Properties properties = case_.getRefProperties();
            return new StringDataClass(this.getPropertyIgnoreCase(properties, string, "REF"));
        }
        return null;
    }

    public TransformMatrix getResultMatrix() {
        if (this.currentResult == null) {
            this.createResultMatrix(false);
        }
        return this.currentResult;
    }

    @Override
    public String getScript() {
        String string = this.getUniqueName();
        StringBuilder stringBuilder = new StringBuilder().append(string).append(" = ").append("dataset.cloneDataSet();");
        stringBuilder.append(string).append(".setName(\"").append(this).append("\");");
        stringBuilder.append(this.dataInfo[0].getScript(string));
        stringBuilder.append(this.dataInfo[1].getScript(string));
        return stringBuilder.toString();
    }

    @Override
    public String getScriptName() {
        return "dataset";
    }

    public int getSize() {
        return 4;
    }

    public DataContainer getStatisticContainer() {
        return this.statisticContainer;
    }

    public ModelWrapper getSubModelAt(int n) {
        return this.dataSetContainer.getSubModelAt(n);
    }

    public AbstractDataMatrix getTransformedMatrix(byte by) {
        if (this.transformedContainer == null || by > this.transformedContainer.getTreeNodeCount()) {
            return null;
        }
        return (AbstractDataMatrix)this.transformedContainer.getTreeNodeAt(by);
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public byte getType() {
        return 9;
    }

    public VariablesInfo getVarDataInfo() {
        return (VariablesInfo)this.getDataInfo(1);
    }

    public boolean hasModels() {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractModel)) continue;
            return true;
        }
        return false;
    }

    public Double hasModification(String string, String string2) {
        return this.hasModificationBool(string, string2) ? 1.0 : 0.0;
    }

    public boolean hasModificationBool(String string, String string2) {
        return this.getModification(string, string2) != null;
    }

    public AbstractTransform getModification(String string, String string2) {
        AbstractDataInfo abstractDataInfo = this.getDataInfoByDirection(string);
        Transformations transformations = abstractDataInfo.getTransformationNode();
        if (transformations != null) {
            for (int i = 0; i < transformations.getColumnCount(); ++i) {
                AbstractTransform abstractTransform = transformations.getTransform(i);
                if (!abstractTransform.getName().equals(string2)) continue;
                return abstractTransform;
            }
        }
        return null;
    }

    public AbstractTransform getModificationByTreeType(String string, int n) {
        AbstractDataInfo abstractDataInfo = this.getDataInfoByDirection(string);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)abstractDataInfo.getPrimaryColumnByType(3);
        Transformations transformations = abstractDataInfo.getTransformationNode();
        if (transformations != null) {
            for (int i = 0; i < transformations.getColumnCount(); ++i) {
                AbstractTransform abstractTransform = transformations.getTransform(i);
                if (abstractTransform.getTreeType() != n || !this.appliedToX(innerColumnBoolean, abstractTransform)) continue;
                return abstractTransform;
            }
        }
        return null;
    }

    private boolean appliedToX(InnerColumnBoolean innerColumnBoolean, AbstractTransform abstractTransform) {
        if (innerColumnBoolean != null) {
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)abstractTransform.getInnerColumn();
            for (int i = 0; i < innerColumnBoolean2.getSize(); ++i) {
                if (!innerColumnBoolean2.getValueBool(i) || !innerColumnBoolean.getValueBool(i)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public AbstractTransform getModificationByTreeTypeFromResult(int n) {
        TransformMatrix transformMatrix = this.getResultMatrix();
        for (int i = 0; i < transformMatrix.getTreeNodeCount(); ++i) {
            AbstractTransform abstractTransform;
            DataTreeInterface dataTreeInterface = transformMatrix.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractTransform) || (abstractTransform = (AbstractTransform)dataTreeInterface).getTreeType() != n) continue;
            return abstractTransform;
        }
        return null;
    }

    public Double hasX() {
        try {
            return this.hasX(null);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public Double hasX(Properties properties) {
        return this.hasX(properties, 0);
    }

    public Double hasX(Properties properties, int n) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrix(0);
        if (abstractDataMatrix == null || abstractDataMatrix.getN() <= n || abstractDataMatrix.getK() <= n) {
            return 0.0;
        }
        if (abstractDataMatrix.getN() > 1) {
            int n2 = this.getMinVariance(abstractDataMatrix, properties, 1);
            ArrayList<Integer> arrayList = this.getVarianceList(abstractDataMatrix, n2);
            if (arrayList.size() < abstractDataMatrix.getK()) {
                return 1.0;
            }
            return 0.0;
        }
        return 1.0;
    }

    public Double hasY() {
        try {
            return this.hasY(null);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public Double hasY(Properties properties) {
        int n;
        AbstractDataMatrix abstractDataMatrix = this.getMatrix(2);
        ArrayList<Integer> arrayList = this.getVarianceList(abstractDataMatrix, n = this.getMinVariance(abstractDataMatrix, properties, 1));
        if (arrayList.size() == 0) {
            return 1.0;
        }
        return 0.0;
    }

    public void include(InteractionArray interactionArray) {
        this.getDataInfo("obs").setIncluded(interactionArray, true, false);
    }

    public void include(ProgressManager progressManager, String string, Double[] doubleArray) {
        if (doubleArray.length > 0) {
            this.getDataInfo(string).setIncluded(DataSet.createArray(doubleArray, 0), true);
        }
        this.updateReferences(progressManager, true);
    }

    public void include(String string, String string2, Double[] doubleArray) {
        this.setByClass((byte)1, true, string, string2, null, doubleArray);
    }

    public void include(String string, String string2, String string3) {
        this.setByClass((byte)1, true, string, string2, string3, null);
    }

    public void includeOnly(int[][] nArray, int[] nArray2) {
        this.includeOnly("obs", nArray, nArray2, null);
    }

    public void includeOnly(InteractionArray interactionArray) {
        int n = interactionArray.getSetCount();
        int[] nArray = new int[]{n};
        int[][] nArray2 = new int[1][n];
        int n2 = 0;
        for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
            if (!interactionArray.get(i)) continue;
            nArray2[0][n2++] = i;
        }
        this.includeOnly("obs", nArray2, nArray, null);
    }

    public void includeOnly(ProgressManager progressManager, String string, AbstractModel abstractModel, String string2, Double d) {
        this.includeOnly(progressManager, string, abstractModel, string2, d, null);
    }

    public void includeOnly(ProgressManager progressManager, String string, AbstractModel abstractModel, String string2, Double d, Properties properties) {
        if (string2.equals("dcrit")) {
            double d2 = abstractModel.getDcritX() * d;
            ModelMatrix modelMatrix = (ModelMatrix)abstractModel.getMatrixByName("ObsDMX");
            int[] nArray = modelMatrix.getKref();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < modelMatrix.getK(); ++i) {
                if (!(modelMatrix.getValue(0, i) > d2)) continue;
                arrayList.add((double)nArray[i] + 1.0);
            }
            if (arrayList.size() > 0) {
                Double[] doubleArray = new Double[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    doubleArray[i] = (Double)arrayList.get(i);
                }
                this.exclude(progressManager, "obs", doubleArray);
                this.applyChanges(progressManager);
            }
        } else {
            int[][] nArray = this.getIndexBySelectionAlgorithm(progressManager, abstractModel, string2, d, properties);
            if (nArray == null) {
                throw new RuntimeException("No such selection algorithm: " + string2);
            }
            this.includeOnly(nArray, null);
        }
    }

    public void includeOnly(String string, Category category, String string2) {
        this.includeOnly(string, category.toString(), string2, null);
    }

    public void includeOnly(String string, AbstractModel abstractModel, String string2) {
        this.includeOnly(string, abstractModel, string2, null);
    }

    public void includeOnly(String string, Category category, String string2, Properties properties) {
        this.includeOnly(string, category.toString(), string2, properties);
    }

    public void includeOnly(String string, Double[] doubleArray) {
        int[][] nArray = new int[1][doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            nArray[0][i] = doubleArray[i].intValue() - 1;
        }
        this.includeOnly(string, nArray, new int[]{doubleArray.length}, null);
    }

    public void includeOnly(String string, int[][] nArray, int[] nArray2, Properties properties) {
        int n;
        int n2;
        BasicTreeInterface basicTreeInterface;
        IncExclude incExclude;
        AbstractDataInfo abstractDataInfo;
        InnerColumnBoolean innerColumnBoolean = null;
        if (string.equalsIgnoreCase("obs")) {
            abstractDataInfo = this.getObsDataInfo();
            incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(4);
            basicTreeInterface = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
            innerColumnBoolean = (InnerColumnBoolean)((DataGroupValues)basicTreeInterface).getPrimaryColumn();
        } else {
            abstractDataInfo = this.getVarDataInfo();
            incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
        }
        basicTreeInterface = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        if (string.equalsIgnoreCase("obs")) {
            ((InnerColumnBoolean)basicTreeInterface).fillColumn(false);
            innerColumnBoolean.fillColumn(false);
        } else {
            IncExclude incExclude2 = (IncExclude)abstractDataInfo.getGroupColumnByType(3);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
            for (n2 = 0; n2 < ((AbstractInnerColumn)basicTreeInterface).getSize(); ++n2) {
                if (!innerColumnBoolean2.getValueBool(n2)) continue;
                ((InnerColumnBoolean)basicTreeInterface).setValueBool(n2, false);
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n].length;
            if (nArray2 != null) {
                n3 = nArray2[n];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                ((InnerColumnBoolean)basicTreeInterface).setValueBool(nArray[n][n2], true);
                if (innerColumnBoolean == null) continue;
                innerColumnBoolean.setValueBool(nArray[n][n2], true);
            }
        }
        n = 1;
        if (properties != null && ScriptHelper.hasKey(properties, "setchanged")) {
            n = ScriptHelper.getPropertyBool(properties, "setchanged") ? 1 : 0;
        }
        this.updateReferences(n != 0);
    }

    public void includeOnly(String string, String[] stringArray) {
        AbstractDataInfo abstractDataInfo = this.getDataInfo(string);
        InnerColumnString innerColumnString = (InnerColumnString)abstractDataInfo.getPrimaryColumnByType(0);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)abstractDataInfo.getPrimaryColumnByType(1);
        int n = innerColumnString.getSize();
        block0: for (int i = 0; i < n; ++i) {
            boolean bl = innerColumnBoolean.getValueBool(i);
            if (!bl) continue;
            innerColumnBoolean.setValueBool(i, false);
            String string2 = innerColumnString.getValueLocal(i);
            String[] stringArray2 = string2.split("_");
            string2 = stringArray2[0];
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                innerColumnBoolean.setValueBool(i, true);
                continue block0;
            }
        }
    }

    public void includeOnly(String string, String string2, String string3) {
        this.includeOnly(string, string2, string3, null);
    }

    public void includeOnly(String string, AbstractModel abstractModel, String string2, Properties properties) {
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "intersect")) {
            bl = ScriptHelper.getPropertyBool(properties, "intersect");
        }
        AbstractDataInfo abstractDataInfo = null;
        if (string.equalsIgnoreCase("obs")) {
            abstractDataInfo = this.getObsDataInfo();
        } else if (string.equalsIgnoreCase("var")) {
            abstractDataInfo = this.getVarDataInfo();
        }
        IncExclude incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        int[] nArray = null;
        if (bl) {
            nArray = innerColumnBoolean.getIndex(false);
        }
        innerColumnBoolean.fillColumn(false);
        this.setByClass((byte)1, true, string, abstractModel, null, string2, null);
        if (bl) {
            for (int n : nArray) {
                innerColumnBoolean.setValueBool(n, false);
            }
            this.updateReferences();
        }
    }

    public void includeOnly(String string, String string2, String string3, Properties properties) {
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "intersect")) {
            bl = ScriptHelper.getPropertyBool(properties, "intersect");
        }
        AbstractDataInfo abstractDataInfo = null;
        if (string.equalsIgnoreCase("obs")) {
            abstractDataInfo = this.getObsDataInfo();
        } else if (string.equalsIgnoreCase("var")) {
            abstractDataInfo = this.getVarDataInfo();
        }
        IncExclude incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        int[] nArray = null;
        if (bl) {
            nArray = innerColumnBoolean.getIndex(false);
        }
        innerColumnBoolean.fillColumn(false);
        this.setByClass((byte)1, true, string, string2, string3, null);
        if (bl) {
            for (int n : nArray) {
                innerColumnBoolean.setValueBool(n, false);
            }
            this.updateReferences();
        }
    }

    public double[] index(ProgressManager progressManager, AbstractModel abstractModel, String string, Double d) {
        return this.index(progressManager, abstractModel, string, d, null);
    }

    public double[] index(ProgressManager progressManager, AbstractModel abstractModel, String string, Double d, Properties properties) {
        int[][] nArray = this.getIndexBySelectionAlgorithm(progressManager, abstractModel, string, d, properties);
        int n = 0;
        for (int[] nArray2 : nArray) {
            n += nArray2.length;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int[] nArray3 : nArray) {
            for (int i = 0; i < nArray3.length; ++i) {
                dArray[n2++] = nArray3[i];
            }
        }
        return dArray;
    }

    public double[] index(String string, Object[] objectArray) {
        AbstractDataInfo abstractDataInfo = this.getDataInfo(string.equalsIgnoreCase("obs") ? 0 : 1);
        Description description = (Description)abstractDataInfo.getGroupColumnByType(0);
        InnerColumnString innerColumnString = (InnerColumnString)description.getPrimaryColumn();
        double[] dArray = new double[objectArray.length];
        block0: for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i].toString();
            for (int j = 0; j < innerColumnString.getSize(); ++j) {
                if (!string2.equalsIgnoreCase(innerColumnString.getValueLocal(j))) continue;
                dArray[i] = j + 1;
                continue block0;
            }
        }
        return dArray;
    }

    public double[] index(String string, String string2) {
        return this.index(string, new Object[]{string2});
    }

    public Double[] index(String string, String string2, String string3) {
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        Double[] doubleArray = this.getBounds(string3);
        return abstractDataMatrix.index(string, string2, doubleArray);
    }

    private Double[] getBounds(String string) {
        String[] stringArray = string.substring(1, string.length() - 1).split(",");
        Double[] doubleArray = new Double[stringArray.length];
        if (doubleArray.length != 4) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            doubleArray[i] = Double.valueOf(stringArray[i]);
        }
        return doubleArray;
    }

    public Double[] index(String string, String string2, Double[] doubleArray) {
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        return abstractDataMatrix.index(string, string2, doubleArray);
    }

    public boolean isExternal() {
        Case case_ = this.getCase();
        if (case_ != null) {
            return case_.isExternal();
        }
        return false;
    }

    public boolean isMultiLayer() {
        AbstractDataMatrix abstractDataMatrix = this.getParentMatrix();
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.isFoldable();
        }
        return false;
    }

    public boolean isUpdateLocalTransformation() {
        return this.updatelocaltransformation;
    }

    public Object[] list(String string) {
        return this.list(null, string);
    }

    public Object[] list(String string, String string2) {
        DataGroupValues dataGroupValues;
        AbstractDataInfo abstractDataInfo;
        if (string2.equalsIgnoreCase("categories")) {
            if (string == null) {
                throw new RuntimeException("Type (" + string2 + ") + required direction parameter");
            }
            abstractDataInfo = this.getDataInfo(string.equalsIgnoreCase("obs") ? 0 : 1);
            dataGroupValues = (Transformations)abstractDataInfo.getGroupColumnByType(10);
            if (dataGroupValues != null) {
                ArrayList<InnerColumnClass> arrayList = new ArrayList<InnerColumnClass>();
                for (int i = 0; i < ((Transformations)dataGroupValues).getColumnCount(); ++i) {
                    if (((Transformations)dataGroupValues).getColumnType(i) != 4) continue;
                    arrayList.add((InnerColumnClass)((Transformations)dataGroupValues).getInnerColumn(i));
                }
                PredictionClasses predictionClasses = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
                if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
                    for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                        arrayList.add((InnerColumnClass)predictionClasses.getInnerColumn(i));
                    }
                }
                Object[] objectArray = new InnerColumnClass[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray[i] = (InnerColumnClass)arrayList.get(i);
                }
                return objectArray;
            }
        } else {
            if (string2.equalsIgnoreCase("model")) {
                ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
                for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                    if (!(this.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                    arrayList.add((AbstractModel)this.getTreeNodeAt(i));
                }
                return arrayList.toArray();
            }
            if (string2.equalsIgnoreCase("included") || string2.equalsIgnoreCase("included_obs") || string2.equalsIgnoreCase("excluded")) {
                IncExclude incExclude = (IncExclude)this.getObsDataInfo().getGroupColumnByType(1);
                IncExclude incExclude2 = (IncExclude)this.getObsDataInfo().getGroupColumnByType(4);
                boolean bl = !string2.equalsIgnoreCase("excluded");
                ArrayList<Double> arrayList = new ArrayList<Double>();
                InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
                InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
                for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                    if (innerColumnBoolean.getValueBool(i) != bl || !bl && !innerColumnBoolean2.getValueBool(i)) continue;
                    arrayList.add((double)i + 1.0);
                }
                if (string2.equalsIgnoreCase("included_obs")) {
                    InnerColumnString innerColumnString = (InnerColumnString)this.getObsDataInfo().getPrimaryColumnByType(0);
                    Object[] objectArray = new String[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        objectArray[i] = innerColumnString.getValueLocal(((Double)arrayList.get(i)).intValue() - 1);
                    }
                    return objectArray;
                }
                Object[] objectArray = new Double[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray[i] = (Double)arrayList.get(i);
                }
                return objectArray;
            }
        }
        abstractDataInfo = this.getVarDataInfo();
        dataGroupValues = (IncExclude)abstractDataInfo.getGroupColumnByType(3);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataGroupValues.getPrimaryColumn();
        LinkedList<String> linkedList = new LinkedList<String>();
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (i >= abstractDataMatrix.getK() || innerColumnBoolean.getValueBool(i)) continue;
            linkedList.add(abstractDataMatrix.getColumnDescription(i, 0));
        }
        return linkedList.toArray();
    }

    @Override
    public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
        this.updateReferences(dataMatrixEvent.getProgressManager(), true);
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
    }

    public void removeDataInfo() {
        if (this.dataInfo != null) {
            if (this.dataInfo[0] != null) {
                this.removeTreeNode(this.dataInfo[0]);
            }
            if (this.dataInfo[1] != null) {
                this.removeTreeNode(this.dataInfo[1]);
            }
        }
        this.dataInfo = new AbstractDataInfo[]{new ObservationInfo(0), new VariablesInfo(0)};
    }

    public void removeIndex(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray != null) {
            this.getObsDataInfo().removeIndex(nArray, bl);
        }
        if (nArray2 != null) {
            this.getVarDataInfo().removeIndex(nArray2, bl);
        }
        this.updateReferences();
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("name", this.toString());
        randomOutputStream.writePropertyNode("parent", this.dataSetContainer);
        randomOutputStream.writePropertyNode("cc", this.controlContainer);
        randomOutputStream.writePropertyNode("tc", this.transformedContainer);
        randomOutputStream.writePropertyNode("sc", this.statisticContainer);
        for (int i = 0; i < 4; ++i) {
            randomOutputStream.writePropertyNode("cm" + i, this.controlMatrix[i]);
        }
        randomOutputStream.writePropertyBoolean("support", true);
        randomOutputStream.writePropertyNode("obsinfo", this.dataInfo[0]);
        randomOutputStream.writePropertyNode("varinfo", this.dataInfo[1]);
        randomOutputStream.writePropertyNode("result", this.currentResult);
        randomOutputStream.writePropertyBoolean("ult", this.updatelocaltransformation);
    }

    public void select(Double[] doubleArray) {
        Project_GUI project_GUI = this.getProject_GUI();
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        InteractionArray interactionArray = project_GUI.getInteractionArray(this, 1, abstractDataMatrix.getN(), 0);
        for (Double d : doubleArray) {
            interactionArray.set((int)(d - 1.0));
        }
        DataSet.doInteractionOnly(project_GUI, interactionArray);
    }

    public void select(InteractionArray interactionArray) {
        Project_GUI project_GUI = this.getProject_GUI();
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        InteractionArray interactionArray2 = project_GUI.getInteractionArray(this, 1, abstractDataMatrix.getN(), 0);
        for (int i = 0; i < interactionArray.size(); ++i) {
            interactionArray2.set(i, interactionArray.get(i));
        }
        DataSet.doInteractionOnly(project_GUI, interactionArray2);
    }

    private static void doInteractionOnly(Project_GUI project_GUI, final InteractionArray interactionArray) {
        project_GUI.doInteractionOnly(new InteractionInterface(){

            @Override
            public boolean doInteraction(InteractionInterface interactionInterface) {
                return false;
            }

            @Override
            public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
            }

            @Override
            public void finishInteraction() {
            }

            public InteractionArray getInteractionArray(int n) {
                return interactionArray;
            }

            @Override
            public void prepareInteraction() {
            }

            @Override
            public void setInteractionFlag(byte by) {
            }
        });
    }

    public void setByXY(int n, String string, boolean bl) {
        int[] nArray = this.getResultMatrix().getIndecies(n, string);
        if (nArray == null) {
            throw new RuntimeException("No such category name: " + string);
        }
        XYclass xYclass = (XYclass)this.getVarDataInfo().getGroupColumnByType(3);
        IncExclude incExclude = (IncExclude)this.getVarDataInfo().getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)xYclass.getPrimaryColumn();
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            innerColumnBoolean2.setValueBool(i, true);
            innerColumnBoolean.setValueBool(i, bl);
        }
        this.updateReferences();
    }

    @Override
    public void setChanged(ProgressManager progressManager) {
        super.setChanged(progressManager);
        if (!this.isPropagating()) {
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                ((AbstractModel)this.getTreeNodeAt(i)).setDatasetchanged(true);
            }
        }
    }

    public void setChangedAskApplyChanges() {
        int n;
        this.setChanged();
        if (this.isManual() && this.hasModels() && (n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Do you want to apply changes in order for update to take effect?", "Apply changes?", 0, 3)) == 0) {
            this.doUpdate(null);
        }
    }

    public void setCreated(Project_GUI project_GUI, boolean bl) {
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                this.removeTreeNode(this.controlMatrix[i]);
            }
        }
        this.getObsDataInfo().setCreated(project_GUI);
        this.getVarDataInfo().setCreated(project_GUI);
        if (!bl) {
            this.setTransformationResults();
            this.transformationsChanged(null, true);
        }
        this.iscreated = true;
        if (bl) {
            this.updateDataInfoReferences();
            if (this.transformedContainer == null) {
                this.createTransformContainer();
                AbstractDataMatrix abstractDataMatrix = this.dataSetContainer.getOriginalMatrix();
                this.setUpdateLocalTransformation(abstractDataMatrix.getDataSize() < 100000);
            }
        } else {
            this.updateReferences(false);
            AbstractDataMatrix abstractDataMatrix = this.dataSetContainer.getOriginalMatrix();
            this.setUpdateLocalTransformation(abstractDataMatrix.getDataSize() < 100000);
        }
    }

    public void setMatrix(int n, AbstractDataMatrix abstractDataMatrix) {
        this.controlMatrix[n] = abstractDataMatrix;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)this, string));
    }

    public void setProtected(ProgressManager progressManager) {
        this.setProtected(progressManager, null);
    }

    public void setProtected(ProgressManager progressManager, Properties properties) {
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "solid")) {
            bl = ScriptHelper.getPropertyBool(properties, "solid");
        }
        this.setProtected(true, progressManager);
        if (bl) {
            this.changeSolidState(progressManager, true);
        }
    }

    public void setTest(AbstractTransform abstractTransform) {
        if (this.currentResult != null) {
            this.getObsDataInfo().setTest(DataSet.createArray(this.currentResult.getIndexForTransformationDouble(true, abstractTransform), 0), true);
            this.updateReferences();
        }
    }

    public void setTest(Double d) {
        this.setTest(d, (Double[])null, null);
    }

    public void setTest(Double d, Double[] doubleArray) {
        this.setTest(d, doubleArray, null);
    }

    public void setTest(Double d, Double[] doubleArray, Properties properties) {
        boolean bl;
        boolean bl2 = bl = 0.5 < d;
        if (doubleArray != null) {
            int[] nArray = DataSet.createArray(doubleArray, 0);
            this.setTestLocal(bl, nArray, properties);
        } else {
            this.setTestLocal(bl, null, properties);
        }
    }

    public void setTest(Double d, String string, Double[] doubleArray) {
        this.setByClass((byte)4, 0.5 >= d, "obs", string, null, doubleArray);
        this.setByClass((byte)5, 0.5 < d, "obs", string, null, doubleArray);
    }

    public void setTest(Double d, String string, String string2) {
        this.setByClass((byte)4, 0.5 >= d, "obs", string, string2, null);
        this.setByClass((byte)5, 0.5 < d, "obs", string, string2, null);
    }

    public void setTest(String string, Double[] doubleArray) {
        this.setTest(string, doubleArray, null);
    }

    public void setTest(String string, Double[] doubleArray, Properties properties) {
        boolean bl = string.equalsIgnoreCase("true");
        this.setTestLocal(bl, DataSet.createArray(doubleArray, 0), properties);
    }

    public void setTest(String string, String string2) {
        this.setTest((Double)1.0, string, string2);
    }

    public void setTrain(AbstractTransform abstractTransform) {
        if (this.currentResult != null) {
            this.getObsDataInfo().setTrain(DataSet.createArray(this.currentResult.getIndexForTransformationDouble(true, abstractTransform), 0), true);
            this.updateReferences();
        }
    }

    public void setTrain(Double d) {
        this.setTrain(d, null);
    }

    public void setTrain(Double d, Double[] doubleArray) {
        boolean bl;
        boolean bl2 = bl = 0.5 < d;
        if (doubleArray != null) {
            this.getObsDataInfo().setTrain(DataSet.createArray(doubleArray, 0), bl);
        } else {
            this.getObsDataInfo().setTrain(null, bl);
        }
        this.updateReferences();
    }

    public void setTrain(Double d, String string, Double[] doubleArray) {
        this.setByClass((byte)4, 0.5 < d, "obs", string, null, doubleArray);
    }

    public void setTrain(Double d, String string, String string2) {
        this.setByClass((byte)4, 0.5 < d, "obs", string, string2, null);
    }

    public void setTransformationResults() {
        this.createResultMatrix(true);
        AbstractDataInfo[] abstractDataInfoArray = this.getDataInfo();
        this.clearAddedDescriptions();
        for (AbstractDataInfo abstractDataInfo : abstractDataInfoArray) {
            for (AbstractTransform.Type type : AbstractTransform.Type.values()) {
                DataTreeInterface dataTreeInterface = abstractDataInfo.getTransformationNode(type);
                for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                    DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
                    if (!(dataTreeInterface2 instanceof AbstractTransform)) continue;
                    AbstractTransform abstractTransform = (AbstractTransform)dataTreeInterface2;
                    if (abstractTransform.getTransformationType() == AbstractTransform.Type.localUpdate) {
                        this.currentResult.addTransformation(abstractTransform);
                        continue;
                    }
                    this.currentResult.addToMatrix(abstractTransform, abstractTransform.isObservation());
                }
            }
        }
        this.updateReferences();
    }

    public void setUpdateLocalTransformation(boolean bl) {
        this.updatelocaltransformation = bl;
        this.transformedContainer.setVisibleInTree(bl);
    }

    public void setX(Double[] doubleArray) {
        if (doubleArray.length > 0) {
            this.getVarDataInfo().setXY(DataSet.createArray(doubleArray, 0), true);
        }
        this.updateReferences();
    }

    public void setX(String string) {
        this.setByXY(4, string, true);
    }

    public void setX(String string, String string2) {
        Double[] doubleArray = this.getIndexFromCategoryClass(string, string2);
        if (doubleArray != null) {
            if (doubleArray.length > 0) {
                this.getVarDataInfo().setXY(DataSet.createArray(doubleArray, 0), true);
            }
            this.updateReferences();
        }
    }

    public void setY(Double[] doubleArray) {
        if (doubleArray.length > 0) {
            this.getVarDataInfo().setXY(DataSet.createArray(doubleArray, 0), false);
        }
        this.updateReferences();
    }

    public void setY(String string) {
        this.setByXY(4, string, false);
    }

    public void setY(String string, String string2) {
        Double[] doubleArray = this.getIndexFromCategoryClass(string, string2);
        if (doubleArray != null) {
            if (doubleArray.length > 0) {
                this.getVarDataInfo().setXY(DataSet.createArray(doubleArray, 0), false);
            }
            this.updateReferences();
        }
    }

    public void transformationsChanged(ProgressManager progressManager, boolean bl) {
        for (AbstractDataMatrix abstractDataMatrix : this.controlMatrix) {
            if (!(abstractDataMatrix instanceof DataSetMatrix)) continue;
            DataSetMatrix dataSetMatrix = (DataSetMatrix)abstractDataMatrix;
            if (bl) {
                dataSetMatrix.setReferenceMatrix(progressManager, this.currentResult, this.iscreated);
                continue;
            }
            dataSetMatrix.setReferenceMatrix(progressManager, this.getOriginalMatrix(), this.iscreated);
        }
        this.updateReferences();
    }

    public void triggetDataInfoEvent(DataInfoEvent dataInfoEvent) {
        this.dataSetContainer.getDataInfo(dataInfoEvent.getSource().getDataType()).triggerEvent(dataInfoEvent);
    }

    public void updateDescription() {
        if (this.controlMatrix != null) {
            for (AbstractDataMatrix abstractDataMatrix : this.controlMatrix) {
                if (!(abstractDataMatrix instanceof DataSetMatrix)) continue;
                DataSetMatrix dataSetMatrix = (DataSetMatrix)abstractDataMatrix;
                dataSetMatrix.triggerEvent(new DataMatrixEvent((Object)this, dataSetMatrix));
            }
        }
    }

    public void updateReferences() {
        this.updateReferences(null, true);
    }

    public void updateReferences(ProgressManager progressManager, boolean bl) {
        if (this.iscreated && this.dataInfo != null) {
            this.updateDataInfoReferences();
            this.getResultMatrix().updateReferences(true);
            this.dataInfo[0].setRowCount(this.currentResult.getN());
            this.dataInfo[1].setRowCount(this.currentResult.getK());
            for (AbstractDataMatrix abstractDataMatrix : this.controlMatrix) {
                if (!(abstractDataMatrix instanceof DataSetMatrix)) continue;
                DataSetMatrix dataSetMatrix = (DataSetMatrix)abstractDataMatrix;
                dataSetMatrix.beginCalculations();
                dataSetMatrix.updateReferences(progressManager, false);
                dataSetMatrix.endCalculations();
                dataSetMatrix.setMatrixDataSetContainer(this.dataSetContainer);
            }
            if (bl) {
                this.setChanged(progressManager);
            }
        }
    }

    public void updateResultMatrix() {
        if (this.currentResult != null) {
            this.currentResult.obsDescriptionUpdated();
            this.currentResult.varDescriptionUpdated();
            this.setChangedAskApplyChanges();
        }
    }

    @Override
    protected void cleanUpChild() {
        AbstractDataMatrix abstractDataMatrix;
        super.cleanUpChild();
        if (this.dataSetContainer != null && (abstractDataMatrix = this.dataSetContainer.getOriginalMatrix()) != null) {
            abstractDataMatrix.removeDataTreeChangeListener(this);
        }
        if (this.dataInfo != null) {
            if (this.dataInfo[0] != null) {
                this.dataInfo[0].cleanUp();
            }
            if (this.dataInfo[1] != null) {
                this.dataInfo[1].cleanUp();
            }
        }
        if (this.currentResult != null) {
            this.currentResult.cleanUp();
        }
        this.originalObs = null;
    }

    protected DataSet cloneThisDataSet() {
        AbstractDataInfo[] abstractDataInfoArray = new AbstractDataInfo[]{(AbstractDataInfo)this.getObsDataInfo().clone(), (AbstractDataInfo)this.getVarDataInfo().clone()};
        return new DataSet(this.getCase(), abstractDataInfoArray);
    }

    @Override
    protected void doUpdateLocal(ProgressManager progressManager) {
        DataSetEvent dataSetEvent = new DataSetEvent((Object)this, this);
        dataSetEvent.setProgressManager(progressManager);
        this.updateLocalTransformation(progressManager, (byte)0, this.updatelocaltransformation);
        this.updateLocalTransformation(progressManager, (byte)2, this.updatelocaltransformation);
        this.triggerEvent(dataSetEvent);
        this.purgeSignal();
    }

    protected void initiate(Case case_, AbstractDataInfo[] abstractDataInfoArray) {
        int n;
        this.dataSetContainer = case_;
        this.dataInfo = abstractDataInfoArray;
        abstractDataInfoArray[0].updateReferences();
        this.addTreeNode(abstractDataInfoArray[0]);
        abstractDataInfoArray[1].updateReferences();
        this.addTreeNode(abstractDataInfoArray[1]);
        this.initDataSet(case_);
        this.createReferenceMatrixes();
        this.createTransformContainer();
        this.createStatisticContainer();
        DataTreeInterface dataTreeInterface = abstractDataInfoArray[0].getTransformationNode(AbstractTransform.Type.globalAdd);
        DataTreeInterface dataTreeInterface2 = abstractDataInfoArray[1].getTransformationNode(AbstractTransform.Type.globalAdd);
        for (n = 0; n < dataTreeInterface.getTreeNodeCount(); ++n) {
            ((AbstractTransform)dataTreeInterface.getTreeNodeAt(n)).applyTransformation(null, null);
        }
        for (n = 0; n < dataTreeInterface2.getTreeNodeCount(); ++n) {
            ((AbstractTransform)dataTreeInterface2.getTreeNodeAt(n)).applyTransformation(null, null);
        }
        this.setDuration(System.currentTimeMillis() - this.getTimestamp());
    }

    @Override
    protected void setProtectedLocal(ProgressManager progressManager, boolean bl) {
        if (bl) {
            this.updateReferences();
        }
        if (!bl && this.isSolidState()) {
            try {
                this.changeSolidState(progressManager, bl);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
    }

    protected void triggerEvent(DataSetEvent dataSetEvent) {
        if (this.listenerList != null) {
            for (DataTreeListener dataTreeListener : this.listenerList) {
                if (!(dataTreeListener instanceof DataSetListener)) continue;
                ((DataSetListener)dataTreeListener).dataSetChanged(dataSetEvent);
            }
        }
        dataSetEvent.cleanUp();
    }

    private void changeSolidState(ProgressManager progressManager, boolean bl) {
        for (byte by = 0; by < this.controlMatrix.length; by = (byte)((byte)(by + 1))) {
            AbstractDataMatrix abstractDataMatrix;
            if (bl) {
                AbstractDataMatrix abstractDataMatrix2 = this.controlMatrix[by];
                if (!(abstractDataMatrix2 instanceof DataSetMatrix)) continue;
                abstractDataMatrix = (DataSetMatrix)abstractDataMatrix2;
                ((ReferenceMatrix)abstractDataMatrix).beginCalculations();
                abstractDataMatrix2 = ((ReferenceMatrix)abstractDataMatrix).subMatrix(progressManager, null, null, null, IniManager.getModelDataType());
                abstractDataMatrix2.setName(TYPENAME[by]);
                ((ReferenceMatrix)abstractDataMatrix).endCalculations();
                this.controlContainer.replaceNode(abstractDataMatrix, abstractDataMatrix2);
                this.controlMatrix[by] = abstractDataMatrix2;
                abstractDataMatrix.cleanUp();
                continue;
            }
            abstractDataMatrix = this.controlMatrix[by];
            if (!(abstractDataMatrix instanceof AbstractMVmatrix)) continue;
            AbstractMVmatrix abstractMVmatrix = (AbstractMVmatrix)abstractDataMatrix;
            abstractDataMatrix = new DataSetMatrix(this, by, true);
            abstractDataMatrix.setName(TYPENAME[by]);
            abstractDataMatrix.setMatrixDataSetContainer(this.dataSetContainer);
            ((ReferenceMatrix)abstractDataMatrix).beginCalculations();
            ((DataSetMatrix)abstractDataMatrix).updateReferences(progressManager, false);
            ((ReferenceMatrix)abstractDataMatrix).endCalculations();
            this.controlContainer.replaceNode(abstractMVmatrix, abstractDataMatrix);
            this.controlMatrix[by] = abstractDataMatrix;
            abstractMVmatrix.cleanUp();
        }
    }

    private void checkMVmatrix(ProgressManager progressManager, DataSetMatrix dataSetMatrix, int n, String string, int n2) {
        MVframe mVframe;
        if (dataSetMatrix.hasMissing() && (mVframe = new MVframe(IniManager.getMainFrame(), "MV check", true, this.dataSetContainer)).showModal(dataSetMatrix, String.valueOf(dataSetMatrix) + " " + string, n, n2) == 0) {
            this.setExcludeOnDataInfo(n, mVframe.generateRemove());
            dataSetMatrix.updateReferences(progressManager, true);
        }
    }

    private void clearAddedDescriptions() {
        this.dataInfo[1].clearAddedDescriptions(this.getParentMatrix().getK());
        this.dataInfo[0].clearAddedDescriptions(this.getParentMatrix().getN());
    }

    private void createHierarchyDataSet() {
    }

    private void createReferenceMatrixes() {
        this.controlContainer = new DataContainer("X and Y", -1);
        for (byte by = 0; by < 4; by = (byte)(by + 1)) {
            this.controlMatrix[by] = new DataSetMatrix(this, by, true);
            this.controlMatrix[by].setName(TYPENAME[by]);
            this.controlMatrix[by].setMatrixDataSetContainer(this.dataSetContainer);
            this.controlContainer.addTreeNode(this.controlMatrix[by]);
        }
        this.addTreeNode(this.controlContainer);
    }

    private void createStatisticContainer() {
        this.statisticContainer = new DataContainer("Statistics", 15, false);
        this.addTreeNode(this.statisticContainer);
    }

    private void createTransformContainer() {
        this.transformedContainer = new DataContainer("Transformed", 6, false);
        MVmatrix mVmatrix = new MVmatrix("X Training (transformed)");
        this.transformedContainer.addTreeNode(mVmatrix);
        this.transformedContainer.addTreeNode(this.createTransformed((byte)1, mVmatrix));
        MVmatrix mVmatrix2 = new MVmatrix("Y Training (transformed)");
        this.transformedContainer.addTreeNode(mVmatrix2);
        this.transformedContainer.addTreeNode(this.createTransformed((byte)3, mVmatrix2));
        this.controlContainer.addTreeNode(this.transformedContainer);
    }

    private void deleteModification(String string, String string2, AbstractTransform abstractTransform) {
        AbstractDataInfo abstractDataInfo = this.getDataInfoByDirection(string);
        if (abstractTransform != null) {
            abstractTransform.delete();
        } else {
            Transformations transformations = abstractDataInfo.getTransformationNode();
            if (transformations != null) {
                Object icType = transformations.getInnerColumnByName(string2);
                if (icType == null) {
                    throw new RuntimeException("No such modification: " + string2);
                }
                if (icType instanceof InnerColumnClass) {
                    ((InnerColumnClass)icType).getCategory().remove();
                } else {
                    AbstractTransform abstractTransform2 = transformations.getTransform((AbstractInnerColumn)icType);
                    if (abstractTransform2 != null) {
                        abstractTransform2.delete();
                    } else {
                        abstractDataInfo.removeDataColumn((AbstractInnerColumn)icType);
                        ((CleanUpClass)icType).cleanUp();
                    }
                }
            }
        }
    }

    private void doTransformationLocal(AbstractTransform abstractTransform, ProgressManager progressManager) {
        abstractTransform.applyTransformation(this.currentResult, progressManager);
        if (this.currentResult != null) {
            this.currentResult.addToMatrix(abstractTransform, abstractTransform.isObservation());
        }
        abstractTransform.workDone(progressManager);
    }

    public void excludeZeroObservationVariances() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        AbstractDataMatrix abstractDataMatrix = this.controlMatrix[0];
        int n = abstractDataMatrix.getN();
        int n2 = abstractDataMatrix.getK();
        int[] nArray = abstractDataMatrix.getNref();
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            int n3 = 0;
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                if (abstractDataMatrix.isMissing(i, j)) continue;
                double d2 = abstractDataMatrix.getValue(i, j);
                if (bl) {
                    bl = false;
                    d = d2;
                    continue;
                }
                if (Double.compare(d2, d) == 0) continue;
                if (++n3 >= 1) break;
                d = d2;
            }
            if (n3 >= true) continue;
            if (nArray == null) {
                arrayList.add(i);
                continue;
            }
            arrayList.add(nArray[i]);
        }
        if (arrayList.size() > 0) {
            AbstractDataInfo abstractDataInfo = this.dataInfo[0];
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)abstractDataInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)abstractDataInfo.getPrimaryColumnByType(4);
            InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)abstractDataInfo.getPrimaryColumnByType(5);
            for (Integer n4 : arrayList) {
                innerColumnBoolean.setValueBool(n4, false);
                innerColumnBoolean2.setValueBool(n4, false);
                innerColumnBoolean3.setValueBool(n4, false);
            }
            this.updateReferences();
        }
    }

    private boolean excludeMissingObservations(AbstractDataMatrix abstractDataMatrix) {
        if (!abstractDataMatrix.hasMissing()) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = abstractDataMatrix.getN();
        int n2 = abstractDataMatrix.getK();
        int[] nArray = abstractDataMatrix.getNref();
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            for (int j = 0; j < n2 && abstractDataMatrix.isMissing(i, j); ++j) {
                ++n3;
            }
            if (n3 != n2) continue;
            if (nArray != null) {
                arrayList.add(nArray[i]);
                continue;
            }
            arrayList.add(i);
        }
        this.setExcludeOnDataInfo(0, arrayList);
        return !arrayList.isEmpty();
    }

    private boolean excludeNonVarying(AbstractDataMatrix abstractDataMatrix, int n) {
        ArrayList<Integer> arrayList = this.getVarianceList(abstractDataMatrix, n);
        this.setExcludeOnDataInfo(1, arrayList);
        return !arrayList.isEmpty();
    }

    private AbstractDataInfo getDataInfo(String string) {
        if ("obs".equalsIgnoreCase(string)) {
            return this.getObsDataInfo();
        }
        if ("var".equalsIgnoreCase(string)) {
            return this.getVarDataInfo();
        }
        throw new RuntimeException("Illegal parameter: " + string);
    }

    private AbstractDataInfo getDataInfoByDirection(String string) {
        if (string.equalsIgnoreCase("obs") || string.equalsIgnoreCase("obsdescr") || string.equalsIgnoreCase("obsid")) {
            return this.getObsDataInfo();
        }
        if (string.equalsIgnoreCase("var") || string.equalsIgnoreCase("vardescr") || string.equalsIgnoreCase("varid")) {
            return this.getVarDataInfo();
        }
        throw new RuntimeException("Direction " + string + " is invalid");
    }

    private int[][] getIndexBySelectionAlgorithm(ProgressManager progressManager, AbstractModel abstractModel, String string, Double d, Properties properties) {
        Vector<AbstractSelectionInfo> vector = new Vector<AbstractSelectionInfo>();
        AbstractSelectionInfo.addExternSelection(vector, null);
        string = EvinceScriptCommands.removeSpace(string);
        for (AbstractSelectionInfo abstractSelectionInfo : vector) {
            if (!string.equalsIgnoreCase(EvinceScriptCommands.removeSpace(abstractSelectionInfo.toString()))) continue;
            return abstractSelectionInfo.getGroup(progressManager, this, abstractModel, d.intValue(), properties);
        }
        return null;
    }

    private Double[] getIndexFromCategoryClass(String string, String string2) {
        InnerColumnClass innerColumnClass = this.getCategory(this.getVarDataInfo(), string);
        if (innerColumnClass != null) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ClassTypes classTypes = innerColumnClass.getObject();
            short s = classTypes.getTypeDescriptionIndex(string2);
            for (int i = 0; i < innerColumnClass.getSize(); ++i) {
                if (innerColumnClass.getValueShort(i) != s) continue;
                arrayList.add((double)i + 1.0);
            }
            Double[] doubleArray = new Double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                doubleArray[i] = (Double)arrayList.get(i);
            }
            return doubleArray;
        }
        return null;
    }

    private int getMinVariance(AbstractDataMatrix abstractDataMatrix, Properties properties, int n) {
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "min_variance")) {
                n = ScriptHelper.getPropertyInt(properties, "min_variance");
            } else if (ScriptHelper.hasKey(properties, "min_variance_percent")) {
                double d = ScriptHelper.getPropertyDouble(properties, "min_variance_percent");
                n = (int)(d / 100.0 * (double)abstractDataMatrix.getN());
            }
        }
        return n;
    }

    private String getPropertyIgnoreCase(Properties properties, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                if (string.equalsIgnoreCase("all_header")) {
                    stringBuilder.append(";");
                    stringBuilder.append(entry.getKey().toString());
                    continue;
                }
                if (string.equalsIgnoreCase("all_type")) {
                    stringBuilder.append(";");
                    stringBuilder.append(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("all_data")) {
                    stringBuilder.append(";");
                    stringBuilder.append(entry.getValue().toString());
                    continue;
                }
                if (!entry.getKey().toString().equalsIgnoreCase(string)) continue;
                return entry.getValue().toString();
            }
        }
        return stringBuilder.toString();
    }

    private ArrayList<Integer> getVarianceList(AbstractDataMatrix abstractDataMatrix, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = abstractDataMatrix.getK();
        int n3 = abstractDataMatrix.getN();
        int[] nArray = abstractDataMatrix.getKref();
        abstractDataMatrix.beginCalculations();
        for (int i = 0; i < n2; ++i) {
            boolean bl = true;
            int n4 = 0;
            double d = 0.0;
            for (int j = 0; j < n3; ++j) {
                if (abstractDataMatrix.isMissing(j, i)) continue;
                double d2 = abstractDataMatrix.getValue(j, i);
                if (bl) {
                    bl = false;
                    d = d2;
                    continue;
                }
                if (Double.compare(d2, d) == 0) continue;
                if (++n4 >= n) break;
                d = d2;
            }
            if (n4 >= n) continue;
            if (nArray == null) {
                arrayList.add(i);
                continue;
            }
            arrayList.add(nArray[i]);
        }
        abstractDataMatrix.endCalculations();
        return arrayList;
    }

    private void initDataSet(Case case_) {
        this.dataSetContainer = case_;
        AbstractDataMatrix abstractDataMatrix = this.getParentMatrix();
        if (abstractDataMatrix != null) {
            abstractDataMatrix.addDataTreeChangeListener(this);
        }
    }

    private boolean isSolidState() {
        AbstractDataMatrix abstractDataMatrix = this.getMatrix(0);
        return abstractDataMatrix instanceof AbstractMVmatrix;
    }

    private void setByClass(byte by, boolean bl, String string, AbstractModel abstractModel, String string2, String string3, Double[] doubleArray) {
        AbstractDataInfo abstractDataInfo = this.getDataInfo(string);
        if (string3 != null) {
            abstractDataInfo.setByClass(by, abstractModel, string2, string3, -1, bl);
        } else {
            int[] nArray;
            for (int n : nArray = DataSet.createArray(doubleArray, 0)) {
                abstractDataInfo.setByClass(by, abstractModel, string2, null, n + 1, bl);
            }
        }
        this.updateReferences();
    }

    private void setByClass(byte by, boolean bl, String string, String string2, String string3, Double[] doubleArray) {
        this.setByClass(by, bl, string, null, string2, string3, doubleArray);
    }

    private void setExcludeOnDataInfo(int n, ArrayList<Integer> arrayList) {
        if (arrayList.size() > 0) {
            AbstractDataInfo abstractDataInfo = this.dataInfo[n];
            IncExclude incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            for (Integer n2 : arrayList) {
                innerColumnBoolean.setValueBool(n2, false);
            }
        }
    }

    private void setTestLocal(boolean bl, int[] nArray, Properties properties) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "excludeTrain")) {
                bl2 = ScriptHelper.getPropertyBool(properties, "excludeTrain");
            }
            if (ScriptHelper.hasKey(properties, "forceInclude")) {
                bl3 = ScriptHelper.getPropertyBool(properties, "forceInclude");
            }
        }
        ObservationInfo observationInfo = this.getObsDataInfo();
        if (nArray != null && nArray.length > 0) {
            if (bl2) {
                observationInfo.setTrain(nArray, !bl, bl3);
            }
            observationInfo.setTest(nArray, bl, bl3);
        } else {
            observationInfo.setTest(null, bl, bl3);
        }
        this.updateReferences();
    }

    private void updateDataInfoReferences() {
        if (this.dataInfo != null) {
            this.dataInfo[0].updateReferences();
            this.dataInfo[1].updateReferences();
        }
    }

    private void updateLocalTransformation(ProgressManager progressManager, byte by, boolean bl) {
        try {
            AbstractDataMatrix abstractDataMatrix = this.getMatrix(by);
            AbstractMVmatrix abstractMVmatrix = (AbstractMVmatrix)this.getTransformedMatrix(by);
            abstractMVmatrix.beginUpdate();
            if (bl) {
                abstractMVmatrix.beginCalculations();
                abstractMVmatrix = abstractDataMatrix.subMatrix(progressManager, abstractMVmatrix, null, null, IniManager.getModelDataType());
                abstractDataMatrix.applyTransformations(abstractMVmatrix, progressManager);
                abstractMVmatrix.endCalculations();
            } else {
                abstractMVmatrix.removeIdentifiersAndTransformations();
                abstractMVmatrix.setRowDescription(abstractDataMatrix.getRowDescription());
                abstractMVmatrix.setColumnDescription(abstractDataMatrix.getColumnDescription());
            }
            abstractMVmatrix.endUpdate(true, true);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void updateReferences(boolean bl) {
        this.updateReferences(null, bl);
    }

    public void setReload(boolean bl) {
        this.reload = bl;
    }

    public boolean isReload() {
        return this.reload;
    }

    public static class NoSuchCategoryException
    extends RuntimeException {
        public NoSuchCategoryException(String string) {
            super(string);
        }
    }
}

