/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;

public class DataSetMatrix
extends ReferenceMatrix {
    private final DataSet dataSet;
    private final byte datasettype;
    private final boolean fitted;

    public DataSetMatrix(DataSet dataSet, byte by, boolean bl) {
        super(dataSet.getParentMatrix());
        this.dataSet = dataSet;
        this.datasettype = by;
        this.fitted = bl;
    }

    public DataSetMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "dataset");
        this.datasettype = mapProperty.getPropertyByte("dstype", (byte)0);
        this.fitted = mapProperty.getPropertyBoolean("fitted", false);
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        if (this.dataSet == null) {
            return null;
        }
        AbstractDataInfo[] abstractDataInfoArray = this.dataSet.getDataInfo();
        if (abstractDataInfoArray == null) {
            return null;
        }
        return this.dataSet.getDataInfo()[n];
    }

    @Override
    public String getFoldName(int n) {
        int[] nArray = this.getKref();
        if (nArray != null && n < nArray.length) {
            return this.dataSet.getResultMatrix().getColumnDescription(nArray[n], 0);
        }
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getFoldName(n);
        }
        return "N/A";
    }

    @Override
    public int getFoldsize() {
        return this.K;
    }

    @Override
    public double getScaledValue(int n, int n2) {
        int n3 = this.getNrefOrig(n);
        int n4 = this.getKrefOrig(n2);
        double d = this.getValue(n3, n4);
        int n5 = this.referenceMatrix.getTreeNodeCount();
        for (int i = 0; i < n5; ++i) {
            AbstractTransform abstractTransform;
            DataTreeInterface dataTreeInterface = this.referenceMatrix.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractTransform) || !(abstractTransform = (AbstractTransform)dataTreeInterface).isScale()) continue;
            d = abstractTransform.scaleValue(this, n3, n4, d);
        }
        return d;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dataset", this.dataSet);
        randomOutputStream.writePropertyByte("dstype", this.datasettype);
        randomOutputStream.writePropertyBoolean("fitted", this.fitted);
    }

    @Override
    public void updateReferences(ProgressManager progressManager, boolean bl) {
        AbstractDataInfo[] abstractDataInfoArray;
        this.checkAndLoadIntoMemory();
        int n = this.N;
        int n2 = this.K;
        if (this.referenceMatrix == null) {
            this.referenceMatrix = this.dataSet.getOriginalMatrix();
        }
        if ((abstractDataInfoArray = this.dataSet.getDataInfo()) != null) {
            switch (this.datasettype) {
                case 0: {
                    this.Nref_cs = abstractDataInfoArray[0].getRef(true);
                    this.Kref_cs = abstractDataInfoArray[1].getRef(true);
                    break;
                }
                case 1: {
                    this.Nref_cs = abstractDataInfoArray[0].getRef(false);
                    this.Kref_cs = abstractDataInfoArray[1].getRef(true);
                    break;
                }
                case 2: {
                    this.Nref_cs = abstractDataInfoArray[0].getRef(true);
                    this.Kref_cs = abstractDataInfoArray[1].getRef(false);
                    break;
                }
                case 3: {
                    this.Nref_cs = abstractDataInfoArray[0].getRef(false);
                    this.Kref_cs = abstractDataInfoArray[1].getRef(false);
                }
            }
            if (this.Nref_cs == null || this.Kref_cs == null) {
                this.N = 0;
                this.K = 0;
            } else {
                this.N = this.Nref_cs.length;
                this.K = this.Kref_cs.length;
            }
        }
        this.updateReferences(n, n2);
        if (bl) {
            this.dataSet.setChanged(progressManager);
        }
    }

    @Override
    protected void updateReferenceCoord(int n, int n2) {
        if (this.referenceMatrix == null) {
            this.referenceMatrix = this.dataSet.getOriginalMatrix();
        }
        super.updateReferenceCoord(n, n2);
    }
}

