/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.register.RegisterKeyManager;

public class DataSetPredictionDialog
extends JDialog {
    private JPanel addPredictionPanel;
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JLabel classLabel;
    private JList classList;
    private JTextPane descriptionTextPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel newPredictionPanel;
    private JButton okButton;
    private JComboBox predCategoryComboBox;
    private JLabel predCategoryLabel;
    private JComboBoxCell templateComboBoxCell;
    private JLabel templateLabel;
    private JTabbedPane typeTabbedPane;
    private boolean modelresult = false;
    private final Vector typesVector = new Vector();
    private String replaceClassName = null;

    public DataSetPredictionDialog(Window window, DataSet dataSet, AbstractModel abstractModel) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this.replaceClassName = abstractModel.getReplaceClassName();
        this.setTitle("Prediction dialog");
        this.initComponents();
        ScriptManager.addScriptInfoComboBox(this.templateComboBoxCell, "prediction", new Object[]{dataSet, abstractModel});
        PredictionClasses predictionClasses = (PredictionClasses)dataSet.getObsDataInfo().getGroupColumnByType(11);
        if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
            for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                this.predCategoryComboBox.addItem(predictionClasses.getInnerColumn(i));
            }
        }
        if (!RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            this.typeTabbedPane.removeTabAt(1);
        } else if (this.predCategoryComboBox.getItemCount() > 0) {
            if (abstractModel.getReplaceModel() != null || abstractModel.getReplaceModelID() != 0) {
                this.typeTabbedPane.setSelectedIndex(1);
            }
        } else {
            this.typeTabbedPane.setEnabledAt(1, false);
        }
        this.descriptionTextPane.setBackground(this.addPredictionPanel.getBackground());
    }

    public InnerColumnPredClass getPredCategory() {
        return (InnerColumnPredClass)this.predCategoryComboBox.getSelectedItem();
    }

    public String getPredClass() {
        return (String)this.classList.getSelectedValue();
    }

    public AbstractScriptInfo getScriptTemplate() {
        Object object = this.templateComboBoxCell.getSelectedItem();
        if (object instanceof AbstractScriptInfo) {
            return (AbstractScriptInfo)this.templateComboBoxCell.getSelectedItem();
        }
        return null;
    }

    public boolean isNewPrediction() {
        return this.typeTabbedPane.getSelectedIndex() == 0;
    }

    public boolean showModel() {
        this.okButton.requestFocus();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.modelresult;
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.typeTabbedPane = new JTabbedPane();
        this.newPredictionPanel = new JPanel();
        this.templateLabel = new JLabel();
        this.templateComboBoxCell = new JComboBoxCell();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextPane = new JTextPane();
        this.addPredictionPanel = new JPanel();
        this.predCategoryLabel = new JLabel();
        this.predCategoryComboBox = new JComboBox();
        this.classLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.classList = new JList();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.bottomPanel.setLayout(new GridBagLayout());
        this.okButton.setText("Predict");
        this.okButton.setMinimumSize(new Dimension(81, 26));
        this.okButton.setPreferredSize(new Dimension(81, 26));
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.bottomPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(81, 26));
        this.cancelButton.setPreferredSize(new Dimension(81, 26));
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.bottomPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.bottomPanel, gridBagConstraints);
        this.typeTabbedPane.setPreferredSize(new Dimension(400, 300));
        this.newPredictionPanel.setLayout(new GridBagLayout());
        this.templateLabel.setText("Select prediction template:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.newPredictionPanel.add((Component)this.templateLabel, gridBagConstraints);
        this.templateComboBoxCell.addItemListener(itemEvent -> this.templateComboBoxCellItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.newPredictionPanel.add((Component)this.templateComboBoxCell, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descriptionTextPane.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.descriptionTextPane.setEditable(false);
        this.descriptionTextPane.setText("N/A");
        this.jScrollPane2.setViewportView(this.descriptionTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.newPredictionPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.typeTabbedPane.addTab("New prediction category", this.newPredictionPanel);
        this.addPredictionPanel.setLayout(new GridBagLayout());
        this.predCategoryLabel.setText("Prediction category:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.addPredictionPanel.add((Component)this.predCategoryLabel, gridBagConstraints);
        this.predCategoryComboBox.addItemListener(itemEvent -> this.predCategoryComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.addPredictionPanel.add((Component)this.predCategoryComboBox, gridBagConstraints);
        this.classLabel.setText("Class to replace:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.addPredictionPanel.add((Component)this.classLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.classList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.addPredictionPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.typeTabbedPane.addTab("Add to existing prediction category", this.addPredictionPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.typeTabbedPane, gridBagConstraints);
        this.typeTabbedPane.getAccessibleContext().setAccessibleName("New prediction");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.modelresult = true;
        this.dispose();
    }

    private void predCategoryComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = this.predCategoryComboBox.getSelectedItem();
            this.typesVector.clear();
            if (object instanceof InnerColumnPredClass) {
                InnerColumnPredClass innerColumnPredClass = (InnerColumnPredClass)object;
                ClassTypes classTypes = innerColumnPredClass.getObject();
                for (ClassSettings classSettings : classTypes) {
                    this.typesVector.add(classSettings.getName());
                }
            }
            this.classList.setListData(this.typesVector);
            if (!this.typesVector.isEmpty()) {
                if (this.replaceClassName != null && this.typesVector.contains(this.replaceClassName)) {
                    this.classList.setSelectedIndex(this.typesVector.indexOf(this.replaceClassName));
                } else {
                    this.classList.setSelectedIndex(0);
                }
            }
        }
    }

    private void templateComboBoxCellItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            AbstractScriptInfo abstractScriptInfo = this.getScriptTemplate();
            if (abstractScriptInfo != null) {
                this.descriptionTextPane.setText(abstractScriptInfo.getScriptInfo());
            } else {
                this.descriptionTextPane.setText("");
            }
        }
    }
}

