/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public class DataSetToolbar
extends CleanUpToolBar
implements GlobalMessageInterface,
DataTreeListener {
    private final JFlatButton cloneButton = new JFlatButton();
    private final JFlatButton deleteButton = new JFlatButton();
    private final JFlatButton renameButton = new JFlatButton();
    private final JFlatButton undoButton = new JFlatButton();
    private final JFlatButton redoButton = new JFlatButton();
    private Project_GUI project;
    private DataSet dataSet;

    public DataSetToolbar() {
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Create new dataset");
        jFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/newFile.png")));
        jFlatButton.addActionListener(actionEvent -> this.createNewDataSet());
        this.cloneButton.setToolTipText("Clone DataSet");
        this.cloneButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/clone.png")));
        this.cloneButton.addActionListener(actionEvent -> this.dataSet.cloneAndShowDataSet(this.project));
        this.deleteButton.setToolTipText("Delete DataSet");
        this.deleteButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        this.deleteButton.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete this data set?", "Really delete?", 2);
            if (n != 0) {
                return;
            }
            Project_GUI project_GUI = this.project;
            this.dataSet.cleanUp();
            project_GUI.purgeSignal();
        });
        this.renameButton.setToolTipText("Rename DataSet");
        this.renameButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        this.renameButton.addActionListener(actionEvent -> {
            String string = this.dataSet.toString();
            String string2 = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for " + string, string);
            if (string2 != null) {
                this.dataSet.setName(string2);
            }
        });
        this.undoButton.setToolTipText("Undo");
        this.undoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/undo.png")));
        this.undoButton.setSelected(true);
        this.undoButton.addActionListener(actionEvent -> {});
        this.undoButton.setEnabled(false);
        this.redoButton.setToolTipText("Redo");
        this.redoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/redo.png")));
        this.redoButton.setSelected(true);
        this.redoButton.addActionListener(this.undoButton.getActionListeners()[0]);
        this.redoButton.setEnabled(false);
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add(this.undoButton);
        this.add(this.redoButton);
        this.addSeparator();
        this.add(jFlatButton);
        this.add(this.cloneButton);
        this.add(this.deleteButton);
        this.add(this.renameButton);
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
        this.setDataSet(this.dataSet);
    }

    public void setCreated(Project_GUI project_GUI) {
        this.project = project_GUI;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null && this.dataSet != dataSet) {
            this.dataSet.removeDataTreeChangeListener(this);
        }
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.cloneButton.setEnabled(false);
        } else {
            this.dataSet.addDataTreeChangeListener(this);
            this.cloneButton.setEnabled(true);
        }
    }

    @Override
    protected void cleanUpChild() {
        this.project = null;
        if (this.dataSet != null) {
            this.dataSet.removeDataTreeChangeListener(this);
        }
        this.dataSet = null;
    }

    private void createNewDataSet() {
        Case case_ = this.dataSet.getCase();
        DataSet dataSet = case_.createDataSet(null, true);
        if (dataSet != null) {
            dataSet.setCreated(this.project, false);
        }
    }
}

