/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.selection.AbstractSelectionInfo;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;

public class RepresentativeAlgorithm
extends AbstractSelectionInfo {
    @Override
    public int[][] getGroupLocal(ProgressManager progressManager, DataSet dataSet, AbstractModel abstractModel, int n, Properties properties) {
        if (abstractModel.getModelName().equals("Model Container")) {
            ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
            for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
                if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                arrayList.add((AbstractModel)abstractModel.getTreeNodeAt(i));
            }
            int[][] nArrayArray = new int[arrayList.size()][];
            int n2 = 0;
            for (AbstractModel abstractModel2 : arrayList) {
                nArrayArray[n2++] = this.getGroupFromModel(progressManager, dataSet, abstractModel2, n);
            }
            return nArrayArray;
        }
        return new int[][]{this.getGroupFromModel(progressManager, dataSet, abstractModel, n)};
    }

    @Override
    public String toString() {
        return "Representative";
    }

    private int[] getGroupFromModel(ProgressManager progressManager, DataSet dataSet, AbstractModel abstractModel, int n) {
        double d;
        ModelMatrix modelMatrix = abstractModel.getScores();
        ArrayList<Data> arrayList = new ArrayList<Data>(modelMatrix.getK());
        int[] nArray = modelMatrix.getKref();
        for (int i = 0; i < modelMatrix.getN(); ++i) {
            DenseVector denseVector = modelMatrix.getRM(i);
            for (int j = 0; j < denseVector.size(); ++j) {
                Data data3 = null;
                if (i == 0) {
                    data3 = new Data();
                    data3.index = nArray[j];
                    arrayList.add(data3);
                } else {
                    data3 = (Data)arrayList.get(j);
                }
                double d2 = denseVector.get(j);
                data3.value += d2 * d2;
            }
        }
        Collections.sort(arrayList, (data, data2) -> {
            Data data3 = data;
            Data data4 = data2;
            return Double.compare(data3.value, data4.value);
        });
        n = Math.min(n, modelMatrix.getK());
        int[] nArray2 = new int[n];
        double d3 = d = (double)modelMatrix.getK() / ((double)n + 1.0);
        int n2 = 0;
        while (n2 < n) {
            Data data4 = (Data)arrayList.get((int)d3);
            nArray2[n2] = data4.index;
            ++n2;
            d3 += d;
        }
        return nArray2;
    }

    private static class Data {
        public double value;
        public int index;

        private Data() {
        }
    }
}

