/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset.type;

import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.AbstractSimpleTable;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.GroupMatrix;
import se.prediktera.map.register.RegisterKeyManager;

public class DataSetGroup
extends DataSet {
    public static int TYPE_AVERAGE = 0;
    public static int TYPE_MEDIAN = 1;
    public static int TYPE_RANDOM = 2;
    public static final ImageIcon icon = AbstractPaint.createIcon(20);
    protected AbstractDataMatrix transformMatrixGroup;
    protected DataSet referenceDataSet;

    public DataSetGroup(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.transformMatrixGroup = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "tmg");
        this.referenceDataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "refds");
    }

    public DataSetGroup(String string) {
        this.setName(string);
    }

    public void addToPopupInternal(AbstractSimpleTable abstractSimpleTable, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (RegisterKeyManager.isPredikteraLicense()) {
            CMenuItem cMenuItem = new CMenuItem("Group selected rows", true);
            cMenuItem.addActionListener(actionEvent -> {
                int[] nArray = abstractSimpleTable.getSelectedOrigIndex(true);
                this.groupLocal(nArray);
            });
            jPopupMenu.add(cMenuItem);
            CMenuItem cMenuItem2 = new CMenuItem("Un-group selected rows", true);
            cMenuItem2.addActionListener(actionEvent -> {
                int[] nArray = abstractSimpleTable.getSelectedOrigIndex(true);
                this.ungroupLocal(nArray);
            });
            jPopupMenu.add(cMenuItem2);
            jPopupMenu.addSeparator();
        }
    }

    @Override
    public Object get(String string) {
        if (string.equalsIgnoreCase("refdataset")) {
            return this.referenceDataSet;
        }
        if (string.equalsIgnoreCase("originalmatrix")) {
            return this.transformMatrixGroup;
        }
        return super.get(string);
    }

    public Double[] get(String string, Double[] doubleArray) {
        GroupMatrix groupMatrix = (GroupMatrix)this.transformMatrixGroup;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Double d : doubleArray) {
            int[] nArray;
            for (int n : nArray = groupMatrix.getGroup(d.intValue() - 1)) {
                arrayList.add((double)n + 1.0);
            }
        }
        Double[] doubleArray2 = new Double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            doubleArray2[i] = (Double)arrayList.get(i);
        }
        return doubleArray2;
    }

    public int getGroupID() {
        return this.transformMatrixGroup.getGroupID();
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return icon;
    }

    @Override
    public AbstractDataMatrix getParentMatrix() {
        return this.transformMatrixGroup;
    }

    @Override
    public byte getTreeType() {
        return 6;
    }

    @Override
    public boolean isMultiLayer() {
        return false;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("tmg", this.transformMatrixGroup);
        randomOutputStream.writePropertyNode("refds", this.referenceDataSet);
    }

    public void updateAverages() {
    }

    @Override
    protected DataSet cloneThisDataSet() {
        AbstractDataInfo[] abstractDataInfoArray = new AbstractDataInfo[]{(AbstractDataInfo)this.getObsDataInfo().clone(), (AbstractDataInfo)this.getVarDataInfo().clone()};
        DataSetGroup dataSetGroup = new DataSetGroup("Cloned DataSet");
        dataSetGroup.initiateDataSet(this.referenceDataSet, abstractDataInfoArray, this.transformMatrixGroup);
        return dataSetGroup;
    }

    protected void groupLocal(int[] nArray) {
    }

    protected void initiateDataSet(DataSet dataSet, AbstractDataInfo[] abstractDataInfoArray, AbstractDataMatrix abstractDataMatrix) {
        this.referenceDataSet = dataSet;
        this.transformMatrixGroup = abstractDataMatrix;
        if (dataSet != null) {
            Case case_ = dataSet.getCase();
            this.initiate(case_, abstractDataInfoArray);
            this.setCreated(case_.getProject_GUI(), false);
        }
    }

    protected void ungroupLocal(int[] nArray) {
    }
}

