/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.dataset.type;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;

public class DataSetHierarchy
extends DataSet {
    private DataSet parentDataSet;
    private String categoryName;
    private ReferenceMatrix transformMatrixHierarchy;
    private DataInfoListener infoListener = null;
    private ObservationInfo info;

    public DataSetHierarchy(Case case_, DataSet dataSet, String string) {
        super(case_);
        this.parentDataSet = dataSet;
        this.categoryName = string;
        this.transformMatrixHierarchy = new ReferenceMatrix(dataSet.getOriginalMatrix());
        this.updateTransformMatrixHierarki();
        this.info = dataSet.getObsDataInfo();
        this.infoListener = dataInfoEvent -> {
            if (!dataInfoEvent.hasClassChanged() && !(dataInfoEvent.getT1() instanceof Category) && dataInfoEvent.getSource().getDataSet() != this.info.getDataSet()) {
                return false;
            }
            if (dataInfoEvent instanceof DataInfoClassEvent) {
                this.updateTransformMatrixHierarki();
            }
            return true;
        };
        this.info.addListener(this.infoListener);
    }

    public DataSetHierarchy(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractDataMatrix getParentMatrix() {
        return this.transformMatrixHierarchy;
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.infoListener != null) {
            this.infoListener = null;
        }
    }

    private void updateTransformMatrixHierarki() {
        try {
            this.parentDataSet.getCategory(this.categoryName);
            int n = this.transformMatrixHierarchy.getN();
            int n2 = this.transformMatrixHierarchy.getK();
            int[] nArray = new int[100];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            this.transformMatrixHierarchy.setNref(nArray);
            this.transformMatrixHierarchy.setN(100);
            this.transformMatrixHierarchy.updateReferences(n, n2);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }
}

