/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.BasicMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixByte;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixShort;

public abstract class AbstractBasicMatrix
extends DataTreeMemoryClass
implements BasicMatrixInterface,
DataTypeInterface {
    public static final int OBSERVATIONS_TAG = 1;
    public static final int VARIABLES_TAG = 2;
    public static final int STATISTIC_TAG = 4;
    public static final int COMPONENTS_TAG = 8;
    public static final int ALL_TAG = 15;
    public static final int ALL_INTERACTIVE_TAG = 11;
    public static final int NONE_TAG = 16;
    public static final int REFERENCE_TAG = 64;
    protected Case dataSetContainer;
    protected Description rowDescription;
    protected Description colDescription;
    private boolean image = false;

    public static AbstractMVmatrix createMatrix(int n, int n2, String string, int n3) {
        return AbstractBasicMatrix.createMatrix(n, n2, string, n3, true);
    }

    public static AbstractMVmatrix createMatrix(int n, int n2, String string, int n3, boolean bl) {
        return switch (n3) {
            case 1 -> new MVmatrixShort(n, n2, bl);
            case 0 -> new MVmatrixByte(n, n2, bl);
            case 4 -> new MVmatrixFloat(n, n2);
            default -> new MVmatrix(n, n2);
        };
    }

    protected AbstractBasicMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.rowDescription = (Description)mapProperty.resolveNodeFromName(randomInputStream, "obsDesc");
        this.colDescription = (Description)mapProperty.resolveNodeFromName(randomInputStream, "varDesc");
        this.dataSetContainer = (Case)mapProperty.resolveNodeFromName(randomInputStream, "dsc");
        this.image = mapProperty.getPropertyBoolean("img", false);
    }

    protected AbstractBasicMatrix(String string) {
        super(string);
    }

    @Override
    public Description getColumnDescription() {
        return this.colDescription;
    }

    public int getColumnDescriptionCount() {
        if (this.colDescription == null) {
            return 0;
        }
        return this.colDescription.getColumnCount();
    }

    public String getColumnDescriptionTitle(int n) {
        if (this.colDescription != null) {
            return this.colDescription.getColumnName(n);
        }
        return "ID " + n;
    }

    public abstract int getColumnType();

    public abstract AbstractDataInfo getDataInfo(int var1);

    public abstract int getMatrixTag();

    public int getPrimitiveDataType() {
        return 5;
    }

    @Override
    public Description getRowDescription() {
        return this.rowDescription;
    }

    public int getRowDescriptionCount() {
        if (this.rowDescription == null) {
            return 0;
        }
        return this.rowDescription.getColumnCount();
    }

    public String getRowDescriptionTitle(int n) {
        if (this.rowDescription != null) {
            return this.rowDescription.getColumnName(n);
        }
        return "ID " + n;
    }

    public abstract int getRowType();

    public boolean hasConfidenceInterval() {
        return false;
    }

    public boolean isImage() {
        return this.image;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("obsDesc", this.rowDescription);
        randomOutputStream.writePropertyNode("varDesc", this.colDescription);
        randomOutputStream.writePropertyNode("dsc", this.dataSetContainer);
        randomOutputStream.writePropertyBoolean("img", this.image);
    }

    public void setColumnDescription(Description description) {
        this.colDescription = description;
        if (description != null && description.getID() == null && description.getTreeParent() == null) {
            this.addTreeNode(description);
        }
    }

    public void setImage(boolean bl) {
        this.image = bl;
    }

    public void setMatrixDataSetContainer(Case case_) {
        this.dataSetContainer = case_;
        if (case_ != null && this.rowDescription == null && this.colDescription == null) {
            if (this.getRowType() == 1) {
                this.rowDescription = (Description)case_.getDataGroup(0, 0);
            } else if (this.getRowType() == 2) {
                this.rowDescription = (Description)case_.getDataGroup(1, 0);
            }
            if (this.getColumnType() == 1) {
                this.colDescription = (Description)case_.getDataGroup(0, 0);
            } else if (this.getColumnType() == 2) {
                this.colDescription = (Description)case_.getDataGroup(1, 0);
            }
        }
    }

    public void setRowDescription(Description description) {
        this.rowDescription = description;
        if (description != null && description.getID() == null && description.getTreeParent() == null) {
            this.addTreeNode(description);
        }
    }

    public void setRowDescriptionTitle(int n, String string) {
        if (this.rowDescription != null) {
            this.rowDescription.setColumnName(n, string);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.rowDescription = null;
        this.colDescription = null;
        this.dataSetContainer = null;
    }
}

