/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.QR;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionGroupInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractBasicMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.GroupMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.SparseMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.StringDataClass;
import se.prediktera.map.model.AbstractModel;

public abstract class AbstractDataMatrix
extends AbstractBasicMatrix {
    protected static final ImageIcon matrixIcon = new ImageIcon(Main_GUI.class.getResource("gif/tableidentified.gif"));
    protected static ImageIcon matrixIcon_obs = new ImageIcon(Main_GUI.class.getResource("gif/tableidentified_obs.gif"));
    protected static ImageIcon matrixIcon_var = new ImageIcon(Main_GUI.class.getResource("gif/tableidentified_var.gif"));
    protected static ImageIcon matrixIcon_other = new ImageIcon(Main_GUI.class.getResource("gif/tableunidentified.gif"));
    protected boolean[][] missingMatrix_cs;
    protected int[] MV_Knr_cs;
    protected int[] MV_Nnr_cs;
    protected int[] Kref_cs;
    protected int[] Nref_cs;
    protected int N;
    protected int K;
    protected int nrMV;
    protected boolean doupdate = false;
    protected boolean needupdate = false;
    private boolean structurechanged = false;
    private int updateN;
    private int updateK;
    private int rowType = 1;
    private int columnType = 2;
    private int lastIndex = 0;
    private String transformationInfo = "";
    private boolean[][] filter;
    private String htmlName = null;
    protected String matrixInfo = null;
    private int foldN = -1;
    public Boolean isOrig = null;
    private double[] layerMinMax;

    protected static int[] cloneArray(int[] nArray) {
        if (nArray != null) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return null;
    }

    public AbstractDataMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.N = mapProperty.getPropertyInt("N");
        this.K = mapProperty.getPropertyInt("K");
        this.nrMV = mapProperty.getPropertyInt("nrMV", 0);
        if (!mapProperty.hasProperty("nrMV") && !ScriptManager.isWorking()) {
            SwingUtilities.invokeLater(() -> this.checkAndLoadIntoMemory());
        }
        if (mapProperty.hasProperty("type")) {
            int n = mapProperty.getLVInt();
            if (n == 3) {
                this.rowType = 1;
                this.columnType = 2;
            } else {
                this.rowType = n;
                this.columnType = 8;
            }
        }
        this.rowType = mapProperty.getPropertyInt("rowtype", this.rowType);
        this.columnType = mapProperty.getPropertyInt("coltype", this.columnType);
        if (mapProperty.hasProperty("tinfo")) {
            this.transformationInfo = mapProperty.getLVStringUTF();
        }
        this.htmlName = mapProperty.getPropertyStringUTF("html");
        this.matrixInfo = mapProperty.getPropertyStringUTF("mInfo");
        this.foldN = mapProperty.getPropertyInt("fN", -1);
        this.filter = mapProperty.getPropertyBooleanArray2d("filter");
        if (mapProperty.hasProperty("wavemin")) {
            if (this.layerMinMax == null) {
                this.getLayerMinMax();
            }
            this.layerMinMax[0] = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("wavemax")) {
            if (this.layerMinMax == null) {
                this.getLayerMinMax();
            }
            this.layerMinMax[1] = mapProperty.getLVDouble();
        }
    }

    public AbstractDataMatrix(String string) {
        super(string);
        if (string == null) {
            this.setName("ModelMatrix");
        }
    }

    public void addData(int n, int n2) {
        this.checkAndLoadIntoMemory();
        if (this.missingMatrix_cs != null) {
            boolean[][] blArray = new boolean[this.N + n][this.K + n2];
            for (int i = 0; i < this.N; ++i) {
                if (this.K < 0) continue;
                System.arraycopy(this.missingMatrix_cs[i], 0, blArray[i], 0, this.K);
            }
            this.missingMatrix_cs = blArray;
            if (n > 0 && this.MV_Nnr_cs != null) {
                int[] nArray = new int[this.N + n];
                if (this.N >= 0) {
                    System.arraycopy(this.MV_Nnr_cs, 0, nArray, 0, this.N);
                }
                this.MV_Nnr_cs = nArray;
            }
            if (n2 > 0 && this.MV_Knr_cs != null) {
                int[] nArray = new int[this.K + n2];
                if (this.K >= 0) {
                    System.arraycopy(this.MV_Knr_cs, 0, nArray, 0, this.K);
                }
                this.MV_Knr_cs = nArray;
            }
        }
        this.needupdate = true;
    }

    public void addMissing(int n, int n2) {
        this.getMissingMatrix();
        if (this.missingMatrix_cs == null) {
            this.missingMatrix_cs = new boolean[this.getN()][this.getK()];
        }
        if (!this.missingMatrix_cs[n][n2]) {
            this.missingMatrix_cs[n][n2] = true;
            int[] nArray = this.getMissingCountForColumns(true);
            int[] nArray2 = this.getMissingCountForRows(true);
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            int n4 = n;
            nArray2[n4] = nArray2[n4] + 1;
            ++this.nrMV;
        }
    }

    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        Accessible accessible;
        if (project_GUI != null) {
            jPopupMenu.add(project_GUI.getData_GUI().getTableMenu(this));
            jPopupMenu.add(project_GUI.getPlot_GUI().getPlotMenu(this));
            jPopupMenu.addSeparator();
        }
        if (!this.isProtected()) {
            accessible = new CMenuItem("Rename", true);
            ((AbstractButton)((Object)accessible)).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
            ((AbstractButton)((Object)accessible)).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for the Matrix:", AbstractDataMatrix.this.toString());
                    if (string != null) {
                        AbstractDataMatrix.this.setName(string);
                        AbstractDataMatrix.this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)AbstractDataMatrix.this, string));
                    }
                }
            });
            jPopupMenu.add((JMenuItem)accessible);
        }
        accessible = new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png"));
        jPopupMenu.add(new CMenuItem("Save As...", (ImageIcon)accessible){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractExportInfo.ExportDataNow(AbstractDataMatrix.this.createTableModel(true), false);
            }
        });
        if (this.isFoldable()) {
            jPopupMenu.add(new CMenuItem("Save As Data Cube...", (ImageIcon)accessible){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractDataMatrix.this.beginCalculations();
                    AbstractExportInfo.ExportDataNow(AbstractDataMatrix.this.createTableModel(true), true);
                    AbstractDataMatrix.this.endCalculations();
                }
            });
        }
    }

    public void addToValue(int n, int n2, double d) {
        this.setValue(n, n2, this.getValue(n, n2) + d);
    }

    public void addTransformation(AbstractTransform abstractTransform) {
        int n = this.getTreeNodeCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.getTreeNodeAt(i) instanceof AbstractTransform && ((AbstractTransform)this.getTreeNodeAt(i)).getPriority() < abstractTransform.getPriority()) {
                    this.insertTreeNode(i, abstractTransform.cloneThis());
                    break;
                }
                if (i != n - 1) continue;
                this.addTreeNode(abstractTransform.cloneThis());
            }
        } else {
            this.addTreeNode(abstractTransform.cloneThis());
        }
        this.setTransformationInfo();
    }

    public void applyTransformations(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager) {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(this, DataSet.class);
        if (dataTreeInterface != null && dataTreeInterface.toString().equals("X and Y") && dataSet != null) {
            TransformMatrix transformMatrix = dataSet.getResultMatrix();
            boolean bl = this.toString().charAt(0) == 'Y';
            for (int i = 0; i < transformMatrix.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface2 = transformMatrix.getTreeNodeAt(i);
                if (!(dataTreeInterface2 instanceof AbstractTransform)) continue;
                AbstractTransform abstractTransform = (AbstractTransform)dataTreeInterface2;
                if (bl && !abstractTransform.appliesToY()) continue;
                abstractDataMatrix.addTransformation(abstractTransform);
            }
            abstractDataMatrix.applyTransformations(abstractDataMatrix, progressManager);
        } else {
            this.applyTransformations(abstractDataMatrix, progressManager, true, false);
        }
    }

    public void applyTransformations(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl) {
        this.applyTransformations(abstractDataMatrix, progressManager, bl, false);
    }

    public void applyTransformations(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl, boolean bl2) {
        DataTreeInterface dataTreeInterface;
        int n;
        int n2 = this.getTreeNodeCount();
        if (progressManager != null && abstractDataMatrix != null) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                dataTreeInterface = this.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof AbstractTransform)) continue;
                AbstractTransform abstractTransform = (AbstractTransform)dataTreeInterface;
                if (bl2 && abstractTransform.getTreeType() != 0 && abstractTransform.getTreeType() != 1) continue;
                ++n;
            }
            progressManager.setMaximumAndReset(2 * n * abstractDataMatrix.getN() * abstractDataMatrix.getK());
        }
        for (n = 0; n < n2; ++n) {
            DataTreeInterface dataTreeInterface2 = this.getTreeNodeAt(n);
            if (!(dataTreeInterface2 instanceof AbstractTransform)) continue;
            dataTreeInterface = (AbstractTransform)dataTreeInterface2;
            if (bl2 && dataTreeInterface.getTreeType() != 0 && dataTreeInterface.getTreeType() != 1) continue;
            if (progressManager != null) {
                progressManager.setInfoText("Applying transformation (" + ((AbstractTransform)dataTreeInterface).getName() + ")");
            }
            ((AbstractTransform)dataTreeInterface).applyTransformation(abstractDataMatrix, progressManager, bl);
        }
    }

    public double averageAll() {
        double d = 0.0;
        int n = 0;
        int n2 = this.getK();
        int n3 = this.getN();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (this.isMissing(j, i)) continue;
                ++n;
                d += this.getValue(j, i);
            }
        }
        if (n == 0) {
            return 0.0;
        }
        return d / (double)n;
    }

    public MVmatrix averagePerRow() {
        MVmatrix mVmatrix = new MVmatrix(this.getK(), 1, String.valueOf(this) + ".Av");
        int n = this.getN();
        for (int i = 0; i < n; ++i) {
            mVmatrix.setValue(i, 0, this.getRowMean(i));
        }
        return mVmatrix;
    }

    @Override
    public void beginUpdate() {
        this.doupdate = true;
        this.needupdate = false;
        this.structurechanged = false;
        this.updateN = this.getN();
        this.updateK = this.getK();
    }

    @Override
    public void beginUpdate(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            this.doupdate = true;
            this.needupdate = abstractDataMatrix.needupdate;
            this.updateN = abstractDataMatrix.updateN;
            this.updateK = abstractDataMatrix.updateK;
        }
    }

    public void beginUpdate(int n, int n2) {
    }

    public MVmatrix calculateColumnMean(final ProgressManager progressManager, MVmatrix mVmatrix) {
        int n = this.getK();
        if (n < 1) {
            return mVmatrix;
        }
        this.beginCalculations();
        mVmatrix.beginCalculations();
        final Matrix matrix = mVmatrix.getInternalMatrix();
        final int n2 = this.getN();
        final int[] nArray = this.getMissingCountForColumns(false);
        Threader threader = new Threader(this){
            final /* synthetic */ AbstractDataMatrix this$0;
            {
                this.this$0 = abstractDataMatrix;
            }

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    int n3 = nArray != null ? nArray[i] : 0;
                    matrix.set(i, 0, this.this$0.getColumnMean(i, n3));
                    if (!bl || progressManager == null) continue;
                    progressManager.incStep(4 * n2);
                }
            }
        };
        threader.execute(n);
        mVmatrix.endCalculations();
        this.endCalculations();
        return mVmatrix;
    }

    public double[] calculateMinMax() {
        double[] dArray = null;
        this.beginCalculations();
        int n = this.getN();
        int n2 = this.getK();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = this.getValue(i, j);
                if (dArray == null) {
                    dArray = new double[2];
                    dArray[0] = dArray[1] = d;
                    continue;
                }
                if (dArray[0] > d) {
                    dArray[0] = d;
                    continue;
                }
                if (!(dArray[1] < d)) continue;
                dArray[1] = d;
            }
        }
        this.endCalculations();
        return dArray;
    }

    public final double calculateStd(int n, double d, InnerColumnBoolean innerColumnBoolean, AbstractDataTransform abstractDataTransform) {
        int n2;
        double d2 = 0.0;
        int n3 = this.getK();
        int[] nArray = this.getMissingCountForRows(false);
        int n4 = n2 = nArray == null ? 0 : nArray[n];
        for (int i = 0; i < n3; ++i) {
            if (innerColumnBoolean == null || innerColumnBoolean.getValueBool(i)) {
                if (n2 != 0 && this.isMissing(n, i)) continue;
                double d3 = d - this.getValueBefore(abstractDataTransform, n, i);
                d3 *= d3;
                d2 += d3;
                continue;
            }
            if (n2 != 0 && this.isMissing(n, i)) continue;
            ++n4;
        }
        return Math.sqrt(d2 / (double)(n3 - 1 - n4));
    }

    @Override
    public void ClearDataLocal() throws IOException {
        this.missingMatrix_cs = null;
        this.MV_Knr_cs = null;
        this.MV_Nnr_cs = null;
        this.Kref_cs = null;
        this.Nref_cs = null;
        this.ClearChild();
    }

    @Override
    public abstract Object clone();

    public int[][] createComponentVector() {
        int n = Math.min(3, this.getN());
        int n2 = this.getK();
        int[][] nArray = new int[3][n2];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                double d3 = this.getValue(i, j);
                if (bl) {
                    d = d2 = d3;
                    bl = false;
                    continue;
                }
                if (d > d3) {
                    d = d3;
                }
                if (!(d2 < d3)) continue;
                d2 = d3;
            }
            double d4 = d2 - d;
            for (int j = 0; j < n2; ++j) {
                double d5 = this.getValue(i, j);
                nArray[i][j] = (int)((d5 - d) / d4 * 255.0);
            }
        }
        return nArray;
    }

    public SparseMatrix createSparseMatrix(String string) {
        return this.mergeMatrix(null, false, string);
    }

    public abstract SimpleTableModel createTableModel(boolean var1);

    public void deleteData(int[] nArray, int[] nArray2) {
        this.beginUpdate();
        AbstractMVmatrix abstractMVmatrix = this.subMatrix(null, null, null, this.getPrimitiveDataType());
        if (this instanceof AbstractMVmatrix) {
            abstractMVmatrix.subMatrix((AbstractMVmatrix)this, nArray, nArray2, this.getPrimitiveDataType());
        }
        this.endUpdate();
    }

    @Override
    public void endUpdate() {
        this.doupdate = false;
        if (this.needupdate && !this.isCleaned()) {
            DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, 0, 0);
            if (this.updateN != this.getN() || this.updateK != this.getK() || this.structurechanged) {
                dataMatrixEvent.Structurechanged(this.updateN, this.updateK);
            }
            this.triggerEvent(dataMatrixEvent);
            dataMatrixEvent.cleanUp();
        }
    }

    public void endUpdate(boolean bl, boolean bl2) {
        if (bl) {
            this.needupdate = true;
            this.structurechanged = bl2;
        }
        this.endUpdate();
    }

    public void enterDiskMode() {
    }

    public void exitDiskMode() {
    }

    public DenseVector extractColVector(int n) {
        DenseVector denseVector = new DenseVector(this.getN());
        for (int i = 0; i < this.getN(); ++i) {
            denseVector.set(i, this.getValue(i, n));
        }
        return denseVector;
    }

    public Object get(String string) {
        if (string.equalsIgnoreCase("n")) {
            return (double)this.getN();
        }
        if (string.equalsIgnoreCase("foldn")) {
            return (double)this.getFoldN();
        }
        if (string.equalsIgnoreCase("k")) {
            return (double)this.getK();
        }
        if (string.equalsIgnoreCase("foldk")) {
            return (double)this.getFoldK();
        }
        if (string.equalsIgnoreCase("name")) {
            return new StringDataClass(this.toString());
        }
        if (string.equalsIgnoreCase("model")) {
            return DataTreeManager.getAncestorNull(this, AbstractModel.class);
        }
        if (string.equalsIgnoreCase("dataset")) {
            return DataTreeManager.getAncestorNull(this, DataSet.class);
        }
        throw new RuntimeException("No such type: " + string);
    }

    public Object get(String string, Double d) {
        int n = d.intValue() - 1;
        if (string.equalsIgnoreCase("nref")) {
            int[] nArray = this.getNref();
            if (nArray != null && n < nArray.length) {
                return (double)(nArray[n] + 1);
            }
            return d;
        }
        if (string.equalsIgnoreCase("kref")) {
            int[] nArray = this.getKref();
            if (nArray != null && n < nArray.length) {
                return (double)(nArray[n] + 1);
            }
            return d;
        }
        throw new RuntimeException("No such type: " + string);
    }

    @Override
    public abstract String getColumnDescription(int var1, int var2);

    public double getColumnMean(int n, int n2) {
        int n3 = this.getN();
        double d = 0.0;
        if (n2 > 0) {
            for (int i = 0; i < n3; ++i) {
                if (this.isMissing(i, n)) continue;
                d += this.getValue(i, n);
            }
            d /= (double)(n3 - n2);
        } else {
            for (int i = 0; i < n3; ++i) {
                d += this.getValue(i, n);
            }
            d /= (double)n3;
        }
        return d;
    }

    @Override
    public int getColumnType() {
        return this.columnType;
    }

    @Override
    public byte getColumnType(int n) {
        return 4;
    }

    @Override
    public int getDataByteSize() {
        return TYPE_SIZE[this.getPrimitiveDataType()] * this.getMatrixSize();
    }

    @Override
    public int getDataSize() {
        return this.getMatrixSize();
    }

    public int getDataType() {
        return this.getRowType();
    }

    public int[] getFNref() {
        return null;
    }

    public int getFoldK() {
        return this.getN() / this.foldN;
    }

    public int getFoldN() {
        return this.foldN;
    }

    public String getFoldName(int n) {
        return this.getColumnDescription(n, 0);
    }

    public int getFoldsize() {
        return this.getK();
    }

    public double getFoldValue(int n, int n2) {
        return this.getValue(n, n2);
    }

    public int[] getGroup(int[] nArray) {
        AbstractDataMatrix abstractDataMatrix = this.getOrigMatrix();
        if (abstractDataMatrix instanceof GroupMatrix) {
            return ((GroupMatrix)abstractDataMatrix).getGroup(nArray);
        }
        return null;
    }

    public int getGroupID() {
        AbstractDataInfo abstractDataInfo = this.getDataInfo(0);
        if (abstractDataInfo != null) {
            return abstractDataInfo.getGroupID();
        }
        if (this.getTreeParent() instanceof DataSetGroup) {
            return ((DataSetGroup)this.getTreeParent()).getGroupID();
        }
        if (this.getTreeParent() instanceof InteractionGroupInterface) {
            return ((InteractionGroupInterface)((Object)this.getTreeParent())).getGroupID();
        }
        return 0;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        int n = this.getMatrixTag();
        if (n == 3) {
            return matrixIcon;
        }
        if ((n & 1) == 1) {
            return matrixIcon_obs;
        }
        if ((n & 2) == 2) {
            return matrixIcon_var;
        }
        return matrixIcon_other;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("<HTML>");
        if (this.matrixInfo != null) {
            stringBuilder.append(this.matrixInfo);
        }
        stringBuilder.append("<BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Observations:</TD><TD>").append(this.getN()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Variables:</TD><TD>").append(this.getK()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Missing values:</TD><TD>").append(this.getNrMV()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Precision:</TD><TD>").append(TYPE_DESCR[this.getPrimitiveDataType()]).append("</TD></TR>");
        stringBuilder.append("<TR><TD>State:</TD><TD>").append(this.getMemoryStateDescr()).append("</TD></TR>");
        if (this.isDataSource()) {
            stringBuilder.append("<TR><TD>Comment:</TD><TD>Is DataSource</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public abstract int getK();

    public int[] getKref() {
        if (this.isOrigMatrix()) {
            return null;
        }
        this.checkAndLoadIntoMemory();
        return this.Kref_cs;
    }

    public final int getKrefOrig(int n) {
        int[] nArray = this.getKref();
        if (nArray != null) {
            return this.getRefOrig(nArray, n, 0, nArray.length - 1);
        }
        if (n >= this.getK()) {
            return -n;
        }
        return n;
    }

    public final int[] getKrefOrig(int[] nArray, int[] nArray2) {
        return this.getRefOrig(this.getKref(), nArray, nArray2);
    }

    public DataTreeInterface getLastSubMatrix() {
        return this.getMatrixAt(this.getMatrixCount() - 1);
    }

    public double[] getLayerMinMax() {
        if (this.layerMinMax == null) {
            this.layerMinMax = new double[2];
            this.layerMinMax[0] = -1.0;
            this.layerMinMax[1] = -1.0;
        }
        return this.layerMinMax;
    }

    public AbstractDataMatrix[] getMatrixArray() {
        AbstractDataMatrix[] abstractDataMatrixArray = new AbstractDataMatrix[this.getMatrixCount()];
        for (int i = 0; i < abstractDataMatrixArray.length; ++i) {
            abstractDataMatrixArray[i] = this.getMatrixAt(i);
        }
        return abstractDataMatrixArray;
    }

    public AbstractDataMatrix getMatrixAt(int n) {
        return this;
    }

    public int getMatrixCount() {
        return 1;
    }

    public int getMatrixSize() {
        return this.getK() * this.getN();
    }

    @Override
    public int getMatrixTag() {
        return this.rowType | this.columnType;
    }

    @Override
    public int getMissingCountForColumn(int n) {
        int[] nArray;
        if (this.hasMissing() && (nArray = this.getMissingCountForColumns(false)) != null) {
            return nArray[n];
        }
        return 0;
    }

    public int[] getMissingCountForColumns(boolean bl) {
        this.checkAndLoadIntoMemory();
        if (bl && this.MV_Knr_cs == null) {
            this.MV_Knr_cs = new int[this.K];
        }
        return this.MV_Knr_cs;
    }

    @Override
    public int getMissingCountForRow(int n) {
        int[] nArray;
        if (this.hasMissing() && (nArray = this.getMissingCountForRows(false)) != null) {
            return nArray[n];
        }
        return 0;
    }

    public int getMissingCountForRow(int n, int[] nArray) {
        int n2 = 0;
        int[] nArray2 = this.getMissingCountForColumns(false);
        if (nArray2 != null) {
            for (int n3 : nArray) {
                if (n3 >= nArray2.length || nArray2[n3] <= 0 || !this.isMissing(n, n3)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int[] getMissingCountForRows(boolean bl) {
        this.checkAndLoadIntoMemory();
        if (bl && this.MV_Nnr_cs == null) {
            this.MV_Nnr_cs = new int[this.N];
        }
        return this.MV_Nnr_cs;
    }

    public boolean[][] getMissingMatrix() {
        if (this.nrMV == 0) {
            return null;
        }
        this.checkAndLoadIntoMemory();
        return this.missingMatrix_cs;
    }

    public AbstractModel getModel() {
        return null;
    }

    @Override
    public abstract int getN();

    @Override
    public byte getNodeType() {
        return 1;
    }

    public int[] getNref() {
        if (this.isOrigMatrix()) {
            return null;
        }
        this.checkAndLoadIntoMemory();
        return this.Nref_cs;
    }

    public final int getNrefOrig(int n) {
        int[] nArray = this.getNref();
        if (nArray != null) {
            return this.getRefOrig(nArray, n, 0, nArray.length - 1);
        }
        if (n >= this.getN()) {
            return -n;
        }
        return n;
    }

    public final int[] getNrefOrig(int[] nArray, int[] nArray2) {
        return this.getRefOrig(this.getNref(), nArray, nArray2);
    }

    public int getNrMV() {
        return this.nrMV;
    }

    public final int getOrigSize(int n) {
        if (n == 8) {
            return this.getN();
        }
        if (n == 4) {
            return this.getK();
        }
        AbstractDataMatrix abstractDataMatrix = this.getOrigMatrix();
        if (abstractDataMatrix != null) {
            if (n == 1) {
                return abstractDataMatrix.getN();
            }
            return abstractDataMatrix.getK();
        }
        if (n == 1) {
            return this.getN();
        }
        return this.getK();
    }

    public Object getPercent() {
        return NiceDataFormat.toPercent(this.getValue(this.getN() - 1, this.getK() - 1));
    }

    public Object getPercent(Double[] doubleArray) {
        return this.getPercent(doubleArray[0], doubleArray[1]);
    }

    public Object getPercent(Double d, Double d2) {
        return NiceDataFormat.toPercent(this.getValue(d2.intValue() - 1, d.intValue() - 1));
    }

    public int[] getReferenceKref() {
        return this.getKref();
    }

    public int[] getReferenceNref() {
        return this.getNref();
    }

    @Override
    public abstract String getRowDescription(int var1, int var2);

    public double getRowMean(int n) {
        return this.getRowMean(n, null, null);
    }

    public final double getRowMean(int n, InnerColumnBoolean innerColumnBoolean, AbstractDataTransform abstractDataTransform) {
        int n2 = this.getK();
        double d = 0.0;
        int n3 = this.getMissingCountForRow(n);
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (innerColumnBoolean == null || innerColumnBoolean.getValueBool(i)) {
                    if (this.isMissing(n, i)) continue;
                    d += this.getValueBefore(abstractDataTransform, n, i);
                    continue;
                }
                if (this.isMissing(n, i)) continue;
                ++n3;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (innerColumnBoolean == null || innerColumnBoolean.getValueBool(i)) {
                    d += this.getValueBefore(abstractDataTransform, n, i);
                    continue;
                }
                ++n3;
            }
        }
        return d /= (double)(n2 - n3);
    }

    @Override
    public int getRowType() {
        return this.rowType;
    }

    @Override
    public byte getRowType(int n) {
        return 4;
    }

    public double getScaledValue(int n, int n2) {
        if (!this.isMissing(n, n2)) {
            double d = this.getValue(n, n2);
            int n3 = this.getTreeNodeCount();
            for (int i = 0; i < n3; ++i) {
                AbstractTransform abstractTransform;
                DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof AbstractTransform) || !(abstractTransform = (AbstractTransform)dataTreeInterface).isScale()) continue;
                d = abstractTransform.scaleValue(this, n, n2, d);
            }
            return d;
        }
        return 0.0;
    }

    public Double getSize() {
        return this.getMatrixSize();
    }

    @Override
    public String getToolTipText() {
        if (this.matrixInfo == null) {
            return super.getToolTipText();
        }
        return "<HTML>" + this.matrixInfo + "</HTML>";
    }

    public AbstractTransform getTransformationByType(int n) {
        int n2 = this.getTreeNodeCount();
        for (int i = 0; i < n2; ++i) {
            AbstractTransform abstractTransform;
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractTransform) || (abstractTransform = (AbstractTransform)dataTreeInterface).getTreeType() != n) continue;
            return abstractTransform;
        }
        return null;
    }

    public String getTransformationInfo() {
        this.setTransformationInfo();
        return this.transformationInfo;
    }

    public byte getTypeAt(int n, int n2) {
        if (this.isMissing(n, n2)) {
            return -2;
        }
        return 4;
    }

    public Double getValue() {
        return this.getValue(this.getN() - 1, this.getK() - 1);
    }

    public double getValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        return this.getValue(n, n2);
    }

    public Double getValue(Double[] doubleArray) {
        return this.getValue(doubleArray[0], doubleArray[1]);
    }

    public Double getValue(Double d, Double d2) {
        return this.getValue(d2.intValue() - 1, d.intValue() - 1);
    }

    @Override
    public abstract double getValue(int var1, int var2);

    public Double getValue(String string, String string2) {
        double d = Double.parseDouble(string);
        double d2 = Double.parseDouble(string2);
        return this.getValue(d2, d);
    }

    public double getValueBefore(AbstractDataTransform abstractDataTransform, int n, int n2) {
        return this.getValue(n, n2);
    }

    public double getVariableStandardDeviation(int n) {
        return this.getVariableStandardDeviation(n, this.getN(), this.getMissingCountForColumn(n));
    }

    public double getVariableStandardDeviation(int n, int n2, int n3) {
        double d = this.getColumnMean(n, n3);
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (n3 != 0 && this.isMissing(i, n)) continue;
            double d3 = d - this.getValue(i, n);
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(n2 - 1 - n3));
    }

    public MVmatrix getVariableStandardDeviation(final ProgressManager progressManager, MVmatrix mVmatrix) {
        final int n = this.getN();
        int n2 = this.getK();
        if (mVmatrix == null) {
            mVmatrix = new MVmatrix(n2, 1, String.valueOf(this) + ".Std");
            if (n <= 1) {
                if (progressManager != null) {
                    progressManager.incStep(n * n2);
                }
                return mVmatrix;
            }
        } else if (progressManager != null) {
            progressManager.incStep(n * n2);
        }
        if (n <= 1) {
            int n3 = mVmatrix.getN();
            for (int i = 0; i < n3; ++i) {
                mVmatrix.setValue(i, 0, 0.0);
            }
            return mVmatrix;
        }
        final int[] nArray = this.getMissingCountForColumns(false);
        final MVmatrix mVmatrix2 = mVmatrix;
        Threader threader = new Threader(this){
            final /* synthetic */ AbstractDataMatrix this$0;
            {
                this.this$0 = abstractDataMatrix;
            }

            @Override
            protected void doOp(boolean bl, int n3, int n2) {
                for (int i = n3; i < n2; ++i) {
                    mVmatrix2.setValue(i, 0, this.this$0.getVariableStandardDeviation(i, n, nArray == null ? 0 : nArray[i]));
                    if (!bl || progressManager == null) continue;
                    progressManager.incStep(n * 2);
                }
            }
        };
        threader.execute(n2);
        return mVmatrix;
    }

    @Override
    public boolean hasMissing() {
        return this.getNrMV() > 0;
    }

    public Double[] index(String string, String string2, Double[] doubleArray) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int[] nArray = this.getNref();
        int n2 = this.getFoldN();
        if (string2.equals("line")) {
            var7_7 = string.equalsIgnoreCase("row");
            if (var7_7 != 0) {
                for (n = 0; n < this.getN(); ++n) {
                    for (Double d : doubleArray) {
                        if ((double)(n % n2) != d - 1.0) continue;
                        arrayList.add((double)(nArray != null ? nArray[n] : n) + 1.0);
                    }
                }
            } else {
                for (n = 0; n < this.getN(); ++n) {
                    for (Double d : doubleArray) {
                        if ((double)(n / n2) != d - 1.0) continue;
                        arrayList.add((double)(nArray != null ? nArray[n] : n) + 1.0);
                    }
                }
            }
        } else if (string2.equalsIgnoreCase("area") && doubleArray.length == 4) {
            var7_7 = doubleArray[0].intValue();
            n = doubleArray[1].intValue();
            int n3 = doubleArray[2].intValue();
            int n4 = doubleArray[3].intValue();
            for (int i = var7_7; i < var7_7 + n3; ++i) {
                for (int j = n; j < n + n4; ++j) {
                    int n5 = (j - 1) * n2 + i;
                    arrayList.add(Double.valueOf(n5));
                }
            }
        }
        if (arrayList.size() > 0) {
            Double[] doubleArray2 = new Double[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                doubleArray2[n] = (Double)arrayList.get(n);
            }
            return doubleArray2;
        }
        return null;
    }

    public Double[] interval(Double d, Double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.K; ++i) {
            double d3 = this.getValue(0, i);
            if (!(d3 >= d) || !(d3 < d2)) continue;
            arrayList.add(Double.valueOf(i));
        }
        return this.createArrayFromList(arrayList);
    }

    public Double[] interval(Double d, Double d2, Double d3) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = d.intValue() - 1;
        boolean bl = this.isModelMatrix();
        int n2 = bl ? this.getK() : this.N;
        int[] nArray = bl ? this.getKref() : this.getNref();
        for (int i = 0; i < n2; ++i) {
            double d4 = bl ? this.getValue(n, i) : this.getValue(i, n);
            if (!(d4 >= d2) || !(d4 < d3)) continue;
            if (nArray != null) {
                arrayList.add((double)nArray[i] + 1.0);
                continue;
            }
            arrayList.add((double)i + 1.0);
        }
        return this.createArrayFromList(arrayList);
    }

    public boolean isDataSource() {
        return false;
    }

    public boolean isFilterAt(int n, int n2) {
        if (this.filter == null) {
            return false;
        }
        return this.filter[n][n2];
    }

    public boolean isFoldable() {
        return !(this.getTreeParent() instanceof LayerMatrix) && this.isUnFolded();
    }

    public boolean isFoldMissing(int n, int n2) {
        return this.isMissing(n, n2);
    }

    public boolean isGroup() {
        return this.getGroupID() != 0;
    }

    public boolean isInDiskMode() {
        return false;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (!this.hasMissing()) {
            return false;
        }
        boolean[][] blArray = this.getMissingMatrix();
        if (blArray != null && n >= 0 && n2 >= 0 && n < blArray.length && n2 < blArray[n].length) {
            return blArray[n][n2];
        }
        return false;
    }

    public abstract boolean isModel();

    public boolean isModelMatrix() {
        return false;
    }

    public boolean isObsN() {
        return this.rowType == 1;
    }

    public boolean isOrigMatrix() {
        if (this.isOrig == null) {
            AbstractDataMatrix abstractDataMatrix = this.getOrigMatrix();
            if (abstractDataMatrix == null) {
                return false;
            }
            this.isOrig = abstractDataMatrix.equals(this);
        }
        return this.isOrig;
    }

    public boolean isProtected() {
        return true;
    }

    public boolean isRotate() {
        return false;
    }

    @Override
    public boolean isSupportClearMemory() {
        return true;
    }

    public boolean isUnFolded() {
        return this.foldN > 0;
    }

    @Override
    public boolean isUpdating() {
        return this.doupdate;
    }

    @Override
    public boolean isVisibleInTree() {
        if (this.getMatrixSize() == 0) {
            // empty if block
        }
        return super.isVisibleInTree();
    }

    public Object[] list(String string) {
        if (string.equalsIgnoreCase("n")) {
            return this.createList(this.getN());
        }
        if (string.equalsIgnoreCase("k")) {
            return this.createList(this.getK());
        }
        if (string.equalsIgnoreCase("nref") || string.equalsIgnoreCase("kref")) {
            int[] nArray = this.getNref();
            if (string.equalsIgnoreCase("kref")) {
                nArray = this.getKref();
            }
            Object[] objectArray = new Double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = (double)nArray[i] + 1.0;
            }
            return objectArray;
        }
        if (string.equalsIgnoreCase("obsdesc")) {
            return this.listDescription(this.getColumnDescription(), this.getNref());
        }
        if (string.equalsIgnoreCase("vardesc")) {
            return this.listDescription(this.getRowDescription(), this.getKref());
        }
        if (string.equalsIgnoreCase("variablenames")) {
            return this.listDescription(this.getColumnDescription(), this.getKref());
        }
        throw new RuntimeException("No such type: " + string);
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.setMatrixDataSetContainer(this.dataSetContainer);
        this.LoadChild(randomInputStream);
        if (!this.isInDiskMode() && this.getMemoryState() != 2) {
            this.LoadDataMatrixLocal(randomInputStream);
        }
    }

    public SparseMatrix mergeMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl, String string) {
        SimpleTableModel simpleTableModel = this.createTableModel(true);
        int n = simpleTableModel.getColumnDescriptionCount();
        int n2 = simpleTableModel.getRowDescriptionCount();
        int n3 = simpleTableModel.getRowCount();
        int n4 = simpleTableModel.getColumnCount();
        if (abstractDataMatrix != null) {
            if (bl) {
                n3 += abstractDataMatrix.getN();
            } else {
                n4 += abstractDataMatrix.getK();
            }
        }
        SparseMatrix sparseMatrix = new SparseMatrix((n3 += n) * (n4 += n2), string);
        sparseMatrix.beginUpdate();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5;
                if (i >= n && j >= n2) {
                    sparseMatrix.setValue(i, j, simpleTableModel.getValueAt(i - n, j - n2));
                    continue;
                }
                if (i < n && j >= n2) {
                    n5 = j - n2;
                    if (abstractDataMatrix != null && n5 >= this.getK()) {
                        sparseMatrix.setValue(i, j, abstractDataMatrix.getColumnDescription(n5 -= this.getK(), i), false);
                        continue;
                    }
                    sparseMatrix.setValue(i, j, simpleTableModel.getRowDescription(i, n5));
                    continue;
                }
                if (i < n) continue;
                n5 = i - n;
                if (abstractDataMatrix != null && n5 >= this.getN()) {
                    sparseMatrix.setValue(i, j, abstractDataMatrix.getRowDescription(n5 -= this.getN(), j), false);
                    continue;
                }
                sparseMatrix.setValue(i, j, simpleTableModel.getColumnDescriptionSorted(n5, j));
            }
        }
        sparseMatrix.endUpdate();
        return sparseMatrix;
    }

    public void minusEqualsMV(Matrix matrix) {
        this.MV_plus_minus_equals(matrix, false);
    }

    public MVmatrix minusMV(Matrix matrix) {
        return this.MV_plus_minus(matrix, false);
    }

    public Vector<RCinfo> missingValueCheck(double d, boolean bl) {
        int n = this.getK();
        int n2 = this.getN();
        int[] nArray = this.getKref();
        Vector<RCinfo> vector = new Vector<RCinfo>();
        if (!bl) {
            n = this.getN();
            n2 = this.getK();
            nArray = this.getNref();
        }
        for (int i = 0; i < n; ++i) {
            int n3 = bl ? this.getMissingCountForColumn(i) : this.getMissingCountForRow(i);
            double d2 = (double)n3 / (double)n2 * 100.0;
            if (!(d2 >= d)) continue;
            vector.addElement(new RCinfo(d2, nArray[i], true));
        }
        return vector;
    }

    public void multValue(int n, int n2, double d) {
        this.setValue(n, n2, this.getValue(n, n2) * d);
    }

    public void plusEqualsMV(Matrix matrix) {
        this.MV_plus_minus_equals(matrix, true);
    }

    public MVmatrix plusMV(Matrix matrix) {
        return this.MV_plus_minus(matrix, true);
    }

    public double[] polyFitRow(int n, MVmatrix mVmatrix, int n2, AbstractDataTransform abstractDataTransform) {
        int n3;
        int n4 = this.getK();
        DenseMatrix denseMatrix = new DenseMatrix(n4, n2 + 1);
        for (n3 = 0; n3 < n4; ++n3) {
            denseMatrix.set(n3, n2, 1.0);
        }
        for (n3 = denseMatrix.numColumns() - 2; n3 >= 0; --n3) {
            for (int i = 0; i < n4; ++i) {
                denseMatrix.set(i, n3, mVmatrix.getValue(i, 0) * denseMatrix.get(i, n3 + 1));
            }
        }
        DenseMatrix denseMatrix2 = new DenseMatrix(n2 + 1, 1);
        if (n4 > 1) {
            QR qR = QR.factorize((Matrix)denseMatrix);
            DenseMatrix denseMatrix3 = qR.getQ();
            int n5 = denseMatrix3.numColumns();
            int n6 = denseMatrix3.numRows();
            DenseMatrix denseMatrix4 = new DenseMatrix(n5, 1);
            for (int i = 0; i < n5; ++i) {
                double d = 0.0;
                for (int j = 0; j < n6; ++j) {
                    d += denseMatrix3.get(j, i) * this.getValueBefore(abstractDataTransform, n, j);
                }
                denseMatrix4.set(i, 0, d);
            }
            qR.getR().solve((Matrix)denseMatrix4, (Matrix)denseMatrix2);
        } else {
            DenseMatrix denseMatrix5 = new DenseMatrix(n4, 1);
            for (int i = 0; i < n4; ++i) {
                denseMatrix5.set(i, 0, this.getValueBefore(abstractDataTransform, n, i));
            }
            denseMatrix.solve((Matrix)denseMatrix5, (Matrix)denseMatrix2);
        }
        return denseMatrix2.getData();
    }

    public void printMatrix() {
        this.printMatrix(null);
    }

    public void printMatrix(String string) {
        if (string != null) {
            System.out.println(string);
        }
        int n = this.getK();
        int n2 = this.getN();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(this.getValue(i, j));
            }
            System.out.println("");
        }
        System.out.println("####");
    }

    public void quickSaveMatrix(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.getN(); ++i) {
                for (int j = 0; j < this.getK(); ++j) {
                    bufferedWriter.write(String.valueOf(this.getValue(i, j)));
                    if (j >= this.getK() - 1) continue;
                    bufferedWriter.write(";");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public void refreshModel() {
    }

    public void removeIdentifiersAndTransformations() {
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof Description) && !(dataTreeInterface instanceof AbstractTransform)) continue;
            dataTreeInterface.cleanUp();
            this.removeTreeNode(dataTreeInterface);
        }
    }

    @Override
    public void removeMissing(int n, int n2) {
        boolean[][] blArray = this.getMissingMatrix();
        if (blArray != null && blArray[n][n2]) {
            int[] nArray = this.getMissingCountForColumns(false);
            int[] nArray2 = this.getMissingCountForRows(false);
            blArray[n][n2] = false;
            if (nArray != null) {
                int n3 = n2;
                nArray[n3] = nArray[n3] - 1;
            }
            if (nArray2 != null) {
                int n4 = n;
                nArray2[n4] = nArray2[n4] - 1;
            }
            --this.nrMV;
        }
    }

    public void resetMinMax() {
        this.layerMinMax = null;
    }

    public void resetRef() {
        int n;
        int[] nArray = this.getNref();
        int[] nArray2 = this.getKref();
        for (n = 0; n < this.getN(); ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < this.getK(); ++n) {
            nArray2[n] = n;
        }
    }

    public void resize(int n, int n2) {
        this.N = 0;
        this.K = 0;
        this.missingMatrix_cs = null;
        this.nrMV = 0;
        this.resetMemoryState();
        this.purge();
    }

    public void reverseTransformations(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl) {
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractTransform)) continue;
            AbstractTransform abstractTransform = (AbstractTransform)dataTreeInterface;
            if (progressManager != null) {
                progressManager.setInfoText("Reversing transformation (" + abstractTransform.getName() + ")");
            }
            abstractTransform.reverseTransformation(abstractDataMatrix, bl);
        }
    }

    public DataTreeInterface save(ProgressManager progressManager, String string) {
        return this.save(progressManager, string, "txt", null, null);
    }

    public DataTreeInterface save(ProgressManager progressManager, String string, String string2) {
        return this.save(progressManager, string, string2, null, null);
    }

    public DataTreeInterface save(ProgressManager progressManager, String string, String string2, Properties properties) {
        return this.save(progressManager, string, string2, null, properties);
    }

    public DataTreeInterface save(ProgressManager progressManager, String string, String string2, String string3) {
        return this.save(progressManager, string, string2, string3, null);
    }

    public DataTreeInterface save(ProgressManager progressManager, String object, String string, String string2, Properties properties) {
        this.beginCalculations();
        int n = ((String)object).indexOf(".");
        if (n < 0) {
            object = (String)object + "." + string;
        }
        AbstractExportInfo.ExportDataNow(progressManager, new File((String)object), string, null, this.createTableModel(true), true, properties);
        this.endCalculations();
        return this;
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveChild(randomOutputStream);
        if (this.getMemoryState() != 2) {
            this.SaveDataMatrixLocal(randomOutputStream);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("N", this.getN());
        randomOutputStream.writePropertyInt("K", this.getK());
        randomOutputStream.writePropertyInt("nrMV", this.nrMV);
        randomOutputStream.writePropertyInt("rowtype", this.rowType);
        randomOutputStream.writePropertyInt("coltype", this.columnType);
        randomOutputStream.writePropertyStringUTF("tinfo", this.transformationInfo);
        randomOutputStream.writePropertyStringUTF("html", this.htmlName);
        randomOutputStream.writePropertyStringUTF("mInfo", this.matrixInfo);
        randomOutputStream.writePropertyInt("fN", this.foldN);
        randomOutputStream.writePropertyBooleanArray("filter", this.filter);
        if (this.layerMinMax != null) {
            randomOutputStream.writePropertyDouble("wavemin", this.layerMinMax[0]);
            randomOutputStream.writePropertyDouble("wavemax", this.layerMinMax[1]);
        }
    }

    public void setColumnType(int n) {
        this.columnType = n;
    }

    public void setFilterAt(int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            this.beginUpdate();
        }
        if (this.filter == null) {
            this.filter = new boolean[this.getN()][this.getK()];
            for (int i = 0; i < this.getN(); ++i) {
                Arrays.fill(this.filter[i], false);
            }
        }
        this.filter[n][n2] = bl;
        if (bl2) {
            this.needupdate = true;
            this.endUpdate();
        }
    }

    public void setFilterAt(int n, int n2, int n3, boolean bl) {
        int n4;
        this.beginUpdate();
        if (this.filter == null) {
            this.filter = new boolean[this.getN()][this.getK()];
            for (n4 = 0; n4 < this.getN(); ++n4) {
                Arrays.fill(this.filter[n4], false);
            }
        }
        for (n4 = n; n4 <= n2; ++n4) {
            this.filter[n4][n3] = bl;
        }
        this.needupdate = true;
        this.endUpdate();
    }

    public void setFoldN(int n) {
        this.foldN = n;
    }

    public void setHtmlName(String string) {
        this.htmlName = string;
    }

    public abstract void setKInfo(int var1, int var2, String var3);

    public final void setKref(int[] nArray) {
        this.Kref_cs = nArray;
    }

    public void setLayerMinMax() {
    }

    public void setLayerMinMax(double d, double d2) {
        this.getLayerMinMax();
        this.layerMinMax[0] = d;
        this.layerMinMax[1] = d2;
    }

    public void setMatrixInfo(String string) {
        this.matrixInfo = string;
    }

    public abstract void setNInfo(int var1, int var2, String var3);

    public final void setNref(int[] nArray) {
        this.Nref_cs = nArray;
    }

    public void setRowType(int n) {
        this.rowType = n;
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        super.setTreeParent(dataTreeInterface);
        if (dataTreeInterface instanceof DataTreeClass) {
            this.setMatrixDataSetContainer(((DataTreeClass)dataTreeInterface).getCase());
        }
    }

    public void setUpdated() {
        this.needupdate = true;
    }

    @Override
    public abstract void setValue(int var1, int var2, double var3);

    @Override
    public abstract void setValue(int var1, int var2, double var3, boolean var5);

    public final void setValue(int n, int n2, FastDecimal fastDecimal) {
        this.setValueMinMax(n, n2, fastDecimal.getValue(), fastDecimal.isMissing());
    }

    public void setValueCheckMissing(int n, int n2, double d) {
        this.setValue(n, n2, d, this.isMissing(n, n2) || Double.isNaN(d) || Double.isInfinite(d));
    }

    public void setValueMinMax(int n, int n2, double d) {
        this.setValueMinMax(n, n2, d, false);
    }

    public void setValueMinMax(int n, int n2, double d, boolean bl) {
        if (!bl) {
            if (this.layerMinMax == null) {
                this.getLayerMinMax();
                this.layerMinMax[0] = d;
                this.layerMinMax[1] = d;
            } else if (this.layerMinMax[0] > d) {
                this.layerMinMax[0] = d;
            } else if (this.layerMinMax[1] < d) {
                this.layerMinMax[1] = d;
            }
        }
        this.setValue(n, n2, d, bl);
    }

    public MVmatrix subMatrix(AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2) {
        return (MVmatrix)this.subMatrix(null, abstractMVmatrix, nArray, nArray2, 5);
    }

    public AbstractMVmatrix subMatrix(AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2, int n) {
        return this.subMatrix(null, abstractMVmatrix, nArray, nArray2, n);
    }

    public MVmatrix subMatrix(int[] nArray, int[] nArray2) {
        return (MVmatrix)this.subMatrix(null, null, nArray, nArray2, 5);
    }

    public AbstractMVmatrix subMatrix(int[] nArray, int[] nArray2, int n) {
        return this.subMatrix(null, null, nArray, nArray2, n);
    }

    public MVmatrix subMatrix(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2) {
        return (MVmatrix)this.subMatrix(progressManager, abstractMVmatrix, nArray, nArray2, 5);
    }

    public AbstractMVmatrix subMatrix(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2, int n) {
        this.beginCalculations();
        int n2 = this.getN();
        int n3 = this.getK();
        int n4 = n2;
        int n5 = n3;
        int[] nArray3 = this.getNref();
        int[] nArray4 = this.getKref();
        if (nArray != null && (n4 -= nArray[nArray.length - 1]) < 0) {
            n4 = 0;
        }
        if (nArray2 != null && (n5 -= nArray2[nArray2.length - 1]) < 0) {
            n5 = 0;
        }
        if (abstractMVmatrix == null) {
            abstractMVmatrix = AbstractDataMatrix.createMatrix(n4, n5, String.valueOf(this) + ".sub", n);
        } else {
            abstractMVmatrix.resize(n4, n5);
        }
        abstractMVmatrix.beginCalculations();
        if (progressManager != null) {
            progressManager.setMaximumAndReset(n4 * n5);
        }
        abstractMVmatrix.setRowDescription(this.getRowDescription());
        abstractMVmatrix.setColumnDescription(this.getColumnDescription());
        abstractMVmatrix.setMatrixDataSetContainer(this.dataSetContainer);
        int[] nArray5 = abstractMVmatrix.getNref();
        int[] nArray6 = abstractMVmatrix.getKref();
        if (nArray5 == null) {
            nArray5 = new int[n4];
            abstractMVmatrix.setNref(nArray5);
        }
        if (nArray6 == null) {
            nArray6 = new int[n5];
            abstractMVmatrix.setKref(nArray6);
        }
        AbstractMatrix abstractMatrix = abstractMVmatrix.getMatrix();
        for (int i = 0; i < n2; ++i) {
            int n6 = 0;
            if (nArray != null && (n6 = nArray[i]) == -1) continue;
            nArray5[i - n6] = nArray3 == null ? i : nArray3[i];
            int n7 = this.getMissingCountForRow(i);
            for (int j = 0; j < n3; ++j) {
                int n8 = 0;
                if (nArray2 != null && (n8 = nArray2[j]) == -1) continue;
                nArray6[j - n8] = nArray4 == null ? j : nArray4[j];
                if (n7 > 0 && this.isMissing(i, j)) {
                    abstractMVmatrix.addMissing(i - n6, j - n8);
                    continue;
                }
                abstractMatrix.set(i - n6, j - n8, this.getValue(i, j));
            }
            if (progressManager == null) continue;
            progressManager.incStep(n5);
        }
        abstractMVmatrix.setFoldN(this.getFoldN());
        this.endCalculations();
        abstractMVmatrix.endCalculations();
        return abstractMVmatrix;
    }

    public MVmatrix subMatrix_Exclude(int[] nArray) {
        int n;
        int n2 = this.getN();
        int[] nArray2 = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0 || nArray[n] >= nArray2.length) continue;
            nArray2[nArray[n]] = -1;
        }
        for (n = 0; n < n2; ++n) {
            if (nArray2[n] == -1) {
                ++n3;
                continue;
            }
            nArray2[n] = n3;
        }
        nArray2[n2] = n3;
        return (MVmatrix)this.subMatrix(nArray2, null, 5);
    }

    public MVmatrix subMatrix_Include_Only(int[] nArray) {
        int n;
        int n2 = this.getN();
        int[] nArray2 = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0 || nArray[n] >= nArray2.length) continue;
            nArray2[nArray[n]] = -1;
        }
        for (n = 0; n < n2; ++n) {
            if (nArray2[n] == -1) {
                nArray2[n] = n3;
                continue;
            }
            nArray2[n] = -1;
            ++n3;
        }
        nArray2[n2] = n3;
        return (MVmatrix)this.subMatrix(nArray2, null, 5);
    }

    public void fill(Double d) {
        for (int i = 0; i < this.getN(); ++i) {
            for (int j = 0; j < this.getK(); ++j) {
                this.setValue(i, j, d);
            }
        }
    }

    public String toHtmlString() {
        if (this.htmlName == null) {
            return this.toString();
        }
        return this.htmlName;
    }

    public void triggerEvent(DataMatrixEvent dataMatrixEvent) {
        if (this.listenerList != null) {
            ArrayList arrayList = new ArrayList(this.listenerList);
            for (DataTreeListener dataTreeListener : arrayList) {
                if (!(dataTreeListener instanceof DataMatrixListener)) continue;
                ((DataMatrixListener)dataTreeListener).matrixChanged(dataMatrixEvent);
            }
            for (DataTreeListener dataTreeListener : arrayList) {
                if (!(dataTreeListener instanceof DataMatrixListener)) continue;
                dataTreeListener.eventFinished(dataMatrixEvent);
            }
        }
        dataMatrixEvent.cleanUp();
    }

    public Double[] wildcard(String string, String string2) {
        String[] stringArray;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Description description = null;
        description = string.equalsIgnoreCase("row") ? this.getRowDescription() : this.getColumnDescription();
        InnerColumnString innerColumnString = (InnerColumnString)description.getPrimaryColumn();
        for (String string3 : stringArray = string2.split(",")) {
            String string4 = string3.replaceAll("(\\.\\*|\\*)", ".*");
            Pattern.compile(string4);
            for (int i = 0; i < innerColumnString.getSize(); ++i) {
                if (!innerColumnString.getValueLocal(i).matches(string4)) continue;
                arrayList.add(Double.valueOf(i));
            }
        }
        return this.createArrayFromList(arrayList);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.missingMatrix_cs = null;
        this.MV_Knr_cs = null;
        this.MV_Nnr_cs = null;
        this.Kref_cs = null;
        this.Nref_cs = null;
    }

    protected abstract void ClearChild() throws IOException;

    protected abstract void LoadChild(RandomInputStream var1) throws IOException;

    protected void LoadDataMatrixLocal(RandomInputStream randomInputStream) throws IOException {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.K; ++j) {
                this.setValue(i, j, randomInputStream.ReadBlockDouble());
            }
        }
    }

    protected abstract void SaveChild(RandomOutputStream var1) throws IOException;

    protected void SaveDataMatrixLocal(RandomOutputStream randomOutputStream) throws IOException {
        for (int i = 0; i < this.getN(); ++i) {
            for (int j = 0; j < this.getK(); ++j) {
                randomOutputStream.WriteBlockDouble(this.getValue(i, j));
            }
        }
    }

    private Double[] createArrayFromList(List<Double> list) {
        Double[] doubleArray = new Double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            doubleArray[i] = list.get(i);
        }
        return doubleArray;
    }

    private Object[] createList(int n) {
        Object[] objectArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = (double)i + 1.0;
        }
        return objectArray;
    }

    private final AbstractDataMatrix getOrigMatrix() {
        DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(this, DataSet.class);
        if (dataSet != null) {
            return dataSet.getParentMatrix();
        }
        Case case_ = this.getCase();
        if (case_ != null) {
            return case_.getOriginalMatrix();
        }
        return null;
    }

    private int[] getRefOrig(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray3 == null) {
            nArray3 = new int[nArray2.length];
        }
        if (nArray == null) {
            System.arraycopy(nArray2, 0, nArray3, 0, nArray3.length);
        } else {
            int n = 0;
            this.lastIndex = -1;
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = this.getRefOrig(nArray, nArray2[i], n, nArray.length - 1);
                if (nArray3[i] == -1) continue;
                n = nArray3[i] + 1;
            }
        }
        return nArray3;
    }

    private int getRefOrig(int[] nArray, int n, int n2, int n3) {
        if (nArray != null && nArray.length > 0) {
            if (++this.lastIndex >= nArray.length) {
                this.lastIndex = 0;
            }
            if (nArray[this.lastIndex] == n) {
                return this.lastIndex;
            }
            int n4 = nArray.length - 1;
            if (nArray[0] > n || nArray[n4] < n) {
                return -1;
            }
            while (n2 <= n3) {
                int n5 = n2 + n3 >>> 1;
                if (n5 >= nArray.length) {
                    return -(n2 + 1);
                }
                int n6 = nArray[n5];
                if (n6 < n) {
                    n2 = n5 + 1;
                    continue;
                }
                if (n6 > n) {
                    n3 = n5 - 1;
                    continue;
                }
                this.lastIndex = n5;
                return this.lastIndex;
            }
            return -(n2 + 1);
        }
        return n;
    }

    public int getBand(int n) {
        int n2;
        AbstractDataMatrix abstractDataMatrix = this;
        if (abstractDataMatrix instanceof FoldMatrix) {
            abstractDataMatrix = ((FoldMatrix)abstractDataMatrix).getReferencedMatrix();
        }
        if ((n2 = abstractDataMatrix.getKrefOrig(n)) >= 0) {
            return n2;
        }
        return n;
    }

    private Object[] listDescription(Description description, int[] nArray) {
        InnerColumnString innerColumnString = (InnerColumnString)description.getPrimaryColumn();
        Object[] objectArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string = innerColumnString.getValueLocal(nArray[i]);
            int n = string.indexOf(":");
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            objectArray[i] = string.trim();
        }
        return objectArray;
    }

    private MVmatrix MV_plus_minus(Matrix matrix, boolean bl) {
        final int n = this.getN();
        int n2 = this.getK();
        final MVmatrix mVmatrix = new MVmatrix(n, n2);
        mVmatrix.setMissing(this);
        if (matrix instanceof DenseMatrix) {
            final double d = bl ? 1.0 : -1.0;
            final boolean[][] blArray = this.getMissingMatrix();
            final double[] dArray = ((DenseMatrix)matrix).getData();
            Threader threader = new Threader(this){
                final /* synthetic */ AbstractDataMatrix this$0;
                {
                    this.this$0 = abstractDataMatrix;
                }

                @Override
                protected void doOp(boolean bl, int n3, int n2) {
                    for (int i = n3; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            if (blArray != null && blArray[j][i]) continue;
                            mVmatrix.setValue(j, i, this.this$0.getValue(j, i) + dArray[i * n + j] * d);
                        }
                    }
                }
            };
            threader.execute(n2);
        }
        return mVmatrix;
    }

    private void MV_plus_minus_equals(Matrix matrix, boolean bl) {
        final double d = bl ? 1.0 : -1.0;
        final boolean[][] blArray = this.getMissingMatrix();
        final double[] dArray = ((DenseMatrix)matrix).getData();
        final int n = this.getN();
        Threader threader = new Threader(this){
            final /* synthetic */ AbstractDataMatrix this$0;
            {
                this.this$0 = abstractDataMatrix;
            }

            @Override
            protected void doOp(boolean bl, int n3, int n2) {
                for (int i = n3; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (blArray != null && blArray[j][i]) continue;
                        this.this$0.setValue(j, i, this.this$0.getValue(j, i) + dArray[i * n + j] * d);
                    }
                }
            }
        };
        threader.execute(this.getK());
    }

    private void setTransformationInfo() {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            AbstractTransform abstractTransform;
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractTransform) || !(abstractTransform = (AbstractTransform)dataTreeInterface).isTransformationEnabled()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append("+");
            }
            stringBuilder.append(abstractTransform.getShortName());
        }
        this.transformationInfo = stringBuilder == null ? "" : stringBuilder.toString();
    }

    public static class RCinfo {
        public double MV;
        public int index;
        public boolean excluded;

        public RCinfo(double d, int n, boolean bl) {
            this.MV = d;
            this.index = n;
            this.excluded = bl;
        }
    }
}

