/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.common.mtj.DenseMatrixByte;
import se.prediktera.map.common.mtj.DenseMatrixFloat;
import se.prediktera.map.common.mtj.DenseMatrixShort;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixByte;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixShort;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;

public abstract class AbstractMVmatrix
extends AbstractDataMatrix {
    private Matrix matrix_cs;
    private boolean isProtected = false;
    private RandomInputStream getValueFromDisk = null;
    private int diskcacheindex;
    private long diskcachepos = -1L;
    private final int diskcachesize = 4096;
    private final byte[] diskcache = new byte[4096];
    protected boolean unsigned = true;

    private static void cloneTo(ProgressManager progressManager, Matrix matrix, Matrix matrix2, int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                matrix.set(j, i, matrix2.get(j, i));
            }
            if (progressManager == null) continue;
            progressManager.incStep();
        }
    }

    public AbstractMVmatrix(int n, int n2, boolean bl) {
        this(n, n2, bl, "Matrix[none," + n + "," + n2 + "]");
    }

    public AbstractMVmatrix(int n, int n2, boolean bl, String string) {
        super(string);
        this.unsigned = bl;
        this.dataSetContainer = null;
        this.init(this.createInternalMatrix(n, n2));
    }

    public AbstractMVmatrix(Matrix matrix, boolean bl) {
        this(matrix, bl, "Matrix");
    }

    public AbstractMVmatrix(Matrix matrix, boolean bl, String string) {
        super(string);
        this.dataSetContainer = null;
        this.init(bl ? matrix : matrix.copy());
    }

    public AbstractMVmatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("lock")) {
            this.isProtected = mapProperty.getLVBoolean();
        }
        this.unsigned = mapProperty.getPropertyBoolean("sign", true);
    }

    public AbstractMVmatrix(String string) {
        super(string);
    }

    @Override
    public void addData(int n, int n2) {
        super.addData(n, n2);
        Matrix matrix = this.createInternalMatrix(this.getN() + n, this.getK() + n2);
        for (int i = 0; i < this.getN(); ++i) {
            for (int j = 0; j < this.getK(); ++j) {
                matrix.set(i, j, this.matrix_cs.get(i, j));
            }
        }
        this.matrix_cs = matrix;
        this.N = matrix.numRows();
        this.K = matrix.numColumns();
    }

    @Override
    public void addMemoryState(byte by) {
        super.addMemoryState(by);
        if ((by & 2) == 2) {
            this.matrix_cs = null;
        }
    }

    @Override
    public void addToValue(int n, int n2, double d) {
        this.getInternalMatrix().add(n, n2, d);
    }

    public final DenseMatrix arrayRightDivide(DenseMatrix denseMatrix) {
        return MatrixExtensions.arrayRightDivide(this.getDoubleMatrix(), denseMatrix);
    }

    public final DenseMatrix arrayRightDivide(MVmatrix mVmatrix) {
        return this.arrayRightDivide(mVmatrix.getDoubleMatrix());
    }

    @Override
    public Object clone() {
        return this.cloneTo(null, null, this.getPrimitiveDataType());
    }

    public Matrix cloneMatrix() {
        return this.getInternalMatrix().copy();
    }

    public AbstractMVmatrix cloneTo(final ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int n) {
        this.beginCalculations();
        final int n2 = this.getN();
        final int n3 = this.getK();
        if (abstractMVmatrix == null) {
            abstractMVmatrix = AbstractMVmatrix.createMatrix(n2, n3, String.valueOf(this) + ".sub", n);
            abstractMVmatrix.beginCalculations();
        } else {
            abstractMVmatrix.beginCalculations();
            abstractMVmatrix.resizeInnerMatrix(n2, n3);
            abstractMVmatrix.removeIdentifiersAndTransformations();
        }
        abstractMVmatrix.setRowDescription(this.getRowDescription());
        abstractMVmatrix.setColumnDescription(this.getColumnDescription());
        abstractMVmatrix.setMatrixDataSetContainer(this.dataSetContainer);
        final Matrix matrix = abstractMVmatrix.getInternalMatrix();
        final Matrix matrix2 = this.getInternalMatrix();
        Threader threader = new Threader(this){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                AbstractMVmatrix.cloneTo(bl ? progressManager : null, matrix, matrix2, n, n22, n2);
            }

            @Override
            protected void init(int n, int n22) {
                if (progressManager != null) {
                    progressManager.setMaximumAndReset(n3 - n22 * (n - 1));
                }
            }
        };
        threader.execute(n3);
        abstractMVmatrix.setNref(AbstractMVmatrix.cloneArray(this.getNref()));
        abstractMVmatrix.setKref(AbstractMVmatrix.cloneArray(this.getKref()));
        abstractMVmatrix.setMissing(this);
        abstractMVmatrix.setFoldN(this.getFoldN());
        abstractMVmatrix.endCalculations();
        this.endCalculations();
        return abstractMVmatrix;
    }

    public Matrix createInternamMatrix() {
        this.matrix_cs = this.createInternalMatrix(this.N, this.K);
        return this.matrix_cs;
    }

    public AbstractMVmatrix createReferenceMatrix() {
        AbstractMatrix abstractMatrix = this.getMatrix();
        if (abstractMatrix instanceof DenseMatrix) {
            return new MVmatrix((Matrix)abstractMatrix, true);
        }
        if (abstractMatrix instanceof DenseMatrixFloat) {
            return new MVmatrixFloat((Matrix)abstractMatrix, true);
        }
        if (abstractMatrix instanceof DenseMatrixShort) {
            return new MVmatrixShort((Matrix)abstractMatrix, true);
        }
        if (abstractMatrix instanceof DenseMatrixByte) {
            return new MVmatrixByte((Matrix)abstractMatrix, true);
        }
        return null;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            public void setValueAt_Sort(Object object, int n, int n2) {
                super.setValueAt_Sort(object, n, n2);
                if (!AbstractMVmatrix.this.isProtected()) {
                    DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, AbstractMVmatrix.this, n, n2);
                    AbstractMVmatrix.this.triggerEvent(dataMatrixEvent);
                    dataMatrixEvent.cleanUp();
                }
            }

            @Override
            protected int getColumnDescriptionCountInternal() {
                return AbstractMVmatrix.this.colDescription == null ? 0 : AbstractMVmatrix.this.colDescription.getColumnCount();
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return AbstractMVmatrix.this.rowDescription == null ? 0 : AbstractMVmatrix.this.rowDescription.getColumnCount();
            }
        };
    }

    @Override
    public final void enterDiskMode() {
        if (!this.isLoaded() && this.getValueFromDisk == null) {
            try {
                this.getValueFromDisk = new RandomInputStream(this.getSaveFile(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public final void exitDiskMode() {
        if (this.getValueFromDisk != null) {
            try {
                this.getValueFromDisk.close();
                this.ClearFromMemory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getValueFromDisk = null;
        }
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof LayerMatrix) {
            return String.valueOf(n + 1);
        }
        if (dataTreeInterface instanceof MatrixContainer) {
            return ((MatrixContainer)dataTreeInterface).getColumnDescription(this, n, n2);
        }
        int[] nArray = this.getKref();
        if (nArray == null) {
            if (this.colDescription != null) {
                return (String)this.colDescription.getValue(n, n2);
            }
        } else if (0 <= n && n < nArray.length) {
            if (this.colDescription != null) {
                return (String)this.colDescription.getValue(nArray[n], n2);
            }
            return String.valueOf(nArray[n]);
        }
        return String.valueOf(n);
    }

    @Override
    public double getColumnMean(int n, int n2) {
        this.beginCalculations();
        int n3 = this.getN();
        Matrix matrix = this.getInternalMatrix();
        double d = 0.0;
        if (n2 > 0) {
            for (int i = 0; i < n3; ++i) {
                if (this.isMissing(i, n)) continue;
                d += matrix.get(i, n);
            }
            d /= (double)(n3 - n2);
        } else {
            for (int i = 0; i < n3; ++i) {
                d += matrix.get(i, n);
            }
            d /= (double)n3;
        }
        this.endCalculations();
        return d;
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        DataSet dataSet = null;
        if (this.isOrigMatrixOrChildTo()) {
            Case case_ = this.getCase();
            if (case_ != null) {
                dataSet = case_.getOriginalDataSet();
            }
        } else {
            dataSet = (DataSet)DataTreeManager.getAncestorNull(this, DataSet.class);
        }
        if (dataSet != null) {
            return dataSet.getDataInfo(n);
        }
        return null;
    }

    private boolean isOrigMatrixOrChildTo() {
        if (this.isOrigMatrix()) {
            return true;
        }
        if (this.getTreeParent() instanceof AbstractDataMatrix) {
            return ((AbstractDataMatrix)this.getTreeParent()).isOrigMatrix();
        }
        return false;
    }

    public DenseMatrix getDoubleMatrix() {
        return null;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("<HTML>");
        if (this.matrixInfo != null) {
            stringBuilder.append(this.matrixInfo);
        }
        stringBuilder.append("<BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Observations:</TD><TD>").append(this.getN()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Variables:</TD><TD>").append(this.getK()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Transformations:</TD><TD>").append(this.getTransformationInfo());
        stringBuilder.append("</TD></TR>");
        stringBuilder.append("<TR><TD>Missing values:</TD><TD>").append(this.getNrMV()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Precision:</TD><TD>").append(TYPE_DESCR[this.getPrimitiveDataType()]).append("</TD></TR>");
        stringBuilder.append("<TR><TD>State:</TD><TD>").append(this.getMemoryStateDescr());
        stringBuilder.append("</TD></TR></TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public Matrix getInternalMatrixPublic() {
        return this.getInternalMatrix();
    }

    @Override
    public int getK() {
        return this.K;
    }

    public AbstractMatrix getMatrix() {
        return (AbstractMatrix)this.getInternalMatrix();
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        int[] nArray = this.getNref();
        if (nArray == null) {
            if (this.rowDescription != null) {
                return (String)this.rowDescription.getValue(n, n2);
            }
        } else if (0 <= n && n < nArray.length) {
            if (this.rowDescription != null) {
                return (String)this.rowDescription.getValue(nArray[n], n2);
            }
            return String.valueOf(nArray[n]);
        }
        return String.valueOf(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue(int n, int n2) {
        Object object;
        if (n < 0 || n2 < 0) {
            return 0.0;
        }
        if (this.matrix_cs == null && this.isInDiskMode()) {
            try {
                object = this;
                synchronized (object) {
                    int n3 = this.getPrimitiveDataType();
                    int n4 = TYPE_SIZE[n3];
                    long l = (n * this.K + n2) * n4;
                    this.diskcacheindex = (int)(l - this.diskcachepos);
                    if (this.diskcachepos == -1L || this.diskcacheindex < 0 || this.diskcacheindex >= 4096) {
                        if (this.diskcachepos != l) {
                            this.diskcachepos = l;
                            this.getValueFromDisk.seek(this.getDataStart() + l);
                        }
                        this.diskcachepos += (long)this.getValueFromDisk.read(this.diskcache);
                        this.diskcacheindex = 0;
                    }
                    switch (n3) {
                        case 0: {
                            return this.readDiskCache();
                        }
                        case 1: {
                            return this.readShort();
                        }
                        case 2: {
                            return this.readInt();
                        }
                        case 3: {
                            return this.readLong();
                        }
                        case 4: {
                            return this.readFloat();
                        }
                        case 5: {
                            return this.readDouble();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.exitDiskMode();
                ErrorHandler.logAndReportException(iOException);
            }
        }
        if (this.iscalculating > 0 && this.matrix_cs != null) {
            return this.matrix_cs.get(n, n2);
        }
        object = this.getInternalMatrix();
        if (object == null) {
            return 0.0;
        }
        return object.get(n, n2);
    }

    @Override
    public final boolean isInDiskMode() {
        return this.getValueFromDisk != null;
    }

    @Override
    public boolean isModel() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    public final DenseMatrix minus(Matrix matrix) {
        return (DenseMatrix)new DenseMatrix((Matrix)this.getMatrix()).add(-1.0, matrix);
    }

    public final DenseMatrix minus(MVmatrix mVmatrix) {
        return this.minus((Matrix)mVmatrix.getMatrix());
    }

    @Override
    public void multValue(int n, int n2, double d) {
        Matrix matrix = this.getInternalMatrix();
        matrix.set(n, n2, matrix.get(n, n2) * d);
    }

    public final void plusEquals(Matrix matrix) {
        this.getInternalMatrix().add(matrix);
    }

    public final void plusEquals(MVmatrix mVmatrix) {
        this.plusEquals((Matrix)mVmatrix.getMatrix());
    }

    @Override
    public void removeMemoryState(byte by) {
        super.removeMemoryState(by);
    }

    @Override
    public void resize(int n, int n2) {
        super.resize(n, n2);
        if (this.matrix_cs != null && n == this.matrix_cs.numRows() && n2 == this.matrix_cs.numColumns()) {
            this.init(this.matrix_cs);
        } else {
            this.init(this.createInternalMatrix(n, n2));
        }
    }

    public void resizeInnerMatrix(int n, int n2) {
        if (this.N != n || this.K != n2 || this.matrix_cs == null || this.matrix_cs.numRows() != this.N || this.matrix_cs.numColumns() != n2) {
            this.matrix_cs = this.createInternalMatrix(n, n2);
            this.N = n;
            this.K = n2;
            this.resetMemoryState();
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("lock", this.isProtected);
        randomOutputStream.writePropertyBoolean("sign", this.unsigned);
    }

    public void set(AbstractDataMatrix abstractDataMatrix) {
        int[] nArray;
        this.N = abstractDataMatrix.getN();
        this.K = abstractDataMatrix.getK();
        this.setFoldN(abstractDataMatrix.getFoldN());
        int[] nArray2 = abstractDataMatrix.getNref();
        if (nArray2 != null) {
            this.Nref_cs = AbstractMVmatrix.cloneArray(nArray2);
        }
        if ((nArray = abstractDataMatrix.getKref()) != null) {
            this.Kref_cs = AbstractMVmatrix.cloneArray(nArray);
        }
        this.setMissing(abstractDataMatrix);
    }

    public void setInternalMatrix(Matrix matrix) {
        this.checkAndLoadIntoMemory();
        this.matrix_cs = matrix;
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
        int[] nArray = this.getKref();
        if (nArray == null) {
            this.colDescription.setValue(n, n2, string);
        } else if (n < nArray.length && this.colDescription != null) {
            this.colDescription.setValue(nArray[n], n2, string);
        }
    }

    public void setMissing(AbstractDataMatrix abstractDataMatrix) {
        if (abstractDataMatrix != null && abstractDataMatrix.getNrMV() > 0) {
            if (this.getNrMV() > 0) {
                this.setMissing(null);
            }
            this.getMissingMatrix();
            boolean[][] blArray = abstractDataMatrix.getMissingMatrix();
            if (this.missingMatrix_cs == null || this.missingMatrix_cs.length != blArray.length) {
                this.missingMatrix_cs = new boolean[this.N][this.K];
                this.nrMV = 0;
                this.MV_Nnr_cs = new int[this.N];
                this.MV_Knr_cs = new int[this.K];
            }
            int[] nArray = this.getMissingCountForColumns(true);
            int[] nArray2 = this.getKref();
            int[] nArray3 = this.getMissingCountForRows(true);
            int[] nArray4 = this.getNref();
            int[] nArray5 = abstractDataMatrix.getMissingCountForRows(true);
            int[] nArray6 = abstractDataMatrix.getReferenceKref();
            int[] nArray7 = abstractDataMatrix.getReferenceNref();
            if (nArray4 != null && nArray2 != null && nArray6 == null && nArray7 == null) {
                for (int i = 0; i < this.N; ++i) {
                    int n = nArray4[i];
                    if (nArray5[n] <= 0 || n >= blArray.length) continue;
                    for (int j = 0; j < this.K; ++j) {
                        int n2 = nArray2[j];
                        if (n2 >= blArray[n].length || !blArray[n][n2]) continue;
                        this.missingMatrix_cs[i][j] = true;
                        int n3 = j;
                        nArray[n3] = nArray[n3] + 1;
                        int n4 = i;
                        nArray3[n4] = nArray3[n4] + 1;
                        ++this.nrMV;
                    }
                }
            } else {
                int n = 0;
                block2: for (int i = 0; i < blArray.length; ++i) {
                    int n5;
                    boolean[] blArray2 = blArray[i];
                    if (nArray5[i] <= 0) continue;
                    int n6 = n5 = nArray7 == null ? i : nArray7[i];
                    while (n < this.N) {
                        int n7;
                        int n8 = n7 = nArray4 == null ? n : nArray4[n];
                        if (n7 == n5) {
                            boolean[] blArray3 = this.missingMatrix_cs[n];
                            int n9 = 0;
                            block4: for (int j = 0; j < blArray[i].length; ++j) {
                                int n10;
                                if (!blArray2[j]) continue;
                                int n11 = n10 = nArray6 == null ? j : nArray6[j];
                                while (n9 < this.K) {
                                    int n12;
                                    int n13 = n12 = nArray2 == null ? n9 : nArray2[n9];
                                    if (n12 == n10) {
                                        blArray3[n9] = true;
                                        int n14 = n9;
                                        nArray[n14] = nArray[n14] + 1;
                                        int n15 = n;
                                        nArray3[n15] = nArray3[n15] + 1;
                                        ++this.nrMV;
                                    } else if (n12 > n10) continue block4;
                                    ++n9;
                                }
                            }
                        } else if (n7 > n5) continue block2;
                        ++n;
                    }
                }
            }
        } else {
            this.missingMatrix_cs = null;
            this.nrMV = 0;
            this.MV_Knr_cs = null;
            this.MV_Nnr_cs = null;
        }
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
        int[] nArray = this.getNref();
        if (nArray == null) {
            this.rowDescription.setValue(n, n2, string);
        } else if (n < nArray.length && this.rowDescription != null) {
            this.rowDescription.setValue(nArray[n], n2, string);
        }
    }

    public void setProtected(boolean bl) {
        this.isProtected = bl;
    }

    @Override
    public void setValue(int n, int n2, double d) {
        this.needupdate = true;
        this.getInternalMatrix().set(n, n2, d);
    }

    @Override
    public synchronized void setValue(int n, int n2, double d, boolean bl) {
        this.needupdate = true;
        if (bl) {
            this.getInternalMatrix().set(n, n2, 0.0);
            this.addMissing(n, n2);
        } else if (this.iscalculating > 0 && this.nrMV == 0) {
            this.matrix_cs.set(n, n2, d);
        } else {
            this.getInternalMatrix().set(n, n2, d);
            this.removeMissing(n, n2);
        }
    }

    @Override
    public AbstractMVmatrix subMatrix(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2, int n) {
        if (nArray == null && nArray2 == null) {
            return this.cloneTo(progressManager, abstractMVmatrix, n);
        }
        return super.subMatrix(progressManager, abstractMVmatrix, nArray, nArray2, n);
    }

    public MVmatrix Sum() {
        final int n = this.getN();
        int n2 = this.getK();
        MVmatrix mVmatrix = new MVmatrix(n2, 1, String.valueOf(this) + ".Sum");
        final Matrix matrix = mVmatrix.getInternalMatrixPublic();
        final Matrix matrix2 = this.getInternalMatrixPublic();
        final boolean[][] blArray = this.getMissingMatrix();
        Threader threader = new Threader(this){

            @Override
            protected void doOp(boolean bl, int n3, int n2) {
                for (int i = n3; i < n2; ++i) {
                    double d = 0.0;
                    for (int j = 0; j < n; ++j) {
                        if (blArray != null && blArray[j][i]) continue;
                        d += matrix2.get(j, i);
                    }
                    matrix.set(i, 0, d);
                }
            }
        };
        threader.execute(n2);
        return mVmatrix;
    }

    public double SumScalar() {
        MVmatrix mVmatrix = this.Sum();
        mVmatrix.beginCalculations();
        double d = mVmatrix.getValue(0, 0);
        mVmatrix.endCalculations();
        return d;
    }

    public DenseVector sumSq() {
        return this.sumSq(null);
    }

    public DenseVector sumSq(DenseVector denseVector) {
        int n = this.getK();
        final int n2 = this.getN();
        if (denseVector == null) {
            denseVector = new DenseVector(n);
        }
        final DenseVector denseVector2 = denseVector;
        final Matrix matrix = this.getInternalMatrixPublic();
        final boolean[][] blArray = this.getMissingMatrix();
        Threader threader = new Threader(this){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    double d = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        if (blArray != null && blArray[j][i]) continue;
                        double d2 = matrix.get(j, i);
                        d += d2 * d2;
                    }
                    denseVector2.set(i, d);
                }
            }
        };
        threader.execute(n);
        return denseVector;
    }

    public final MVmatrix SumSQ() {
        return this.SumSQ(null);
    }

    public MVmatrix SumSQ(MVmatrix mVmatrix) {
        int n = this.getK();
        final int n2 = this.getN();
        if (mVmatrix == null) {
            mVmatrix = new MVmatrix(n, 1, String.valueOf(this) + ".SumSQ");
        } else {
            mVmatrix.resize(n, 1);
        }
        final Matrix matrix = mVmatrix.getInternalMatrixPublic();
        final Matrix matrix2 = this.getInternalMatrixPublic();
        final boolean[][] blArray = this.getMissingMatrix();
        boolean bl = this.hasMissing();
        if (bl) {
            Threader threader = new Threader(this){

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        double d = 0.0;
                        for (int j = 0; j < n2; ++j) {
                            if (blArray != null && blArray[j][i]) continue;
                            double d2 = matrix2.get(j, i);
                            d += d2 * d2;
                        }
                        matrix.set(i, 0, d);
                    }
                }
            };
            threader.execute(n);
        } else {
            Threader threader = new Threader(this){

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        double d = 0.0;
                        for (int j = 0; j < n2; ++j) {
                            double d2 = matrix2.get(j, i);
                            d += d2 * d2;
                        }
                        matrix.set(i, 0, d);
                    }
                }
            };
            threader.execute(n);
        }
        return mVmatrix;
    }

    public final DenseVector times(DenseVector denseVector) {
        AbstractMatrix abstractMatrix = this.getMatrix();
        return MatrixExtensions.mult(new DenseVector(abstractMatrix.numRows()), (Matrix)abstractMatrix, denseVector);
    }

    public final void timesEquals(double d) {
        this.getInternalMatrix().scale(d);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.matrix_cs = null;
        this.getValueFromDisk = null;
    }

    @Override
    protected void ClearChild() throws IOException {
        this.matrix_cs = null;
    }

    protected abstract Matrix createInternalMatrix(int var1, int var2);

    protected final long getDataStart() {
        return this.getBlockBegin() + 13L + (long)((this.N + this.K + 2 + this.nrMV * 2) * 4);
    }

    protected final Matrix getInternalMatrix() {
        this.checkAndLoadIntoMemory();
        return this.matrix_cs;
    }

    protected void init(Matrix matrix) {
        this.matrix_cs = matrix;
        this.N = matrix.numRows();
        this.K = matrix.numColumns();
        this.nrMV = 0;
        this.MV_Nnr_cs = null;
        this.MV_Knr_cs = null;
        this.Nref_cs = null;
        this.Kref_cs = null;
    }

    @Override
    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
        int n;
        int n2;
        this.setMatrixDataSetContainer(this.dataSetContainer);
        if (!this.isInDiskMode()) {
            this.matrix_cs = this.createInternalMatrix(this.N, this.K);
            this.init(this.matrix_cs);
        }
        if (this.K > 0) {
            n2 = randomInputStream.ReadBlockInt();
            if (n2 < 0) {
                randomInputStream.skip((this.K - 1) * 4);
            } else {
                this.Kref_cs = new int[this.K];
                this.Kref_cs[0] = n2;
                for (n = 1; n < this.K; ++n) {
                    this.Kref_cs[n] = randomInputStream.ReadBlockInt();
                }
            }
        }
        if (this.N > 0) {
            n2 = randomInputStream.ReadBlockInt();
            if (n2 < 0) {
                randomInputStream.skip((this.N - 1) * 4);
            } else {
                this.Nref_cs = new int[this.N];
                this.Nref_cs[0] = n2;
                for (n = 1; n < this.N; ++n) {
                    this.Nref_cs[n] = randomInputStream.ReadBlockInt();
                }
            }
        }
        n2 = randomInputStream.ReadBlockInt();
        for (n = 0; n < n2; ++n) {
            int n3 = randomInputStream.ReadBlockInt();
            int n4 = randomInputStream.ReadBlockInt();
            this.addMissing(n3, n4);
        }
        randomInputStream.ReadBlockInt();
    }

    @Override
    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        if (this.Kref_cs == null) {
            for (n = 0; n < this.K; ++n) {
                randomOutputStream.WriteBlockInt(-1);
            }
        } else {
            for (n = 0; n < this.K; ++n) {
                randomOutputStream.WriteBlockInt(this.Kref_cs[n]);
            }
        }
        if (this.Nref_cs == null) {
            for (n = 0; n < this.N; ++n) {
                randomOutputStream.WriteBlockInt(-1);
            }
        } else {
            for (n = 0; n < this.N; ++n) {
                randomOutputStream.WriteBlockInt(this.Nref_cs[n]);
            }
        }
        n = this.getNrMV();
        randomOutputStream.WriteBlockInt(n);
        if (n > 0) {
            for (int i = 0; i < this.K; ++i) {
                for (int j = 0; j < this.N; ++j) {
                    if (!this.isMissing(j, i)) continue;
                    randomOutputStream.WriteBlockInt(j);
                    randomOutputStream.WriteBlockInt(i);
                }
            }
        }
        randomOutputStream.WriteBlockInt(0);
    }

    private int readDiskCache() {
        byte by;
        if ((by = this.diskcache[this.diskcacheindex++]) < 0) {
            return 256 + by;
        }
        return by;
    }

    private final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    private final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    private final int readInt() {
        int n = this.readDiskCache();
        int n2 = this.readDiskCache();
        int n3 = this.readDiskCache();
        int n4 = this.readDiskCache();
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    private final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    private final short readShort() throws IOException {
        int n = this.readDiskCache();
        int n2 = this.readDiskCache();
        return (short)((n << 8) + n2);
    }

    public static class DimensionException
    extends Exception {
        @Override
        public String toString() {
            return "Dimension Error";
        }
    }
}

