/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class DataSourceMatrix
extends AbstractDataMatrix {
    private final AbstractDataSource model;
    private final int layer;
    private final FastDecimal fastDecimal = new FastDecimal();

    public DataSourceMatrix(CellIdentifierModel cellIdentifierModel, int n) {
        super("DataSource");
        this.model = (AbstractDataSource)cellIdentifierModel;
        this.layer = n;
        this.refreshModel();
    }

    public DataSourceMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.model = (AbstractDataSource)mapProperty.resolveNodeFromName(randomInputStream, "model");
        this.layer = mapProperty.getPropertyInt("layer");
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            protected int getColumnDescriptionCountInternal() {
                return DataSourceMatrix.this.colDescription == null ? 0 : DataSourceMatrix.this.colDescription.getColumnCount();
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return DataSourceMatrix.this.rowDescription == null ? 0 : DataSourceMatrix.this.rowDescription.getColumnCount();
            }
        };
    }

    @Override
    public synchronized String getColumnDescription(int n, int n2) {
        if (this.colDescription != null) {
            return (String)this.colDescription.getValue(n, n2);
        }
        return String.valueOf(this.model.getColumnValueAt(n, n2));
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        return null;
    }

    @Override
    public int getK() {
        return this.K;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public synchronized String getRowDescription(int n, int n2) {
        if (this.rowDescription != null) {
            return (String)this.rowDescription.getValue(n, n2);
        }
        return String.valueOf(this.model.getRowValueAt(n, n2));
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    public synchronized double getValue(int n, int n2) {
        this.model.setCurrentLayer(this.layer);
        this.model.getDataValueAt(n, n2, this.fastDecimal);
        if (this.fastDecimal != null) {
            return this.fastDecimal.getValue();
        }
        return 0.0;
    }

    @Override
    public boolean isDataSource() {
        return true;
    }

    @Override
    public synchronized boolean isMissing(int n, int n2) {
        this.model.setCurrentLayer(this.layer);
        this.model.getDataValueAt(n, n2, this.fastDecimal);
        if (this.fastDecimal != null) {
            return this.fastDecimal.isMissing();
        }
        return true;
    }

    @Override
    public boolean isModel() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.setMatrixDataSetContainer(this.dataSetContainer);
        this.LoadChild(randomInputStream);
    }

    @Override
    public void refreshModel() {
        this.N = this.model.analyzeObs();
        this.K = this.model.analyzeVar();
        this.nrMV = 0;
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.K; ++j) {
                if (!this.isMissing(i, j)) continue;
                ++this.nrMV;
            }
        }
        this.updateDescription(this.getRowDescription(), true);
        this.updateDescription(this.getColumnDescription(), false);
        Case case_ = this.getCase();
        if (case_ != null) {
            CleanUpVector cleanUpVector;
            BasicTreeInterface basicTreeInterface;
            Object object;
            DataContainer dataContainer = case_.getDsContainer();
            for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof DataSet)) continue;
                object = (DataSet)dataTreeInterface;
                basicTreeInterface = (Description)((DataSet)object).getObsDataInfo().getGroupColumnByIndex(0);
                this.updateDescription((Description)basicTreeInterface, true);
                cleanUpVector = (Description)((DataSet)object).getVarDataInfo().getGroupColumnByIndex(0);
                this.updateDescription((Description)cleanUpVector, false);
            }
            DataSet dataSet = case_.getOriginalDataSet();
            for (int i = 0; i < 0; ++i) {
                try {
                    object = this.model.getReferenceCategory(i);
                    basicTreeInterface = dataSet.getCategory((String)object);
                    cleanUpVector = ((InnerColumnClass)basicTreeInterface).getObject();
                    ((AbstractInnerColumn)basicTreeInterface).setSize(2 * this.N);
                    for (int j = 0; j < this.N; ++j) {
                        String string = this.model.getReferenceCategoryValue(j);
                        ((ClassTypes)cleanUpVector).addString(string, true);
                    }
                    continue;
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        }
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveChild(randomOutputStream);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("model", this.model);
        randomOutputStream.writePropertyInt("layer", this.layer);
    }

    @Override
    public synchronized void setKInfo(int n, int n2, String string) {
        if (this.colDescription != null) {
            this.colDescription.setValue(n, n2, string);
        }
    }

    @Override
    public synchronized void setNInfo(int n, int n2, String string) {
        if (this.rowDescription != null) {
            this.rowDescription.setValue(n, n2, string);
        }
    }

    @Override
    public synchronized void setValue(int n, int n2, double d) {
        this.model.setCurrentLayer(this.layer);
        this.model.setDataValueAt(n, n2, String.valueOf(d));
    }

    @Override
    public synchronized void setValue(int n, int n2, double d, boolean bl) {
        this.model.setCurrentLayer(this.layer);
        if (bl) {
            this.model.setDataValueAt(n, n2, "MV");
        } else {
            this.setValue(n, n2, d);
        }
        if (!this.isProtected()) {
            DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, n, n2);
            this.triggerEvent(dataMatrixEvent);
            dataMatrixEvent.cleanUp();
        }
    }

    @Override
    protected void ClearChild() throws IOException {
    }

    @Override
    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
    }

    @Override
    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
    }

    private void updateDescription(Description description, boolean bl) {
        if (description != null) {
            for (int i = 0; i < description.getColumnCount(); ++i) {
                Object object;
                int n;
                InnerColumnString innerColumnString = (InnerColumnString)description.getColumn(i);
                Object object2 = bl ? this.model.getValueAt_Transpose(0, i) : this.model.getValueAt_Transpose(i, 0);
                if (bl) {
                    if (innerColumnString.getName() != object2.toString() || !bl) continue;
                    innerColumnString.setSize(2 * this.N);
                    for (n = 0; n < this.N; ++n) {
                        object = this.model.getValueAt_Transpose(n + 1, i);
                        innerColumnString.setValueLocal(n, object.toString());
                    }
                    continue;
                }
                innerColumnString.setSize(2 * this.K);
                for (n = 0; n < this.K; ++n) {
                    object = this.model.getValueAt_Transpose(i, n + 1);
                    innerColumnString.setValueLocal(n, NiceDataFormat.tryGetNiceString(object.toString()));
                }
            }
        }
    }
}

