/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import java.util.Arrays;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;

public class FoldMatrix
extends ReferenceMatrix
implements FoldMatrixInterface {
    private int[] fNref_cs;
    private int pmin;
    private int smin;
    private int pmax;
    private int smax;
    private int fold;
    private boolean[] valuearray;
    private int valuenumber;
    private DataMatrixListener referenceListener = null;
    private boolean rotate = false;

    public FoldMatrix(AbstractDataMatrix abstractDataMatrix) {
        this(abstractDataMatrix, false);
    }

    public FoldMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        super(abstractDataMatrix);
        this.rotate = bl;
        this.initFold();
        this.init();
    }

    public FoldMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty.removeProperty("tp"));
        this.pmin = mapProperty.getPropertyInt("pmin");
        this.smin = mapProperty.getPropertyInt("smin");
        this.pmax = mapProperty.getPropertyInt("pmax");
        this.smax = mapProperty.getPropertyInt("smax");
        this.fold = mapProperty.getPropertyInt("fold");
        this.valuearray = mapProperty.getPropertyBooleanArray("va");
        this.valuenumber = mapProperty.getPropertyInt("vn");
        if (this.valuearray == null) {
            int n = this.getFoldN();
            int n2 = this.getPSize();
            int[] nArray = this.getPref();
            if (nArray != null) {
                this.valuearray = new boolean[this.pmax * this.smax];
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray[i] % n - this.pmin;
                    int n4 = nArray[i] / n - this.smin;
                    this.valuearray[n4 * this.pmax + n3] = true;
                    ++this.valuenumber;
                }
            }
        }
        this.init();
    }

    @Override
    public Case getCase() {
        if (this.referenceMatrix == null) {
            return super.getCase();
        }
        return this.referenceMatrix.getCase();
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        int[] nArray = this.getKref();
        if (nArray == null || n < 0 || n >= nArray.length) {
            return String.valueOf(n + 1);
        }
        return String.valueOf(nArray[n] + 1);
    }

    @Override
    public int getColumnType() {
        return 16;
    }

    @Override
    public int[] getFNref() {
        this.checkAndLoadIntoMemory();
        return this.fNref_cs;
    }

    public int getFold() {
        return this.fold;
    }

    public String getFoldInfo() {
        if (this.isModel()) {
            return this.referenceMatrix.getRowDescription(this.fold, 0);
        }
        return this.referenceMatrix.getColumnDescription(this.fold, 0);
    }

    public int getIndex(int n, int n2) {
        return n2 * this.referenceMatrix.getFoldN() + n;
    }

    @Override
    public int getK() {
        return this.smax;
    }

    @Override
    public int getN() {
        return this.pmax;
    }

    public int[] getPoint(int n) {
        return new int[]{0, 0};
    }

    @Override
    public int[] getPref() {
        if (this.referenceMatrix == null) {
            return null;
        }
        if (this.isModel()) {
            return this.referenceMatrix.getKref();
        }
        return this.referenceMatrix.getNref();
    }

    public int getPSize() {
        if (this.isModel()) {
            return this.referenceMatrix.getK();
        }
        return this.referenceMatrix.getN();
    }

    @Override
    public String getRowDescription(int n, int n2) {
        int[] nArray = this.getNref();
        if (nArray == null || n < 0 || n >= nArray.length) {
            return String.valueOf(n + 1);
        }
        return String.valueOf(nArray[n] + 1);
    }

    @Override
    public int getRowType() {
        if (this.referenceMatrix != null && this.referenceMatrix.getRowType() == 64) {
            return 64;
        }
        return 1;
    }

    @Override
    public byte getTreeType() {
        return 9;
    }

    @Override
    public double getValue(int n, int n2) {
        int n3 = n2 * this.pmax + n;
        if (this.referenceMatrix == null || n3 < 0) {
            return 0.0;
        }
        int[] nArray = this.getFNref();
        if (nArray != null) {
            if (n3 >= nArray.length) {
                return 0.0;
            }
            if ((n3 = nArray[n3]) < 0) {
                return 0.0;
            }
        }
        return this.referenceMatrix.getFoldValue(n3, this.fold);
    }

    public int getXmax() {
        return this.smax;
    }

    public int getXmin() {
        return this.smin;
    }

    public int getYmax() {
        return this.pmax;
    }

    public int getYmin() {
        return this.pmin;
    }

    @Override
    public final boolean hasMissing() {
        if (super.hasMissing()) {
            return true;
        }
        if (this.valuearray != null) {
            return this.valuenumber != this.valuearray.length;
        }
        return false;
    }

    @Override
    public boolean isFoldable() {
        return false;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        int n3 = n2 * this.pmax + n;
        if (this.valuearray != null && !this.valuearray[n3] || this.referenceMatrix == null || n3 < 0) {
            return true;
        }
        int[] nArray = this.getFNref();
        if (nArray != null && (n3 = nArray[n3]) < 0) {
            return true;
        }
        return this.referenceMatrix.isFoldMissing(n3, this.fold);
    }

    @Override
    public boolean isModel() {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isModel();
    }

    @Override
    public boolean isRotate() {
        return this.rotate;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("pmin", this.pmin);
        randomOutputStream.writePropertyInt("smin", this.smin);
        randomOutputStream.writePropertyInt("pmax", this.pmax);
        randomOutputStream.writePropertyInt("smax", this.smax);
        randomOutputStream.writePropertyInt("fold", this.fold);
        randomOutputStream.writePropertyBooleanArray("va", this.valuearray);
        randomOutputStream.writePropertyInt("vn", this.valuenumber);
    }

    public void setFold(int n) {
        this.fold = n;
    }

    public void setFoldByVariableName(String string) {
        int n = this.referenceMatrix.getK();
        for (int i = 0; i < n; ++i) {
            String string2 = this.referenceMatrix.getColumnDescription(i, 0);
            if (!string.equalsIgnoreCase(string2)) continue;
            this.setFold(i);
        }
    }

    @Override
    public String toString() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.toString();
        }
        return super.toString();
    }

    @Override
    protected void cleanUpChild() {
        if (this.referenceMatrix != null && this.referenceListener != null) {
            this.referenceMatrix.removeDataTreeChangeListener(this.referenceListener);
            this.referenceListener = null;
        }
        super.cleanUpChild();
    }

    @Override
    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
        super.LoadChild(randomInputStream);
        if (this.getPref() != null) {
            int n = this.pmax * this.smax;
            this.fNref_cs = new int[n];
            for (int i = 0; i < n; ++i) {
                this.fNref_cs[i] = randomInputStream.ReadBlockInt();
            }
        }
    }

    @Override
    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveChild(randomOutputStream);
        if (this.fNref_cs != null) {
            for (int n : this.fNref_cs) {
                randomOutputStream.WriteBlockInt(n);
            }
        }
    }

    private void init() {
        this.referenceListener = new DataMatrixListener(){

            @Override
            public void eventFinished(DataTreeEvent dataTreeEvent) {
            }

            @Override
            public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
                FoldMatrix.this.initFold();
            }

            @Override
            public void nodeReplaced(DataTreeEvent dataTreeEvent) {
                DataTreeInterface dataTreeInterface = dataTreeEvent.getReplaceDataTreeInterface();
                FoldMatrix.this.setReferenceMatrix(dataTreeEvent.getProgressManager(), (AbstractDataMatrix)dataTreeInterface, true);
                FoldMatrix.this.initFold();
            }

            @Override
            public void propertyChanged(DataTreeEvent dataTreeEvent) {
            }
        };
        if (this.referenceMatrix != null) {
            this.referenceMatrix.addDataTreeChangeListener(this.referenceListener);
        }
    }

    private void initFold() {
        int n;
        this.beginUpdate();
        if (this.referenceMatrix != null && this.referenceMatrix.isUnFolded()) {
            this.smin = Integer.MAX_VALUE;
            this.pmin = Integer.MAX_VALUE;
            this.smax = 0;
            this.pmax = 0;
            if (this.referenceMatrix.getMatrixSize() > 0) {
                int n2;
                int n3;
                int n4;
                int n5;
                n = this.getFoldN();
                int n6 = this.getPSize();
                int[] nArray = this.getPref();
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = n5;
                    if (nArray != null) {
                        n4 = nArray[n4];
                    }
                    if (this.rotate) {
                        n3 = n4 / n;
                        n2 = n4 % n;
                    } else {
                        n3 = n4 % n;
                        n2 = n4 / n;
                    }
                    if (n3 < this.pmin) {
                        this.pmin = n3;
                    }
                    if (n3 > this.pmax) {
                        this.pmax = n3;
                    }
                    if (n2 < this.smin) {
                        this.smin = n2;
                    }
                    if (n2 <= this.smax) continue;
                    this.smax = n2;
                }
                if (this.pmin > this.pmax) {
                    this.pmin = this.pmax;
                }
                if (this.smin > this.smax) {
                    this.smin = this.smax;
                }
                this.pmax = this.pmax - this.pmin + 1;
                this.smax = this.smax - this.smin + 1;
                if (nArray != null || this.rotate) {
                    this.Nref_cs = new int[this.pmax];
                    for (n5 = 0; n5 < this.pmax; ++n5) {
                        this.Nref_cs[n5] = n5 + this.pmin;
                    }
                    this.Kref_cs = new int[this.smax];
                    for (n5 = 0; n5 < this.smax; ++n5) {
                        this.Kref_cs[n5] = n5 + this.smin;
                    }
                    this.fNref_cs = new int[this.pmax * this.smax];
                    this.valuearray = new boolean[this.pmax * this.smax];
                    this.valuenumber = 0;
                    Arrays.fill(this.fNref_cs, -1);
                    n5 = 0;
                    while (n5 < n6) {
                        n2 = n5;
                        if (nArray != null) {
                            n2 = nArray[n5];
                        }
                        if (this.rotate) {
                            n4 = n2 / n - this.pmin;
                            n3 = n2 % n - this.smin;
                        } else {
                            n4 = n2 % n - this.pmin;
                            n3 = n2 / n - this.smin;
                        }
                        this.fNref_cs[n3 * this.pmax + n4] = n5++;
                        this.valuearray[n3 * this.pmax + n4] = true;
                        ++this.valuenumber;
                    }
                } else {
                    this.fNref_cs = null;
                }
            }
        } else {
            this.fNref_cs = null;
        }
        if (this.fold >= (n = this.getFoldsize()) && n > 0) {
            this.fold = n - 1;
        }
        this.endUpdate(true, true);
    }
}

