/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;

public class FrameMatrix
extends MatrixContainer {
    private int[] defaultband;
    private int cachedFold = -1;
    private AbstractDataMatrix cachedMatrix = null;
    private int cachedN = 0;

    public FrameMatrix(int[] nArray) {
        super("Layer");
        this.defaultband = nArray;
    }

    public FrameMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.defaultband = mapProperty.getPropertyIntArray("dband", null);
    }

    @Override
    public final void addMatrix(AbstractDataMatrix abstractDataMatrix) {
        super.addMatrix(abstractDataMatrix);
        if (!this.isUnFolded()) {
            this.setFoldN(abstractDataMatrix.getN());
        }
    }

    @Override
    public final void beginCalculations() {
        this.N = this.getN();
        super.beginCalculations();
    }

    public final void cloneTo(ProgressManager progressManager, int[] nArray, int[] nArray2, Matrix matrix, int n, int n2, int n3) {
        if (nArray == null || nArray2 == null) {
            for (int i = n; i < n2; ++i) {
                int n4 = nArray2 == null ? i : nArray2[i];
                AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n4);
                int n5 = abstractDataMatrix.getN();
                for (int j = 0; j < n3; ++j) {
                    int n6 = nArray == null ? j : nArray[j];
                    matrix.set(j, i, abstractDataMatrix.getValue(n6 % n5, n6 / n5));
                }
                if (progressManager == null) continue;
                progressManager.incStep();
            }
        } else {
            for (int i = n; i < n2; ++i) {
                AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(nArray2[i]);
                int n7 = abstractDataMatrix.getN();
                for (int j = 0; j < n3; ++j) {
                    matrix.set(j, i, abstractDataMatrix.getValue(nArray[j] % n7, nArray[j] / n7));
                }
                if (progressManager == null) continue;
                progressManager.incStep();
            }
        }
    }

    @Override
    public final String getColumnDescription(int n, int n2) {
        return String.valueOf(this.getMatrixAt(n));
    }

    public int[] getDefaultBand() {
        return this.defaultband;
    }

    @Override
    public final String getFoldName(int n) {
        this.cacheFold(n);
        return String.valueOf(this.cachedMatrix);
    }

    @Override
    public final int getFoldsize() {
        return this.getMatrixCount();
    }

    @Override
    public final double getFoldValue(int n, int n2) {
        this.cacheFold(n2);
        if (this.cachedMatrix == null) {
            return 0.0;
        }
        return this.cachedMatrix.getValue(n % this.cachedN, n / this.cachedN);
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("<HTML>");
        if (this.matrixInfo != null) {
            stringBuilder.append(this.matrixInfo);
        }
        stringBuilder.append("<BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Layers:</TD><TD>").append(this.getMatrixCount()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Observations:</TD><TD>").append(this.getN()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Variables:</TD><TD>").append(this.getK()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Missing values:</TD><TD>").append(this.getNrMV()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Precision:</TD><TD>").append(TYPE_DESCR[this.getPrimitiveDataType()]).append("</TD></TR>");
        stringBuilder.append("<TR><TD>State:</TD><TD>").append(this.getMemoryStateDescr()).append("</TD></TR>");
        if (this.isDataSource()) {
            stringBuilder.append("<TR><TD>Comment:</TD><TD>Is DataSource</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public final int getK() {
        if (!this.isLoaded()) {
            return this.K;
        }
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(0);
        return abstractDataMatrix.getK();
    }

    @Override
    public final int getN() {
        if (!this.isLoaded() || this.isCalculating()) {
            return this.N;
        }
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(0);
        if (abstractDataMatrix == null) {
            return 0;
        }
        return abstractDataMatrix.getN() * this.getMatrixCount();
    }

    @Override
    public int getPrimitiveDataType() {
        if (this.getMatrixCount() > 0) {
            return this.getMatrixAt(0).getPrimitiveDataType();
        }
        return super.getPrimitiveDataType();
    }

    @Override
    public final String getRowDescription(int n, int n2) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n2);
        if (abstractDataMatrix == null) {
            return "null";
        }
        int n3 = abstractDataMatrix.getN();
        return "[" + (n % n3 + 1) + "][" + (n / n3 + 1) + "]";
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    @Override
    public final double getValue(int n, int n2) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n2);
        if (abstractDataMatrix == null) {
            return 0.0;
        }
        int n3 = abstractDataMatrix.getN();
        return abstractDataMatrix.getValue(n % n3, n / n3);
    }

    @Override
    public final boolean hasMissing() {
        int n = this.getMatrixCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getMatrixAt(i).hasMissing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isFoldMissing(int n, int n2) {
        this.cacheFold(n2);
        if (this.cachedMatrix == null) {
            return true;
        }
        return this.cachedMatrix.isMissing(n % this.cachedN, n / this.cachedN);
    }

    @Override
    public final boolean isMissing(int n, int n2) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n2);
        if (abstractDataMatrix == null) {
            return true;
        }
        int n3 = abstractDataMatrix.getN();
        return abstractDataMatrix.isMissing(n % n3, n / n3);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyIntArray("dband", this.defaultband);
    }

    public void setDefaultBand(int[] nArray) {
        this.defaultband = nArray;
    }

    @Override
    public final void setKInfo(int n, int n2, String string) {
    }

    @Override
    public final void setLayerMinMax() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getK();
        for (int i = 0; i < n; ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            double[] dArray = abstractDataMatrix.getLayerMinMax();
            if (dArray[0] < d) {
                d = dArray[0];
            }
            if (!(dArray[1] > d2)) continue;
            d2 = dArray[1];
        }
        this.setLayerMinMax(d, d2);
    }

    @Override
    public final void setNInfo(int n, int n2, String string) {
    }

    @Override
    public final void setValue(int n, int n2, double d) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n2);
        if (abstractDataMatrix == null) {
            return;
        }
        this.needupdate = true;
        int n3 = abstractDataMatrix.getN();
        abstractDataMatrix.setValue(n % n3, n / n3, d);
    }

    @Override
    public final void setValue(int n, int n2, double d, boolean bl) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n2);
        if (abstractDataMatrix == null) {
            return;
        }
        this.needupdate = true;
        int n3 = abstractDataMatrix.getN();
        abstractDataMatrix.setValue(n % n3, n / n3, d, bl);
    }

    private final void cacheFold(int n) {
        if (n != this.cachedFold) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n);
            this.cachedFold = n;
            this.cachedMatrix = abstractDataMatrix;
            this.cachedN = abstractDataMatrix == null ? 0 : abstractDataMatrix.getN();
        }
    }
}

