/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;

public class GroupMatrix
extends MVmatrix {
    private final int[][] groupRef;
    private final int groupID;

    public GroupMatrix(int n, int n2, int n3) {
        super(n, n2);
        this.groupID = n3;
        this.groupRef = new int[n][];
        this.setRowType(1);
        this.setColumnType(2);
    }

    public GroupMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.groupRef = mapProperty.getPropertyIntArray2d("gref", null);
        this.groupID = mapProperty.getPropertyInt("gID");
    }

    public int[] getGroup(int n) {
        return this.groupRef[n];
    }

    @Override
    public int[] getGroup(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 >= this.groupRef.length) continue;
            n += this.groupRef[n2].length;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        for (int n4 : nArray) {
            int[] nArray3;
            if (n4 >= this.groupRef.length) continue;
            for (int n5 : nArray3 = this.groupRef[n4]) {
                nArray2[n3++] = n5;
            }
        }
        return nArray2;
    }

    @Override
    public int getGroupID() {
        return this.groupID;
    }

    @Override
    public byte getTreeType() {
        return 16;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyIntArray("gref", this.groupRef);
        randomOutputStream.writePropertyInt("gID", this.groupID);
    }

    public void setGroup(int n, int[] nArray) {
        this.groupRef[n] = nArray;
    }
}

