/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import javax.swing.ImageIcon;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Main_GUI;

public class MatrixContainer
extends AbstractDataMatrix {
    private static ImageIcon matrixIcon_stacked = new ImageIcon(Main_GUI.class.getResource("gif/stackedtableidentified.gif"));
    private AbstractDataInfo dataInfo;
    private boolean ismodel;
    private int nr_cache = 0;

    public MatrixContainer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.ismodel = mapProperty.getPropertyBoolean("ismodel", false);
        if (mapProperty.hasProperty("typek")) {
            this.setColumnType(mapProperty.getLVInt());
        }
    }

    public MatrixContainer(String string) {
        super(string);
    }

    public MatrixContainer(String string, Case case_, AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix, AbstractDataInfo abstractDataInfo2, AbstractDataMatrix abstractDataMatrix2, boolean bl) {
        super(string);
        this.dataInfo = abstractDataInfo;
        this.dataSetContainer = case_;
        this.ismodel = bl;
        if (abstractDataInfo != null) {
            this.rowDescription = (Description)abstractDataInfo.getGroupColumnByType(0);
            if (abstractDataInfo.getDataType() == 0) {
                this.setRowType(1);
            } else {
                this.setRowType(2);
            }
        }
        if (abstractDataInfo2 == null) {
            this.setColumnType(3);
        } else {
            this.colDescription = (Description)abstractDataInfo2.getGroupColumnByType(0);
            if (abstractDataInfo2.getDataType() == 0) {
                this.setColumnType(1);
            } else {
                this.setColumnType(2);
            }
        }
        this.resize(abstractDataMatrix, abstractDataMatrix2);
    }

    public MatrixContainer(String string, MatrixContainer matrixContainer) throws IOException {
        this(string, matrixContainer.getCase(), matrixContainer.getDataInfo(0), null, matrixContainer.getDataInfo(1), null, matrixContainer.isModel());
        this.resize(matrixContainer);
    }

    public void addMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.addMatrix(abstractDataMatrix, false);
    }

    public void addMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        this.needupdate = true;
        abstractDataMatrix.setName(String.valueOf(this) + "[" + (this.getMatrixCount() + 1) + "]");
        abstractDataMatrix.setFoldN(this.getFoldN());
        int[] nArray = this.getNref();
        if (nArray != null) {
            abstractDataMatrix.setNref(nArray);
        }
        if (bl || !this.hasChild(abstractDataMatrix)) {
            this.addTreeNode(abstractDataMatrix);
        }
        this.nrMV += abstractDataMatrix.getNrMV();
    }

    public MVmatrix addMatrix(DenseMatrix denseMatrix) {
        this.needupdate = true;
        if (this.nr_cache > 0) {
            int n = this.getMatrixCount();
            int n2 = n - this.nr_cache;
            MVmatrix mVmatrix = (MVmatrix)this.getMatrixAt(n2);
            mVmatrix.init((Matrix)denseMatrix);
            int[] nArray = this.getNref();
            if (nArray != null) {
                mVmatrix.setNref(MatrixContainer.cloneArray(nArray));
            }
            mVmatrix.setUpdated();
            --this.nr_cache;
            return mVmatrix;
        }
        MVmatrix mVmatrix = new MVmatrix((Matrix)denseMatrix, true, String.valueOf(this) + "[" + (this.getMatrixCount() + 1) + "]");
        mVmatrix.setRowType(this.getRowType());
        mVmatrix.setColumnType(this.getColumnInternalType());
        mVmatrix.setMatrixDataSetContainer(this.dataSetContainer);
        mVmatrix.setTreeParent(this);
        this.addMatrix(mVmatrix);
        return mVmatrix;
    }

    @Override
    public void addMemoryState(byte by) {
        super.addMemoryState(by);
        if (by == 2) {
            int n = this.getMatrixCount();
            for (int i = 0; i < n; ++i) {
                AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
                abstractDataMatrix.addMemoryState(by);
            }
        }
    }

    @Override
    public void beginCalculations() {
        super.beginCalculations();
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataTreeMemoryClass)) continue;
            ((DataTreeMemoryClass)dataTreeInterface).beginCalculations();
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            public void setValueAt_Sort(Object object, int n, int n2) {
            }

            @Override
            protected int getColumnDescriptionCountInternal() {
                return 1;
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return MatrixContainer.this.rowDescription == null ? 1 : MatrixContainer.this.rowDescription.getColumnCount();
            }
        };
    }

    @Override
    public void endCalculations() {
        super.endCalculations();
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataTreeMemoryClass)) continue;
            ((DataTreeMemoryClass)dataTreeInterface).endCalculations();
        }
    }

    @Override
    public void enterDiskMode() {
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (!(abstractDataMatrix instanceof AbstractMVmatrix)) continue;
            ((AbstractMVmatrix)abstractDataMatrix).enterDiskMode();
        }
    }

    @Override
    public void exitDiskMode() {
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (!(abstractDataMatrix instanceof AbstractMVmatrix)) continue;
            ((AbstractMVmatrix)abstractDataMatrix).exitDiskMode();
        }
    }

    public String getColumnDescription(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        int n3 = this.getMatrixCount();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (abstractDataMatrix != this.getMatrixAt(i)) continue;
            n4 = i + 1;
            break;
        }
        if (n4 == 0) {
            return abstractDataMatrix.toString();
        }
        return this.getColumnDescription(n, n2, abstractDataMatrix.getK(), n4);
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (this.colDescription != null && this.getMatrixCount() > 0) {
            int n3 = this.getMatrixAt(0).getK();
            int n4 = n / n3 + 1;
            return this.getColumnDescription(n, n2, n3, n4);
        }
        return "K[" + (n + 1) + "]";
    }

    @Override
    public int getDataByteSize() {
        int n = 0;
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            n += this.getMatrixAt(i).getDataByteSize();
        }
        return n;
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        AbstractDataMatrix abstractDataMatrix;
        if (this.dataInfo == null && (abstractDataMatrix = this.getLastAbstractMatrix()) != null) {
            return abstractDataMatrix.getDataInfo(n);
        }
        return this.dataInfo;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        int n = this.getMatrixTag();
        if (n == 3) {
            // empty if block
        }
        return matrixIcon_stacked;
    }

    @Override
    public int getK() {
        if (!this.isLoaded()) {
            return this.K;
        }
        int n = 0;
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            n += this.getMatrixAt(i).getK();
        }
        return n;
    }

    public AbstractDataMatrix getLastAbstractMatrix() {
        int n = this.getTreeNodeCount() - this.nr_cache;
        if (n > 0) {
            return this.getMatrixAt(n - 1);
        }
        return null;
    }

    public DenseMatrix getLastMatrix() {
        AbstractDataMatrix abstractDataMatrix = this.getLastAbstractMatrix();
        if (abstractDataMatrix != null) {
            return ((MVmatrix)abstractDataMatrix).getDoubleMatrix();
        }
        return null;
    }

    @Override
    public AbstractDataMatrix getMatrixAt(int n) {
        return (AbstractDataMatrix)this.getTreeNodeAt(n);
    }

    @Override
    public final int getMatrixCount() {
        return this.getTreeNodeCount();
    }

    @Override
    public int getMissingCountForColumn(int n) {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(n);
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.getNrMV();
        }
        return super.getMissingCountForColumn(n);
    }

    @Override
    public int getN() {
        if (!this.isLoaded()) {
            return this.N;
        }
        int n = 0;
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            int n2 = this.getMatrixAt(i).getN();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        int[] nArray = this.getNref();
        if (this.rowDescription != null) {
            if (nArray != null && n >= 0 && n < nArray.length) {
                return String.valueOf(this.rowDescription.getValue(nArray[n], n2));
            }
            if (nArray == null) {
                return String.valueOf(this.rowDescription.getValue(n, n2));
            }
        }
        return "N[" + (n + 1) + "]";
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public Double getValue() {
        AbstractDataMatrix abstractDataMatrix = this.getLastAbstractMatrix();
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.getValue();
        }
        return Double.NaN;
    }

    @Override
    public double getValue(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (n3 + abstractDataMatrix.getK() > n2) {
                return abstractDataMatrix.getValue(n, n2 - n3);
            }
            n3 += abstractDataMatrix.getK();
        }
        return 0.0;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        return false;
    }

    @Override
    public boolean isModel() {
        return this.ismodel;
    }

    @Override
    public boolean isVisibleInTree() {
        if (this.getMatrixCount() == 0) {
            return false;
        }
        return super.isVisibleInTree();
    }

    @Override
    public void LoadChild(RandomInputStream randomInputStream) throws IOException {
        int n;
        int n2;
        if (this.rowDescription == null) {
            if (this.getRowType() == 2) {
                this.rowDescription = this.colDescription;
                if (this.dataSetContainer != null) {
                    this.dataInfo = this.dataSetContainer.getDataInfo(1);
                }
            } else if (this.dataSetContainer != null) {
                this.dataInfo = this.dataSetContainer.getDataInfo(0);
            }
        }
        if ((n2 = randomInputStream.ReadBlockInt()) > 0) {
            this.Kref_cs = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.Kref_cs[n] = randomInputStream.ReadBlockInt();
            }
        }
        if ((n = randomInputStream.ReadBlockInt()) > 0) {
            this.Nref_cs = new int[n];
            for (int i = 0; i < n; ++i) {
                this.Nref_cs[i] = randomInputStream.ReadBlockInt();
            }
        }
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.setMatrixDataSetContainer(this.dataSetContainer);
        this.LoadChild(randomInputStream);
    }

    @Override
    public void purge() {
        if (this.nr_cache <= 0) {
            super.purge();
        }
    }

    public void removeLastMatrix() {
        AbstractDataMatrix abstractDataMatrix = this.getLastAbstractMatrix();
        if (abstractDataMatrix != null) {
            this.needupdate = true;
            abstractDataMatrix.cleanUp();
        }
    }

    @Override
    public void removeMemoryState(byte by) {
        super.removeMemoryState(by);
        if (by == 2) {
            int n = this.getMatrixCount();
            for (int i = 0; i < n; ++i) {
                AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
                abstractDataMatrix.removeMemoryState(by);
            }
        }
    }

    @Override
    public void resetMinMax() {
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            this.getMatrixAt(i).resetMinMax();
        }
    }

    public void resize(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
        this.nr_cache = this.getMatrixCount();
        super.resize(0, 0);
        if (abstractDataMatrix != null) {
            Description description = this.rowDescription = this.getRowType() == 2 ? abstractDataMatrix.getColumnDescription() : abstractDataMatrix.getRowDescription();
        }
        if (abstractDataMatrix2 != null) {
            if (abstractDataMatrix2 instanceof ModelMatrix) {
                this.colDescription = abstractDataMatrix2.getRowDescription();
            } else {
                Description description = this.colDescription = this.getColumnInternalType() == 2 ? abstractDataMatrix2.getColumnDescription() : abstractDataMatrix2.getRowDescription();
            }
        }
        if (abstractDataMatrix != null && this.rowDescription != null) {
            if (this.getRowType() == 2) {
                this.setNref(abstractDataMatrix.getKref());
            } else {
                this.setNref(abstractDataMatrix.getNref());
                this.setFoldN(abstractDataMatrix.getFoldN());
            }
        }
        if (abstractDataMatrix2 != null && this.colDescription != null) {
            if (this.getColumnInternalType() == 2) {
                this.setKref(abstractDataMatrix2.getKref());
            } else {
                this.setKref(abstractDataMatrix2.getNref());
            }
        }
    }

    public void resize(MatrixContainer matrixContainer) {
        super.resize(0, 0);
        if (matrixContainer != null) {
            this.setNref(matrixContainer.getNref());
            this.setKref(matrixContainer.getKref());
        }
    }

    @Override
    public void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
        if (this.Kref_cs == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            randomOutputStream.WriteBlockInt(this.Kref_cs.length);
            for (int n : this.Kref_cs) {
                randomOutputStream.WriteBlockInt(n);
            }
        }
        if (this.Nref_cs == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            randomOutputStream.WriteBlockInt(this.Nref_cs.length);
            for (int n : this.Nref_cs) {
                randomOutputStream.WriteBlockInt(n);
            }
        }
        randomOutputStream.WriteBlockInt(0);
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveChild(randomOutputStream);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("ismodel", this.ismodel);
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
        if (this.colDescription != null && this.getMatrixCount() > 0) {
            int[] nArray = this.getKref();
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(0);
            int n3 = n % abstractDataMatrix.getK();
            this.colDescription.setValue(nArray[n3], n2, string);
        }
    }

    @Override
    public void setMatrixDataSetContainer(Case case_) {
        super.setMatrixDataSetContainer(case_);
        int n = this.getMatrixCount();
        for (int i = 0; i < n; ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (!(abstractDataMatrix instanceof AbstractMVmatrix)) continue;
            ((AbstractMVmatrix)abstractDataMatrix).setMatrixDataSetContainer(case_);
        }
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
        int[] nArray = this.getNref();
        if (this.rowDescription != null && n < nArray.length) {
            this.rowDescription.setValue(nArray[n], n2, string);
        }
    }

    public void setSize(int n) {
        for (int i = this.getMatrixCount() - 1; i >= n; --i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (abstractDataMatrix == null) continue;
            this.needupdate = true;
            abstractDataMatrix.cleanUp();
            if (this.nr_cache <= 0) continue;
            --this.nr_cache;
        }
    }

    @Override
    public void setValue(int n, int n2, double d) {
        this.needupdate = true;
        int n3 = 0;
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(i);
            if (n3 + abstractDataMatrix.getK() > n2) {
                abstractDataMatrix.setValue(n, n2 - n3, d);
                break;
            }
            n3 += abstractDataMatrix.getK();
        }
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dataInfo = null;
    }

    @Override
    protected void ClearChild() throws IOException {
        this.N = this.getN();
        this.K = this.getK();
        this.dataInfo = null;
    }

    private String getColumnDescription(int n, int n2, int n3, int n4) {
        int n5 = n % n3;
        int[] nArray = this.getKref();
        String string = "null";
        if (nArray != null && 0 <= n5 && n5 < nArray.length && this.colDescription != null) {
            string = String.valueOf(this.colDescription.getValue(nArray[n5], n2));
        }
        return String.valueOf(this) + "." + string + ".[" + n4 + "]";
    }

    private int getColumnInternalType() {
        return 2;
    }
}

