/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public class ModelMatrix
extends AbstractDataMatrix {
    private static int cntr = 0;
    private Vector<DenseVector> nVector_cs = null;
    private Vector<DenseVector> ciVector_cs = null;
    private boolean isvector = true;
    private List<String> statisticDescription = null;
    private boolean hasCI = false;

    public ModelMatrix(AbstractDataInfo abstractDataInfo) {
        super("modelmatrix" + ++cntr);
        if (abstractDataInfo != null) {
            this.rowDescription = (Description)abstractDataInfo.getGroupColumnByType(0);
            if (abstractDataInfo.getDataType() == 0) {
                this.setRowType(1);
            } else if (abstractDataInfo.getDataType() == 1) {
                this.setRowType(2);
            } else {
                this.setRowType(4);
            }
            this.setColumnType(8);
        }
    }

    public ModelMatrix(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix) {
        this(abstractDataInfo);
        this.resize(abstractDataMatrix);
    }

    public ModelMatrix(AbstractDataInfo abstractDataInfo, int[] nArray) {
        this(abstractDataInfo);
        this.Kref_cs = nArray;
        this.nVector_cs = new Vector();
        this.ciVector_cs = new Vector();
    }

    public ModelMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (this.rowDescription == null && (this.getMatrixTag() & 2) == 2) {
            this.rowDescription = this.colDescription;
        }
        this.isvector = mapProperty.getPropertyBoolean("iv", true);
        int n = mapProperty.getPropertyInt("sDsize", 0);
        if (n > 0) {
            this.statisticDescription = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                this.statisticDescription.add(mapProperty.getPropertyStringUTF("sD" + i));
            }
        }
        this.hasCI = mapProperty.getPropertyBoolean("hasci", false);
    }

    public void addConfidenceInterval(DenseVector denseVector) {
        Vector<Object> vector = this.getCIvector();
        if (vector == null) {
            this.ciVector_cs = new Vector();
            vector = this.ciVector_cs;
        }
        vector.addElement(denseVector);
        this.hasCI = true;
    }

    public void addRow(DenseVector denseVector) {
        Vector<DenseVector> vector = this.getNvector();
        int n = denseVector.size();
        if (vector.size() > 0) {
            if (this.K != n) {
                throw new IllegalArgumentException("Dimension doesn't fit");
            }
        } else {
            this.K = n;
        }
        this.needupdate = true;
        vector.addElement(denseVector);
    }

    public void addRow(double d) {
        this.needupdate = true;
        DenseVector denseVector = new DenseVector(1);
        denseVector.set(0, d);
        this.addRow(denseVector);
    }

    public void addStatisticDescription(String string) {
        if (this.statisticDescription == null) {
            this.statisticDescription = new ArrayList<String>();
        }
        this.statisticDescription.add(string);
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.nVector_cs != null) {
            this.nVector_cs.removeAllElements();
            this.nVector_cs = null;
        }
        if (this.ciVector_cs != null) {
            this.ciVector_cs.removeAllElements();
            this.ciVector_cs = null;
        }
        this.statisticDescription = null;
    }

    public void clearStatisticDescription() {
        this.statisticDescription = null;
    }

    @Override
    public Object clone() {
        try {
            int[] nArray = this.getKref();
            ModelMatrix modelMatrix = new ModelMatrix(this.getDataInfo(0), nArray);
            Vector<DenseVector> vector = this.getNvector();
            for (int i = 0; i < vector.size(); ++i) {
                modelMatrix.addRow(vector.elementAt(i).copy());
            }
            Vector<DenseVector> vector2 = this.getCIvector();
            if (this.hasCI) {
                for (int i = 0; i < vector2.size(); ++i) {
                    modelMatrix.addConfidenceInterval(vector2.elementAt(i).copy());
                }
            }
            return modelMatrix;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return null;
        }
    }

    public DenseMatrix createDenseMatrix() {
        int n = this.getN();
        int n2 = this.getK();
        DenseMatrix denseMatrix = new DenseMatrix(this.getK(), this.getN());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                denseMatrix.set(j, i, this.getValue(i, j));
            }
        }
        return denseMatrix;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), (this.getMatrixTag() & 4) == 0){

            @Override
            protected int getColumnDescriptionCountInternal() {
                return ModelMatrix.this.rowDescription == null || (ModelMatrix.this.getMatrixTag() & 4) != 0 ? 1 : ModelMatrix.this.rowDescription.getColumnCount();
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return 1;
            }
        };
    }

    public ModelMatrix getAdditionalMatrix() {
        DataTreeInterface dataTreeInterface;
        if (this.getTreeNodeCount() > 0 && (dataTreeInterface = this.getTreeNodeAt(0)) instanceof ModelMatrix) {
            return (ModelMatrix)dataTreeInterface;
        }
        return null;
    }

    public Vector<DenseVector> getCIvector() {
        if (!this.isCalculating()) {
            this.checkAndLoadIntoMemory();
        }
        return this.ciVector_cs;
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        int[] nArray = this.getKref();
        if (this.rowDescription == null || nArray == null || nArray.length <= n || n < 0) {
            if (n < 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.isvector ? this.name.toLowerCase() : this.name);
            if ((this.getMatrixTag() & 4) == 0) {
                stringBuilder.append("[").append(n + 1).append("]");
            }
            return stringBuilder.toString();
        }
        return String.valueOf(this.rowDescription.getValue(nArray[n], n2));
    }

    @Override
    public int getColumnDescriptionCount() {
        if (this.rowDescription == null) {
            return 1;
        }
        return this.rowDescription.getColumnCount();
    }

    @Override
    public String getColumnDescriptionTitle(int n) {
        if (this.rowDescription == null) {
            return this.isvector ? this.name.toLowerCase() : this.name;
        }
        return this.rowDescription.getColumnName(n);
    }

    @Override
    public int getColumnType() {
        return this.getMatrixTag() - 8;
    }

    public double[][] getData() {
        Vector<DenseVector> vector = this.getNvector();
        double[][] dArray = new double[this.K][vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray2 = vector.elementAt(i).getData();
            for (int j = 0; j < this.K; ++j) {
                dArray[j][i] = dArray2[j];
            }
        }
        return dArray;
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        DataTreeInterface dataTreeInterface;
        int n2;
        if (this.isCleaned()) {
            return null;
        }
        DataTreeInterface dataTreeInterface2 = this.getTreeParent();
        int n3 = this.getDataType();
        int n4 = n2 = n3 == 1 ? 0 : 1;
        if (dataTreeInterface2 instanceof AbstractPrediction && (dataTreeInterface = ((AbstractPrediction)dataTreeInterface2).getDataSet()) != null) {
            return ((DataSet)dataTreeInterface).getDataInfo(n2);
        }
        if (dataTreeInterface2 instanceof AbstractModel && (dataTreeInterface = ((AbstractModel)dataTreeInterface2).getDataSet()) != null) {
            return ((DataSet)dataTreeInterface).getDataInfo(n2);
        }
        if (this.rowDescription == null) {
            DataTreeInterface dataTreeInterface3 = dataTreeInterface = dataTreeInterface2 == null ? null : dataTreeInterface2.getTreeParent();
            if (dataTreeInterface instanceof DataSet) {
                return ((DataSet)dataTreeInterface).getDataInfo(n2);
            }
            return null;
        }
        dataTreeInterface = this.rowDescription.getTreeParent();
        if (dataTreeInterface instanceof AbstractDataInfo) {
            return (AbstractDataInfo)dataTreeInterface;
        }
        if (dataTreeInterface instanceof AbstractDataMatrix && dataTreeInterface != this) {
            return ((AbstractDataMatrix)dataTreeInterface).getDataInfo(n2);
        }
        return null;
    }

    @Override
    public int getDataType() {
        return this.getColumnType();
    }

    public float[][] getFloatData() {
        Vector<DenseVector> vector = this.getNvector();
        float[][] fArray = new float[this.K][vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = vector.elementAt(i).getData();
            for (int j = 0; j < this.K; ++j) {
                fArray[j][i] = (float)dArray[j];
            }
        }
        return fArray;
    }

    public double[][] getDoubleData() {
        Vector<DenseVector> vector = this.getNvector();
        double[][] dArray = new double[this.K][vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray2 = vector.elementAt(i).getData();
            for (int j = 0; j < this.K; ++j) {
                dArray[j][i] = dArray2[j];
            }
        }
        return dArray;
    }

    @Override
    public String getFoldName(int n) {
        return this.getRowDescription(n, 0);
    }

    @Override
    public int getFoldsize() {
        return this.getN();
    }

    @Override
    public double getFoldValue(int n, int n2) {
        return this.getValue(n2, n);
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("<HTML>");
        if (this.matrixInfo != null) {
            stringBuilder.append(this.matrixInfo);
        }
        stringBuilder.append("<BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Components:</TD><TD>").append(this.getN()).append("</TD></TR>");
        int n = this.getDataType();
        if (n == 2) {
            stringBuilder.append("<TR><TD>Variables:</TD><TD>").append(this.getK()).append("</TD></TR>");
        } else if (n == 1) {
            stringBuilder.append("<TR><TD>Observations:</TD><TD>").append(this.getK()).append("</TD></TR>");
        }
        stringBuilder.append("<TR><TD>Missing values:</TD><TD>").append(this.getNrMV()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Precision:</TD><TD>").append(TYPE_DESCR[this.getPrimitiveDataType()]).append("</TD></TR>");
        stringBuilder.append("<TR><TD>State:</TD><TD>").append(this.getMemoryStateDescr()).append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public int getK() {
        return this.K;
    }

    public DenseVector getLastRM() {
        Vector<DenseVector> vector = this.getNvector();
        if (vector != null) {
            return this.getVector(vector.size() - 1);
        }
        return null;
    }

    public double getLastScalar() {
        DenseVector denseVector = this.getLastRM();
        if (denseVector == null) {
            return 0.0;
        }
        return denseVector.get(0);
    }

    @Override
    public AbstractModel getModel() {
        DataTreeInterface dataTreeInterface;
        for (dataTreeInterface = this.getTreeParent(); dataTreeInterface != null && !(dataTreeInterface instanceof AbstractModel); dataTreeInterface = dataTreeInterface.getTreeParent()) {
        }
        return (AbstractModel)dataTreeInterface;
    }

    @Override
    public int getN() {
        if (!this.isLoaded()) {
            return this.N;
        }
        Vector<DenseVector> vector = this.getNvector();
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public DenseVector getRM(int n) {
        return this.getVector(n);
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (this.statisticDescription == null || n >= this.statisticDescription.size()) {
            if (n < 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append(this.isvector ? this.name.toLowerCase() : this.name);
            stringBuilder.append("[").append(n + 1).append("]");
            return stringBuilder.toString();
        }
        return this.statisticDescription.get(n);
    }

    @Override
    public int getRowDescriptionCount() {
        return 1;
    }

    @Override
    public String getRowDescriptionTitle(int n) {
        if (this.rowDescription != null && n < this.rowDescription.getColumnCount()) {
            return this.rowDescription.getColumnName(n);
        }
        return this.isvector ? this.name.toLowerCase() : this.name;
    }

    @Override
    public int getRowType() {
        return 8;
    }

    public double getScalar(int n) {
        DenseVector denseVector = this.getRM(n);
        if (denseVector == null) {
            return Double.NaN;
        }
        return denseVector.get(0);
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public Double getValue() {
        return this.getLastScalar();
    }

    @Override
    public double getValue(int n, int n2) {
        DenseVector denseVector = this.getVector(n);
        if (denseVector == null || n2 < 0 || n2 >= denseVector.size()) {
            return 0.0;
        }
        return denseVector.get(n2);
    }

    @Override
    public boolean hasConfidenceInterval() {
        Vector<DenseVector> vector = this.getCIvector();
        return vector != null && vector.size() > 0;
    }

    @Override
    public boolean isFoldMissing(int n, int n2) {
        return this.isMissing(n2, n);
    }

    @Override
    public boolean isModel() {
        return true;
    }

    @Override
    public boolean isModelMatrix() {
        return true;
    }

    @Override
    public boolean isObsN() {
        return !super.isObsN();
    }

    @Override
    public boolean isVisibleInTree() {
        if (this.getMatrixSize() > 0) {
            return super.isVisibleInTree();
        }
        return false;
    }

    @Override
    public Object[] list(String string) {
        if (string.equalsIgnoreCase("componentmatrices")) {
            int n = this.getN();
            int n2 = this.getK();
            Object[] objectArray = new AbstractDataMatrix[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new MVmatrix(n2, 1, "Component " + (i + 1));
                ((AbstractDataMatrix)objectArray[i]).setFoldN(this.getFoldN());
                ((AbstractDataMatrix)objectArray[i]).setNref(this.getKref());
                for (int j = 0; j < n2; ++j) {
                    ((AbstractDataMatrix)objectArray[i]).setValue(j, 0, this.getValue(i, j));
                }
            }
            return objectArray;
        }
        return super.list(string);
    }

    @Override
    public void LoadChild(RandomInputStream randomInputStream) throws IOException {
        int n;
        int n2 = randomInputStream.ReadBlockInt();
        if (n2 > 0) {
            this.Kref_cs = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.Kref_cs[n] = randomInputStream.ReadBlockInt();
            }
        }
        this.nVector_cs = new Vector();
        for (n = 0; n < this.N; ++n) {
            this.nVector_cs.addElement(new DenseVector(this.K));
        }
        if (this.hasCI) {
            this.ciVector_cs = new Vector();
            for (n = 0; n < this.N; ++n) {
                DenseVector denseVector = new DenseVector(this.K);
                this.ciVector_cs.addElement(denseVector);
                for (int i = 0; i < this.K; ++i) {
                    denseVector.set(i, randomInputStream.ReadBlockDouble());
                }
            }
        }
    }

    public void removeLastRow() {
        Vector<DenseVector> vector = this.getNvector();
        int n = vector.size();
        if (n > 0) {
            ModelMatrix modelMatrix;
            Vector<DenseVector> vector2;
            this.needupdate = true;
            DenseVector denseVector = vector.remove(n - 1);
            if (denseVector instanceof CleanUpInterface) {
                ((CleanUpInterface)denseVector).cleanUp();
            }
            if (n == 1) {
                this.K = 0;
                this.N = 0;
            }
            if ((vector2 = this.getCIvector()) != null && vector2.size() == n) {
                vector2.remove(n - 1);
            }
            if ((modelMatrix = this.getAdditionalMatrix()) != null) {
                modelMatrix.removeLastRow();
            }
        }
    }

    public void resize(AbstractDataMatrix abstractDataMatrix) {
        ModelMatrix modelMatrix;
        super.resize(0, 0);
        if (abstractDataMatrix != null && !this.isObsN()) {
            this.setFoldN(abstractDataMatrix.getFoldN());
        }
        this.nVector_cs = new Vector();
        this.ciVector_cs = new Vector();
        this.hasCI = false;
        if (abstractDataMatrix == null || this.getDataType() == 4) {
            this.setKref(null);
        } else if (this.getDataType() == 2) {
            this.setKref(abstractDataMatrix.getKref());
        } else {
            this.setKref(abstractDataMatrix.getNref());
        }
        if (abstractDataMatrix != null && this.getDataType() != 4) {
            Description description = this.rowDescription = this.getDataType() == 2 ? abstractDataMatrix.getColumnDescription() : abstractDataMatrix.getRowDescription();
        }
        if ((modelMatrix = this.getAdditionalMatrix()) != null) {
            modelMatrix.resize(abstractDataMatrix);
        }
    }

    @Override
    public void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
        int n = this.Kref_cs == null ? 0 : this.Kref_cs.length;
        randomOutputStream.WriteBlockInt(n);
        for (int i = 0; i < n; ++i) {
            randomOutputStream.WriteBlockInt(this.Kref_cs[i]);
        }
        if (this.hasCI) {
            for (DenseVector denseVector : this.ciVector_cs) {
                for (int i = 0; i < this.K; ++i) {
                    randomOutputStream.WriteBlockDouble(denseVector.get(i));
                }
            }
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("iv", this.isvector);
        if (this.statisticDescription != null) {
            randomOutputStream.writePropertyInt("sDsize", this.statisticDescription.size());
            for (int i = 0; i < this.statisticDescription.size(); ++i) {
                randomOutputStream.writePropertyStringUTF("sD" + i, this.statisticDescription.get(i));
            }
        } else {
            randomOutputStream.writePropertyInt("sDsize", 0);
        }
        randomOutputStream.writePropertyBoolean("hasci", this.hasCI);
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
        int[] nArray = this.getKref();
        if (this.rowDescription != null && nArray != null && n < nArray.length) {
            this.rowDescription.setValue(nArray[n], n2, string);
        }
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
    }

    public void setRowDescription(AbstractDataInfo abstractDataInfo) {
        this.rowDescription = (Description)abstractDataInfo.getGroupColumnByType(0);
    }

    @Override
    public void setValue(int n, int n2, double d) {
        this.needupdate = true;
        DenseVector denseVector = this.getVector(n);
        if (denseVector != null) {
            denseVector.set(n2, d);
        }
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
        this.needupdate = true;
        this.setValue(n, n2, d);
        if (bl) {
            this.addMissing(n, n2);
        }
    }

    public void setVector(boolean bl) {
        this.isvector = bl;
    }

    @Override
    protected void ClearChild() throws IOException {
        this.N = this.nVector_cs.size();
        this.nVector_cs.removeAllElements();
        this.nVector_cs = null;
        if (this.ciVector_cs != null) {
            this.ciVector_cs.removeAllElements();
            this.ciVector_cs = null;
        }
    }

    private Vector<DenseVector> getNvector() {
        if (!this.isCalculating()) {
            this.checkAndLoadIntoMemory();
        }
        return this.nVector_cs;
    }

    private DenseVector getVector(int n) {
        Vector<DenseVector> vector = this.getNvector();
        if (n < 0 || vector == null || n >= vector.size()) {
            return null;
        }
        return vector.elementAt(n);
    }
}

