/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;

public class NormalizedModelMatrix
extends ReferenceMatrix {
    private double[][] maxabs;
    private final AbstractDataMatrix refMatrix;
    private DataMatrixListener referenceListener = null;
    private final boolean normalizeRows;

    public NormalizedModelMatrix(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
        this(abstractDataMatrix, abstractDataMatrix2, true);
    }

    public NormalizedModelMatrix(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2, boolean bl) {
        super(abstractDataMatrix);
        this.refMatrix = abstractDataMatrix2;
        this.normalizeRows = bl;
        this.normalize();
        this.init();
    }

    public NormalizedModelMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.refMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "refMatrix");
        this.maxabs = mapProperty.getPropertyDoubleArray2d("maxabs", null);
        this.normalizeRows = mapProperty.getPropertyBoolean("normrows");
        this.init();
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (!this.normalizeRows) {
            String string = super.getColumnDescription(n, n2);
            return string + " (Normalized)";
        }
        return super.getColumnDescription(n, n2);
    }

    @Override
    public int getColumnDescriptionCount() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getColumnDescriptionCount();
        }
        return super.getColumnDescriptionCount();
    }

    @Override
    public String getColumnDescriptionTitle(int n) {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getColumnDescriptionTitle(n);
        }
        return super.getColumnDescriptionTitle(n);
    }

    @Override
    public int[] getKref() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getKref();
        }
        return super.getKref();
    }

    @Override
    public int[] getNref() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getNref();
        }
        return super.getNref();
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (this.normalizeRows) {
            String string = super.getRowDescription(n, n2);
            return string + " (Normalized)";
        }
        return super.getRowDescription(n, n2);
    }

    @Override
    public int getRowDescriptionCount() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getRowDescriptionCount();
        }
        return super.getRowDescriptionCount();
    }

    @Override
    public byte getTreeType() {
        return 15;
    }

    @Override
    public double getValue(int n, int n2) {
        double d = super.getValue(n, n2);
        if (this.normalizeRows) {
            return d / this.maxabs[n][0] * this.maxabs[n][1];
        }
        return d / this.maxabs[n2][0] * this.maxabs[n2][1];
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("refMatrix", this.refMatrix);
        randomOutputStream.writePropertyDoubleArray("maxabs", this.maxabs);
        randomOutputStream.writePropertyBoolean("normrows", this.normalizeRows);
    }

    @Override
    protected void cleanUpChild() {
        if (this.referenceMatrix != null && this.referenceListener != null) {
            this.referenceMatrix.removeDataTreeChangeListener(this.referenceListener);
            this.referenceListener = null;
        }
        super.cleanUpChild();
    }

    @Override
    protected int getReferenceK(int n) {
        return n;
    }

    @Override
    protected int getReferenceN(int n) {
        return n;
    }

    private void init() {
        this.referenceListener = new DataMatrixListener(){

            @Override
            public void eventFinished(DataTreeEvent dataTreeEvent) {
            }

            @Override
            public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
                NormalizedModelMatrix.this.normalize();
            }

            @Override
            public void nodeReplaced(DataTreeEvent dataTreeEvent) {
            }

            @Override
            public void propertyChanged(DataTreeEvent dataTreeEvent) {
            }
        };
        this.referenceMatrix.addDataTreeChangeListener(this.referenceListener);
    }

    private void normalize() {
        int n;
        int n2;
        this.beginUpdate();
        this.K = this.referenceMatrix.getK();
        this.N = this.referenceMatrix.getN();
        this.maxabs = this.normalizeRows ? new double[this.N][2] : new double[this.K][2];
        for (n2 = 0; n2 < this.N; ++n2) {
            for (n = 0; n < this.K; ++n) {
                double d = Math.abs(this.referenceMatrix.getValue(n2, n));
                if (this.normalizeRows) {
                    if (!(this.maxabs[n2][0] < d)) continue;
                    this.maxabs[n2][0] = d;
                    continue;
                }
                if (!(this.maxabs[n][0] < d)) continue;
                this.maxabs[n][0] = d;
            }
        }
        n2 = this.refMatrix.getK();
        n = this.refMatrix.getN();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = Math.abs(this.refMatrix.getValue(i, j));
                if (this.normalizeRows) {
                    if (!(this.maxabs[i][1] < d)) continue;
                    this.maxabs[i][1] = d;
                    continue;
                }
                if (!(this.maxabs[j][1] < d)) continue;
                this.maxabs[j][1] = d;
            }
        }
        this.endUpdate(true, true);
    }
}

