/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.EOFException;
import java.io.IOException;
import javax.swing.ImageIcon;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.model.AbstractModel;

public class ReferenceMatrix
extends AbstractDataMatrix {
    private static final ImageIcon matrixShortcutIcon = new ImageIcon(Main_GUI.class.getResource("gif/tableshortcut.gif"));
    protected AbstractDataMatrix referenceMatrix;
    private int refrow;
    private int refcol;
    private boolean canloadNKref = false;

    public ReferenceMatrix(AbstractDataMatrix abstractDataMatrix) {
        super(abstractDataMatrix == null ? "ReferenceMatrix" : abstractDataMatrix.toString());
        this.referenceMatrix = abstractDataMatrix;
    }

    public ReferenceMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.referenceMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "rmatrix");
        this.canloadNKref = mapProperty.getPropertyBoolean("NK");
    }

    @Override
    public void beginCalculations() {
        super.beginCalculations();
        if (this.referenceMatrix != null) {
            this.referenceMatrix.beginCalculations();
        }
    }

    @Override
    public Object clone() {
        return this.cloneTo(null, null, this.getPrimitiveDataType());
    }

    public AbstractMVmatrix cloneTo(final ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int n) {
        final int n2 = this.getN();
        final int n3 = this.getK();
        if (abstractMVmatrix == null) {
            abstractMVmatrix = ReferenceMatrix.createMatrix(n2, n3, String.valueOf(this) + ".sub", n);
            abstractMVmatrix.beginCalculations();
        } else {
            abstractMVmatrix.beginCalculations();
            abstractMVmatrix.resizeInnerMatrix(n2, n3);
            abstractMVmatrix.removeIdentifiersAndTransformations();
        }
        abstractMVmatrix.setRowDescription(this.getRowDescription());
        abstractMVmatrix.setColumnDescription(this.getColumnDescription());
        abstractMVmatrix.setMatrixDataSetContainer(this.dataSetContainer);
        final int[] nArray = this.getNref();
        final int[] nArray2 = this.getKref();
        final Matrix matrix = abstractMVmatrix.getInternalMatrix();
        this.beginCalculations();
        if (this.getDeepestReference().isLoaded()) {
            Threader threader = new Threader(this){
                final /* synthetic */ ReferenceMatrix this$0;
                {
                    this.this$0 = referenceMatrix;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    this.this$0.cloneTo(bl ? progressManager : null, nArray, nArray2, matrix, n, n22, n2);
                }

                @Override
                protected void init(int n, int n22) {
                    if (progressManager != null) {
                        progressManager.setMaximumAndReset(n3 - n22 * (n - 1));
                    }
                }
            };
            threader.execute(n3);
        } else {
            this.cloneTo(progressManager, nArray, nArray2, matrix, 0, n3, n2);
        }
        this.endCalculations();
        abstractMVmatrix.setNref(ReferenceMatrix.cloneArray(nArray));
        abstractMVmatrix.setKref(ReferenceMatrix.cloneArray(nArray2));
        abstractMVmatrix.setMissing(this);
        abstractMVmatrix.setFoldN(this.getFoldN());
        abstractMVmatrix.endCalculations();
        return abstractMVmatrix;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            public void setValueAt_Sort(Object object, int n, int n2) {
                super.setValueAt_Sort(object, n, n2);
                if (!ReferenceMatrix.this.referenceMatrix.isProtected()) {
                    DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, ReferenceMatrix.this, n, n2);
                    ReferenceMatrix.this.triggerEvent(dataMatrixEvent);
                    dataMatrixEvent.cleanUp();
                }
            }

            @Override
            protected int getColumnDescriptionCountInternal() {
                return ReferenceMatrix.this.colDescription == null ? 0 : ReferenceMatrix.this.colDescription.getColumnCount();
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return ReferenceMatrix.this.rowDescription == null ? 0 : ReferenceMatrix.this.rowDescription.getColumnCount();
            }
        };
    }

    @Override
    public void endCalculations() {
        super.endCalculations();
        if (this.referenceMatrix != null) {
            this.referenceMatrix.endCalculations();
        }
    }

    @Override
    public void enterDiskMode() {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.enterDiskMode();
        }
    }

    @Override
    public void exitDiskMode() {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.exitDiskMode();
        }
    }

    @Override
    public DataTreeInterface getAncestor() {
        if (this.referenceMatrix == null) {
            return super.getAncestor();
        }
        return this.referenceMatrix.getAncestor();
    }

    @Override
    public Description getColumnDescription() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getColumnDescription();
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (this.referenceMatrix == null) {
            return "N/A";
        }
        this.updateReferenceCoord(0, n);
        return this.referenceMatrix.getColumnDescription(this.refcol, n2);
    }

    @Override
    public int getColumnType() {
        if (this.referenceMatrix == null) {
            return super.getColumnType();
        }
        return this.referenceMatrix.getColumnType();
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getDataInfo(n);
    }

    public AbstractDataMatrix getDeepestReference() {
        AbstractDataMatrix abstractDataMatrix = this.referenceMatrix;
        while (abstractDataMatrix instanceof ReferenceMatrix) {
            abstractDataMatrix = ((ReferenceMatrix)abstractDataMatrix).referenceMatrix;
        }
        return abstractDataMatrix;
    }

    @Override
    public int getFoldK() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getFoldK();
    }

    @Override
    public int getFoldN() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getFoldN();
    }

    @Override
    public String getFoldName(int n) {
        if (this.referenceMatrix == null) {
            return "N/A";
        }
        return this.referenceMatrix.getFoldName(n);
    }

    @Override
    public int getFoldsize() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getFoldsize();
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return matrixShortcutIcon;
    }

    @Override
    public int getK() {
        return this.K;
    }

    @Override
    public AbstractDataMatrix getMatrixAt(int n) {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getMatrixAt(n);
        }
        return null;
    }

    @Override
    public int getMatrixCount() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getMatrixCount();
        }
        return 0;
    }

    @Override
    public int getMissingCountForColumn(int n) {
        this.updateReferenceCoord(0, n);
        if (this.referenceMatrix == null || this.referenceMatrix.getMissingCountForColumn(this.refcol) == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this.N; ++i) {
            if (!this.referenceMatrix.isMissing(this.getReferenceN(i), this.refcol)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public int[] getMissingCountForColumns(boolean bl) {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getMissingCountForColumns(bl);
    }

    @Override
    public int getMissingCountForRow(int n) {
        this.updateReferenceCoord(n, 0);
        if (this.referenceMatrix == null || this.referenceMatrix.getMissingCountForRow(this.refrow) == 0) {
            return 0;
        }
        int[] nArray = this.getKref();
        if (nArray != null) {
            return this.referenceMatrix.getMissingCountForRow(this.refrow, nArray);
        }
        int n2 = 0;
        for (int i = 0; i < this.K; ++i) {
            if (!this.referenceMatrix.isMissing(this.refrow, this.getReferenceK(i))) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public int[] getMissingCountForRows(boolean bl) {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getMissingCountForRows(bl);
    }

    @Override
    public boolean[][] getMissingMatrix() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getMissingMatrix();
    }

    @Override
    public AbstractModel getModel() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getModel();
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public int getNrMV() {
        return this.nrMV;
    }

    @Override
    public int getPrimitiveDataType() {
        if (this.referenceMatrix != null) {
            return this.referenceMatrix.getPrimitiveDataType();
        }
        return super.getPrimitiveDataType();
    }

    public AbstractDataMatrix getReferencedMatrix() {
        return this.referenceMatrix;
    }

    @Override
    public int[] getReferenceKref() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getKref();
    }

    @Override
    public int[] getReferenceNref() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getNref();
    }

    public int getRefRow() {
        return this.refrow;
    }

    public AbstractDataMatrix getRootReferencedMatrix() {
        if (this.referenceMatrix instanceof ReferenceMatrix) {
            return ((ReferenceMatrix)this.referenceMatrix).getRootReferencedMatrix();
        }
        return this.referenceMatrix;
    }

    @Override
    public Description getRowDescription() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getRowDescription();
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (this.referenceMatrix == null) {
            return "N/A";
        }
        this.updateReferenceCoord(n, 0);
        return this.referenceMatrix.getRowDescription(this.refrow, n2);
    }

    @Override
    public String getRowDescriptionTitle(int n) {
        if (this.referenceMatrix == null) {
            return "N/A";
        }
        return this.referenceMatrix.getRowDescriptionTitle(n);
    }

    @Override
    public int getRowType() {
        if (this.referenceMatrix == null) {
            return super.getRowType();
        }
        return this.referenceMatrix.getRowType();
    }

    @Override
    public byte getTreeType() {
        return 4;
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.referenceMatrix == null || n < 0 || n2 < 0) {
            return 0.0;
        }
        this.updateReferenceCoord(n, n2);
        return this.referenceMatrix.getValue(this, this.refrow, this.refcol);
    }

    public double getValueRefCoords(int n, int n2) {
        if (this.referenceMatrix == null || n < 0 || n2 < 0) {
            return 0.0;
        }
        return this.referenceMatrix.getValue(this, n, n2);
    }

    @Override
    public boolean isImage() {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isImage();
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (this.referenceMatrix == null) {
            return true;
        }
        this.updateReferenceCoord(n, n2);
        return this.referenceMatrix.isMissing(this.refrow, this.refcol);
    }

    @Override
    public boolean isModel() {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isModel();
    }

    @Override
    public boolean isModelMatrix() {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isModelMatrix();
    }

    @Override
    public boolean isObsN() {
        if (this.referenceMatrix == null) {
            return super.isObsN();
        }
        return this.referenceMatrix.isObsN();
    }

    public boolean isReferenceCleaned() {
        return this.referenceMatrix == null || this.referenceMatrix.isCleaned();
    }

    @Override
    public boolean isRelatedTo(DataTreeInterface dataTreeInterface) {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isRelatedTo(dataTreeInterface);
    }

    @Override
    public boolean isUnFolded() {
        if (this.referenceMatrix == null) {
            return false;
        }
        return this.referenceMatrix.isUnFolded();
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.setMatrixDataSetContainer(this.dataSetContainer);
        this.LoadChild(randomInputStream);
    }

    @Override
    public void resetMinMax() {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.resetMinMax();
        }
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveChild(randomOutputStream);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("rmatrix", this.referenceMatrix);
        randomOutputStream.writePropertyBoolean("NK", true);
    }

    public void setK(int n) {
        this.K = n;
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
        this.updateReferenceCoord(0, n);
        this.referenceMatrix.setKInfo(this.refcol, n2, string);
    }

    @Override
    public void setLayerMinMax() {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.setLayerMinMax();
        }
    }

    public void setN(int n) {
        this.N = n;
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
        this.updateReferenceCoord(n, 0);
        this.referenceMatrix.setNInfo(this.refrow, n2, string);
    }

    public void setReferenceMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
        this.setReferenceMatrix(progressManager, abstractDataMatrix, true);
    }

    public void setReferenceMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) {
        if (this.referenceMatrix != abstractDataMatrix) {
            this.referenceMatrix = abstractDataMatrix;
            if (bl) {
                this.updateReferences(progressManager, true);
            }
        }
    }

    @Override
    public void setValue(int n, int n2, double d) {
        if (this.referenceMatrix == null) {
            return;
        }
        this.updateReferenceCoord(n, n2);
        this.referenceMatrix.setValue(this.refrow, this.refcol, d);
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
        if (this.referenceMatrix == null) {
            return;
        }
        this.updateReferenceCoord(n, n2);
        this.referenceMatrix.setValue(this.refrow, this.refcol, d, bl);
    }

    @Override
    public void setValueMinMax(int n, int n2, double d) {
        if (this.referenceMatrix == null) {
            return;
        }
        this.updateReferenceCoord(n, n2);
        this.referenceMatrix.setValueMinMax(this.refrow, this.refcol, d);
    }

    @Override
    public void setValueMinMax(int n, int n2, double d, boolean bl) {
        if (this.referenceMatrix == null) {
            return;
        }
        this.updateReferenceCoord(n, n2);
        this.referenceMatrix.setValueMinMax(this.refrow, this.refcol, d, bl);
    }

    @Override
    public AbstractMVmatrix subMatrix(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, int[] nArray, int[] nArray2, int n) {
        if (nArray == null && nArray2 == null) {
            return this.cloneTo(progressManager, abstractMVmatrix, n);
        }
        return super.subMatrix(progressManager, abstractMVmatrix, nArray, nArray2, n);
    }

    public void updateReferences(int n, int n2) {
        this.nrMV = 0;
        if (this.referenceMatrix != null && this.referenceMatrix.getNrMV() > 0) {
            if (this.N < this.K) {
                for (var3_3 = 0; var3_3 < this.N; ++var3_3) {
                    this.nrMV += this.getMissingCountForRow(var3_3);
                }
            } else {
                for (var3_3 = 0; var3_3 < this.K; ++var3_3) {
                    this.nrMV += this.getMissingCountForColumn(var3_3);
                }
            }
        }
        DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, 0, 0);
        if (n != this.N || n2 != this.K) {
            dataMatrixEvent.Structurechanged(n, n2);
        }
        this.triggerEvent(dataMatrixEvent);
        dataMatrixEvent.cleanUp();
    }

    public void updateReferences(ProgressManager progressManager, boolean bl) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    @Override
    protected void ClearChild() throws IOException {
        this.Kref_cs = null;
        this.Nref_cs = null;
    }

    protected int getReferenceK(int n) {
        int[] nArray = this.getKref();
        if (nArray != null && 0 <= n && n < nArray.length) {
            return nArray[n];
        }
        return n;
    }

    protected int getReferenceN(int n) {
        int[] nArray = this.getNref();
        if (nArray != null && 0 <= n && n < nArray.length) {
            return nArray[n];
        }
        return n;
    }

    @Override
    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
        try {
            int n;
            int n2 = this.K;
            if (this.canloadNKref) {
                n2 = randomInputStream.ReadBlockInt();
            }
            if (n2 > 0) {
                this.Kref_cs = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.Kref_cs[n] = randomInputStream.ReadBlockInt();
                }
            }
            n = this.N;
            if (this.canloadNKref) {
                n = randomInputStream.ReadBlockInt();
            }
            if (n > 0) {
                this.Nref_cs = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.Nref_cs[i] = randomInputStream.ReadBlockInt();
                }
            }
        }
        catch (EOFException eOFException) {
            ErrorHandler.logAndReportException(eOFException);
            this.Kref_cs = null;
            this.Nref_cs = null;
        }
    }

    @Override
    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        int n2;
        if (this.Kref_cs != null) {
            n2 = Math.min(this.getK(), this.Kref_cs.length);
            randomOutputStream.WriteBlockInt(n2);
            for (n = 0; n < n2; ++n) {
                randomOutputStream.WriteBlockInt(this.Kref_cs[n]);
            }
        } else {
            randomOutputStream.WriteBlockInt(0);
        }
        if (this.Nref_cs != null) {
            n2 = Math.min(this.getN(), this.Nref_cs.length);
            randomOutputStream.WriteBlockInt(n2);
            for (n = 0; n < n2; ++n) {
                randomOutputStream.WriteBlockInt(this.Nref_cs[n]);
            }
        } else {
            randomOutputStream.WriteBlockInt(0);
        }
    }

    protected void updateReferenceCoord(int n, int n2) {
        this.refrow = this.getReferenceN(n);
        this.refcol = this.getReferenceK(n2);
    }

    private void cloneTo(ProgressManager progressManager, int[] nArray, int[] nArray2, Matrix matrix, int n, int n2, int n3) {
        AbstractDataMatrix abstractDataMatrix = this.referenceMatrix;
        if (abstractDataMatrix instanceof TransformMatrix) {
            TransformMatrix transformMatrix = (TransformMatrix)abstractDataMatrix;
            AbstractDataMatrix abstractDataMatrix2 = transformMatrix.getReferencedMatrix();
            if (transformMatrix.getN() == abstractDataMatrix2.getN() && transformMatrix.getK() == abstractDataMatrix2.getK()) {
                abstractDataMatrix = abstractDataMatrix2;
            }
        }
        if (abstractDataMatrix instanceof LayerMatrix) {
            ((LayerMatrix)abstractDataMatrix).cloneTo(progressManager, nArray, nArray2, matrix, n, n2, n3);
        } else if (nArray == null || nArray2 == null) {
            for (int i = n; i < n2; ++i) {
                int n4 = nArray2 == null ? i : nArray2[i];
                for (int j = 0; j < n3; ++j) {
                    int n5 = nArray == null ? j : nArray[j];
                    matrix.set(j, i, abstractDataMatrix.getValue(n5, n4));
                }
                if (progressManager == null) continue;
                progressManager.incStep();
            }
        } else {
            for (int i = n; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    matrix.set(j, i, abstractDataMatrix.getValue(nArray[j], nArray2[i]));
                }
                if (progressManager == null) continue;
                progressManager.incStep();
            }
        }
    }
}

