/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.sparsetable.SparseModel;
import se.prediktera.map.datasetcontainer.database.EditableTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public class SparseMatrix
extends AbstractDataMatrix
implements EditableTreeInterface {
    protected static final ImageIcon matrixIcon = new ImageIcon(Main_GUI.class.getResource("gif/tableunidentified.gif"));
    private Hashtable<Key, Object> sparseData = new Hashtable();
    private final Key key = new Key();
    private int maxRows = 65536;
    private int maxCols = 8000;
    private boolean fixedsize = false;
    private Project_GUI project_GUI;

    public SparseMatrix(int n, int n2, String string) {
        super(string);
        this.maxRows = n;
        this.maxCols = n2;
    }

    public SparseMatrix(int n, String string) {
        super(string);
        this.sparseData = new Hashtable((int)((float)n / 0.75f), 0.75f);
    }

    public SparseMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public SparseMatrix(String string) {
        super(string);
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        this.project_GUI = project_GUI;
        jPopupMenu.addSeparator();
        jPopupMenu.add(new CMenuItem("Erase", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.cleanUp();
                SparseMatrix.this.project_GUI.purgeSignal();
            }
        });
    }

    @Override
    public void beginUpdate(int n, int n2) {
        this.beginUpdate();
        this.fixedsize = true;
        this.Expand(n, n2);
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.sparseData.clear();
        this.sparseData = null;
    }

    public void clearMatrix() {
        boolean bl;
        int n = this.N;
        int n2 = this.K;
        this.sparseData.clear();
        this.K = 0;
        this.N = 0;
        boolean bl2 = bl = this.N != n || this.K != n2;
        if (!this.doupdate) {
            DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, 0, 0);
            if (bl) {
                dataMatrixEvent.Structurechanged(n, n2);
            }
            this.triggerEvent(dataMatrixEvent);
            dataMatrixEvent.cleanUp();
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    public MVmatrix createMVmatrix() {
        MVmatrix mVmatrix = new MVmatrix(this.N, this.K);
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.K; ++j) {
                if (this.isMissing(i, j)) {
                    mVmatrix.setValue(i, j, 0.0, true);
                    continue;
                }
                mVmatrix.setValue(i, j, this.getValue(i, j), false);
            }
        }
        return mVmatrix;
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        int n = this.maxRows;
        int n2 = this.maxCols;
        if (bl) {
            n = this.getN();
            n2 = this.getK();
        }
        return new SparseModel(this, n, n2, false);
    }

    @Override
    public void endUpdate() {
        this.fixedsize = false;
        super.endUpdate();
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (this.colDescription != null) {
            return (String)this.colDescription.getValue(n, n2);
        }
        return String.valueOf(n + 1);
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return matrixIcon;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("<HTML>");
        if (this.matrixInfo != null) {
            stringBuilder.append(this.matrixInfo);
        }
        stringBuilder.append("<BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Observations:</TD><TD>").append(this.getN()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Variables:</TD><TD>").append(this.getK()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>State:</TD><TD>").append(this.getMemoryStateDescr()).append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public int getK() {
        return this.K;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (this.rowDescription != null) {
            return (String)this.rowDescription.getValue(n, n2);
        }
        return String.valueOf(n + 1);
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public double getValue(int n, int n2) {
        Object object = this.getValue_Object(n, n2);
        if (object != null) {
            Double d = SimpleTableModel.parseObject(object);
            if (d == null) {
                return 0.0;
            }
            return d;
        }
        return 0.0;
    }

    public Object getValue_Object(int n, int n2) {
        this.checkAndLoadIntoMemory();
        this.key.row = n;
        this.key.col = n2;
        return this.sparseData.get(this.key);
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (n >= this.N || n2 >= this.K) {
            return true;
        }
        this.key.row = n;
        this.key.col = n2;
        Object object = this.sparseData.get(this.key);
        return object == null;
    }

    @Override
    public boolean isModel() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public void LoadChild(RandomInputStream randomInputStream) throws IOException {
        this.Expand(this.getN() - 1, this.getK() - 1);
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        this.setMatrixDataSetContainer(this.dataSetContainer);
        this.LoadChild(randomInputStream);
        int n = randomInputStream.ReadBlockInt();
        this.sparseData = new Hashtable((int)((float)n / 0.75f), 0.75f);
        for (int i = 0; i < n; ++i) {
            Key key = new Key(randomInputStream.ReadBlockInt(), randomInputStream.ReadBlockInt());
            this.sparseData.put(key, randomInputStream.ReadBlockUTF());
        }
    }

    @Override
    public void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveChild(randomOutputStream);
        this.checkAndLoadIntoMemory();
        randomOutputStream.WriteBlockInt(this.sparseData.size());
        Enumeration<Key> enumeration = this.sparseData.keys();
        while (enumeration.hasMoreElements()) {
            Key key = enumeration.nextElement();
            randomOutputStream.WriteBlockInt(key.row);
            randomOutputStream.WriteBlockInt(key.col);
            randomOutputStream.WriteBlockUTF(this.sparseData.get(key).toString());
        }
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
        if (this.colDescription != null) {
            this.colDescription.setValue(n, n2, string);
        }
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
        if (this.rowDescription != null) {
            this.rowDescription.setValue(n, n2, string);
        }
    }

    @Override
    public void setValue(int n, int n2, double d) {
        this.setValue(n, n2, (Object)d);
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
        this.setValue(n, n2, (Object)d, bl);
    }

    public void setValue(int n, int n2, Object object) {
        int n3 = this.N;
        int n4 = this.K;
        this.needupdate = true;
        boolean bl = false;
        if (!this.fixedsize) {
            bl = this.Expand(n, n2);
        }
        boolean bl2 = true;
        Key key = new Key(n, n2);
        Object object2 = this.sparseData.put(key, object);
        if (object2 != null && object2 == object) {
            bl2 = false;
        }
        if (bl2 && !this.doupdate) {
            DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, n, n2);
            if (bl) {
                dataMatrixEvent.Structurechanged(n3, n4);
            }
            this.triggerEvent(dataMatrixEvent);
            dataMatrixEvent.cleanUp();
        }
    }

    public void setValue(int n, int n2, Object object, boolean bl) {
        this.needupdate = true;
        if (bl) {
            this.key.row = n;
            this.key.col = n2;
            Object object2 = this.sparseData.remove(this.key);
            if (object2 != null) {
                boolean bl2 = this.Shrink(n, n2);
                if (!this.doupdate) {
                    DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, n, n2);
                    if (bl2) {
                        dataMatrixEvent.Structurechanged(this.N, this.K);
                    }
                    this.triggerEvent(dataMatrixEvent);
                    dataMatrixEvent.cleanUp();
                }
            }
        } else if (object.toString().length() > 0) {
            this.setValue(n, n2, object);
        }
    }

    @Override
    protected void ClearChild() throws IOException {
        this.sparseData.clear();
    }

    private boolean Expand(int n, int n2) {
        if (++n > this.N || ++n2 > this.K) {
            if (n > this.N) {
                this.N = n;
            }
            if (n2 > this.K) {
                this.K = n2;
            }
            return true;
        }
        return false;
    }

    private boolean Shrink(int n, int n2) {
        if (++n == this.N || ++n2 == this.K) {
            n = -1;
            n2 = -1;
            Enumeration<Key> enumeration = this.sparseData.keys();
            while (enumeration.hasMoreElements()) {
                Key key = enumeration.nextElement();
                if (n < key.row) {
                    n = key.row;
                }
                if (n2 >= key.row) continue;
                n2 = key.row;
            }
            if (++n < this.N || ++n2 < this.K) {
                this.N = n;
                this.K = n2;
                return true;
            }
        }
        return false;
    }

    static class Key {
        public int row;
        public int col;

        public Key() {
        }

        public Key(int n, int n2) {
            this.row = n;
            this.col = n2;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Key && ((Key)object).row == this.row && ((Key)object).col == this.col;
        }

        public int hashCode() {
            return this.row + this.col;
        }
    }
}

