/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.matrix;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSetMatrix;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;

public class TransformedReferenceMatrix
extends ReferenceMatrix {
    private AbstractDataMatrix dataSetMatrix;
    private AbstractDataMatrix transformationMatrix;

    public TransformedReferenceMatrix(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2, AbstractDataMatrix abstractDataMatrix3) {
        super(abstractDataMatrix2);
        this.dataSetMatrix = abstractDataMatrix;
        this.transformationMatrix = abstractDataMatrix3;
    }

    public TransformedReferenceMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dataSetMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "trfPar");
        if (this.referenceMatrix instanceof DataSetMatrix) {
            this.dataSetMatrix = this.referenceMatrix;
            this.setReferenceMatrix(null, this.dataSetMatrix);
        }
        this.transformationMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "tfm");
        if (this.transformationMatrix == null) {
            this.transformationMatrix = this.referenceMatrix;
        }
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.addDataTreeChangeListener(dataTreeListener);
        }
        super.addDataTreeChangeListener(dataTreeListener);
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            public void setValueAt_Sort(Object object, int n, int n2) {
                super.setValueAt_Sort(object, n, n2);
                if (!TransformedReferenceMatrix.this.referenceMatrix.isProtected()) {
                    DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, TransformedReferenceMatrix.this, n, n2);
                    TransformedReferenceMatrix.this.triggerEvent(dataMatrixEvent);
                    dataMatrixEvent.cleanUp();
                }
            }

            @Override
            protected int getColumnDescriptionCountInternal() {
                if (TransformedReferenceMatrix.this.referenceMatrix != null) {
                    return TransformedReferenceMatrix.this.referenceMatrix.getColumnDescription().getColumnCount();
                }
                return 0;
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                if (TransformedReferenceMatrix.this.referenceMatrix != null) {
                    return TransformedReferenceMatrix.this.referenceMatrix.getRowDescription().getColumnCount();
                }
                return 0;
            }
        };
    }

    @Override
    public void endUpdate() {
        this.doupdate = false;
        if (!this.isCleaned()) {
            DataMatrixEvent dataMatrixEvent = new DataMatrixEvent(this, this, 0, 0);
            this.triggerEvent(dataMatrixEvent);
            dataMatrixEvent.cleanUp();
        }
    }

    @Override
    public int getK() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getK();
    }

    @Override
    public int[] getKref() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getKref();
    }

    @Override
    public int[] getMissingCountForColumns(boolean bl) {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getMissingCountForColumns(bl);
    }

    @Override
    public int getN() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getN();
    }

    @Override
    public int[] getNref() {
        if (this.referenceMatrix == null) {
            return null;
        }
        return this.referenceMatrix.getNref();
    }

    @Override
    public int getNrMV() {
        if (this.referenceMatrix == null) {
            return 0;
        }
        return this.referenceMatrix.getNrMV();
    }

    public double getOrigValue(int n, int n2) {
        AbstractDataMatrix abstractDataMatrix = ((DataSetMatrix)this.dataSetMatrix).getReferencedMatrix();
        return abstractDataMatrix.getValue(n, n2);
    }

    @Override
    public String getTransformationInfo() {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.getTransformationInfo();
        }
        return "";
    }

    @Override
    public byte getTreeType() {
        return 10;
    }

    @Override
    public double getValue(int n, int n2) {
        return this.getValueBefore(null, n, n2);
    }

    @Override
    public double getValueBefore(AbstractDataTransform abstractDataTransform, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return 0.0;
        }
        AbstractDataMatrix abstractDataMatrix = ((DataSetMatrix)this.dataSetMatrix).getReferencedMatrix();
        int[] nArray = this.getNref();
        int[] nArray2 = this.getKref();
        int n3 = nArray == null || n >= nArray.length ? n : nArray[n];
        int n4 = nArray2 == null || n2 >= nArray2.length ? n2 : nArray2[n2];
        double d = abstractDataMatrix.getValue(n3, n4);
        if (n < 0 || n2 < 0) {
            return d;
        }
        int n5 = this.transformationMatrix.getTreeNodeCount();
        for (int i = 0; i < n5; ++i) {
            DataTreeInterface dataTreeInterface = this.transformationMatrix.getTreeNodeAt(i);
            if (abstractDataTransform != null && dataTreeInterface == abstractDataTransform) break;
            if (!(dataTreeInterface instanceof AbstractDataTransform)) continue;
            d = ((AbstractDataTransform)dataTreeInterface).transformValue(this, n, n2, n3, n4, d);
        }
        return d;
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
        if (this.referenceMatrix != null) {
            this.referenceMatrix.removeDataTreeChangeListener(dataTreeListener);
        }
        super.removeDataTreeChangeListener(dataTreeListener);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("trfPar", this.dataSetMatrix);
        randomOutputStream.writePropertyNode("tfm", this.transformationMatrix);
    }

    @Override
    public String toHtmlString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.dataSetMatrix != null) {
            String string = this.dataSetMatrix.toString();
            if (this.referenceMatrix == null) {
                return string;
            }
            return string + "  (transformed)";
        }
        return "N/A";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dataSetMatrix = null;
        this.transformationMatrix = null;
    }

    @Override
    protected int getReferenceK(int n) {
        return n;
    }

    @Override
    protected int getReferenceN(int n) {
        return n;
    }
}

