/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.nodecase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.VarianceDialog;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.IniManager;

public class ProjectDataSource
extends AbstractDataSource {
    private List<ProjectSummary> projectFileList = new ArrayList<ProjectSummary>();
    private ProjectSummary referenceProject = null;
    private int currow;
    private int yvalues;
    private int ROWDESCR = 1;
    private int COLDESCR = 5;
    private int METADATA = 0;
    private File folder;
    private String[] names;
    private int layerCount;
    private int currentLayer;
    private boolean mergeProjects = false;
    private boolean representativeSelection = false;
    private boolean showThumbnails = true;
    private boolean showAverageClass = true;
    private String dataSetName;
    private long minmetatime = Long.MAX_VALUE;
    private final String[] thumbnailNames = new String[]{"raw", "score"};
    private boolean byvariablename = false;
    private String categoryDescription = null;

    public static void main(String[] stringArray) {
        ProjectDataSource projectDataSource = new ProjectDataSource(new File("I:\\data\\Arla\\091202 - Arla\\Struktur snittyta"));
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                return null;
            }
        };
        long l = System.currentTimeMillis();
        projectDataSource.setupProjectStructure(progressManagerImpl);
        projectDataSource.initiateDataSet(progressManagerImpl, "Average");
        projectDataSource.close();
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l2 - runtime.freeMemory();
        System.out.println("Used memory: " + l3 / 1024L / 1024L + "MB");
        System.out.println("Time: " + (System.currentTimeMillis() - l) / 1000L + "sek");
        System.exit(0);
    }

    public ProjectDataSource(File file) {
        super((byte)0);
        if (file.isDirectory()) {
            this.folder = file;
            this.loopProjectFiles(this.folder);
        } else {
            this.folder = file.getParentFile();
            this.projectFileList.add(new ProjectSummary(file));
        }
    }

    public ProjectDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        int n = mapProperty.getPropertyInt("files");
        for (int i = 0; i < n; ++i) {
        }
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        int n2;
        if (this.mergeProjects) {
            return;
        }
        this.setPrimaryRow(0);
        int n3 = 0;
        this.addInterval(1, n3++, (byte)3);
        this.addInterval(1, n3++, (byte)3);
        if (this.showThumbnails) {
            for (n2 = 0; n2 < this.thumbnailNames.length; ++n2) {
                this.addInterval(1, n3++, (byte)14);
            }
        }
        if (this.showAverageClass) {
            this.addInterval(1, n3++, (byte)3);
        }
        this.addInterval(0, 0, (byte)0);
        for (n2 = 0; n2 < this.METADATA; ++n2) {
            this.addInterval(1, n2 + this.COLDESCR, (byte)1);
        }
        for (n2 = 0; n2 < this.yvalues; ++n2) {
            this.addInterval(1, this.columns - n2 - 1, (byte)10);
        }
        if (!this.representativeSelection) {
            VarianceDialog.autoExclude(0, this);
        }
    }

    @Override
    public void closeConnections() {
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof Case)) continue;
            dataTreeInterface.cleanUp();
        }
    }

    @Override
    public int[] getDataOrder() {
        if (this.mergeProjects) {
            return new int[]{2, 1, 0};
        }
        return new int[]{0, 1, 2};
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (!this.mergeProjects && n == 0) {
            return fastDecimal.error();
        }
        ProjectSummary projectSummary = this.getProjectSummary(n);
        if (projectSummary != null) {
            if (this.mergeProjects) {
                projectSummary.setCurrentLayer(this.currentLayer);
            }
            if (projectSummary != null && !projectSummary.isMissing(n - this.currow, n2 - this.COLDESCR - this.METADATA)) {
                return fastDecimal.setValue(projectSummary.getValueAt(n - this.currow, n2 - this.COLDESCR - this.METADATA));
            }
        }
        return fastDecimal.error();
    }

    @Override
    public Properties getEnvProperties() {
        return super.getEnvProperties();
    }

    @Override
    public String getInformation() {
        return "Project Data Source";
    }

    @Override
    public int getLayerCount() {
        return this.layerCount;
    }

    @Override
    public String getLayerName(int n) {
        return String.valueOf(n + 1);
    }

    @Override
    public Properties getMetaProperties() {
        return super.getMetaProperties();
    }

    @Override
    public String getName() {
        return "Project Data Source";
    }

    public String getProjectLink(int n) {
        ProjectSummary projectSummary = this.getProjectSummary(n);
        File file = projectSummary.getFile();
        return file.getAbsolutePath();
    }

    @Override
    public String getReferenceName(int n) {
        return String.valueOf(n + 1);
    }

    @Override
    public FastDecimal getReferenceValue(int n, int n2, int n3, FastDecimal fastDecimal) {
        if (this.mergeProjects) {
            ProjectSummary projectSummary = this.getProjectSummary(n2);
            projectSummary.setCurrentYLayer(n);
            return fastDecimal.setValue(projectSummary.getYValueAt(n2 - this.currow, n3));
        }
        return super.getReferenceValue(n, n2, n3);
    }

    @Override
    public int getReferenceValues() {
        if (this.mergeProjects) {
            return this.yvalues;
        }
        return super.getReferenceValues();
    }

    @Override
    public File getRootFolder() {
        return this.folder;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        ProjectSummary projectSummary = null;
        projectSummary = n == 0 ? this.referenceProject : this.getProjectSummary(n);
        if (projectSummary == null) {
            return "N/A";
        }
        if (n == 0) {
            if (n2 == 0) {
                return "Sample";
            }
            if (n2 == 1) {
                return "Type";
            }
            if (this.showThumbnails && n2 >= 2 && n2 < 2 + this.thumbnailNames.length) {
                return this.thumbnailNames[n2 - 2] + " image";
            }
            if (this.showAverageClass && n2 == 2 + this.thumbnailNames.length) {
                return "Category";
            }
            if (n2 < this.COLDESCR + this.METADATA) {
                return projectSummary.getMetaDescriptionAt(n2 - this.COLDESCR);
            }
            return projectSummary.getColumnDescription(n2 - this.COLDESCR - this.METADATA);
        }
        if (n2 == 0) {
            return projectSummary.toString();
        }
        if (n2 == 1) {
            return projectSummary.getType();
        }
        if (this.showThumbnails && n2 >= 2 && n2 < 2 + this.thumbnailNames.length) {
            return projectSummary.getImageRef(this.thumbnailNames[n2 - 2]);
        }
        if (this.showAverageClass && n2 == 2 + this.thumbnailNames.length) {
            return projectSummary.getRowDescription(n - this.currow);
        }
        if (n2 < this.COLDESCR + this.METADATA) {
            return projectSummary.getMetaAt(n2 - this.COLDESCR);
        }
        if (projectSummary != null) {
            double d;
            int n3 = n2 - this.COLDESCR - this.METADATA;
            if (this.byvariablename) {
                String string = projectSummary.getColumnDescription(n3);
                n3 = projectSummary.getColumnIndexByVariable(string);
            }
            if (n3 >= 0 && !projectSummary.isMissing(n - this.currow, n3) && !Double.isNaN(d = projectSummary.getValueAt(n - this.currow, n3))) {
                return String.valueOf(d);
            }
        }
        return "MV";
    }

    public void initiateDataSet(ProgressManager progressManager, String string) {
        this.dataSetName = string;
        this.mergeProjects = string.equalsIgnoreCase("Sample") || string.equalsIgnoreCase("Original");
        this.representativeSelection = string.equalsIgnoreCase("Representative") || this.mergeProjects || string.endsWith("references");
        this.showThumbnails = !this.representativeSelection;
        this.showAverageClass = string.equalsIgnoreCase("Average");
        if (this.mergeProjects) {
            this.ROWDESCR = 0;
            this.COLDESCR = 0;
        } else {
            this.ROWDESCR = 1;
            this.COLDESCR = 2;
        }
        if (this.showAverageClass) {
            ++this.COLDESCR;
        }
        if (this.showThumbnails) {
            this.COLDESCR += this.thumbnailNames.length;
        }
        this.METADATA = 0;
        this.rows = this.ROWDESCR;
        this.columns = 0;
        this.layerCount = 0;
        this.yvalues = -1;
        int n = 1;
        int n2 = progressManager.setGroupMaximumAndReset(this.projectFileList.size());
        Iterator<ProjectSummary> iterator = this.projectFileList.iterator();
        while (iterator.hasNext()) {
            try {
                progressManager.setInfoText("Initiating dataset " + n + " of " + this.projectFileList.size());
                ProjectSummary projectSummary = iterator.next();
                projectSummary.initiateDataSet(string);
                this.rows += projectSummary.getRows();
                int n3 = projectSummary.getYvalues();
                if (n3 > this.yvalues) {
                    this.yvalues = n3;
                    this.referenceProject = projectSummary;
                }
                if (!this.mergeProjects) {
                    this.METADATA = Math.max(this.METADATA, projectSummary.getMetaCount());
                }
                this.columns = Math.max(this.columns, projectSummary.getColumns() + this.COLDESCR + this.METADATA);
                this.layerCount = projectSummary.getLayers();
            }
            catch (Exception exception) {
                iterator.remove();
                ErrorHandler.logAndReportException(exception);
            }
            ++n;
            progressManager.incStepGroup(n2);
        }
        progressManager.showGroupProgressBar(false);
    }

    @Override
    public boolean isMultiLayer() {
        return this.mergeProjects;
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("files", this.projectFileList.size());
    }

    @Override
    public void setCurrentLayer(int n) {
        this.currentLayer = n;
    }

    public String[] setupProjectStructure(ProgressManager progressManager) {
        int n = 1;
        DataTreeManager dataTreeManager = this.getDataTreeManager();
        int n2 = progressManager.setGroupMaximumAndReset(this.projectFileList.size());
        Iterator<ProjectSummary> iterator = this.projectFileList.iterator();
        while (iterator.hasNext()) {
            block6: {
                progressManager.setInfoText("Loading project " + n + " of " + this.projectFileList.size());
                ProjectSummary projectSummary = iterator.next();
                if (projectSummary != null) {
                    try {
                        Case case_ = projectSummary.readFileFramework(progressManager);
                        if (case_ != null) {
                            case_.setDataTreeManager(dataTreeManager, true);
                            this.addTreeNode(case_);
                            this.names = projectSummary.getNames();
                            break block6;
                        }
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        iterator.remove();
                        ErrorHandler.logAndReportException(exception);
                    }
                } else {
                    System.out.println("Cannot open project summary (null)");
                }
            }
            ++n;
            progressManager.incStepGroup(n2);
        }
        progressManager.showGroupProgressBar(false);
        return this.names;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.projectFileList != null) {
            this.projectFileList.clear();
            this.projectFileList = null;
        }
        this.referenceProject = null;
        this.folder = null;
        this.dataSetName = null;
    }

    private ProjectSummary getProjectSummary(int n) {
        this.currow = this.ROWDESCR;
        for (ProjectSummary projectSummary : this.projectFileList) {
            int n2 = projectSummary.getRows();
            if (n < this.currow + n2) {
                return projectSummary;
            }
            this.currow += n2;
        }
        return null;
    }

    private void loopProjectFiles(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            File[] fileArray2;
            if (!file2.isDirectory()) continue;
            for (File file3 : fileArray2 = file2.listFiles()) {
                String string = jopensaveDialog.getFileName(file3);
                String string2 = jopensaveDialog.getFileExtension(file3);
                if (!string.equals(file2.getName())) {
                    // empty if block
                }
                if (!string2.equalsIgnoreCase("map")) continue;
                this.projectFileList.add(new ProjectSummary(file3));
            }
        }
    }

    private class ProjectSummary {
        private final File file;
        private String name;
        private Case projectCase;
        private AbstractDataMatrix xTr;
        private AbstractDataMatrix yTr;
        private int[] nref;
        private int rows;
        private int columns;
        private int layers;
        private boolean hasmissing;
        private String[][] metaData;
        private String type = "Train";
        private long metatime = 0L;
        private HashMap<String, Integer> varnamesX;
        private HashMap<String, Integer> varnamesY;
        private InnerColumnClass icc = null;

        public ProjectSummary(File file) {
            this.file = file;
            this.name = file.getName();
            int n = this.name.lastIndexOf(".");
            if (n > 0) {
                this.name = this.name.substring(0, n);
            }
        }

        public String getColumnDescription(int n) {
            if (n < this.xTr.getK()) {
                return this.xTr.getColumnDescription(n, 0);
            }
            n -= this.xTr.getK();
            if (this.yTr != null) {
                return this.yTr.getColumnDescription(n, 0);
            }
            if (this.metatime > 0L) {
                return "Time";
            }
            return "N/A";
        }

        public final int getColumnIndexByVariable(String string) {
            Integer n;
            if (this.varnamesX != null && (n = this.varnamesX.get(string)) != null) {
                return n;
            }
            if (this.varnamesY != null && (n = this.varnamesY.get(string)) != null) {
                return n + this.xTr.getK();
            }
            return -1;
        }

        public int getColumns() {
            return this.columns;
        }

        public File getFile() {
            return this.file;
        }

        public String getImageRef(String string) {
            return this.name + IniManager.getFileSeparator() + this.name + "_" + string + ".png";
        }

        public int getLayers() {
            return this.layers;
        }

        public String getMetaAt(int n) {
            if (this.metaData != null && n >= 0 && n < this.metaData.length) {
                return this.metaData[n][1];
            }
            return "N/A";
        }

        public int getMetaCount() {
            if (this.metaData != null) {
                return this.metaData.length;
            }
            return 0;
        }

        public String getMetaDescriptionAt(int n) {
            if (this.metaData != null && n < this.metaData.length) {
                return this.metaData[n][0];
            }
            return "N/A";
        }

        public String[] getNames() {
            DataContainer dataContainer = this.projectCase.getDsContainer();
            String[] stringArray = new String[dataContainer.getTreeNodeCount() + 3];
            int n = dataContainer.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                DataSet dataSet = (DataSet)dataContainer.getTreeNodeAt(i);
                stringArray[i] = dataSet.toString();
            }
            stringArray[n] = "Reference values";
            stringArray[n + 1] = "White references";
            stringArray[n + 2] = "Dark references";
            return stringArray;
        }

        public String getRowDescription(int n) {
            if (this.icc != null) {
                n = this.nref[n];
                short s = this.icc.getValueShort(n);
                return this.icc.getObject().getTypeDescription(s);
            }
            return this.xTr.getRowDescription(n, 0);
        }

        public int getRows() {
            return this.rows;
        }

        public String getType() {
            return this.type;
        }

        public final double getValueAt(int n, int n2) {
            if (ProjectDataSource.this.mergeProjects || n2 < this.xTr.getK()) {
                return this.xTr.getValue(n, n2);
            }
            return this.getYValueAt(n, n2 -= this.xTr.getK());
        }

        public final double getYValueAt(int n, int n2) {
            if (this.yTr != null) {
                if (n2 < this.yTr.getK()) {
                    return this.yTr.getValue(n, n2);
                }
                return Double.NaN;
            }
            return this.metatime - ProjectDataSource.this.minmetatime;
        }

        public int getYvalues() {
            if (this.yTr != null) {
                if (ProjectDataSource.this.mergeProjects) {
                    return this.yTr.getFoldsize();
                }
                return this.yTr.getK();
            }
            if (this.metatime > 0L) {
                return 1;
            }
            return 0;
        }

        public void initiateDataSet(String string) {
            Object object;
            Object object2;
            int n;
            Collection<DataTreeInterface> collection;
            Properties properties = this.projectCase.getMetaProperties();
            if (properties != null) {
                this.metaData = new String[properties.size()][];
                collection = properties.entrySet();
                n = 0;
                for (Map.Entry object3 : collection) {
                    object2 = object3.getKey().toString();
                    object = object3.getValue().toString();
                    this.metaData[n] = new String[]{object2, object};
                    if (((String)object2).equalsIgnoreCase("type")) {
                        this.type = object;
                    } else if (((String)object2).equalsIgnoreCase("time")) {
                        try {
                            this.metatime = Long.parseLong((String)object);
                            if (ProjectDataSource.this.minmetatime > this.metatime) {
                                ProjectDataSource.this.minmetatime = this.metatime;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
            collection = this.projectCase.getDsContainer();
            if (string.endsWith("references") || string.equalsIgnoreCase("Dark references")) {
                this.xTr = string.equalsIgnoreCase("White references") ? (AbstractDataMatrix)this.projectCase.getNodeByName("Reference (100%)") : (AbstractDataMatrix)this.projectCase.getNodeByName("Reference (0%)");
                if (this.xTr != null) {
                    this.rows = this.xTr.getN();
                    this.columns = this.xTr.getK();
                    this.hasmissing = this.xTr.hasMissing();
                    this.layers = 1;
                }
                if (this.metatime > 0L) {
                    ++this.columns;
                }
                this.yTr = null;
            } else {
                this.metatime = 0L;
                for (n = 0; n < ((DataTreeClass)collection).getTreeNodeCount(); ++n) {
                    DataSet dataSet = (DataSet)((DataTreeClass)collection).getTreeNodeAt(n);
                    String string2 = dataSet.toString();
                    if (!string2.equalsIgnoreCase(string)) continue;
                    object2 = dataSet.getObsDataInfo();
                    this.rows = ((AbstractDataInfo)object2).getActiveTrueSize(4);
                    object = dataSet.getVarDataInfo();
                    this.columns = ((AbstractDataInfo)object).getActiveTrueSize(1);
                    this.layers = 1;
                    this.xTr = dataSet.getMatrix(0);
                    this.yTr = dataSet.getMatrix(2);
                    boolean bl = this.hasmissing = this.xTr.hasMissing() || this.yTr.hasMissing();
                    if (string.equalsIgnoreCase("Sample") || string.equalsIgnoreCase("Original")) {
                        this.xTr = new FoldMatrix(this.xTr);
                        this.yTr = new FoldMatrix(this.yTr);
                        this.rows = this.xTr.getN();
                        this.columns = this.xTr.getK();
                        this.layers = this.xTr.getFoldsize();
                    }
                    if (ProjectDataSource.this.byvariablename) {
                        try {
                            this.varnamesX = this.createVarHashMap((String[])this.xTr.list("variablenames"));
                            this.varnamesY = this.createVarHashMap((String[])this.yTr.list("variablenames"));
                        }
                        catch (Exception throwable) {
                            ErrorHandler.logAndReportException(throwable);
                        }
                    }
                    if (ProjectDataSource.this.categoryDescription == null) break;
                    try {
                        this.icc = dataSet.getCategory(ProjectDataSource.this.categoryDescription);
                        this.icc.getParent().beginCalculations();
                        this.nref = this.xTr.getNref();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Name: " + String.valueOf(this));
                        ErrorHandler.logAndReportException(throwable);
                    }
                    break;
                }
            }
        }

        public final boolean isMissing(int n, int n2) {
            if (this.hasmissing) {
                if (ProjectDataSource.this.mergeProjects) {
                    return this.xTr.isMissing(n, n2);
                }
                if (n2 < this.xTr.getK()) {
                    if (this.xTr.hasMissing()) {
                        return this.xTr.isMissing(n, n2);
                    }
                    return false;
                }
                n2 -= this.xTr.getK();
                if (this.yTr.hasMissing()) {
                    return this.yTr.isMissing(n, n2);
                }
            }
            return false;
        }

        public final void setCurrentLayer(int n) {
            ((FoldMatrix)this.xTr).setFold(n);
        }

        public final void setCurrentYLayer(int n) {
            ((FoldMatrix)this.yTr).setFold(n);
        }

        public String toString() {
            return this.name;
        }

        private HashMap<String, Integer> createVarHashMap(String[] stringArray) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], i);
            }
            return hashMap;
        }

        private Case readFileFramework(ProgressManager progressManager) throws Exception {
            RandomInputStream randomInputStream = new RandomInputStream(this.file, progressManager);
            randomInputStream.setDataTreeManager(new DataTreeManager(true));
            try {
                randomInputStream.readFileFramework(true, false);
                DataTreeInterface dataTreeInterface = randomInputStream.resolveRoot();
                if (dataTreeInterface != null) {
                    for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                        if (!(dataTreeInterface.getTreeNodeAt(i) instanceof Case)) continue;
                        this.projectCase = (Case)dataTreeInterface.getTreeNodeAt(i);
                        return this.projectCase;
                    }
                }
            }
            catch (IOException iOException) {
                randomInputStream.close();
            }
            return null;
        }
    }
}

