/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSeparator;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanNoY;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixByte;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public abstract class AbstractDataTransform
extends AbstractTransform<Boolean> {
    protected MVmatrixByte includedMatrix = null;
    protected MVmatrix intermediateMatrix = null;
    private int creationMode = 2;

    public AbstractDataTransform(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public AbstractDataTransform(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.includedMatrix = (MVmatrixByte)mapProperty.resolveNodeFromName(randomInputStream, "iM");
        if (this.includedMatrix != null) {
            this.includedMatrix.setVisibleInTree(false);
        }
        this.intermediateMatrix = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "dM");
    }

    public AbstractDataTransform(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
        if (abstractDataTransform.includedMatrix != null) {
            this.includedMatrix = (MVmatrixByte)abstractDataTransform.includedMatrix.clone();
            this.includedMatrix.setVisibleInTree(false);
            this.addTreeNode(this.includedMatrix);
        }
        if (abstractDataTransform.intermediateMatrix != null) {
            this.intermediateMatrix = (MVmatrix)abstractDataTransform.intermediateMatrix.clone();
            this.addTreeNode(this.intermediateMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractDataMatrix applyTransformation(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl) {
        try {
            abstractDataMatrix.beginCalculations();
            if (bl) {
                this.createIncludedMatrix(abstractDataMatrix);
            }
            Matrix matrix = null;
            if (abstractDataMatrix instanceof AbstractMVmatrix) {
                matrix = ((AbstractMVmatrix)abstractDataMatrix).getInternalMatrixPublic();
            }
            this.createSourceMatrix(abstractDataMatrix);
            this.calculateIntermediateMatrix(progressManager, abstractDataMatrix, bl);
            if (matrix != null || this.hasResultMatrix()) {
                AbstractDataMatrix abstractDataMatrix2 = this.applyTransformationLocal(abstractDataMatrix, matrix, progressManager);
                return abstractDataMatrix2;
            }
            AbstractDataMatrix abstractDataMatrix3 = abstractDataMatrix;
            return abstractDataMatrix3;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
        finally {
            abstractDataMatrix.endCalculations();
        }
        return null;
    }

    @Override
    public AbstractInnerColumn<Boolean> createInnerColumn(String string, Transformations transformations) {
        if (this.appliesToY()) {
            return new InnerColumnBoolean(string, transformations, null, -1);
        }
        return new InnerColumnBooleanNoY(string, transformations, null, -1);
    }

    @Override
    public void fillColumn(boolean bl) {
        if (this.ic instanceof InnerColumnBoolean) {
            ((InnerColumnBoolean)this.ic).fillColumn(bl);
            if (this.dataInfo != null) {
                this.dataInfo.triggerEvent(new DataInfoEvent(this.dataInfo, this.changeEffects(), this));
            }
        }
    }

    @Override
    public byte getColumnType(int n) {
        return 12;
    }

    @Override
    public byte[] getIncludedData() {
        if (this.includedMatrix != null) {
            return this.includedMatrix.getByteMatrix().getByteData();
        }
        return null;
    }

    @Override
    public double[] getIntermediateData() {
        if (this.intermediateMatrix != null) {
            return this.intermediateMatrix.getDoubleMatrix().getData();
        }
        return null;
    }

    public MVmatrix getIntermediateMatrix() {
        return this.intermediateMatrix;
    }

    @Override
    public int getOriginatingRow(int n) {
        int n2 = 0;
        int n3 = this.getColumnSize();
        for (int i = 0; i < n3; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public byte getRowType(int n) {
        return 12;
    }

    public boolean hasUserdefinedValues() {
        InnerColumnBoolean innerColumnBoolean = this.getIncludedNull();
        if (innerColumnBoolean != null) {
            return true;
        }
        if (this.includedMatrix != null) {
            for (int i = 0; i < this.includedMatrix.getN(); ++i) {
                for (int j = 0; j < this.includedMatrix.getK(); ++j) {
                    if (this.includedMatrix.getValue(i, j) != 0.0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void includeFromScript(Object[] objectArray) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        boolean bl = innerColumnBoolean.getDefaultValue();
        innerColumnBoolean.setDefaultValue(false);
        this.setIncluded(objectArray, true);
        innerColumnBoolean.setDefaultValue(bl);
    }

    public void initInnerColumnValue(int n) {
        if (n >= 0 && n < this.ic.getSize()) {
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
            if (innerColumnBoolean.getValueBool(n)) {
                return;
            }
            innerColumnBoolean.setValue(n, this.defaultValue());
        }
    }

    public boolean isIncluded(int n) {
        return this.ic == null || ((InnerColumnBoolean)this.ic).getValueBool(n);
    }

    @Override
    public boolean isTransformationEnabled() {
        if (this.ic == null) {
            if (this.includedMatrix != null) {
                for (int i = 0; i < this.includedMatrix.getN(); ++i) {
                    for (int j = 0; j < this.includedMatrix.getK(); ++j) {
                        if (!(this.includedMatrix.getValue(i, j) > 0.0)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        int n = this.ic.getSize();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        for (int i = 0; i < n; ++i) {
            if (!innerColumnBoolean.getValueBool(i)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseTransformation(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        try {
            abstractDataMatrix.beginCalculations();
            Matrix matrix = null;
            if (abstractDataMatrix instanceof AbstractMVmatrix) {
                matrix = ((AbstractMVmatrix)abstractDataMatrix).getInternalMatrixPublic();
            }
            this.reverseTransformationLocal(abstractDataMatrix, matrix, bl);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
        finally {
            abstractDataMatrix.endCalculations();
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("iM", this.includedMatrix);
        randomOutputStream.writePropertyNode("dM", this.intermediateMatrix);
    }

    public void setAll(boolean bl) {
        int n = this.ic.getSize();
        for (int i = 0; i < n; ++i) {
            this.ic.setValue(i, bl);
        }
    }

    public void setByIncluded(boolean bl) {
        InnerColumnBoolean innerColumnBoolean;
        InnerColumnBoolean innerColumnBoolean2 = null;
        if (this.dataInfo instanceof ObservationInfo) {
            innerColumnBoolean = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(4);
            innerColumnBoolean2 = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(1);
        } else {
            innerColumnBoolean = (InnerColumnBoolean)this.dataInfo.getPrimaryColumnByType(1);
        }
        if (innerColumnBoolean != null) {
            int n = innerColumnBoolean.getSize();
            AbstractInnerColumn abstractInnerColumn = this.ic;
            if (abstractInnerColumn instanceof InnerColumnBoolean) {
                InnerColumnBoolean innerColumnBoolean3 = (InnerColumnBoolean)abstractInnerColumn;
                if (innerColumnBoolean2 != null) {
                    for (int i = 0; i < n; ++i) {
                        if (innerColumnBoolean.getValueBool(i) != bl || innerColumnBoolean2.getValueBool(i) != bl) continue;
                        innerColumnBoolean3.setValueBool(i, true);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (innerColumnBoolean.getValueBool(i) != bl) continue;
                        innerColumnBoolean3.setValueBool(i, true);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (innerColumnBoolean.getValueBool(i) != bl) continue;
                    this.ic.setValue(i, true);
                }
            }
            if (this.isCreated) {
                this.triggerEvent();
            }
        }
    }

    public void setBySelection(boolean bl) {
        InteractionArray interactionArray = this.getInteractionArray(this.isObs ? 1 : 2);
        if (interactionArray != null) {
            int n = Math.min(interactionArray.size(), this.ic.getSize());
            for (int i = 0; i < n; ++i) {
                if (!interactionArray.get(i)) continue;
                this.ic.setValue(i, bl);
            }
            if (this.isCreated) {
                this.triggerEvent();
            }
        }
    }

    @Override
    public boolean setCreated(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo) {
        if (!super.setCreated(project_GUI, abstractDataInfo)) {
            return false;
        }
        this.isCreated = false;
        switch (this.creationMode) {
            case 0: {
                this.setBySelection(true);
                break;
            }
            case 3: {
                this.setByIncluded(true);
                break;
            }
            case 1: {
                this.setAll(true);
                break;
            }
        }
        this.isCreated = true;
        return true;
    }

    public void setCreationMode(int n) {
        this.creationMode = n;
    }

    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        return d;
    }

    public void triggerEvent() {
        this.triggerEvent(this.changeEffects());
    }

    public void triggerEvent(byte by) {
        this.dataInfo.triggerEvent(new DataInfoEvent(this.dataInfo, by, this));
    }

    @Override
    protected boolean addToPopup(DataTreeInterface dataTreeInterface, CMenu cMenu) {
        cMenu.add(new CMenuItem("Include", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDataTransform.this.setBySelection(true);
            }
        });
        cMenu.add(new CMenuItem("Exclude", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDataTransform.this.setBySelection(false);
            }
        });
        super.addToPopup(dataTreeInterface, cMenu);
        return true;
    }

    protected abstract AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix var1, Matrix var2, ProgressManager var3) throws Exception;

    protected void calculateIntermediateMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
    }

    protected abstract byte changeEffects();

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.includedMatrix != null) {
            this.includedMatrix.cleanUp();
            this.includedMatrix = null;
        }
        if (this.intermediateMatrix != null) {
            this.intermediateMatrix.cleanUp();
            this.intermediateMatrix = null;
        }
    }

    protected void createIntermediateMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.createIntermediateMatrix(abstractDataMatrix, null);
    }

    protected void createIntermediateMatrix(AbstractDataMatrix abstractDataMatrix, String string) {
        this.createIntermediateMatrix(abstractDataMatrix, string, this.isObs);
    }

    protected void createIntermediateMatrix(AbstractDataMatrix abstractDataMatrix, String string, boolean bl) {
        if (this.intermediateMatrix != null) {
            this.removeTreeNode(this.intermediateMatrix);
            this.intermediateMatrix.cleanUp();
        }
        this.intermediateMatrix = new MVmatrix(bl ? abstractDataMatrix.getN() : abstractDataMatrix.getK(), 1, String.valueOf(this) + " interm");
        if (string != null) {
            this.intermediateMatrix.setName(string);
        } else {
            this.intermediateMatrix.setName(String.valueOf(abstractDataMatrix) + "." + this.getName());
        }
        this.intermediateMatrix.setMatrixDataSetContainer(abstractDataMatrix.getCase());
        this.intermediateMatrix.setRowDescription(abstractDataMatrix.getColumnDescription());
        if (bl) {
            this.intermediateMatrix.setRowType(16);
            this.intermediateMatrix.setColumnType(1);
        } else {
            this.intermediateMatrix.setRowType(2);
            this.intermediateMatrix.setColumnType(16);
        }
        this.intermediateMatrix.setColumnDescription(null);
        this.addTreeNode(this.intermediateMatrix);
    }

    protected void createSourceMatrix(AbstractDataMatrix abstractDataMatrix) {
    }

    protected boolean defaultValue() {
        return false;
    }

    protected boolean[] generateIncludeArray() {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        if (innerColumnBoolean != null && innerColumnBoolean.hasUserdefinedValues()) {
            boolean[] blArray = new boolean[innerColumnBoolean.getSize()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = innerColumnBoolean.getValueBool(i);
            }
        }
        return null;
    }

    protected int[] generateReferenceArray() {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        int n = 0;
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i)) continue;
            nArray[n2++] = i;
        }
        return nArray;
    }

    protected InnerColumnBoolean getIncludedNull() {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        if (innerColumnBoolean != null && innerColumnBoolean.hasUserdefinedValues()) {
            return innerColumnBoolean;
        }
        return null;
    }

    protected boolean hasResultMatrix() {
        return this.results != null;
    }

    @Override
    protected void initiateGUILocal() {
        final JButton jButton = new JButton("Include selected");
        CMenuItem cMenuItem = new CMenuItem(this, true){
            final /* synthetic */ AbstractDataTransform this$0;
            {
                this.this$0 = abstractDataTransform;
                super(bl);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setBySelection(actionEvent.getSource() == jButton);
            }
        };
        jButton.addActionListener(cMenuItem);
        jButton.setIcon(new ImageIcon(DataSetTable.class.getResource("images/check.gif")));
        JButton jButton2 = new JButton("Exclude selected");
        jButton2.addActionListener(cMenuItem);
        JButton jButton3 = new JButton("Delete modification", new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        jButton3.addActionListener(actionEvent -> this.deleteModification());
        this.mainPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        this.mainPanel.add((Component)jButton2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        this.mainPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        this.mainPanel.add((Component)jButton3, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
    }

    protected boolean isIncluded(int[] nArray, int n) {
        if (nArray == null) {
            return this.isIncluded(n);
        }
        return this.isIncluded(nArray[n]);
    }

    protected void reverseTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, boolean bl) throws Exception {
    }

    protected void setIcDefault(boolean bl) {
        ((InnerColumnBoolean)this.ic).setDefaultValue(bl);
    }

    protected void setIncluded(int n, boolean bl) {
        ((InnerColumnBoolean)this.ic).setValueBool(n, bl);
    }

    private void createIncludedMatrix(AbstractDataMatrix abstractDataMatrix) {
        if (this.includedMatrix != null) {
            this.removeTreeNode(this.includedMatrix);
            this.includedMatrix.cleanUp();
        }
        this.includedMatrix = new MVmatrixByte(this.isObs ? abstractDataMatrix.getN() : abstractDataMatrix.getK(), 1, true);
        this.includedMatrix.setName(String.valueOf(abstractDataMatrix) + "_included_" + this.getName());
        this.includedMatrix.setMatrixDataSetContainer(abstractDataMatrix.getCase());
        this.includedMatrix.setRowDescription(abstractDataMatrix.getColumnDescription());
        this.includedMatrix.setColumnDescription(null);
        this.includedMatrix.setVisibleInTree(false);
        this.addTreeNode(this.includedMatrix);
        byte[] byArray = this.includedMatrix.getByteMatrix().getByteData();
        InnerColumnBoolean innerColumnBoolean = this.getIncludedNull();
        if (innerColumnBoolean == null) {
            Arrays.fill(byArray, (byte)1);
        } else {
            int[] nArray = null;
            nArray = this.isObs ? abstractDataMatrix.getNref() : abstractDataMatrix.getKref();
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.isIncluded(nArray, i) ? (byte)1 : 0;
            }
        }
    }

    private void setIncluded(Object[] objectArray, boolean bl) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (Double.isInfinite((Double)objectArray[i])) {
                for (i = n; i < innerColumnBoolean.getSize(); ++i) {
                    innerColumnBoolean.setValueBool(i, bl);
                }
                break;
            }
            n = ((Double)objectArray[i]).intValue() - 1;
            innerColumnBoolean.setValueBool(n, bl);
        }
    }
}

