/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.BasicMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.history.HistoryInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayer;

public abstract class AbstractTransform<type>
extends AbstractLayer
implements InteractionInterface,
HistoryInterface,
BasicMatrixInterface {
    private static ImageIcon transformIcon = AbstractPaint.createIcon(2);
    private static Font menuFont = null;
    protected AbstractInnerColumn<type> ic = null;
    protected JPanel mainPanel;
    protected boolean isObs;
    protected AbstractDataInfo dataInfo;
    private Project_GUI project;
    private Transformations icParent = null;
    private long duration;
    private final long timestamp;
    private final String username;
    protected MVmatrix results;

    public AbstractTransform(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(0);
        this.dataInfo = abstractDataInfo;
        this.isObs = bl;
        this.setLayerName(this.getTitleName());
        this.icParent = abstractDataInfo.getTransformationNode();
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
    }

    public AbstractTransform(AbstractDataInfo abstractDataInfo, boolean bl, String string) {
        super(0);
        this.dataInfo = abstractDataInfo;
        this.isObs = bl;
        this.setLayerName(string);
        this.icParent = abstractDataInfo.getTransformationNode();
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
    }

    public AbstractTransform(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("col")) {
            this.isObs = mapProperty.getLVBoolean();
        }
        this.dataInfo = (AbstractDataInfo)mapProperty.resolveNodeFromName(randomInputStream, "dInfo");
        this.icParent = (Transformations)mapProperty.resolveNodeFromName(randomInputStream, "icp");
        this.duration = mapProperty.getPropertyLong("dur");
        this.timestamp = mapProperty.getPropertyLong("ts");
        this.username = mapProperty.getPropertyStringUTF("un");
        this.results = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "res");
    }

    public AbstractTransform(Transformations transformations, AbstractTransform<type> abstractTransform) {
        super(0);
        this.dataInfo = abstractTransform.dataInfo;
        this.project = abstractTransform.project;
        this.isObs = abstractTransform.isObs;
        this.setLayerName(abstractTransform.layerName);
        this.setLayerVisible(abstractTransform.isLayerVisible());
        this.ic = abstractTransform.ic == null ? null : abstractTransform.ic.clone(transformations);
        this.icParent = transformations;
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
        if (abstractTransform.results != null) {
            Description description;
            this.results = (MVmatrix)abstractTransform.results.clone();
            if (abstractTransform.results.getRowDescription() != null) {
                description = (Description)abstractTransform.results.getRowDescription().cloneThis(null);
                this.results.addTreeNode(description);
                this.results.setRowDescription(description);
            }
            if (abstractTransform.results.getColumnDescription() != null) {
                description = (Description)abstractTransform.results.getColumnDescription().cloneThis(null);
                this.results.addTreeNode(description);
                this.results.setColumnDescription(description);
            }
            this.results.setVisibleInTree(false);
            this.addTreeNode(this.results);
        }
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        CMenu cMenu = new CMenu(this.toString(), false);
        if (menuFont == null) {
            menuFont = cMenu.getFont().deriveFont(2 | cMenu.getFont().getStyle());
        }
        cMenu.setFont(menuFont);
        if (this.addToPopup(dataTreeInterface, cMenu)) {
            cMenu.setIcon(AbstractPaint.createIcon(2));
            jPopupMenu.add(cMenu);
        }
        return true;
    }

    public boolean appliesToY() {
        return true;
    }

    public AbstractDataMatrix applyTransformation(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager) {
        if (progressManager != null) {
            progressManager.setInfoText("Applying transformation (" + this.getTitleName() + ")");
        }
        return this.applyTransformation(abstractDataMatrix, progressManager, true);
    }

    public abstract AbstractDataMatrix applyTransformation(AbstractDataMatrix var1, ProgressManager var2, boolean var3);

    @Override
    public void beginCalculations() {
        super.beginCalculations();
        if (this.results != null) {
            this.results.beginCalculations();
        }
    }

    public AbstractTransform<type> cloneThis() {
        DataGroupValues dataGroupValues;
        DataGroupValues dataGroupValues2 = dataGroupValues = this.ic == null ? null : this.ic.getParent();
        if (dataGroupValues instanceof Transformations) {
            return this.cloneThis((Transformations)dataGroupValues);
        }
        return this.cloneThis(this.icParent);
    }

    public abstract AbstractTransform<type> cloneThis(Transformations var1);

    public abstract AbstractInnerColumn<type> createInnerColumn(String var1, Transformations var2);

    public void delete() {
        DataSet dataSet = this.dataInfo.getDataSet();
        this.remove();
        dataSet.setTransformationResults();
    }

    public void deleteModification() {
        int n = JOptionPane.showConfirmDialog(null, "Are you really sure you want to delete\nthis modification (" + String.valueOf(this) + ")?", "Confirm delete", 0, 3, null);
        if (n == 0 && !this.remove()) {
            JOptionPane.showMessageDialog(null, "This transformation is currently being used by one or more models", "Delete failed", 2);
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    @Override
    public void endCalculations() {
        super.endCalculations();
        if (this.results != null) {
            this.results.endCalculations();
        }
    }

    public void fillColumn(boolean bl) {
    }

    @Override
    public void finishInteraction() {
    }

    public Object get(String string) {
        if (string.equalsIgnoreCase("column")) {
            return this.getInnerColumn();
        }
        if (string.equalsIgnoreCase("name")) {
            return this.layerName;
        }
        return null;
    }

    public int getColumnCount() {
        if (this.results == null) {
            return 0;
        }
        return this.results.getK();
    }

    @Override
    public Description getColumnDescription() {
        if (this.results != null) {
            return this.results.getColumnDescription();
        }
        return null;
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        return this.results.getColumnDescription(n, n2);
    }

    public AbstractDataInfo getDataInfo() {
        return this.dataInfo;
    }

    @Override
    public String getDescription() {
        return "Transformation";
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public List getHistory() {
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return transformIcon;
    }

    public byte[] getIncludedData() {
        return null;
    }

    @Override
    public String getInformation() {
        if (this.ic == null) {
            return super.getInformation();
        }
        return super.getInformation() + "<tr><td>Rows:</td><td>" + this.ic.getSize() + "</td></tr>";
    }

    public AbstractInnerColumn getInnerColumn() {
        return this.ic;
    }

    public AbstractInnerColumn<type> getInnerColumn(Transformations transformations) {
        int n = transformations.getRows();
        if (this.ic == null) {
            this.ic = this.createInnerColumn(this.toString(), transformations);
            this.setIcDefault();
        } else {
            if (this.ic.getSize() != n) {
                this.ic.setSize(n);
            }
            if (this.ic.getParent() != transformations) {
                this.ic.setParent(transformations);
            }
        }
        return this.ic;
    }

    public InteractionArray getInteractionArray(int n) {
        if (this.project != null && n == 1 == this.isObs) {
            return this.project.getInteractionArray(n, this.dataInfo.getGroupID());
        }
        return null;
    }

    public double[] getIntermediateData() {
        return null;
    }

    @Override
    public int getK() {
        return this.getColumnCount();
    }

    @Override
    public int getMissingCountForColumn(int n) {
        if (this.results == null) {
            return 0;
        }
        return this.results.getMissingCountForColumn(n);
    }

    @Override
    public int getMissingCountForRow(int n) {
        if (this.results == null) {
            return 0;
        }
        return this.results.getMissingCountForRow(n);
    }

    @Override
    public int getN() {
        return this.getRowCount();
    }

    @Override
    public abstract String getName();

    @Override
    public byte getNodeType() {
        return 7;
    }

    public String[] getObsDescriptionArray() {
        if (this.results == null) {
            return null;
        }
        Description description = this.results.getRowDescription();
        if (description != null && description.getPrimaryColumn() != null) {
            return ((InnerColumnString)description.getPrimaryColumn()).getArray();
        }
        return null;
    }

    public int getOriginatingRow(int n) {
        return n;
    }

    public int getPriority() {
        return 100;
    }

    public MVmatrix getResults() {
        return this.results;
    }

    public int getRowCount() {
        if (this.results == null) {
            return 0;
        }
        return this.results.getN();
    }

    @Override
    public Description getRowDescription() {
        if (this.results != null) {
            return this.results.getRowDescription();
        }
        return null;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        return this.results.getRowDescription(n, n2);
    }

    @Override
    public String getScript() {
        return null;
    }

    public abstract String getShortName();

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTitleName() {
        return this.getName();
    }

    public abstract Type getTransformationType();

    @Override
    public String getUsername() {
        return this.username;
    }

    public double getValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        return this.getValue(n, n2);
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.results == null) {
            return 0.0;
        }
        return this.results.getValue(n, n2);
    }

    public String[] getVarDescriptionArray() {
        if (this.results == null) {
            return null;
        }
        Description description = this.results.getColumnDescription();
        if (description != null && description.getPrimaryColumn() != null) {
            return ((InnerColumnString)description.getPrimaryColumn()).getArray();
        }
        return null;
    }

    @Override
    public final boolean hasMissing() {
        if (this.results == null) {
            return false;
        }
        return this.results.hasMissing();
    }

    @Override
    public void removeMissing(int n, int n2) {
        if (this.results != null) {
            this.results.removeMissing(n, n2);
        }
    }

    @Override
    public void initiateGUI() {
        if (this.mainPanel == null) {
            this.setLayout(new BorderLayout());
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(EvinceBorderFactory.createEvinceBorder(this.getTitleName()));
            this.add((Component)this.mainPanel, "Center");
            this.initiateGUILocal();
        }
    }

    @Override
    public boolean isLayerReady() {
        return this.isCreated;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (this.results == null) {
            return false;
        }
        return this.results.isMissing(n, n2);
    }

    public boolean isObservation() {
        return this.isObs;
    }

    public boolean isScale() {
        return false;
    }

    public boolean isTransformationEnabled() {
        return true;
    }

    @Override
    public boolean isVisibleInTree() {
        return true;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
        randomInputStream.beginDataBlock("Loading transformations into memory", false);
        int n = randomInputStream.ReadBlockInt();
        if (n > 0) {
            this.icParent = this.getIcParent();
            if (this.icParent != null) {
                this.ic = this.createInnerColumn(null, this.icParent);
                this.ic.Load(randomInputStream, this.icParent.getSaveVersion());
                this.setIcDefault();
            }
        }
        this.loadDataLocal(randomInputStream);
        randomInputStream.endDataBlock();
    }

    @Override
    public void prepareInteraction() {
    }

    public boolean remove() {
        AbstractDataInfo abstractDataInfo = this.dataInfo;
        this.cleanUp();
        DataInfoEvent dataInfoEvent = new DataInfoEvent(abstractDataInfo, 1, this);
        if (abstractDataInfo != null) {
            if (this.getTransformationType() == Type.globalAdd) {
                abstractDataInfo.triggerGlobalEvent(dataInfoEvent);
            } else {
                abstractDataInfo.triggerEvent(dataInfoEvent);
            }
        }
        return true;
    }

    public void renameModification() {
        String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for the modification", this.toString());
        if (string != null) {
            this.setName(string);
        }
    }

    public abstract void reverseTransformation(AbstractDataMatrix var1, boolean var2);

    @Override
    public void SaveData(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginDataBlock();
        if (this.ic == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            int n = this.ic.getSize();
            randomOutputStream.WriteBlockInt(n);
            this.ic.Save(randomOutputStream, this.getSaveVersion());
        }
        this.saveDataLocal(randomOutputStream);
        randomOutputStream.endDataBlock();
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyBoolean("col", this.isObs);
        randomOutputStream.writePropertyNode("dInfo", this.dataInfo);
        randomOutputStream.writePropertyNode("icp", this.icParent);
        randomOutputStream.writePropertyLong("ts", this.timestamp);
        randomOutputStream.writePropertyStringUTF("un", this.username);
        randomOutputStream.writePropertyLong("dur", this.duration);
        randomOutputStream.writePropertyNode("res", this.results);
    }

    public double scaleValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, double d) {
        return d;
    }

    public void set(Object[] objectArray) {
    }

    public boolean setCreated(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo) {
        if (this.isCleaned()) {
            return false;
        }
        if (!this.isCreated) {
            this.isCreated = true;
            this.project = project_GUI;
            if (abstractDataInfo != null) {
                this.dataInfo = abstractDataInfo;
            }
            this.getInnerColumn(this.dataInfo.getTransformationNode());
        }
        return true;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.setEnabled(this.getComponent(i), bl);
        }
    }

    public void setExtraArgument(Properties properties) {
        if (properties != null && properties.size() > 0) {
            throw new RuntimeException("Properties is not supported");
        }
    }

    public void setInnerColumn(AbstractInnerColumn abstractInnerColumn) {
        this.ic = abstractInnerColumn;
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    @Override
    public void setLayerName(String string) {
        super.setLayerName(string);
        if (this.ic != null) {
            this.ic.setName(string);
            if (this.isCreated) {
                DataInfoEvent dataInfoEvent = new DataInfoEvent(this.dataInfo, 3, this);
                if (this.getTransformationType() == Type.globalAdd) {
                    this.dataInfo.triggerGlobalEvent(dataInfoEvent);
                } else {
                    this.dataInfo.triggerEvent(dataInfoEvent);
                }
            }
        }
    }

    @Override
    public void setName(String string) {
        this.setLayerName(string);
        if (this.mainPanel != null) {
            this.mainPanel.setBorder(EvinceBorderFactory.createEvinceBorder(this.getTitleName()));
        }
        if (this.project != null) {
            this.project.renameSignal();
        }
    }

    @Override
    public void setValue(int n, int n2, double d) {
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
    }

    public String setWorkflow(StringBuffer stringBuffer, String string, boolean bl) {
        return null;
    }

    public void workDone(ProgressManager progressManager) {
    }

    protected boolean addToPopup(DataTreeInterface dataTreeInterface, CMenu cMenu) {
        cMenu.addSeparator();
        cMenu.add(new CMenuItem("Delete modification", new ImageIcon(Main_GUI.class.getResource("gif/delete.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTransform.this.deleteModification();
            }
        });
        if (!(this instanceof AbstractDataTransform)) {
            cMenu.add(new CMenuItem("Rename modification", new ImageIcon(Main_GUI.class.getResource("gif/rename.png"))){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractTransform.this.renameModification();
                }
            });
        }
        return true;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.ic != null) {
            this.ic.cleanUp();
            this.ic = null;
        }
        if (this.results != null) {
            this.results.cleanUp();
            this.results = null;
        }
        this.dataInfo = null;
        this.project = null;
        this.results = null;
        this.icParent = null;
        this.isCreated = true;
    }

    protected void createResults(int n, int n2) {
        if (this.results == null) {
            this.results = new MVmatrix(n, n2, this.toString());
            this.results.setVisibleInTree(false);
            this.addTreeNode(this.results);
        } else {
            this.results.resize(n, n2);
        }
    }

    protected int getColumnSize() {
        if (this.ic == null) {
            return 0;
        }
        return this.ic.getSize();
    }

    protected Transformations getIcParent() {
        if (this.icParent == null && this.getTreeParent().getTreeParent() instanceof DataGroupValues) {
            return (Transformations)this.getTreeParent().getTreeParent();
        }
        return this.icParent;
    }

    protected Project_GUI getProject() {
        return this.project;
    }

    protected int getSaveVersion() {
        Transformations transformations = this.getIcParent();
        if (transformations != null) {
            return transformations.getSaveVersion();
        }
        return 3;
    }

    protected String getWorkflowName() {
        return "N/A";
    }

    protected String getWorkflowTransformName() {
        return "N/A";
    }

    protected void initiateGUILocal() {
    }

    protected void loadDataLocal(RandomInputStream randomInputStream) throws IOException {
    }

    protected void saveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    protected void setIcDefault() {
    }

    protected void setObsDescription(AbstractDataMatrix abstractDataMatrix, String[] stringArray) {
        abstractDataMatrix.setRowDescription(this.createDescription(abstractDataMatrix, stringArray));
    }

    protected void setVarDescription(AbstractDataMatrix abstractDataMatrix, String[] stringArray) {
        abstractDataMatrix.setColumnDescription(this.createDescription(abstractDataMatrix, stringArray));
    }

    private Description createDescription(AbstractDataMatrix abstractDataMatrix, String[] stringArray) {
        int n = stringArray.length;
        Description description = new Description(n);
        InnerColumnString innerColumnString = description.addStringColumn(this.toString());
        description.addColumn(innerColumnString);
        for (int i = 0; i < n; ++i) {
            description.addValue(innerColumnString, i, stringArray[i], false);
        }
        abstractDataMatrix.addTreeNode(description);
        return description;
    }

    private void setEnabled(Component component, boolean bl) {
        if (component.isEnabled() == bl) {
            return;
        }
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.setEnabled(container.getComponent(i), bl);
            }
        }
    }

    public Properties getProperties() {
        return null;
    }

    public static enum Type {
        localAdd,
        globalAdd,
        localUpdate;

    }
}

