/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataGroupListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.BasicMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;

public class TransformMatrix
extends ReferenceMatrix
implements DataGroupListener {
    private boolean hasMatrixChildren = false;
    private Description obsDesc = null;
    private Description varDesc = null;

    public TransformMatrix(AbstractDataMatrix abstractDataMatrix) {
        super(abstractDataMatrix);
        DataContainer dataContainer = new DataContainer("Rows", 6);
        dataContainer.setVisibleInTree(true);
        this.addTreeNode(dataContainer);
        DataContainer dataContainer2 = new DataContainer("Columns", 6);
        dataContainer2.setVisibleInTree(true);
        this.addTreeNode(dataContainer2);
    }

    public TransformMatrix(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public final void addToMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        if (bl) {
            this.getExtraColumns().addTreeNode(abstractDataMatrix);
            this.varDescriptionUpdated();
        } else {
            this.getExtraRows().addTreeNode(abstractDataMatrix);
            this.obsDescriptionUpdated();
        }
        this.updateReferences(true);
    }

    public final boolean addToMatrix(AbstractTransform abstractTransform, boolean bl) {
        DataContainer dataContainer;
        if (bl) {
            dataContainer = this.getExtraColumns();
            this.varDescriptionUpdated();
        } else {
            dataContainer = this.getExtraRows();
            this.obsDescriptionUpdated();
        }
        if (!dataContainer.hasChild(abstractTransform)) {
            dataContainer.addShortcut(abstractTransform);
            this.updateReferences(true);
            return true;
        }
        return false;
    }

    @Override
    public final void beginCalculations() {
        super.beginCalculations();
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            ((BasicMatrixInterface)((Object)dataTreeInterface)).beginCalculations();
        }
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            ((BasicMatrixInterface)((Object)dataTreeInterface)).beginCalculations();
        }
    }

    @Override
    public final Object clone() {
        AbstractDataMatrix abstractDataMatrix;
        TransformMatrix transformMatrix = new TransformMatrix(this.referenceMatrix);
        transformMatrix.setName(this.toString());
        transformMatrix.setVisibleInTree(this.isVisibleInTree());
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (dataTreeInterface instanceof AbstractTransform) {
                transformMatrix.addToMatrix((AbstractTransform)dataTreeInterface, true);
                continue;
            }
            if (!(dataTreeInterface instanceof AbstractDataMatrix)) continue;
            abstractDataMatrix = (AbstractDataMatrix)((AbstractDataMatrix)dataTreeInterface).clone();
            transformMatrix.addToMatrix(abstractDataMatrix, true);
        }
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (dataTreeInterface instanceof AbstractTransform) {
                transformMatrix.addToMatrix((AbstractTransform)dataTreeInterface, false);
                continue;
            }
            if (!(dataTreeInterface instanceof AbstractDataMatrix)) continue;
            abstractDataMatrix = (AbstractDataMatrix)((AbstractDataMatrix)dataTreeInterface).clone();
            transformMatrix.addToMatrix(abstractDataMatrix, false);
        }
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractTransform)) continue;
            transformMatrix.addTransformation((AbstractTransform)this.getTreeNodeAt(i));
        }
        return transformMatrix;
    }

    @Override
    public final void dataGroupChanged(AbstractInnerColumn abstractInnerColumn, byte by) {
        this.varDescriptionUpdated();
        this.obsDescriptionUpdated();
    }

    @Override
    public final void endCalculations() {
        super.endCalculations();
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            ((BasicMatrixInterface)((Object)dataTreeInterface)).endCalculations();
        }
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            ((BasicMatrixInterface)((Object)dataTreeInterface)).endCalculations();
        }
    }

    @Override
    public final Description getColumnDescription() {
        int n;
        if (this.varDesc != null && this.varDesc.getColumnCount() > 0 && this.varDesc.getInnerColumn(0) != null) {
            return this.varDesc;
        }
        DataSet dataSet = (DataSet)this.getTreeParent();
        if (this.referenceMatrix == null || dataSet == null) {
            return null;
        }
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        Description description = (Description)variablesInfo.getGroupColumnByType(0);
        this.updateReferences(true);
        this.varDesc = new Description(this.K);
        description.addListener(this);
        int n2 = this.referenceMatrix.getK();
        int n3 = description.getColumnCount();
        for (n = 0; n < n3; ++n) {
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n);
            BasicTreeInterface basicTreeInterface = (InnerColumnString)this.varDesc.addColumn(innerColumnString.toString());
            for (int i = 0; i < n2; ++i) {
                this.varDesc.addValue((InnerColumnString)basicTreeInterface, i, innerColumnString.getValueLocal(i), true);
            }
        }
        n = n2;
        for (BasicTreeInterface basicTreeInterface : this.getExtraColumns()) {
            String[] stringArray = null;
            if (basicTreeInterface instanceof AbstractDataMatrix) {
                Description description2 = ((AbstractDataMatrix)basicTreeInterface).getColumnDescription();
                stringArray = ((InnerColumnString)description2.getPrimaryColumn()).getArray();
            } else {
                if (!(basicTreeInterface instanceof AbstractTransform)) continue;
                stringArray = ((AbstractTransform)basicTreeInterface).getVarDescriptionArray();
            }
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length && n < this.K; ++i) {
                this.varDesc.addValue((InnerColumnString)this.varDesc.getPrimaryColumn(), n++, stringArray[i], true);
            }
        }
        return this.varDesc;
    }

    @Override
    public final String getColumnDescription(int n, int n2) {
        if (this.referenceMatrix == null || this.isCleaned() || n < 0 || n2 < 0) {
            return "";
        }
        int n3 = this.referenceMatrix.getK();
        if (n < n3) {
            DataSet dataSet = (DataSet)this.getTreeParent();
            VariablesInfo variablesInfo = dataSet.getVarDataInfo();
            Description description = (Description)variablesInfo.getGroupColumnByType(0);
            if (description == null) {
                return "";
            }
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n2);
            return innerColumnString.getValueLocal(n);
        }
        n -= n3;
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getK()) {
                return basicMatrixInterface.getColumnDescription(n, n2);
            }
            n -= basicMatrixInterface.getK();
        }
        return "";
    }

    public final BasicMatrixInterface getColumnMatrixAt(int n) {
        if (this.referenceMatrix != null) {
            int n2 = this.referenceMatrix.getK();
            if (n < n2) {
                return null;
            }
            n -= n2;
            for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (n < basicMatrixInterface.getK()) {
                    return basicMatrixInterface;
                }
                n -= basicMatrixInterface.getK();
            }
        }
        return null;
    }

    @Override
    public final byte getColumnType(int n) {
        if (this.referenceMatrix == null) {
            return 4;
        }
        int n2 = this.referenceMatrix.getK();
        if (n < n2) {
            return this.referenceMatrix.getColumnType(n);
        }
        n -= n2;
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getK()) {
                return basicMatrixInterface.getColumnType(n);
            }
            n -= basicMatrixInterface.getK();
        }
        return 12;
    }

    public final int[] getIndecies(int n, String string) {
        int n2 = this.referenceMatrix.getK();
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            String[] stringArray = null;
            if (dataTreeInterface instanceof AbstractDataMatrix) {
                Description description = ((AbstractDataMatrix)dataTreeInterface).getColumnDescription();
                stringArray = ((InnerColumnString)description.getPrimaryColumn()).getArray();
            } else {
                if (!(dataTreeInterface instanceof AbstractTransform)) continue;
                AbstractTransform abstractTransform = (AbstractTransform)dataTreeInterface;
                stringArray = abstractTransform.getVarDescriptionArray();
                if (abstractTransform.getTreeType() == n && abstractTransform.getName().equalsIgnoreCase(string)) {
                    return new int[]{n2, n2 + (stringArray != null ? stringArray.length : 0)};
                }
            }
            if (stringArray == null) continue;
            n2 += stringArray.length;
        }
        return null;
    }

    public final int[] getIndexForTransformation(boolean bl, AbstractTransform abstractTransform) {
        if (bl) {
            int n = this.referenceMatrix.getN();
            for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (basicMatrixInterface.equals(abstractTransform)) {
                    int[] nArray = new int[basicMatrixInterface.getN()];
                    for (int i = 0; i < basicMatrixInterface.getN(); ++i) {
                        nArray[i] = n + i;
                    }
                    return nArray;
                }
                n += basicMatrixInterface.getN();
            }
        } else {
            int n = this.referenceMatrix.getK();
            for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (basicMatrixInterface.equals(abstractTransform)) {
                    int[] nArray = new int[basicMatrixInterface.getK()];
                    for (int i = 0; i < basicMatrixInterface.getK(); ++i) {
                        nArray[i] = n + i;
                    }
                    return nArray;
                }
                n += basicMatrixInterface.getK();
            }
        }
        return null;
    }

    public final Double[] getIndexForTransformationDouble(boolean bl, AbstractTransform abstractTransform) {
        int[] nArray = this.getIndexForTransformation(bl, abstractTransform);
        if (nArray != null) {
            Double[] doubleArray = new Double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                doubleArray[i] = (double)nArray[i] + 1.0;
            }
            return doubleArray;
        }
        throw new RuntimeException("No such modification: " + abstractTransform.toString());
    }

    @Override
    public final int[] getKref() {
        return this.referenceMatrix.getKref();
    }

    @Override
    public final int getMissingCountForColumn(int n) {
        if (n >= 0 && n < this.referenceMatrix.getK()) {
            int n2 = this.referenceMatrix.getMissingCountForColumn(n);
            for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                n2 += basicMatrixInterface.getMissingCountForColumn(n);
            }
            return n2;
        }
        n -= this.referenceMatrix.getK();
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getK()) {
                return basicMatrixInterface.getMissingCountForColumn(n);
            }
            n -= basicMatrixInterface.getK();
        }
        return 0;
    }

    @Override
    public final int[] getMissingCountForColumns(boolean bl) {
        if (this.MV_Knr_cs != null) {
            return this.MV_Knr_cs;
        }
        return super.getMissingCountForColumns(bl);
    }

    @Override
    public final int getMissingCountForRow(int n) {
        if (n >= 0 && n < this.referenceMatrix.getN()) {
            int n2 = this.referenceMatrix.getMissingCountForRow(n);
            for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                n2 += basicMatrixInterface.getMissingCountForRow(n);
            }
            return n2;
        }
        n -= this.referenceMatrix.getN();
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getN()) {
                return basicMatrixInterface.getMissingCountForRow(n);
            }
            n -= basicMatrixInterface.getN();
        }
        return 0;
    }

    @Override
    public final int[] getMissingCountForRows(boolean bl) {
        if (this.MV_Nnr_cs != null) {
            return this.MV_Nnr_cs;
        }
        return super.getMissingCountForRows(bl);
    }

    @Override
    public final boolean[][] getMissingMatrix() {
        if (this.nrMV > 0 && (this.nrMV != this.referenceMatrix.getNrMV() || this.referenceMatrix instanceof LayerMatrix)) {
            this.missingMatrix_cs = new boolean[this.N][this.K];
            this.MV_Knr_cs = new int[this.K];
            this.MV_Nnr_cs = new int[this.N];
            for (int i = 0; i < this.N; ++i) {
                for (int j = 0; j < this.K; ++j) {
                    this.missingMatrix_cs[i][j] = this.isMissing(i, j);
                    if (!this.missingMatrix_cs[i][j]) continue;
                    int n = j;
                    this.MV_Knr_cs[n] = this.MV_Knr_cs[n] + 1;
                    int n2 = i;
                    this.MV_Nnr_cs[n2] = this.MV_Nnr_cs[n2] + 1;
                }
            }
            return this.missingMatrix_cs;
        }
        return this.referenceMatrix.getMissingMatrix();
    }

    @Override
    public final int[] getNref() {
        return this.referenceMatrix.getNref();
    }

    public final int getOriginatingColumn(int n) {
        if (this.referenceMatrix == null) {
            return n;
        }
        int n2 = this.referenceMatrix.getK();
        if (n < n2) {
            return n;
        }
        int n3 = n - n2;
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n3 < basicMatrixInterface.getK()) {
                if (basicMatrixInterface instanceof AbstractTransform) {
                    return ((AbstractTransform)basicMatrixInterface).getOriginatingRow(n3);
                }
                return n;
            }
            n3 -= basicMatrixInterface.getK();
        }
        return n;
    }

    public final int getOriginatingRow(int n) {
        if (this.referenceMatrix == null) {
            return n;
        }
        int n2 = this.referenceMatrix.getN();
        if (n < n2) {
            return n;
        }
        int n3 = n - n2;
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n3 < basicMatrixInterface.getN()) {
                if (basicMatrixInterface instanceof AbstractTransform) {
                    return ((AbstractTransform)basicMatrixInterface).getOriginatingRow(n3);
                }
                return n;
            }
            n3 -= basicMatrixInterface.getN();
        }
        return n;
    }

    @Override
    public final Description getRowDescription() {
        int n;
        if (this.obsDesc != null && this.obsDesc.getColumnCount() > 0 && this.obsDesc.getInnerColumn(0) != null) {
            return this.obsDesc;
        }
        DataSet dataSet = (DataSet)this.getTreeParent();
        if (this.referenceMatrix == null || dataSet == null) {
            return null;
        }
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        Description description = (Description)observationInfo.getGroupColumnByType(0);
        this.updateReferences(true);
        description.addListener(this);
        this.obsDesc = new Description(this.N);
        int n2 = this.referenceMatrix.getN();
        int n3 = description.getColumnCount();
        for (n = 0; n < n3; ++n) {
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n);
            BasicTreeInterface basicTreeInterface = (InnerColumnString)this.obsDesc.addColumn(innerColumnString.toString());
            for (int i = 0; i < n2; ++i) {
                this.obsDesc.addValue((InnerColumnString)basicTreeInterface, i, innerColumnString.getValueLocal(i), true);
            }
        }
        n = n2;
        for (BasicTreeInterface basicTreeInterface : this.getExtraRows()) {
            String[] stringArray = null;
            if (basicTreeInterface instanceof AbstractDataMatrix) {
                Description description2 = ((AbstractDataMatrix)basicTreeInterface).getRowDescription();
                stringArray = ((InnerColumnString)description2.getPrimaryColumn()).getArray();
            } else {
                if (!(basicTreeInterface instanceof AbstractTransform)) continue;
                stringArray = ((AbstractTransform)basicTreeInterface).getObsDescriptionArray();
            }
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length && n < this.N; ++i) {
                this.obsDesc.addValue((InnerColumnString)this.obsDesc.getPrimaryColumn(), n++, stringArray[i], true);
            }
        }
        return this.obsDesc;
    }

    @Override
    public final String getRowDescription(int n, int n2) {
        if (this.referenceMatrix == null || this.isCleaned() || n < 0 || n2 < 0) {
            return "";
        }
        int n3 = this.referenceMatrix.getN();
        if (n < n3) {
            DataSet dataSet = (DataSet)this.getTreeParent();
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            Description description = (Description)observationInfo.getGroupColumnByType(0);
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n2);
            return innerColumnString.getValueLocal(n);
        }
        n -= n3;
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getN()) {
                return basicMatrixInterface.getRowDescription(n, n2);
            }
            n -= basicMatrixInterface.getN();
        }
        return "";
    }

    @Override
    public final String getRowDescriptionTitle(int n) {
        DataSet dataSet = (DataSet)this.getTreeParent();
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        Description description = (Description)observationInfo.getGroupColumnByType(0);
        if (n < description.getColumnCount()) {
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n);
            return innerColumnString.toString();
        }
        return "ID " + n;
    }

    public final BasicMatrixInterface getRowMatrixAt(int n) {
        if (this.referenceMatrix != null) {
            int n2 = this.referenceMatrix.getN();
            if (n < n2) {
                return null;
            }
            n -= n2;
            for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (n < basicMatrixInterface.getN()) {
                    return basicMatrixInterface;
                }
                n -= basicMatrixInterface.getN();
            }
        }
        return null;
    }

    @Override
    public final byte getRowType(int n) {
        if (this.referenceMatrix == null) {
            return 4;
        }
        int n2 = this.referenceMatrix.getN();
        if (n < n2) {
            return this.referenceMatrix.getRowType(n);
        }
        n -= n2;
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            if (n < basicMatrixInterface.getN()) {
                return basicMatrixInterface.getRowType(n);
            }
            n -= basicMatrixInterface.getN();
        }
        return 12;
    }

    @Override
    public final byte getTreeType() {
        return 6;
    }

    @Override
    public final double getValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        block17: {
            if (this.referenceMatrix == null) break block17;
            int n3 = this.referenceMatrix.getN();
            int n4 = this.referenceMatrix.getK();
            int n5 = n;
            int n6 = n2;
            if (n5 < n3 && n6 < n4) {
                return this.referenceMatrix.getValue(n5, n6);
            }
            if (n5 < n3) {
                n6 -= n4;
                for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n6 < basicMatrixInterface.getK()) {
                        if (basicMatrixInterface instanceof AbstractTransform) {
                            return ((AbstractTransform)basicMatrixInterface).getValue(abstractDataMatrix, n5, n6);
                        }
                        return basicMatrixInterface.getValue(n5, n6);
                    }
                    n6 -= basicMatrixInterface.getK();
                }
            } else if (n6 < n4) {
                n5 -= n3;
                for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n5 < basicMatrixInterface.getN()) {
                        if (basicMatrixInterface instanceof AbstractTransform) {
                            ((AbstractTransform)basicMatrixInterface).getValue(abstractDataMatrix, n5, n6);
                        }
                        return basicMatrixInterface.getValue(n5, n6);
                    }
                    n5 -= basicMatrixInterface.getN();
                }
            } else {
                int n7 = n6 - n4;
                for (Object object : this.getExtraColumns()) {
                    if (!(object instanceof BasicMatrixInterface)) continue;
                    Object object2 = (BasicMatrixInterface)object;
                    if (n7 >= 0 && n7 < object2.getK() && n5 < object2.getN()) {
                        if (object2 instanceof AbstractTransform) {
                            return ((AbstractTransform)object2).getValue(abstractDataMatrix, n5, n7);
                        }
                        return object2.getValue(n5, n7);
                    }
                    n7 -= object2.getK();
                }
                int n8 = n5 - n3;
                for (Object object2 : this.getExtraRows()) {
                    if (!(object2 instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)object2;
                    if (n6 < basicMatrixInterface.getK() && n8 >= 0 && n8 < basicMatrixInterface.getN()) {
                        if (basicMatrixInterface instanceof AbstractTransform) {
                            return ((AbstractTransform)basicMatrixInterface).getValue(abstractDataMatrix, n8, n6);
                        }
                        return basicMatrixInterface.getValue(n8, n6);
                    }
                    n8 -= basicMatrixInterface.getN();
                }
            }
        }
        return 0.0;
    }

    @Override
    public final double getValue(int n, int n2) {
        return this.getValue(this, n, n2);
    }

    public final boolean hasMatrixChildren() {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n && !this.hasMatrixChildren; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataContainer)) continue;
            DataContainer dataContainer = (DataContainer)dataTreeInterface;
            int n2 = dataContainer.getTreeNodeCount();
            for (int j = 0; j < n2 && !this.hasMatrixChildren; ++j) {
                this.hasMatrixChildren = dataContainer.getTreeNodeAt(j) instanceof AbstractDataMatrix;
            }
        }
        return this.hasMatrixChildren;
    }

    @Override
    public final boolean hasMissing() {
        BasicMatrixInterface basicMatrixInterface;
        if (this.referenceMatrix.hasMissing()) {
            return true;
        }
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface) || !(basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface)).hasMissing()) continue;
            return true;
        }
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface) || !(basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface)).hasMissing()) continue;
            return true;
        }
        return false;
    }

    public final boolean isIncluded(int n, int n2) {
        return this.getDataInfo(0).isIncluded(n) && this.getDataInfo(1).isIncluded(n2);
    }

    @Override
    public final boolean isMissing(int n, int n2) {
        block13: {
            if (this.referenceMatrix == null) break block13;
            int n3 = this.referenceMatrix.getN();
            int n4 = this.referenceMatrix.getK();
            if (n < n3 && n2 < n4) {
                return super.isMissing(n, n2);
            }
            if (n < n3) {
                n2 -= n4;
                for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n2 < basicMatrixInterface.getK()) {
                        return basicMatrixInterface.isMissing(n, n2);
                    }
                    n2 -= basicMatrixInterface.getK();
                }
            } else if (n2 < n4) {
                n -= n3;
                for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n < basicMatrixInterface.getN()) {
                        return basicMatrixInterface.isMissing(n, n2);
                    }
                    n -= basicMatrixInterface.getN();
                }
            } else {
                int n5 = n2 - n4;
                for (Object object : this.getExtraColumns()) {
                    if (!(object instanceof BasicMatrixInterface)) continue;
                    Object object2 = (BasicMatrixInterface)object;
                    if (n5 >= 0 && n5 < object2.getK() && n < object2.getN()) {
                        return object2.isMissing(n, n5);
                    }
                    n5 -= object2.getK();
                }
                int n6 = n - n3;
                for (Object object2 : this.getExtraRows()) {
                    if (!(object2 instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)object2;
                    if (n2 < basicMatrixInterface.getK() && n6 >= 0 && n6 < basicMatrixInterface.getN()) {
                        return basicMatrixInterface.isMissing(n6, n2);
                    }
                    n6 -= basicMatrixInterface.getN();
                }
            }
        }
        return true;
    }

    public final boolean isTest(int n) {
        return ((ObservationInfo)this.getDataInfo(0)).isTest(n);
    }

    public final boolean isTrain(int n) {
        return ((ObservationInfo)this.getDataInfo(0)).isTrain(n);
    }

    public final boolean isX(int n) {
        return ((VariablesInfo)this.getDataInfo(1)).isX(n);
    }

    public final boolean isY(int n) {
        return ((VariablesInfo)this.getDataInfo(1)).isY(n);
    }

    public final void obsDescriptionUpdated() {
        this.obsDesc = null;
    }

    public void setColumnDescription(int n, int n2, String string) {
        if (this.isCleaned() || n < 0 || n2 < 0) {
            return;
        }
        int n3 = this.referenceMatrix.getK();
        if (n < n3) {
            DataSet dataSet = (DataSet)this.getTreeParent();
            VariablesInfo variablesInfo = dataSet.getVarDataInfo();
            Description description = (Description)variablesInfo.getGroupColumnByType(0);
            InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n2);
            if (innerColumnString != null) {
                innerColumnString.setValueLocal(n, string);
            }
        } else {
            n -= n3;
            for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (n < basicMatrixInterface.getK()) {
                    Description description = basicMatrixInterface.getColumnDescription();
                    InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(n2);
                    if (innerColumnString == null) break;
                    innerColumnString.setValueLocal(n, string);
                    break;
                }
                n -= basicMatrixInterface.getK();
            }
        }
    }

    @Override
    public final void setReferenceMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (dataTreeInterface instanceof DataContainer) {
                DataContainer dataContainer = (DataContainer)dataTreeInterface;
                for (int j = dataContainer.getTreeNodeCount() - 1; j >= 0; --j) {
                    if (dataContainer.getTreeNodeAt(j) instanceof AbstractDataMatrix) {
                        dataContainer.getTreeNodeAt(j).cleanUp();
                        continue;
                    }
                    dataContainer.removeTreeNodeAt(j);
                }
                continue;
            }
            if (!(dataTreeInterface instanceof AbstractTransform)) continue;
            ((AbstractTransform)dataTreeInterface).cleanUp();
        }
        this.hasMatrixChildren = false;
        this.N = 0;
        this.K = 0;
        super.setReferenceMatrix(progressManager, abstractDataMatrix);
    }

    @Override
    public final void setValue(int n, int n2, double d) {
        block4: {
            int n3;
            int n4;
            block6: {
                block5: {
                    n4 = this.referenceMatrix.getN();
                    n3 = this.referenceMatrix.getK();
                    if (n >= n4 || n2 >= n3) break block5;
                    this.referenceMatrix.setValue(n, n2, d);
                    break block4;
                }
                if (n >= n4) break block6;
                n2 -= n3;
                for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n2 < basicMatrixInterface.getK()) {
                        basicMatrixInterface.setValue(n, n2, d);
                        break block4;
                    }
                    n2 -= basicMatrixInterface.getK();
                }
                break block4;
            }
            if (n2 >= n3) break block4;
            n -= n4;
            for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (n < basicMatrixInterface.getN()) {
                    basicMatrixInterface.setValue(n, n2, d);
                    break;
                }
                n -= basicMatrixInterface.getN();
            }
        }
    }

    @Override
    public final void setValue(int n, int n2, double d, boolean bl) {
        block4: {
            int n3;
            int n4;
            block6: {
                block5: {
                    n4 = this.referenceMatrix.getN();
                    n3 = this.referenceMatrix.getK();
                    if (n >= n4 || n2 >= n3) break block5;
                    this.referenceMatrix.setValue(n, n2, d, bl);
                    break block4;
                }
                if (n >= n4) break block6;
                n2 -= n3;
                for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
                    if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                    BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                    if (n2 < basicMatrixInterface.getK()) {
                        basicMatrixInterface.setValue(n, n2, d, bl);
                        break block4;
                    }
                    n2 -= basicMatrixInterface.getK();
                }
                break block4;
            }
            if (n2 >= n3) break block4;
            n -= n4;
            for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
                if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
                BasicMatrixInterface basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
                if (n < basicMatrixInterface.getN()) {
                    basicMatrixInterface.setValue(n, n2, d, bl);
                    break;
                }
                n -= basicMatrixInterface.getN();
            }
        }
    }

    public final void updateReferences(boolean bl) {
        int n;
        BasicMatrixInterface basicMatrixInterface;
        if (this.referenceMatrix == null) {
            return;
        }
        this.nrMV = this.referenceMatrix.getNrMV();
        this.K = this.referenceMatrix.getK();
        for (DataTreeInterface dataTreeInterface : this.getExtraColumns()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            this.K += basicMatrixInterface.getK();
            for (n = 0; n < basicMatrixInterface.getN(); ++n) {
                if (!basicMatrixInterface.isMissing(n, 0)) continue;
                ++this.nrMV;
            }
        }
        this.N = this.referenceMatrix.getN();
        for (DataTreeInterface dataTreeInterface : this.getExtraRows()) {
            if (!(dataTreeInterface instanceof BasicMatrixInterface)) continue;
            basicMatrixInterface = (BasicMatrixInterface)((Object)dataTreeInterface);
            this.N += basicMatrixInterface.getN();
            for (n = 0; n < basicMatrixInterface.getK(); ++n) {
                if (!basicMatrixInterface.isMissing(0, n)) continue;
                ++this.nrMV;
            }
        }
        this.missingMatrix_cs = null;
        this.MV_Knr_cs = null;
        this.MV_Nnr_cs = null;
    }

    public final void varDescriptionUpdated() {
        this.varDesc = null;
    }

    @Override
    protected void cleanUpChild() {
        if (this.referenceMatrix != null) {
            Description description;
            Description description2 = this.referenceMatrix.getRowDescription();
            if (description2 != null) {
                description2.removeListener(this);
            }
            if ((description = this.referenceMatrix.getColumnDescription()) != null) {
                description.removeListener(this);
            }
        }
        if (this.varDesc != null) {
            this.varDesc.cleanUp();
        }
        if (this.obsDesc != null) {
            this.obsDesc.cleanUp();
        }
        this.getExtraColumns().clear();
        this.getExtraRows().clear();
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            this.getTreeNodeAt(i).cleanUp();
        }
        super.cleanUpChild();
    }

    private final DataContainer getExtraColumns() {
        DataTreeInterface dataTreeInterface;
        if (this.getTreeNodeCount() > 1 && (dataTreeInterface = this.getTreeNodeAt(1)) instanceof DataContainer) {
            DataContainer dataContainer = (DataContainer)dataTreeInterface;
            return dataContainer;
        }
        return new DataContainer("Cleaned", 0);
    }

    private final DataContainer getExtraRows() {
        DataTreeInterface dataTreeInterface;
        if (this.getTreeNodeCount() > 0 && (dataTreeInterface = this.getTreeNodeAt(0)) instanceof DataContainer) {
            DataContainer dataContainer = (DataContainer)dataTreeInterface;
            return dataContainer;
        }
        return new DataContainer("Cleaned", 0);
    }
}

