/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.baseline;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.baseline.BaseLineCorrectionPanel;

public class BaseLineCorrection
extends AbstractDataTransform {
    private BaseLineCorrectionPanel settingsPanel = new BaseLineCorrectionPanel(this);
    private int usedStartPos = -1;
    private int usedEndPos = -1;
    private int usedWindow = -1;

    public BaseLineCorrection(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public BaseLineCorrection(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.usedStartPos = mapProperty.getPropertyInt("usp", -1);
        this.usedEndPos = mapProperty.getPropertyInt("uep", -1);
        this.usedWindow = mapProperty.getPropertyInt("uw", -1);
        this.settingsPanel.setStartPos(mapProperty.getPropertyInt("sps", 0));
        this.settingsPanel.setEndPos(mapProperty.getPropertyInt("eps", 0));
        this.settingsPanel.setWindow(mapProperty.getPropertyInt("ws", 0));
    }

    public BaseLineCorrection(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
        BaseLineCorrection baseLineCorrection = (BaseLineCorrection)abstractDataTransform;
        this.usedStartPos = baseLineCorrection.usedStartPos;
        this.usedEndPos = baseLineCorrection.usedEndPos;
        this.usedWindow = baseLineCorrection.usedWindow;
        this.settingsPanel.setStartPos(baseLineCorrection.settingsPanel.getStartPos());
        this.settingsPanel.setEndPos(baseLineCorrection.settingsPanel.getEndPos());
        this.settingsPanel.setWindow(baseLineCorrection.settingsPanel.getWindow());
    }

    @Override
    public boolean appliesToY() {
        return false;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, final Matrix matrix, final ProgressManager progressManager) throws Exception {
        final int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        final byte[] byArray = this.getIncludedData();
        final int[] nArray = abstractDataMatrix.getMissingCountForRows(false);
        final int[] nArray2 = abstractDataMatrix.getNref();
        final int[] nArray3 = abstractDataMatrix.getKref();
        Threader threader = new Threader(this){
            final /* synthetic */ BaseLineCorrection this$0;
            {
                this.this$0 = baseLineCorrection;
            }

            @Override
            protected void doOp(boolean bl, int n4, int n2) {
                AbstractDataMatrix abstractDataMatrix2 = this.this$0.getOrigMatrix(abstractDataMatrix);
                boolean bl2 = abstractDataMatrix2.isOrigMatrix();
                for (int i = n4; i < n2; ++i) {
                    int n3 = i;
                    if (bl2) {
                        n3 = nArray2[i];
                    }
                    double d = this.this$0.getWindowValue(abstractDataMatrix2, n3, this.this$0.usedStartPos);
                    double d2 = this.this$0.getWindowValue(abstractDataMatrix2, n3, this.this$0.usedEndPos);
                    double d3 = d;
                    double d4 = (d2 - d) / (double)(this.this$0.usedEndPos - this.this$0.usedStartPos);
                    if (nArray == null || nArray[i] == 0) {
                        for (var16_12 = 0; var16_12 < n; ++var16_12) {
                            if (byArray != null && byArray[var16_12] <= 0) continue;
                            var17_13 = var16_12;
                            if (bl2) {
                                var17_13 = nArray3[var16_12];
                            }
                            double d5 = matrix.get(i, var16_12) - d3 - (double)var17_13 * d4;
                            matrix.set(i, var16_12, d5);
                        }
                    } else {
                        for (var16_12 = 0; var16_12 < n; ++var16_12) {
                            if (byArray != null && byArray[var16_12] <= 0 || abstractDataMatrix.isMissing(i, var16_12)) continue;
                            var17_13 = var16_12;
                            if (abstractDataMatrix2.isOrig.booleanValue()) {
                                var17_13 = nArray3[var16_12];
                            }
                            matrix.set(i, var16_12, matrix.get(i, var16_12) - (double)var17_13 * d4 - d3);
                        }
                    }
                    if (progressManager == null) continue;
                    progressManager.incStep(n);
                }
            }
        };
        threader.execute(n2);
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new BaseLineCorrection(transformations, this);
    }

    @Override
    public String getName() {
        return "Base-line correction";
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public String getShortName() {
        return "Base-line correction";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 14;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("usp", this.usedStartPos);
        randomOutputStream.writePropertyInt("uep", this.usedEndPos);
        randomOutputStream.writePropertyInt("uw", this.usedWindow);
        randomOutputStream.writePropertyInt("sps", this.settingsPanel.getStartPos());
        randomOutputStream.writePropertyInt("eps", this.settingsPanel.getEndPos());
        randomOutputStream.writePropertyInt("ws", this.settingsPanel.getWindow());
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.usedStartPos < 0 || this.usedEndPos < 0 || this.usedWindow < 0) {
            return 0.0;
        }
        this.setUsedValues();
        AbstractDataMatrix abstractDataMatrix2 = this.getOrigMatrix(null);
        double d2 = this.getWindowValue(abstractDataMatrix2, n3, this.usedStartPos);
        double d3 = this.getWindowValue(abstractDataMatrix2, n3, this.usedEndPos);
        double d4 = (d3 - d2) / (double)(this.usedEndPos - this.usedStartPos);
        return d - d2 - (double)n4 * d4;
    }

    @Override
    protected void calculateIntermediateMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
        this.setUsedValues();
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.settingsPanel = null;
    }

    protected AbstractDataMatrix getOrigMatrix(AbstractDataMatrix abstractDataMatrix) {
        Case case_ = (Case)DataTreeManager.getAncestorNull(this, Case.class);
        if (case_ != null && case_.getOriginalMatrix() != null) {
            return case_.getOriginalMatrix();
        }
        return abstractDataMatrix;
    }

    @Override
    protected void initiateGUILocal() {
        this.mainPanel.add((Component)this.settingsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private double getWindowValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        int n3 = this.usedWindow / 2;
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < this.usedWindow; ++i) {
            int n5 = n2 + i - n3;
            if (n5 < 0 || n5 >= abstractDataMatrix.getK()) continue;
            d += abstractDataMatrix.getValue(n, n5);
            ++n4;
        }
        if (n4 > 0) {
            return d / (double)n4;
        }
        if (n2 < abstractDataMatrix.getK()) {
            return abstractDataMatrix.getValue(n, n2);
        }
        return abstractDataMatrix.getValue(n, abstractDataMatrix.getK() - 1);
    }

    private void setUsedValues() {
        this.usedStartPos = this.settingsPanel.getStartPos() - 1;
        this.usedEndPos = this.settingsPanel.getEndPos() - 1;
        this.usedWindow = this.settingsPanel.getWindow();
    }
}

