/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.baseline;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.baseline.BaseLineCorrection;

public class BaseLineCorrectionPanel
extends JPanel
implements JValidateNumberField.NumberChangedInterface {
    private final JTextFieldButtonUppDown startPos = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final JLabel startPosDescr = new JLabel();
    private final JTextFieldButtonUppDown endPos = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final JLabel endPosDescr = new JLabel();
    private final JTextFieldButtonUppDown window = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final BaseLineCorrection transformation;

    public BaseLineCorrectionPanel(BaseLineCorrection baseLineCorrection) {
        super(new GridBagLayout());
        this.transformation = baseLineCorrection;
        this.setup();
    }

    public int getEndPos() {
        return (int)this.endPos.getNumber();
    }

    public int getStartPos() {
        return (int)this.startPos.getNumber();
    }

    public int getWindow() {
        return (int)this.window.getNumber();
    }

    public boolean hasDerivative() {
        return this.endPos.getNumber() > 0.0;
    }

    @Override
    public void NumberChanged(int n, double d) {
        this.transformation.triggerEvent((byte)16);
        this.setDescriptions();
    }

    public void setEndPos(int n) {
        this.endPos.setNumber(n);
    }

    public void setStartPos(int n) {
        this.startPos.setNumber(n);
    }

    public void setWindow(int n) {
        this.window.setNumber(n);
    }

    private void setDescriptions() {
        AbstractDataMatrix abstractDataMatrix = this.transformation.getOrigMatrix(null);
        if (abstractDataMatrix != null) {
            this.startPosDescr.setText(abstractDataMatrix.getColumnDescription((int)this.startPos.getNumber() - 1, 0));
            this.endPosDescr.setText(abstractDataMatrix.getColumnDescription((int)this.endPos.getNumber() - 1, 0));
        } else {
            this.startPosDescr.setText("N/A");
            this.endPosDescr.setText("N/A");
        }
    }

    private final void setup() {
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Settings"));
        this.startPos.setPreferredSize(new Dimension(70, 20));
        this.startPos.setMinimumSize(new Dimension(70, 20));
        this.endPos.setPreferredSize(new Dimension(70, 20));
        this.endPos.setMinimumSize(new Dimension(70, 20));
        this.window.setPreferredSize(new Dimension(70, 20));
        this.window.setMinimumSize(new Dimension(70, 20));
        this.add((Component)new JLabel("Start index"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.startPos, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Description"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.startPosDescr, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("End index"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.endPos, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Description"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.endPosDescr, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Window size"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.window, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.startPos.setNumber(1.0);
        this.endPos.setNumber(2.147483647E9);
        this.window.setNumber(15.0);
        SwingUtilities.invokeLater(() -> {
            AbstractDataMatrix abstractDataMatrix = this.transformation.getOrigMatrix(null);
            if (abstractDataMatrix != null) {
                int n = abstractDataMatrix.getK();
                if (this.endPos.getNumber() > (double)n) {
                    this.endPos.setNumber(n);
                    this.startPos.setMinMax(1.0, n);
                    this.endPos.setMinMax(1.0, n);
                }
            }
            this.startPos.setNumberChangedInterface(this);
            this.endPos.setNumberChangedInterface(this);
            this.window.setNumberChangedInterface(this);
            this.setDescriptions();
        });
    }
}

