/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.CPopupMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnShort;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.CategoryHierarchy;
import se.prediktera.map.datasetcontainer.transform.category.CategorySettingsPanel;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.datasetcontainer.transform.category.EqualSizeAnalysisInfo;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.SelectionInterface;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;

public class Category
extends AbstractTransform<Integer>
implements MouseListener {
    public static final int BINARYDATA = 0;
    public static final int CONTINUOUSDATA = 1;
    public static final int NODATA = 2;
    private final JList typeList = new JList();
    private final JTextField typeTextfield = new JTextField();
    private CategorySettingsPanel panel;
    private AbstractDataMatrix matrix;
    private int createData = 0;
    private final JRadioButton binaryData = new JRadioButton("One per class");
    private final JRadioButton continuousData = new JRadioButton("One for all");
    private final JRadioButton noData = new JRadioButton("None");
    private AbstractTransform.Type defaultType = AbstractTransform.Type.globalAdd;

    private static String fillColumnHelper(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix, InnerColumnString innerColumnString, int n, int n2, int n3, int n4, int n5) {
        Object object;
        String string = n == 0 ? ((object = innerColumnString.getValue(n5)) == null ? "-" : String.valueOf(object)) : (abstractDataInfo.getDataType() == 0 ? (n5 < abstractDataMatrix.getN() && n2 < abstractDataMatrix.getK() && !abstractDataMatrix.isMissing(n5, n2) ? String.valueOf(abstractDataMatrix.getValue(n5, n2)) : "-") : (n5 < abstractDataMatrix.getK() && n2 < abstractDataMatrix.getN() && !abstractDataMatrix.isMissing(n2, n5) ? String.valueOf(abstractDataMatrix.getValue(n2, n5)) : "-"));
        if (n3 > 0 || string.length() > n4) {
            int n6 = n3;
            int n7 = Math.min(string.length(), n6 + n4);
            string = n6 < n7 ? string.substring(n6, n7) : "-";
        }
        return string;
    }

    public Category(AbstractDataInfo abstractDataInfo, boolean bl, AbstractInnerColumn<Integer> abstractInnerColumn) {
        super(abstractDataInfo, bl);
        if (!this.isObs) {
            this.createData = 2;
        }
        this.ic = abstractInnerColumn;
        this.setLayerName(this.getName());
        this.updateClasses();
    }

    public Category(AbstractDataInfo abstractDataInfo, String string, boolean bl) {
        super(abstractDataInfo, bl, string);
        if (!bl) {
            this.createData = 2;
        }
    }

    public Category(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.createData = mapProperty.getPropertyInt("crdat", this.isObs ? 0 : 2);
    }

    public Category(Transformations transformations, Category category) {
        super(transformations, category);
        this.createData = category.createData;
        this.updateClasses();
    }

    public void addSetSelectedMenuItems(final SelectionInterface selectionInterface, CMenu cMenu) {
        if (this.ic != null) {
            final ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            CMenuItem cMenuItem = new CMenuItem(this, "New Class", false){
                final /* synthetic */ Category this$0;
                {
                    this.this$0 = category;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.createNewSubClass(selectionInterface);
                }
            };
            cMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
            cMenu.add(cMenuItem);
            ListModel listModel = this.typeList.getModel();
            int n = listModel.getSize();
            if (n > 0) {
                int n2 = Math.min(n, 30);
                int n3 = (int)Math.ceil((double)n / (double)n2);
                if (n3 > 1) {
                    cMenu.getPopupMenu().setLayout(new GridLayout(n2, n3));
                }
                cMenu.addSeparator();
                for (int i = 0; i < n; ++i) {
                    cMenu.add(new AbstractAction(this, listModel.getElementAt(i).toString()){
                        final /* synthetic */ Category this$0;
                        {
                            this.this$0 = category;
                            super(string);
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = (String)this.getValue("Name");
                            this.this$0.setType(classTypes.getTypeDescriptionIndex(string));
                            if (selectionInterface != null && selectionInterface.isAutoCreateLayerFromClass()) {
                                selectionInterface.autoCreateLayerFromClass(string, false);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public AbstractDataMatrix applyTransformation(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, boolean bl) {
        if (this.createData == 2) {
            this.results = null;
            return null;
        }
        ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
        if (classTypes.size() > 1) {
            if (this.createData == 0) {
                return this.createBinaryData(abstractDataMatrix, progressManager, classTypes);
            }
            if (this.createData == 1) {
                return this.createContinuousData(abstractDataMatrix, progressManager, classTypes);
            }
        }
        this.results = null;
        return null;
    }

    @Override
    public AbstractTransform<Integer> cloneThis(Transformations transformations) {
        return new Category(transformations, this);
    }

    @Override
    public AbstractInnerColumn<Integer> createInnerColumn(String string, Transformations transformations) {
        return new InnerColumnClass(this, string, transformations, null, -1);
    }

    @Override
    public InnerColumnClass getInnerColumn() {
        return (InnerColumnClass)super.getInnerColumn();
    }

    public void createNewSubClass(SelectionInterface selectionInterface) {
        ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
        int n = this.createNewClass(Main_GUI.get(), false);
        if (n != -1) {
            String string = classTypes.getTypeDescription(n);
            this.setType(n);
            this.updateClasses();
            this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 0));
            if (selectionInterface != null && selectionInterface.isAutoCreateLayerFromClass()) {
                selectionInterface.autoCreateLayerFromClass(string, false);
            }
        }
    }

    public void fillColumn(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, String string) {
        boolean bl;
        Description description = (Description)abstractDataInfo.getGroupColumnByType(0);
        InnerColumnString innerColumnString = null;
        if (n == 0) {
            innerColumnString = (InnerColumnString)description.getInnerColumn(n2);
        }
        this.ic.beginUpdate();
        ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
        boolean bl2 = bl = string != null;
        if (bl) {
            string = string.replaceAll("(\\.\\*|\\*)", ".*");
            try {
                "testing".matches(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                bl = false;
                Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Warning: Expression invalid, skipping matching", 7);
            }
        }
        for (int i = 0; i < this.ic.getSize(); ++i) {
            String string2 = Category.fillColumnHelper(abstractDataInfo, abstractDataMatrix, innerColumnString, n, n2, n3, n4, i);
            if (bl && string2 != null && !string2.matches(string)) {
                classTypes.addSorted("-");
                continue;
            }
            classTypes.addSorted(string2);
        }
        InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
        for (int i = 0; i < this.ic.getSize(); ++i) {
            String string3 = Category.fillColumnHelper(abstractDataInfo, abstractDataMatrix, innerColumnString, n, n2, n3, n4, i);
            if (bl && !string3.matches(string)) {
                string3 = "-";
            }
            innerColumnClass.setValueShort(i, classTypes.getTypeDescriptionIndex(string3));
        }
        this.ic.endUpdate();
        this.updateClasses();
    }

    @Override
    public byte getColumnType(int n) {
        return 3;
    }

    @Override
    public AbstractInnerColumn<Integer> getInnerColumn(Transformations transformations) {
        InnerColumnClass innerColumnClass = (InnerColumnClass)super.getInnerColumn(transformations);
        if (innerColumnClass.getObject() == null) {
            innerColumnClass.holdObject(new ClassTypes(innerColumnClass));
        }
        return innerColumnClass;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public byte getRowType(int n) {
        return 3;
    }

    @Override
    public String getShortName() {
        return this.toString();
    }

    @Override
    public String getTitleName() {
        return "Category (" + String.valueOf(this) + ")";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        AbstractDataInfo abstractDataInfo = this.getDataInfo();
        if (abstractDataInfo != null && abstractDataInfo.isGroup()) {
            return AbstractTransform.Type.localAdd;
        }
        return this.defaultType;
    }

    @Override
    public byte getTreeType() {
        return 4;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
        randomInputStream.beginDataBlock("Loading categories into memory", false);
        int n = randomInputStream.ReadBlockInt();
        if (n > 0) {
            Transformations transformations = this.getIcParent();
            int n2 = 3;
            if (transformations != null) {
                n2 = transformations.getSaveVersion();
            }
            if (this.ic == null) {
                this.ic = new InnerColumnClass(this, null, transformations, null, -1);
            }
            this.ic.Load(randomInputStream, n2);
        }
        this.loadDataLocal(randomInputStream);
        randomInputStream.endDataBlock();
        if (this.ic != null) {
            this.updateClasses();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int[] nArray = this.typeList.getSelectedIndices();
            CPopupMenu cPopupMenu = new CPopupMenu();
            cPopupMenu.add(new AbstractAction("Add new class"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Category.this.createNewClass(Category.this, true);
                }
            });
            if (nArray != null && nArray.length > 0) {
                ((JPopupMenu)cPopupMenu).addSeparator();
                cPopupMenu.add(new AbstractAction("Select from class(es)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Category.this.getProject().doInteraction(Category.this);
                    }
                });
                cPopupMenu.add(new AbstractAction("Rename class(es)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Category.this.renameClasses(Category.this, Category.this.typeList.getSelectedIndices());
                    }
                });
                cPopupMenu.add(new AbstractAction("Change color for class(es)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Category.this.changeColorForClasses(Category.this, Category.this.typeList.getSelectedIndices());
                    }
                });
                cPopupMenu.add(new AbstractAction("Delete class(es)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Category.this.removeClasses(Category.this, Category.this.typeList.getSelectedIndices());
                    }
                });
                if (nArray.length > 1) {
                    cPopupMenu.add(new AbstractAction("Merge classes"){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Category.this.mergeSelectedClasses();
                        }
                    });
                }
            }
            cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void prepareInteraction() {
        int n;
        int[] nArray = this.typeList.getSelectedIndices();
        int n2 = n = this.isObs ? 1 : 2;
        if (nArray != null) {
            InteractionArray interactionArray = this.getProject().getInteractionArray(this.dataInfo.getCase(), n, this.ic.getSize(), this.dataInfo.getGroupID());
            InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
            for (int n3 : nArray) {
                for (int i = 0; i < interactionArray.size(); ++i) {
                    if (innerColumnClass.getValueShort(i) != n3) continue;
                    interactionArray.set(i);
                }
            }
        }
    }

    @Override
    public void reverseTransformation(AbstractDataMatrix abstractDataMatrix, boolean bl) {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("crdat", this.createData);
    }

    @Override
    public void set(Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0].equals("sample")) {
            InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            short s = classTypes.addString("Sample");
            int n = innerColumnClass.getSize();
            innerColumnClass.beginUpdate();
            for (int i = 0; i < n; ++i) {
                innerColumnClass.setValueShort(i, s);
            }
            innerColumnClass.endUpdate();
            this.updateClasses();
            this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 0));
        }
    }

    public void setBySelection(String string) {
        InteractionArray interactionArray = this.getInteractionArray(this.isObservation() ? 1 : 2);
        if (interactionArray != null) {
            this.ic.beginUpdate();
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            short s = classTypes.getTypeDescriptionIndex("-");
            if (s < 0) {
                s = classTypes.addString("-");
            }
            short s2 = s;
            s = classTypes.getTypeDescriptionIndex(string);
            if (s < 0) {
                s = classTypes.addString(string);
            }
            InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
            short s3 = s;
            for (int i = 0; i < interactionArray.size() && i < this.ic.getSize(); ++i) {
                if (interactionArray.get(i)) {
                    innerColumnClass.setValueShort(i, s3);
                    continue;
                }
                innerColumnClass.setValueShort(i, s2);
            }
            this.dataInfo.triggerEvent(new DataInfoEvent(this.dataInfo, 7, this));
            this.ic.endUpdate();
            this.updateClasses();
        }
    }

    @Override
    public boolean setCreated(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo) {
        if (!super.setCreated(project_GUI, abstractDataInfo)) {
            return false;
        }
        if (this.panel == null) {
            this.updateClasses();
        } else {
            this.panel.fillColumn(this.matrix, this);
            this.panel = null;
            this.matrix = null;
        }
        return true;
    }

    public void setDefaultType(AbstractTransform.Type type) {
        this.defaultType = type;
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "autocreate")) {
                String string = ScriptHelper.getProperty(properties, "autocreate");
                if (string.equalsIgnoreCase("y")) {
                    DataSet dataSet = this.dataInfo.getDataSet();
                    VariablesInfo variablesInfo = dataSet.getVarDataInfo();
                    InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getGroupColumnByType(3).getPrimaryColumn();
                    InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getGroupColumnByType(1).getPrimaryColumn();
                    TransformMatrix transformMatrix = dataSet.getResultMatrix();
                    ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
                    for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                        if (!innerColumnBoolean.isY(i) || !innerColumnBoolean2.getValueBool(i)) continue;
                        String string2 = transformMatrix.getColumnDescription(i, 0);
                        int n = string2.lastIndexOf(": ");
                        if (n >= 0) {
                            string2 = string2.substring(n + 2);
                        }
                        short s = classTypes.addString(string2);
                        this.ic.setValueLocal(i, Integer.valueOf(s));
                    }
                } else if (string.equalsIgnoreCase("data")) {
                    int n = ScriptHelper.getPropertyInt(properties, "dataindex");
                    this.fillColumn(this.dataInfo, this.matrix, 0, n, 0, Integer.MAX_VALUE, null);
                }
            }
            if (ScriptHelper.hasKey(properties, "name")) {
                this.setLayerName(ScriptHelper.getProperty(properties, "name"));
            }
        }
        this.panel = null;
    }

    public void setSettingsPanel(CategorySettingsPanel categorySettingsPanel, AbstractDataMatrix abstractDataMatrix) {
        this.panel = categorySettingsPanel;
        this.matrix = abstractDataMatrix;
    }

    public void updateClasses() {
        if (this.ic != null) {
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            this.typeList.setListData(classTypes.toArray());
            this.typeList.setSelectedIndex(classTypes.size() - 1);
            this.typeList.ensureIndexIsVisible(this.typeList.getSelectedIndex());
        }
    }

    @Override
    protected boolean addToPopup(DataTreeInterface dataTreeInterface, CMenu cMenu) {
        ActionListener actionListener;
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        CMenu cMenu2 = new CMenu("Set selected to...", false);
        cMenu.add(cMenu2);
        this.addSetSelectedMenuItems(null, cMenu2);
        ListModel listModel = this.typeList.getModel();
        int n = listModel.getSize();
        if (n > 0) {
            int n2 = Math.min(n, 30);
            int n3 = (int)Math.ceil((double)n / (double)n2);
            jMenuItem2 = new CMenu("Delete class", false);
            if (n3 > 1) {
                ((JMenu)jMenuItem2).getPopupMenu().setLayout(new GridLayout(n2, n3));
            }
            for (int i = 1; i < n; ++i) {
                AbstractAction abstractAction = new AbstractAction(listModel.getElementAt(i).toString()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Integer n = (Integer)this.getValue("index");
                        Category.this.removeClasses(Main_GUI.get(), new int[]{n});
                    }
                };
                abstractAction.putValue("index", i);
                ((JMenu)jMenuItem2).add(abstractAction);
            }
            jMenuItem2.setEnabled(n > 1);
            cMenu.add(jMenuItem2);
            jMenuItem = new CMenu("Rename class", false);
            if (n3 > 1) {
                ((JMenu)jMenuItem).getPopupMenu().setLayout(new GridLayout(n2, n3));
            }
            for (int i = 0; i < n; ++i) {
                actionListener = new AbstractAction(listModel.getElementAt(i).toString()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Integer n = (Integer)this.getValue("index");
                        Category.this.renameClasses(Main_GUI.get(), new int[]{n});
                    }
                };
                ((AbstractAction)actionListener).putValue("index", i);
                ((JMenu)jMenuItem).add((Action)actionListener);
            }
            cMenu.add(jMenuItem);
        }
        if (this.isObs) {
            CMenu cMenu3 = new CMenu("Create dummy variable", false);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("One for each class");
            jRadioButtonMenuItem.setSelected(this.binaryData.isSelected());
            jRadioButtonMenuItem.addActionListener(actionEvent -> this.binaryData.setSelected(true));
            cMenu3.add(jRadioButtonMenuItem);
            jMenuItem2 = new JRadioButtonMenuItem("One for all classes");
            jMenuItem2.setSelected(this.continuousData.isSelected());
            jMenuItem2.addActionListener(actionEvent -> this.continuousData.setSelected(true));
            cMenu3.add(jMenuItem2);
            jMenuItem = new JRadioButtonMenuItem("None");
            jMenuItem.setSelected(this.noData.isSelected());
            jMenuItem.addActionListener(actionEvent -> this.noData.setSelected(true));
            cMenu3.add(jMenuItem);
            cMenu.add(cMenu3);
            CMenuItem cMenuItem = new CMenuItem("Select Equal Class Sizes", false);
            cMenuItem.addActionListener(actionEvent -> {
                if (dataTreeInterface instanceof DataSet) {
                    EqualSizeAnalysisInfo.doInteraction(this.getProject(), ((DataSet)dataTreeInterface).getObsDataInfo(), (InnerColumnClass)this.ic);
                }
            });
            cMenu.add(cMenuItem);
            actionListener = new CMenuItem("Create hierarchy", false);
            ((AbstractButton)((Object)actionListener)).addActionListener(actionEvent -> {
                if (dataTreeInterface instanceof DataSet) {
                    CategoryHierarchy.createHierarchy(this.getProject(), (DataSet)dataTreeInterface, null, this);
                }
            });
            cMenu.add((JMenuItem)((Object)actionListener));
        }
        super.addToPopup(dataTreeInterface, cMenu);
        return true;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.panel != null) {
            this.panel.cleanUp();
            this.panel = null;
        }
        if (this.matrix != null) {
            this.matrix.cleanUp();
            this.matrix = null;
        }
    }

    @Override
    protected void initiateGUILocal() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JButton jButton = new JButton("Rename modification", new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        jButton.addActionListener(actionEvent -> this.renameModification());
        JButton jButton2 = new JButton("Delete modification", new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        jButton2.addActionListener(actionEvent -> this.deleteModification());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)jButton2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 18, 2, new Insets(6, 6, 12, 6), 0, 0));
        this.mainPanel.add(jPanel);
        JFlatButton jFlatButton = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/left.gif")));
        jFlatButton.setPreferredSize(new Dimension(27, 21));
        jFlatButton.setToolTipText("Set Selected Rows to class");
        jFlatButton.addActionListener(actionEvent -> this.setType(this.typeList.getSelectedIndex()));
        this.typeList.addListSelectionListener(listSelectionEvent -> {
            if (this.typeList.getSelectedIndex() >= 0) {
                this.typeTextfield.setText(this.typeList.getSelectedValue().toString());
            } else {
                this.typeTextfield.setText("");
            }
        });
        this.typeList.addMouseListener(this);
        this.typeList.setCellRenderer(new ColorRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.typeList);
        jScrollPane.setMinimumSize(new Dimension(0, 200));
        jScrollPane.setPreferredSize(new Dimension(0, 200));
        this.typeTextfield.setEditable(false);
        JFlatButton jFlatButton2 = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("icons/common/newFile.png")));
        jFlatButton2.setPreferredSize(new Dimension(27, 21));
        jFlatButton2.setRequestFocusEnabled(false);
        jFlatButton2.setToolTipText("Add New Class");
        jFlatButton2.setMargin(new Insets(0, 0, 0, 0));
        jFlatButton2.addActionListener(actionEvent -> this.createNewClass(this, true));
        JFlatButton jFlatButton3 = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        jFlatButton3.setPreferredSize(new Dimension(27, 21));
        jFlatButton3.setRequestFocusEnabled(false);
        jFlatButton3.setToolTipText("Delete Selected Class(es)");
        jFlatButton3.setMargin(new Insets(0, 0, 0, 0));
        jFlatButton3.addActionListener(actionEvent -> this.removeClasses(this, this.typeList.getSelectedIndices()));
        JFlatButton jFlatButton4 = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        jFlatButton4.setPreferredSize(new Dimension(27, 21));
        jFlatButton4.setToolTipText("Rename Selected Class(es)");
        jFlatButton4.addActionListener(actionEvent -> this.renameClasses(this, this.typeList.getSelectedIndices()));
        JFlatButton jFlatButton5 = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/up.png")));
        jFlatButton5.setPreferredSize(new Dimension(27, 21));
        jFlatButton5.setToolTipText("Move Class Up");
        jFlatButton5.addActionListener(actionEvent -> this.moveClass(true));
        JFlatButton jFlatButton6 = new JFlatButton(new ImageIcon(Main_GUI.class.getResource("gifother/down.png")));
        jFlatButton6.setPreferredSize(new Dimension(27, 21));
        jFlatButton6.setToolTipText("Move Class Down");
        jFlatButton6.addActionListener(actionEvent -> this.moveClass(false));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jFlatButton2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel2.add((Component)jFlatButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)jFlatButton4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)jFlatButton5, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)jFlatButton6, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 0, 6, 6), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Classes"));
        this.mainPanel.add(jPanel3);
        jPanel3.add((Component)jFlatButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.typeTextfield, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)jScrollPane, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.binaryData);
        buttonGroup.add(this.continuousData);
        buttonGroup.add(this.noData);
        this.binaryData.setSelected(this.createData == 0);
        this.continuousData.setSelected(this.createData == 1);
        this.noData.setSelected(this.createData == 2);
        if (this.isObs) {
            JPanel jPanel4 = new JPanel(new GridLayout(3, 1, 5, 5));
            this.mainPanel.add(jPanel4);
            jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Create Dummy Variable"));
            jPanel4.add(this.binaryData);
            jPanel4.add(this.continuousData);
            jPanel4.add(this.noData);
            ItemListener itemListener = itemEvent -> {
                Object object = itemEvent.getSource();
                if (this.binaryData.equals(object)) {
                    this.createData = 0;
                } else if (this.continuousData.equals(object)) {
                    this.createData = 1;
                } else if (this.noData.equals(object)) {
                    this.createData = 2;
                }
                this.dataInfo.triggerGlobalEvent(new DataInfoEvent(this.dataInfo, 6, this));
            };
            this.binaryData.addItemListener(itemListener);
            this.continuousData.addItemListener(itemListener);
            this.noData.addItemListener(itemListener);
        }
    }

    @Override
    protected void loadDataLocal(RandomInputStream randomInputStream) throws IOException {
        if (this.ic != null) {
            ClassTypes classTypes = new ClassTypes((InnerColumnClass)this.ic);
            classTypes.LoadData(randomInputStream, this.getSaveVersion());
            ((InnerColumnClass)this.ic).holdObject(classTypes);
        }
    }

    @Override
    protected void saveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        if (this.ic != null) {
            ((InnerColumnClass)this.ic).getObject().SaveData(randomOutputStream, this.getSaveVersion());
        }
    }

    private void changeColorForClasses(Component component, int[] nArray) {
        if (nArray != null) {
            boolean bl = false;
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            for (int n : nArray) {
                ClassSettings classSettings = classTypes.getClassSettings(n);
                Color color = ScalePanel.showDialog(this, "Change color for " + classSettings.getName(), classSettings.getColor());
                if (color == null) continue;
                classSettings.setColor(color);
                bl = true;
            }
            if (bl) {
                this.updateClasses();
                this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 2));
                this.typeList.setSelectedIndices(nArray);
            }
        }
    }

    private boolean checkClassName(String string) {
        if (string == null) {
            return false;
        }
        ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
        if (classTypes.hasTypeDescription(string)) {
            JOptionPane.showConfirmDialog(this, "This class name already exists, try another", "Class name exists", -1, 1, null);
        } else if (string.length() == 0) {
            JOptionPane.showConfirmDialog(this, "Illegal class name, try another", "Illegal class name", -1, 1, null);
        } else {
            return true;
        }
        return false;
    }

    private AbstractDataMatrix createBinaryData(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, ClassTypes classTypes) {
        InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
        int n = innerColumnClass.getSize();
        if (this.isObs) {
            this.createResults(n, classTypes.size() - 1);
        } else {
            this.createResults(classTypes.size() - 1, n);
        }
        String[] stringArray = new String[classTypes.size() - 1];
        String string = this.toString().length() > 10 ? this.toString().substring(0, 8) + "..: " : String.valueOf(this) + ": ";
        for (int i = 1; i < classTypes.size(); ++i) {
            stringArray[i - 1] = string + classTypes.getTypeDescription(i);
            for (int j = 0; j < n; ++j) {
                boolean bl;
                boolean bl2 = bl = innerColumnClass.getValueShort(j) == i;
                if (this.isObs) {
                    this.results.setValue(j, i - 1, (double)bl);
                    continue;
                }
                this.results.setValue(i - 1, j, (double)bl);
            }
        }
        if (this.isObs) {
            this.setVarDescription(this.results, stringArray);
        } else {
            this.setObsDescription(this.results, stringArray);
        }
        if (progressManager != null && abstractDataMatrix != null) {
            progressManager.incStep(2 * abstractDataMatrix.getK() * abstractDataMatrix.getN());
        }
        return this.results;
    }

    private AbstractDataMatrix createContinuousData(AbstractDataMatrix abstractDataMatrix, ProgressManager progressManager, ClassTypes classTypes) {
        if (this.isObs) {
            this.createResults(this.ic.getSize(), 1);
        } else {
            this.createResults(1, this.ic.getSize());
        }
        String[] stringArray = new String[]{this.toString()};
        InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
        for (int i = 0; i < this.ic.getSize(); ++i) {
            short s = innerColumnClass.getValueShort(i);
            if (this.isObs) {
                this.results.setValue(i, 0, s);
                continue;
            }
            this.results.setValue(0, i, s);
        }
        if (this.isObs) {
            this.setVarDescription(this.results, stringArray);
        } else {
            this.setObsDescription(this.results, stringArray);
        }
        if (progressManager != null) {
            progressManager.incStep(2 * abstractDataMatrix.getK() * abstractDataMatrix.getN());
        }
        return this.results;
    }

    private int createNewClass(Component component, boolean bl) {
        String string = JOptionPane.showInputDialog(component, (Object)"Choose name for the new class:");
        if (string != null) {
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            if (this.checkClassName(string)) {
                short s = classTypes.addString(string);
                if (bl) {
                    this.updateClasses();
                    this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 0));
                }
                return s;
            }
        }
        return -1;
    }

    private void mergeSelectedClasses() {
        int[] nArray = this.typeList.getSelectedIndices();
        if (nArray != null && nArray.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.typeList.getModel().getElementAt(nArray[i]));
            }
            String string = JOptionPane.showInputDialog(this, "Choose name to for the merge result:", stringBuilder.toString());
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            int n = classTypes.getTypeDescriptionIndex(string);
            boolean bl = false;
            if (n >= 0) {
                bl = true;
                for (int n2 : nArray) {
                    if (n2 != n) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.checkClassName(string);
            } else {
                this.ic.beginUpdate();
                Object object = (InnerColumnClass)this.ic;
                for (int i = nArray.length - 1; i > 0; --i) {
                    n = nArray[i];
                    for (int j = 0; j < this.ic.getSize(); ++j) {
                        int n2;
                        n2 = ((InnerColumnShort)object).getValueShort(j);
                        if (n2 < n) continue;
                        if (n2 == n) {
                            ((InnerColumnShort)object).setValueShort(j, (short)nArray[0]);
                            continue;
                        }
                        ((InnerColumnShort)object).setValueShort(j, (short)(n2 - 1));
                    }
                    classTypes.remove(n);
                }
                classTypes.setTypeDescription(nArray[0], string);
                this.ic.endUpdate();
                this.updateClasses();
                this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 0, this, classTypes, 0));
            }
        }
    }

    private void moveClass(boolean bl) {
        int[] nArray = this.typeList.getSelectedIndices();
        if (this.ic != null && nArray != null && nArray.length > 0) {
            this.ic.beginUpdate();
            InnerColumnClass innerColumnClass = (InnerColumnClass)this.ic;
            ClassTypes classTypes = innerColumnClass.getObject();
            if (bl) {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n <= i) continue;
                    innerColumnClass.swapValues((short)n, (short)(n - 1));
                    nArray[i] = n - 1;
                }
            } else {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    if (n + nArray.length - i >= classTypes.size()) continue;
                    innerColumnClass.swapValues((short)n, (short)(n + 1));
                    nArray[i] = n + 1;
                }
            }
            this.ic.endUpdate();
            this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, this.typeList.getSelectedIndices(), nArray, bl));
            this.updateClasses();
            this.typeList.setSelectedIndices(nArray);
            this.typeList.scrollRectToVisible(this.typeList.getCellBounds(nArray[0], nArray[nArray.length - 1]));
        }
    }

    private void removeClasses(Component component, int[] nArray) {
        if (nArray != null) {
            int n = JOptionPane.showConfirmDialog(component, "Really delete selected class(es)?", "Really delete?", 2);
            if (n != 0) {
                return;
            }
            this.ic.beginUpdate();
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                if (n2 == 0) continue;
                ((InnerColumnClass)this.ic).removeClassByIndex(n2);
                classTypes.remove(n2);
            }
            this.ic.endUpdate();
            this.updateClasses();
            this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 1));
        }
    }

    private void renameClasses(Component component, int[] nArray) {
        if (nArray != null) {
            boolean bl = false;
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            for (int n : nArray) {
                String string = classTypes.getTypeDescription(n);
                String string2 = JOptionPane.showInputDialog(component, "Enter new name for " + string + ":", string);
                if (!this.checkClassName(string2)) continue;
                classTypes.setTypeDescription(n, string2);
                bl = true;
            }
            if (bl) {
                this.updateClasses();
                this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 9, this, classTypes, 2));
                this.typeList.setSelectedIndices(nArray);
            }
        }
    }

    private void setType(int n) {
        InteractionArray interactionArray;
        if (n >= 0 && (interactionArray = this.getInteractionArray(this.isObs ? 1 : 2)) != null) {
            ClassTypes classTypes = ((InnerColumnClass)this.ic).getObject();
            this.ic.beginUpdate();
            for (int i = 0; i < interactionArray.size() && i < this.ic.getSize(); ++i) {
                if (!interactionArray.get(i)) continue;
                this.ic.setValue(i, n);
            }
            this.ic.endUpdate();
            this.dataInfo.triggerGlobalEvent(new DataInfoClassEvent(this.dataInfo, 7, this, classTypes, 2));
        }
    }

    public InnerColumnClass getInnerColumnClass() {
        return this.getInnerColumn();
    }

    public ClassTypes getClassTypes() {
        return this.getInnerColumnClass().getObject();
    }

    private class ColorRenderer
    extends DefaultListCellRenderer {
        private final ColorIcon colorIcon = new ColorIcon();

        private ColorRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ClassSettings) {
                ClassSettings classSettings = (ClassSettings)object;
                this.colorIcon.setColor(classSettings.getColor());
                jLabel.setIcon(this.colorIcon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }

        private class ColorIcon
        extends ImageIcon {
            int size = 10;
            BufferedImage image = new BufferedImage(this.size, this.size, 2);

            private ColorIcon() {
            }

            public void setColor(Color color) {
                Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, this.size, this.size);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, this.size - 1, this.size - 1);
                graphics2D.dispose();
                this.setImage(this.image);
            }
        }
    }
}

