/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.register.RegisterKeyManager;

public class CategoryAnalysisInfo
extends AbstractAnalysisInfo {
    public void createDialog() {
    }

    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        Serializable serializable;
        String string = "Category";
        String string2 = "class1";
        String string3 = "class2";
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "name")) {
                string = ScriptHelper.getProperty(properties, "name");
            }
            if (ScriptHelper.hasKey(properties, "name1")) {
                string2 = ScriptHelper.getProperty(properties, "name1");
            }
            if (ScriptHelper.hasKey(properties, "name2")) {
                string3 = ScriptHelper.getProperty(properties, "name2");
            }
        }
        DataSet dataSet = null;
        AbstractDataInfo abstractDataInfo = null;
        AbstractDataMatrix abstractDataMatrix = null;
        InteractionArray interactionArray = null;
        ArrayList<AbstractModel> arrayList = null;
        if (objectArray[0] instanceof AbstractDataMatrix) {
            abstractDataMatrix = (AbstractDataMatrix)objectArray[0];
            abstractDataInfo = abstractDataMatrix.getDataInfo(0);
            dataSet = abstractDataInfo.getDataSet();
        } else if (objectArray[0] instanceof InteractionArray) {
            interactionArray = (InteractionArray)objectArray[0];
            serializable = (Case)interactionArray.getRoot();
            dataSet = ((Case)serializable).getOriginalDataSet();
            abstractDataInfo = dataSet.getObsDataInfo();
        } else if (objectArray[0] instanceof DataSet) {
            dataSet = (DataSet)objectArray[0];
            abstractDataInfo = dataSet.getObsDataInfo();
            arrayList = new ArrayList<AbstractModel>();
            ModelManager.collectModels(dataSet.getCase(), arrayList);
        }
        serializable = (Category)dataSet.createModification(progressManager, "obs", "category");
        ((AbstractTransform)serializable).setLayerName(DataTreeManager.getUniqueName(((AbstractLayer)serializable).getTreeParent(), string));
        InnerColumnClass innerColumnClass = ((Category)serializable).getInnerColumn();
        innerColumnClass.beginUpdate();
        if (arrayList != null) {
            this.createCategoryFromModelList(arrayList, innerColumnClass);
        } else {
            ClassTypes classTypes = innerColumnClass.getObject();
            short s = classTypes.addString(string2);
            progressManager.setInfoText("Calculating category");
            if (abstractDataMatrix != null) {
                this.createCategoryFromMatrix(abstractDataMatrix, innerColumnClass, s);
            } else {
                innerColumnClass.fillColumn(s);
                short s2 = classTypes.addString(string3);
                for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
                    innerColumnClass.setValueShort(i, s2);
                }
            }
        }
        innerColumnClass.endUpdate();
        ((Category)serializable).updateClasses();
        abstractDataInfo.triggerGlobalEvent(new DataInfoEvent(abstractDataInfo, 6, (AbstractTransform)serializable));
        return serializable;
    }

    @Override
    public void showAnalysisDialog(Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            return objectArray.length != 1 || !(objectArray[0] instanceof FloatWindow);
        }
        return false;
    }

    public String toString() {
        return "Category";
    }

    private void createCategoryFromMatrix(AbstractDataMatrix abstractDataMatrix, InnerColumnClass innerColumnClass, int n) {
        int n2 = abstractDataMatrix.getFoldN();
        abstractDataMatrix.beginCalculations();
        boolean bl = abstractDataMatrix instanceof FoldMatrixInterface;
        int n3 = abstractDataMatrix.getN();
        int n4 = abstractDataMatrix.getK();
        int[] nArray = abstractDataMatrix.getNref();
        int[] nArray2 = abstractDataMatrix.getKref();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (abstractDataMatrix.isMissing(i, j) || !(abstractDataMatrix.getValue(i, j) > 0.0)) continue;
                int n5 = bl ? nArray2[j] * n2 + nArray[i] : nArray[j * n2 + i];
                innerColumnClass.setValueShort(n5, (short)n);
            }
        }
        abstractDataMatrix.endCalculations();
    }

    private void createCategoryFromModelList(List<AbstractModel> list, InnerColumnClass innerColumnClass) {
        ClassTypes classTypes = innerColumnClass.getObject();
        int n = innerColumnClass.getSize();
        boolean bl = false;
        for (AbstractModel abstractModel : list) {
            InnerColumnClass innerColumnClass2;
            String string = abstractModel.getClassName();
            if (string == null) continue;
            String string2 = abstractModel.getReplaceClassName();
            short s = classTypes.getTypeDescriptionIndex(string2);
            if (s >= 0) {
                innerColumnClass.removeClassByIndex(s);
                classTypes.remove(s);
            }
            if ((innerColumnClass2 = abstractModel.getClassByName(string)) != null) {
                ClassTypes classTypes2 = innerColumnClass2.getObject();
                for (int i = 0; i < classTypes2.size(); ++i) {
                    ClassSettings classSettings = classTypes2.getClassSettings(i);
                    String string3 = classSettings.getName();
                    if (string3.equals("-")) continue;
                    short s2 = classTypes.getTypeDescriptionIndex(string3);
                    if (s2 < 0) {
                        s2 = classTypes.addStringNoEvent(string3, classSettings.getColor());
                    }
                    for (int j = 0; j < n; ++j) {
                        if (innerColumnClass2.getValueShort(j) != i) continue;
                        innerColumnClass.setValueShort(j, s2);
                    }
                }
            }
            bl = true;
        }
        if (!bl) {
            short s = classTypes.addStringNoEvent("Sample", Color.white);
            for (int i = 0; i < n; ++i) {
                innerColumnClass.setValueShort(i, s);
            }
        }
    }
}

