/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.awt.Color;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Properties;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.CategoryHierarchyDialog;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.datasetcontainer.transform.category.EqualSizeAnalysisInfo;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;

public class CategoryHierarchy {
    public static void createHierarchy(Project_GUI project_GUI, AbstractModel abstractModel) {
        CategoryHierarchy.createHierarchy(project_GUI, abstractModel.getDataSet(), abstractModel, abstractModel.getDataSet().getCategory(abstractModel.getClassName()).getCategory());
    }

    public static void createHierarchy(final Project_GUI project_GUI, final DataSet dataSet, final AbstractModel abstractModel, final Category category) {
        String string;
        String[] stringArray = null;
        if (abstractModel != null) {
            stringArray = abstractModel.getVariableArray();
        }
        ClassTypes classTypes = category.getClassTypes();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < classTypes.size(); ++i) {
            string = classTypes.getTypeDescription(i);
            if (!CategoryHierarchy.contains(stringArray, string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        final CategoryHierarchyDialog categoryHierarchyDialog = new CategoryHierarchyDialog((Frame)Main_GUI.get(), category.getName(), stringBuilder.toString());
        string = categoryHierarchyDialog.showModal();
        if (string != null) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    this.setInfoText("Creating hierarchy");
                    AbstractModel abstractModel2 = CategoryHierarchy.apply(this, project_GUI, dataSet, category, string, categoryHierarchyDialog.createDataSet(), categoryHierarchyDialog.createModels());
                    if (abstractModel != null) {
                        if (abstractModel2 != null) {
                            abstractModel2.setReplaceClassName(abstractModel.getReplaceClassName());
                            abstractModel2.setReplaceModel(abstractModel.getReplaceModel());
                        }
                        abstractModel.delete();
                    }
                    dataSet.getDataTreeManager().updateGraph();
                    return null;
                }
            };
            progressManagerImpl.invokeLater();
        }
    }

    private static boolean contains(String[] stringArray, String string) {
        if (stringArray == null) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static AbstractModel apply(ProgressManager progressManager, Project_GUI project_GUI, DataSet dataSet, Category category, String string, boolean bl, boolean bl2) {
        Object object;
        InnerColumnClass innerColumnClass = category.getInnerColumnClass();
        ClassTypes classTypes = innerColumnClass.getObject();
        ArrayList<DataSetClass> arrayList = new ArrayList<DataSetClass>();
        String[] stringArray = string.split(",");
        Category category2 = (Category)dataSet.createModification(progressManager, "obs", "category");
        String string2 = string.replace("+", "");
        category2.setLayerName(string2);
        InnerColumnClass innerColumnClass2 = category2.getInnerColumn();
        ClassTypes classTypes2 = innerColumnClass2.getObject();
        for (String object2 : stringArray) {
            String[] stringArray2;
            object = object2.replace("+", "");
            ClassSettings classSettings = classTypes.getClassSettingsByName((String)object);
            Color color = classSettings != null ? classSettings.getColor() : null;
            short s = classTypes2.addStringNoEvent((String)object, color);
            for (String string3 : stringArray2 = object2.split("\\+")) {
                short s2 = classTypes.getTypeDescriptionIndex(string3);
                for (int i = 0; i < innerColumnClass.getSize(); ++i) {
                    if (innerColumnClass.getValueShort(i) != s2) continue;
                    innerColumnClass2.setValueShort(i, s);
                }
            }
            if (!bl || stringArray2.length <= 1) continue;
            arrayList.add(new DataSetClass(CategoryHierarchy.createDataSet(progressManager, project_GUI, dataSet, innerColumnClass2, (String)object, s), (String)object));
        }
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        observationInfo.triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)observationInfo, 0, category2, classTypes2, 0));
        category2.updateClasses();
        if (bl2) {
            progressManager.setInfoText("Creating hierarchy models");
            AbstractModel abstractModel = CategoryHierarchy.createModel(progressManager, string2, string2, innerColumnClass2, dataSet);
            dataSet.setName("DataSet (" + string2 + ")");
            for (DataSetClass dataSetClass : arrayList) {
                object = CategoryHierarchy.createModel(progressManager, category.getName(), dataSetClass.className, innerColumnClass, dataSetClass.dataSet);
                ((AbstractModel)object).setReplaceClassName(dataSetClass.className);
                ((AbstractModel)object).setReplaceModel(abstractModel);
            }
            return abstractModel;
        }
        return null;
    }

    private static DataSet createDataSet(ProgressManager progressManager, Project_GUI project_GUI, DataSet dataSet, InnerColumnClass innerColumnClass, String string, short s) {
        DataSet dataSet2 = dataSet.cloneDataSet(progressManager, null, false);
        dataSet2.setName("DataSet (" + string + ")");
        dataSet2.addDataSetToProject(project_GUI);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataSet2.getObsDataInfo().getPrimaryColumnByType(4);
        for (int i = 0; i < innerColumnClass.getSize(); ++i) {
            innerColumnBoolean.setValueBool(i, innerColumnClass.getValueShort(i) == s);
        }
        return dataSet2;
    }

    private static AbstractModel createModel(ProgressManager progressManager, String string, String string2, InnerColumnClass innerColumnClass, DataSet dataSet) {
        EqualSizeAnalysisInfo.performAnalysis(progressManager, dataSet, innerColumnClass);
        Properties properties = new Properties();
        properties.put("ycategory", string);
        AbstractModel abstractModel = dataSet.createModel(progressManager, "pls-da", properties);
        abstractModel.setEnabled(true);
        abstractModel.setName("PLS-DA (" + string2 + ")");
        return abstractModel;
    }

    private static class DataSetClass {
        private final DataSet dataSet;
        private final String className;

        public DataSetClass(DataSet dataSet, String string) {
            this.dataSet = dataSet;
            this.className = string;
        }
    }
}

