/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.prediktera.map.main.Evince;

public class CategoryHierarchyDialog
extends JDialog {
    private boolean okClicked = false;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JCheckBox createDataSetCheckBox;
    private JCheckBox createModelCheckBox;
    private JTextArea informationTextArea;
    private JTextField inputTextField;
    private JButton okButton;

    public CategoryHierarchyDialog(Frame frame, String string, String string2) {
        super(frame, true);
        this.initComponents();
        this.createModelCheckBox.setSelected(true);
        this.setPreferredSize(new Dimension(500, 300));
        this.setTitle("Create hierarchy");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Create a hierarchy category by merging classes in the category (" + string + ").\n\n");
        stringBuilder.append("Merge classes by replacing the \u2019,\u2019 sign by a \u2019+\u2019 sign in the field below:\n");
        stringBuilder.append("(Classes can be removed but class name cannot be changed)");
        this.informationTextArea.setText(stringBuilder.toString());
        this.inputTextField.setText(string2);
    }

    public String showModal() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.inputTextField.requestFocus();
        this.setVisible(true);
        if (this.okClicked) {
            return this.getInput();
        }
        return null;
    }

    private void initComponents() {
        this.informationTextArea = new JTextArea();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.inputTextField = new JTextField();
        this.createDataSetCheckBox = new JCheckBox();
        this.createModelCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.informationTextArea.setEditable(false);
        this.informationTextArea.setColumns(20);
        this.informationTextArea.setFont(new Font("Tahoma", 0, 13));
        this.informationTextArea.setRows(3);
        this.informationTextArea.setText("Information");
        this.informationTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(24, 24, 0, 24);
        this.getContentPane().add((Component)this.informationTextArea, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(85, 27));
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(85, 27));
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints);
        this.inputTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CategoryHierarchyDialog.this.inputTextFieldKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 24, 0, 24);
        this.getContentPane().add((Component)this.inputTextField, gridBagConstraints);
        this.createDataSetCheckBox.setSelected(true);
        this.createDataSetCheckBox.setText("Create new DataSet for each merged class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 24, 0, 24);
        this.getContentPane().add((Component)this.createDataSetCheckBox, gridBagConstraints);
        this.createModelCheckBox.setText("Create connected PLS-DA models for each class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 24, 0, 24);
        this.getContentPane().add((Component)this.createModelCheckBox, gridBagConstraints);
        this.pack();
    }

    private void inputTextFieldKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okButtonActionPerformed(null);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.okClicked = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public String getInput() {
        return this.inputTextField.getText();
    }

    public boolean createDataSet() {
        return this.createDataSetCheckBox.isSelected();
    }

    public boolean createModels() {
        return this.createModelCheckBox.isSelected();
    }

    public static void main(String[] stringArray) {
        Evince.setLookAndFeel();
        EventQueue.invokeLater(() -> {
            CategoryHierarchyDialog categoryHierarchyDialog = new CategoryHierarchyDialog((Frame)new JFrame(), "Category", "A,B,C,D,E,F,G,H");
            categoryHierarchyDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            categoryHierarchyDialog.showModal();
        });
    }
}

