/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.SelectionInterface;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.FloatWindowScatter3D;

public class CategorySettingsPanel
extends WizardPageClass {
    private final JRadioButton createFromData = new JRadioButton("Create classes from identifier or data");
    private final JTextField name = new JTextField();
    private final JComboBoxCell createComboBox = new JComboBoxCell(false);
    private final JTextFieldButtonUppDown descrStartPos = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final JTextFieldButtonUppDown descrLength = new JTextFieldButtonUppDown(1.0, 2.147483647E9, false);
    private final JRadioButton createFromSelection = new JRadioButton("Create class from selection");
    private final JTextField selectedClass = new JTextField("A");
    private final JTextField example = new JTextField();
    private final JTextField regex = new JTextField();
    private DataSet dataSet;
    private AbstractDataInfo dataInfo1 = null;
    private AbstractDataInfo dataInfo2 = null;
    private final JCheckBox autoCreateCheckBox = new JCheckBox("Auto create layers from class (Only for selected plot)", false);
    private boolean doevent = true;
    private boolean autoname = true;

    public CategorySettingsPanel() {
        this(null, null, null);
    }

    public CategorySettingsPanel(DataSet dataSet, AbstractDataInfo abstractDataInfo, AbstractDataInfo abstractDataInfo2) {
        super(new BorderLayout());
        this.dataSet = dataSet;
        this.dataInfo1 = abstractDataInfo;
        this.dataInfo2 = abstractDataInfo2;
        this.jbinit();
        if (UpdateHelper.Product.isRunningProductEvince()) {
            this.fillCreateBox();
        }
        this.descrStartPos.setRequestFocusEnabled(false);
        this.descrLength.setRequestFocusEnabled(false);
        this.descrStartPos.setNumber(1.0);
        this.descrLength.setNumber(50.0);
    }

    public void fillColumn(AbstractDataMatrix abstractDataMatrix, Category category) {
        if (this.createFromData.isSelected()) {
            ComboItem comboItem = (ComboItem)this.createComboBox.getSelectedItem();
            if (comboItem != null) {
                String string = this.regex.getText();
                category.fillColumn(this.dataInfo1, abstractDataMatrix, comboItem.getType(), comboItem.getRealIndex(), this.getStartPos(), this.getLength(), string.length() == 0 ? null : string);
            }
        } else {
            category.setBySelection(this.getSelectedClass());
        }
    }

    @Override
    public boolean finishedPressed() {
        if (this.isCreateFromData()) {
            boolean bl = true;
            if (!this.isOnlyNumbers(this.example.getText())) {
                return true;
            }
            int n = (int)Math.pow(10.0, this.getLength());
            int n2 = this.dataInfo1.getActiveTrueSize(1);
            if ((n2 = Math.min(n, n2)) > 1000) {
                boolean bl2 = bl = JOptionPane.showOptionDialog(null, "Warning! The chosen data seem to contain only numbers.\nThis could possibly generate up to " + n2 + " classes.\n\nDo you wish to continue?", "Warning", 0, 2, null, null, null) != 1;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name.getText();
        }
        return "";
    }

    public String getSelectedClass() {
        return this.selectedClass.getText();
    }

    public boolean isAutoCreateLayerFromClass() {
        return this.autoCreateCheckBox.isVisible() && this.autoCreateCheckBox.isSelected();
    }

    public boolean isCreateFromData() {
        return this.createFromData.isSelected();
    }

    @Override
    public void pageShown() {
        SwingUtilities.invokeLater(() -> {
            if (this.createFromData.isSelected()) {
                this.name.selectAll();
                this.name.requestFocus();
            } else {
                this.selectedClass.selectAll();
                this.selectedClass.requestFocus();
            }
        });
    }

    public void setCreateFrom(int n, Double[] doubleArray) {
        int n2 = doubleArray[0].intValue() - 1;
        int n3 = this.createComboBox.getItemCount();
        for (int i = 0; i < n3; ++i) {
            ComboItem comboItem;
            Object e = this.createComboBox.getItemAt(i);
            if (!(e instanceof ComboItem) || (comboItem = (ComboItem)e).getType() != n || comboItem.getRealIndex() != n2) continue;
            this.createComboBox.setSelectedItem(comboItem);
            if (doubleArray.length == 3) {
                this.descrStartPos.setNumber(doubleArray[1].intValue());
                this.descrLength.setNumber(doubleArray[2].intValue());
            }
            return;
        }
    }

    public void setCreateFromPlotSelection(SelectionInterface selectionInterface) {
        this.createFromSelection.setSelected(true);
        Class<?> clazz = selectionInterface.getClass();
        if (clazz.equals(FloatWindowScatter.class) || clazz.equals(FloatWindowScatter3D.class) || clazz.equals(FloatWindowContour2D.class)) {
            this.autoCreateCheckBox.setVisible(true);
        }
    }

    @Override
    public void setWizard(AbstractWizard abstractWizard) {
        super.setWizard(abstractWizard);
        abstractWizard.addNextListener(this.name);
        abstractWizard.addNextListener(this.selectedClass);
    }

    @Override
    protected void cleanUpChild() {
        this.dataSet = null;
        this.dataInfo1 = null;
        this.dataInfo2 = null;
    }

    private void fillCreateBox() {
        this.createComboBox.removeAllItems();
        if (this.dataInfo1 != null && this.dataInfo2 != null) {
            DataGroupValues dataGroupValues = this.dataInfo1.getGroupColumnByType(0);
            int n = dataGroupValues.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.createComboBox.addItem(new ComboItem(dataGroupValues.getColumnName(i), 0, i, false));
            }
            DataGroupValues dataGroupValues2 = this.dataInfo2.getGroupColumnByType(0);
            Object icType = dataGroupValues2.getPrimaryColumn();
            if (icType != null) {
                this.createComboBox.addSeparator();
                int n2 = ((AbstractInnerColumn)icType).getSize();
                for (int i = 0; i < n2; ++i) {
                    Object object = ((AbstractInnerColumn)icType).getValue(i);
                    if (object == null || object.equals("")) continue;
                    this.createComboBox.addItem(new ComboItem(String.valueOf(object), 1, i, false));
                }
            }
            this.setExample();
        }
    }

    private String getIndexName(int n) {
        if (n > 0) {
            return "Category (" + n + ")";
        }
        return "Category";
    }

    private final int getLength() {
        return (int)this.descrLength.getNumber();
    }

    private final int getStartPos() {
        return (int)this.descrStartPos.getNumber() - 1;
    }

    private String getUniqueClassName() {
        Transformations transformations = (Transformations)this.dataInfo1.getGroupColumnByType(10);
        int n = 0;
        if (transformations != null) {
            boolean bl;
            int n2 = transformations.getColumnCount();
            block0: do {
                bl = false;
                for (int i = 0; i < n2; ++i) {
                    if (transformations.getColumnType(i) != 4 || !this.getIndexName(n).equals(transformations.getColumnName(i))) continue;
                    bl = true;
                    ++n;
                    continue block0;
                }
            } while (bl);
        }
        return this.getIndexName(n);
    }

    private boolean isOnlyNumbers(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && c == '-' || c == ' ') continue;
            if (!(c != '.' && c != ',' || bl)) {
                bl = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void jbinit() {
        JValidateNumberField.NumberChangedInterface numberChangedInterface = (n, d) -> this.setExample();
        this.descrStartPos.setNumberChangedInterface(numberChangedInterface);
        this.descrLength.setNumberChangedInterface(numberChangedInterface);
        this.example.addCaretListener(caretEvent -> {
            if (this.doevent) {
                boolean bl = caretEvent.getDot() < caretEvent.getMark();
                int n = bl ? caretEvent.getDot() : caretEvent.getMark();
                int n2 = Math.abs(caretEvent.getMark() - caretEvent.getDot());
                if (n2 == 0) {
                    this.descrStartPos.setNumber(1.0);
                    this.descrLength.setNumber(n);
                    this.setExample();
                } else {
                    if (this.getStartPos() != n) {
                        this.descrStartPos.setNumber(n + 1);
                    }
                    if (this.getLength() != n2) {
                        this.descrLength.setNumber(n2);
                    }
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.createFromData);
        buttonGroup.add(this.createFromSelection);
        this.createFromData.setSelected(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Create Category"));
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.selectedClass.setEnabled(false);
        this.name.setText(this.getUniqueClassName());
        this.name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CategorySettingsPanel.this.autoname = false;
            }
        });
        this.createComboBox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CategorySettingsPanel.this.autoname && CategorySettingsPanel.this.createFromData.isSelected()) {
                    CategorySettingsPanel.this.name.setText(CategorySettingsPanel.this.createComboBox.getSelectedItem().toString());
                    CategorySettingsPanel.this.setExample();
                }
            }
        });
        this.example.setEditable(false);
        this.example.setBackground(Color.white);
        this.createFromData.addItemListener(itemEvent -> {
            boolean bl = this.createFromData.isSelected();
            this.createComboBox.setEnabled(bl);
            this.selectedClass.setEnabled(!bl);
            this.descrStartPos.setEnabled(bl);
            this.descrLength.setEnabled(bl);
            this.example.setEnabled(bl);
            if (this.autoname) {
                if (bl) {
                    this.name.setText(this.createComboBox.getSelectedItem().toString());
                    this.example.grabFocus();
                    this.setExample();
                } else {
                    this.name.setText(this.getUniqueClassName());
                }
            }
        });
        this.autoCreateCheckBox.setVisible(false);
        jPanel.add((Component)new JLabel("Category Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.createFromData, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0));
        jPanel3.add((Component)this.createComboBox, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 13, 2, new Insets(6, 0, 0, 6), 0, 0));
        jPanel3.add((Component)new JLabel("Select constraints:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.example, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)new JLabel("Description Constraints"), new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Start position:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.descrStartPos, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)new JLabel("Length:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.descrLength, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)new JLabel("Matching expression:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.regex, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.createFromSelection, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 5, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0));
        jPanel2.add((Component)new JLabel("Class for selected:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)this.selectedClass, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel2.add((Component)this.autoCreateCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 6, 0, 0, 0.0, 1.0, 17, 1, new Insets(6, 6, 0, 6), 0, 0));
    }

    private void setExample() {
        String string;
        ComboItem comboItem = (ComboItem)this.createComboBox.getSelectedItem();
        if (comboItem == null) {
            this.example.setText("");
            return;
        }
        int n = comboItem.getIndex();
        int n2 = comboItem.getType();
        if (n2 == 0) {
            var5_4 = this.dataInfo1.getGroupColumnByType(0);
            string = ((AbstractInnerColumn)((DataGroupValues)var5_4).getInnerColumn(n)).getValue(0).toString();
        } else {
            var5_4 = this.dataSet.getOriginalMatrix();
            string = this.dataInfo1.getDataType() == 0 ? (0 < ((AbstractDataMatrix)var5_4).getN() && n < ((AbstractDataMatrix)var5_4).getK() && !((AbstractDataMatrix)var5_4).isMissing(0, n) ? String.valueOf(((AbstractDataMatrix)var5_4).getValue(0, n)) : "-") : (0 < ((AbstractDataMatrix)var5_4).getK() && n < ((AbstractDataMatrix)var5_4).getN() && !((AbstractDataMatrix)var5_4).isMissing(n, 0) ? String.valueOf(((AbstractDataMatrix)var5_4).getValue(n, 0)) : "-");
        }
        int n3 = this.getStartPos();
        int n4 = n3 + this.getLength();
        this.doevent = false;
        this.example.setText(string + "                                                     ");
        this.example.select(n3, n4);
        this.example.requestFocus();
        this.doevent = true;
    }
}

