/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.category;

import java.util.ArrayList;
import java.util.Properties;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;

public class EqualSizeAnalysisInfo
extends AbstractAnalysisInfo
implements InteractionInterface {
    private Project_GUI pGUI;
    private AbstractDataInfo dataInfo;
    private InnerColumnClass icc;

    public static void doInteraction(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo, InnerColumnClass innerColumnClass) {
        EqualSizeAnalysisInfo equalSizeAnalysisInfo = new EqualSizeAnalysisInfo(project_GUI, abstractDataInfo, innerColumnClass);
        project_GUI.doInteraction(equalSizeAnalysisInfo);
        equalSizeAnalysisInfo.cleanUp();
    }

    public static void performAnalysis(ProgressManager progressManager, DataSet dataSet, InnerColumnClass innerColumnClass) {
        EqualSizeAnalysisInfo equalSizeAnalysisInfo = new EqualSizeAnalysisInfo();
        equalSizeAnalysisInfo.performAnalysis(progressManager, dataSet.getObsDataInfo(), innerColumnClass);
        equalSizeAnalysisInfo.cleanUp();
    }

    public EqualSizeAnalysisInfo() {
    }

    public EqualSizeAnalysisInfo(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo, InnerColumnClass innerColumnClass) {
        this.pGUI = project_GUI;
        this.dataInfo = abstractDataInfo;
        this.icc = innerColumnClass;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    @Override
    public void finishInteraction() {
    }

    public void performAnalysis(ProgressManager progressManager, AbstractDataInfo abstractDataInfo, InnerColumnClass innerColumnClass) {
        this.dataInfo = abstractDataInfo;
        this.icc = innerColumnClass;
        IncExclude incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(4);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        BooleanArray booleanArray = new BooleanArray(incExclude.getRows());
        this.setEqualSize(booleanArray);
        innerColumnBoolean.beginUpdate();
        innerColumnBoolean.fillColumn(false);
        for (int i = booleanArray.getFirstSet(); i <= booleanArray.getLastSet(); ++i) {
            if (!booleanArray.get(i)) continue;
            innerColumnBoolean.setValueBool(i, true);
        }
        innerColumnBoolean.endUpdate();
        abstractDataInfo.triggerObsVarIncExc();
    }

    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        DataSet dataSet = (DataSet)objectArray[0];
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        InnerColumnClass innerColumnClass = null;
        if (ScriptHelper.hasKey(properties, "classindex")) {
            int n = ScriptHelper.getPropertyInt(properties, "classindex");
            innerColumnClass = observationInfo.getClassByNameOrIndex(null, n - 1);
        } else if (ScriptHelper.hasKey(properties, "classname")) {
            String string = ScriptHelper.getProperty(properties, "classname");
            innerColumnClass = observationInfo.getClassByNameOrIndex(string, -1);
        } else {
            throw new RuntimeException("No class property");
        }
        this.performAnalysis(progressManager, observationInfo, innerColumnClass);
        return null;
    }

    @Override
    public void prepareInteraction() {
        InteractionArray interactionArray = this.pGUI.getInteractionArray(this.dataInfo.getCase(), 1, this.icc.getSize(), this.dataInfo.getGroupID());
        this.setEqualSize(interactionArray);
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        return objectArray.length >= 1 && objectArray[0] instanceof DataSet;
    }

    public String toString() {
        return "Equal Size";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.pGUI = null;
        this.dataInfo = null;
        this.icc = null;
    }

    private void setEqualSize(BooleanArray booleanArray) {
        int n;
        int n2;
        ClassTypes classTypes = this.icc.getObject();
        int n3 = classTypes.size();
        ArrayList[] arrayListArray = new ArrayList[n3];
        for (n2 = 1; n2 < n3; ++n2) {
            arrayListArray[n2] = new ArrayList();
        }
        n2 = Integer.MAX_VALUE;
        IncExclude incExclude = (IncExclude)this.dataInfo.getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        IncExclude incExclude2 = (IncExclude)this.dataInfo.getGroupColumnByType(4);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
        for (n = 0; n < this.icc.getSize(); ++n) {
            if (!innerColumnBoolean.getValueBool(n) || !innerColumnBoolean2.getValueBool(n) || this.icc.getValueShort(n) <= 0) continue;
            arrayListArray[this.icc.getValueShort(n)].add(n);
        }
        for (n = 1; n < n3; ++n) {
            if (n2 <= arrayListArray[n].size() || arrayListArray[n].size() <= 0) continue;
            n2 = arrayListArray[n].size();
        }
        for (n = 1; n < n3; ++n) {
            double d = (double)arrayListArray[n].size() / (double)n2;
            for (double d2 = 0.0; d2 < (double)arrayListArray[n].size(); d2 += d) {
                booleanArray.set((Integer)arrayListArray[n].get((int)d2));
            }
        }
    }
}

