/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.cr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.cr.ConvexHull;
import se.prediktera.map.main.script.ScriptHelper;

public class ContinuumRemovalTransform
extends AbstractDataTransform {
    public static final String Name = "Continuum removal";
    private int leftOffset;
    private int rightOffset;

    public ContinuumRemovalTransform(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public ContinuumRemovalTransform(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.leftOffset = mapProperty.getPropertyInt("lo", 0);
        this.rightOffset = mapProperty.getPropertyInt("ro", 0);
    }

    public ContinuumRemovalTransform(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
        ContinuumRemovalTransform continuumRemovalTransform = (ContinuumRemovalTransform)abstractDataTransform;
        this.leftOffset = continuumRemovalTransform.leftOffset;
        this.rightOffset = continuumRemovalTransform.rightOffset;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("lo", this.leftOffset);
        randomOutputStream.writePropertyInt("ro", this.rightOffset);
    }

    @Override
    public boolean appliesToY() {
        return false;
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (ScriptHelper.hasKey(properties, "leftoffset")) {
            this.leftOffset = ScriptHelper.getPropertyInt(properties, "leftoffset");
        }
        if (ScriptHelper.hasKey(properties, "rightoffset")) {
            this.rightOffset = ScriptHelper.getPropertyInt(properties, "rightoffset");
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("leftoffset", String.valueOf(this.leftOffset));
        properties.put("rightoffset", String.valueOf(this.rightOffset));
        return properties;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, final Matrix matrix, final ProgressManager progressManager) throws Exception {
        final int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        final boolean bl = !abstractDataMatrix.hasMissing() && !this.hasUserdefinedValues();
        Threader threader = new Threader(this, 1){
            final /* synthetic */ ContinuumRemovalTransform this$0;
            {
                this.this$0 = continuumRemovalTransform;
                super(n3);
            }

            @Override
            protected void doOp(boolean bl2, int n6, int n2) {
                if (bl) {
                    for (int i = n6; i < n2; ++i) {
                        int n3 = n - this.this$0.rightOffset;
                        ArrayList<ConvexHull.Point> arrayList = new ArrayList<ConvexHull.Point>();
                        for (int j = this.this$0.leftOffset; j < n3; ++j) {
                            arrayList.add(new ConvexHull.Point(j, (float)matrix.get(i, j)));
                        }
                        List<ConvexHull.Point> list = ConvexHull.compute(arrayList);
                        for (int j = 1; j < list.size(); ++j) {
                            ConvexHull.Point point = list.get(j - 1);
                            ConvexHull.Point point2 = list.get(j);
                            int n4 = point.X;
                            int n5 = point2.X;
                            float f = point.Y;
                            float f2 = point2.Y;
                            float f3 = (f2 - f) / (float)(n5 - n4);
                            float f4 = f - f3 * (float)n4;
                            for (int k = n4; k < n5; ++k) {
                                float f5 = f3 * (float)k + f4;
                                if (f5 == 0.0f) {
                                    matrix.set(i, k, 1.0);
                                    continue;
                                }
                                matrix.set(i, k, matrix.get(i, k) / (double)f5);
                            }
                        }
                        matrix.set(i, n3 - 1, 1.0);
                        if (progressManager == null) continue;
                        progressManager.incStep(n);
                    }
                } else {
                    throw new RuntimeException("Not yet implemented for missing values");
                }
            }
        };
        threader.execute(n2);
        return abstractDataMatrix;
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new ContinuumRemovalTransform(transformations, this);
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public int getPriority() {
        return 195;
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public int getRightOffset() {
        return this.rightOffset;
    }

    @Override
    public String getShortName() {
        return "ContinuumRemoval";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 15;
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.isIncluded(n4)) {
            // empty if block
        }
        return d;
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected String getWorkflowName() {
        return "ContinuumRemoval";
    }
}

