/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.cr;

import java.util.ArrayList;
import java.util.List;

public class ConvexHull {
    public static List<Point> compute(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point point = list.get(0);
        int n = 0;
        while (true) {
            arrayList.add(point);
            if (n == list.size() - 1) break;
            Point point2 = list.get(n);
            for (int i = n + 1; i < list.size(); ++i) {
                if (!(ConvexHull.Ccw(point, point2, list.get(i)) >= 0.0f)) continue;
                n = i;
                point2 = list.get(n);
            }
            if (point2.X < point.X) break;
            point = point2;
        }
        return arrayList;
    }

    private static float Ccw(Point point, Point point2, Point point3) {
        return Math.signum((float)(point2.X - point.X) * (point3.Y - point.Y) - (float)(point3.X - point.X) * (point2.Y - point.Y));
    }

    public static class Point {
        public int X;
        public float Y;

        public Point(int n, float f) {
            this.X = n;
            this.Y = f;
        }

        public String toString() {
            return this.X + " " + this.Y + " ";
        }
    }
}

