/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.derivative;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.transform.derivative.Derivative;
import se.prediktera.map.main.script.ScriptHelper;

public class DerivativeSettingsPanel
extends JPanel
implements ItemListener {
    private final JRadioButton type1 = new JRadioButton("Type 1");
    private final JRadioButton type2 = new JRadioButton("Type 2");
    private final Derivative transformation;
    private boolean trigger = true;

    public DerivativeSettingsPanel(Derivative derivative) {
        super(new GridBagLayout());
        this.setup();
        this.transformation = derivative;
    }

    public int getType() {
        return this.type1.isSelected() ? 1 : 2;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.transformation != null && itemEvent.getStateChange() == 1 && this.trigger) {
            this.transformation.triggerEvent((byte)16);
        }
    }

    public void setType(int n) {
        this.trigger = false;
        if (n == 2) {
            this.type2.setSelected(true);
        } else {
            this.type1.setSelected(true);
        }
        this.trigger = true;
    }

    private final void setup() {
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Settings"));
        this.add((Component)this.type1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        JLabel jLabel = new JLabel("X(i)=X(i + 1) - X(i)");
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 2, jLabel.getFont().getSize()));
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.add((Component)this.type2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        JLabel jLabel2 = new JLabel("X(i)=(X(i + 1) - X(i - 1)) / 2");
        jLabel2.setFont(new Font(jLabel2.getFont().getFontName(), 2, jLabel2.getFont().getSize()));
        this.add((Component)jLabel2, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.type1.addItemListener(this);
        this.type2.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.type1);
        buttonGroup.add(this.type2);
        this.type1.setSelected(true);
    }

    public void setProperties(Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "type")) {
            this.setType(ScriptHelper.getPropertyInt(properties, "type"));
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("type", String.valueOf(this.getType()));
        return properties;
    }
}

