/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.function;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.polynom.PolynomParser;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.Project_GUI;

public class Function
extends AbstractDataTransform {
    private final PolynomParser polynomParser = new PolynomParser();
    private final JTextField polynomText = new JTextField();
    private final JPanel varPanel = new JPanel(new GridBagLayout());

    public Function(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public Function(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("polynom")) {
            this.polynomText.setText(mapProperty.getLVStringUTF());
        }
    }

    public Function(Transformations transformations, Function function) {
        super(transformations, function);
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        int n = 0;
        int n2 = this.getColumnSize();
        for (int i = 0; i < n2; ++i) {
            if (!this.isIncluded(i)) continue;
            ++n;
        }
        if (n == 0) {
            if (progressManager != null) {
                progressManager.incStep(2 * abstractDataMatrix.getN() * abstractDataMatrix.getK());
            }
            return null;
        }
        PolyNode[] polyNodeArray = new PolyNode[n];
        for (int i = 0; i < n; ++i) {
            polyNodeArray[i] = new PolyNode(6, (char)(65 + i));
        }
        try {
            this.polynomParser.parse(this.polynomText.getText(), polyNodeArray);
        }
        catch (PolynomException polynomException) {
            if (progressManager != null) {
                progressManager.incStep(abstractDataMatrix.getN() * abstractDataMatrix.getK());
            }
            return null;
        }
        if (this.isObs) {
            this.createResults(1, abstractDataMatrix.getK());
        } else {
            this.createResults(abstractDataMatrix.getN(), 1);
        }
        String[] stringArray = new String[]{"function (" + this.polynomText.getText() + ")"};
        if (this.isObs) {
            for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                boolean bl = false;
                int n3 = 0;
                for (int j = 0; j < n2; ++j) {
                    if (!this.isIncluded(j)) continue;
                    if (polyNodeArray[n3].isIncluded()) {
                        bl = abstractDataMatrix.isMissing(j, i);
                        if (bl) break;
                        polyNodeArray[n3].setNum(abstractDataMatrix.getValue(j, i));
                    }
                    ++n3;
                }
                if (bl) {
                    this.results.setValue(0, i, 0.0, true);
                } else {
                    this.results.setValue(0, i, this.polynomParser.evaluateDouble(), false);
                }
                if (progressManager == null) continue;
                progressManager.incStep(2 * abstractDataMatrix.getN());
            }
        } else {
            for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                boolean bl = false;
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    if (!this.isIncluded(j)) continue;
                    if (polyNodeArray[n4].isIncluded()) {
                        bl = abstractDataMatrix.isMissing(i, j);
                        if (bl) break;
                        polyNodeArray[n4].setNum(abstractDataMatrix.getValue(i, j));
                    }
                    ++n4;
                }
                if (bl) {
                    this.results.setValue(i, 0, 0.0, true);
                } else {
                    this.results.setValue(i, 0, this.polynomParser.evaluateDouble(), false);
                }
                if (progressManager == null) continue;
                progressManager.incStep(2 * abstractDataMatrix.getK());
            }
        }
        if (this.isObs) {
            this.setObsDescription(this.results, stringArray);
        } else {
            this.setVarDescription(this.results, stringArray);
        }
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        Function function = new Function(transformations, this);
        function.setPolynom(this.polynomText.getText());
        return function;
    }

    @Override
    public void fillColumn(boolean bl) {
        super.fillColumn(bl);
        this.updatePanel();
    }

    @Override
    public String getName() {
        return "Function";
    }

    @Override
    public String getShortName() {
        return "Function";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 6;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("polynom", this.polynomText.getText());
    }

    @Override
    public void setBySelection(boolean bl) {
        super.setBySelection(bl);
        this.updatePanel();
    }

    @Override
    public boolean setCreated(Project_GUI project_GUI, AbstractDataInfo abstractDataInfo) {
        if (super.setCreated(project_GUI, abstractDataInfo)) {
            this.updatePanel();
            return true;
        }
        return false;
    }

    public void setPolynom(String string) {
        this.polynomText.setText(string);
    }

    @Override
    public void triggerEvent() {
        this.updatePanel();
        super.triggerEvent();
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected boolean hasResultMatrix() {
        return true;
    }

    @Override
    protected void initiateGUILocal() {
        int n = 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)new JLabel("Enter your function"), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.polynomText, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)new JLabel("Example: log(A)"), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)new JLabel("(A+B)/2"), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)new JLabel("Variables:"), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.varPanel, new GridBagConstraints(0, n++, 0, 1, 0.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
        this.polynomText.addActionListener(actionEvent -> this.dataInfo.triggerEvent(new DataInfoEvent(this.dataInfo, this.changeEffects(), this)));
        this.polynomText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Function.this.dataInfo.triggerEvent(new DataInfoEvent(Function.this.dataInfo, Function.this.changeEffects(), Function.this));
            }
        });
        this.updatePanel();
    }

    @Override
    protected void setIcDefault() {
        this.setIcDefault(false);
    }

    @Override
    protected void setIncluded(int n, boolean bl) {
        super.setIncluded(n, bl);
        this.updatePanel();
    }

    private void updatePanel() {
        if (this.mainPanel != null) {
            this.varPanel.removeAll();
            int n = 0;
            Description description = (Description)this.dataInfo.getGroupColumnByType(0);
            InnerColumnString innerColumnString = (InnerColumnString)description.getPrimaryColumn();
            int n2 = this.getColumnSize();
            for (int i = 0; i < n2; ++i) {
                if (!this.isIncluded(i)) continue;
                String string = (char)(65 + n) + " = " + String.valueOf(innerColumnString.getValue(i));
                this.varPanel.add((Component)new JLabel(string), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 12, 0, 6), 0, 0));
            }
            this.varPanel.add((Component)new JLabel(""), new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
            this.mainPanel.invalidate();
            this.mainPanel.validate();
            this.mainPanel.repaint();
        }
    }
}

