/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.interactionterm;

import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class InteractionTerm
extends AbstractDataTransform {
    private AbstractDataMatrix sourceMatrix;
    private int nIncluded;
    private int size;

    public InteractionTerm(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public InteractionTerm(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.sourceMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "src");
        this.size = mapProperty.getPropertyInt("rsize");
        this.nIncluded = mapProperty.getPropertyInt("nincl");
    }

    public InteractionTerm(Transformations transformations, InteractionTerm interactionTerm) {
        super(transformations, interactionTerm);
        if (interactionTerm.sourceMatrix != null) {
            this.sourceMatrix = interactionTerm.sourceMatrix;
            this.size = interactionTerm.size;
        }
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new InteractionTerm(transformations, this);
    }

    @Override
    public int getColumnCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.size;
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (this.sourceMatrix == null) {
            return "";
        }
        int n3 = this.parseRow(this.getFirstRow(n));
        int n4 = this.parseRow(this.getSecondRow(n));
        if (n3 < 0 || n4 < 0) {
            return "";
        }
        return this.sourceMatrix.getColumnDescription(n3, 0) + "*" + this.sourceMatrix.getColumnDescription(n4, 0);
    }

    @Override
    public String getName() {
        return "Interaction term";
    }

    @Override
    public int getOriginatingRow(int n) {
        return this.parseRow(this.getFirstRow(n));
    }

    @Override
    public int getRowCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.sourceMatrix.getN();
    }

    @Override
    public String getShortName() {
        return "Interaction";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public double getValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (abstractDataMatrix == null) {
            return 0.0;
        }
        int n3 = this.parseRow(this.getFirstRow(n2));
        int n4 = this.parseRow(this.getSecondRow(n2));
        return this.sourceMatrix.getScaledValue(n, n3) * this.sourceMatrix.getScaledValue(n, n4);
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.sourceMatrix == null) {
            return 0.0;
        }
        int n3 = this.parseRow(this.getFirstRow(n2));
        int n4 = this.parseRow(this.getSecondRow(n2));
        return this.sourceMatrix.getScaledValue(n, n3) * this.sourceMatrix.getScaledValue(n, n4);
    }

    @Override
    public String[] getVarDescriptionArray() {
        String[] stringArray = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            stringArray[i] = this.getColumnDescription(i, 0);
        }
        return stringArray;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (this.sourceMatrix == null) {
            return false;
        }
        int n3 = this.parseRow(this.getFirstRow(n2));
        int n4 = this.parseRow(this.getSecondRow(n2));
        if (n3 >= 0 && n4 >= 0) {
            return this.sourceMatrix.isMissing(n, n3) || this.sourceMatrix.isMissing(n, n4);
        }
        return true;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("src", this.sourceMatrix);
        randomOutputStream.writePropertyInt("rsize", this.size);
        randomOutputStream.writePropertyInt("nincl", this.nIncluded);
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected void createSourceMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.nIncluded = 0;
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!this.isIncluded(i)) continue;
            ++this.nIncluded;
        }
        this.size = this.nIncluded * (this.nIncluded - 1) / 2;
        this.sourceMatrix = abstractDataMatrix;
    }

    @Override
    protected void setIcDefault() {
        this.setIcDefault(false);
    }

    private int getFirstRow(int n) {
        int n2 = n;
        for (int i = 0; i < this.nIncluded - 1; ++i) {
            int n3 = this.nIncluded - (i + 1);
            if (n2 < n3) {
                return i;
            }
            n2 -= n3;
        }
        return 0;
    }

    private int getSecondRow(int n) {
        int n2 = n;
        for (int i = 0; i < this.nIncluded - 1; ++i) {
            int n3 = this.nIncluded - (i + 1);
            if (n2 < n3) {
                return i + n2 + 1;
            }
            n2 -= n3;
        }
        return 0;
    }

    private int parseRow(int n) {
        int n2 = 0;
        int n3 = this.getColumnSize();
        for (int i = 0; i < n3; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }
}

