/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.logarithm;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.script.ScriptHelper;

public class Logarithm
extends AbstractDataTransform {
    public static final String Name = "Logarithm";
    private AbstractDataMatrix sourceMatrix;
    private int size;
    private final JTextField constantField = new JTextField();
    private final double toLog10 = 1.0 / Math.log(10.0);
    private boolean convertToLog10 = true;
    private double constant = 0.0;
    private JRadioButton addButton;
    private JRadioButton updateButton;
    private ButtonGroup buttonGroup;
    private boolean isAdded = false;
    private boolean includeAll;

    public Logarithm(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public Logarithm(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.sourceMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "src");
        this.size = mapProperty.getPropertyInt("rsize");
        this.constant = mapProperty.getPropertyDouble("const");
        this.isAdded = mapProperty.getPropertyBoolean("added", true);
        this.includeAll = mapProperty.getPropertyBoolean("includeAll", false);
        this.convertToLog10 = mapProperty.getPropertyBoolean("log10", true);
    }

    public Logarithm(Transformations transformations, Logarithm logarithm) {
        this(transformations, logarithm, false, 0.0, false, true);
    }

    public Logarithm(Transformations transformations, Logarithm logarithm, boolean bl, double d, boolean bl2, boolean bl3) {
        super(transformations, logarithm);
        this.isAdded = bl;
        this.constant = d;
        this.includeAll = bl2;
        this.convertToLog10 = bl3;
        if (logarithm.sourceMatrix != null) {
            this.sourceMatrix = logarithm.sourceMatrix;
            this.size = logarithm.size;
        }
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, Matrix matrix, final ProgressManager progressManager) throws Exception {
        final byte[] byArray = this.getIncludedData();
        int n = abstractDataMatrix.getK();
        final int n2 = abstractDataMatrix.getN();
        if (n > 0 && n2 > 0) {
            Threader threader = new Threader(this){
                final /* synthetic */ Logarithm this$0;
                {
                    this.this$0 = logarithm;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        if (byArray == null || byArray[i] > 0) {
                            int n3 = abstractDataMatrix.getMissingCountForColumn(i);
                            for (int j = 0; j < n2; ++j) {
                                if (n3 == 0 || !abstractDataMatrix.isMissing(j, i)) {
                                    double d = abstractDataMatrix.getValue(j, i) + this.this$0.constant;
                                    if (d <= 0.0) {
                                        abstractDataMatrix.setValue(j, i, 0.0, true);
                                    } else {
                                        double d2 = Math.log(d);
                                        if (this.this$0.convertToLog10) {
                                            d2 *= this.this$0.toLog10;
                                        }
                                        abstractDataMatrix.setValue(j, i, d2);
                                    }
                                }
                                if (!bl || progressManager == null) continue;
                                progressManager.incStep(2);
                            }
                            continue;
                        }
                        if (!bl || progressManager == null) continue;
                        progressManager.incStep(2 * n2);
                    }
                }
            };
            threader.execute(n);
        }
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new Logarithm(transformations, this, this.isAdded, this.constant, this.includeAll, this.convertToLog10);
    }

    @Override
    public int getColumnCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.size;
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n) {
                StringBuilder stringBuilder = new StringBuilder("log ").append(this.sourceMatrix.getColumnDescription(i, 0));
                if (this.constant != 0.0) {
                    stringBuilder.append(" (C = ").append(this.constant).append(")");
                }
                return stringBuilder.toString();
            }
            ++n3;
        }
        return "";
    }

    public double getConstant() {
        if (this.isCorrectInput()) {
            return Double.parseDouble(this.constantField.getText());
        }
        return 0.0;
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public int getRowCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.sourceMatrix.getN();
    }

    @Override
    public String getShortName() {
        return "Log";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return this.isAdded ? AbstractTransform.Type.localAdd : AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.sourceMatrix == null) {
            return 0.0;
        }
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n2) {
                double d = this.sourceMatrix.getValue(n, i) + this.constant;
                if (d <= 0.0) {
                    return 0.0;
                }
                double d2 = Math.log(d);
                if (this.convertToLog10) {
                    d2 *= this.toLog10;
                }
                return d2;
            }
            ++n3;
        }
        return 0.0;
    }

    @Override
    public String[] getVarDescriptionArray() {
        String[] stringArray = new String[this.size];
        int n = 0;
        int n2 = this.getColumnSize();
        for (int i = 0; i < n2 && n < this.size; ++i) {
            if (!this.isIncluded(i)) continue;
            stringArray[n] = "log " + this.sourceMatrix.getColumnDescription(i, 0);
            if (this.constant != 0.0) {
                int n3 = n;
                stringArray[n3] = stringArray[n3] + " (C = " + this.constant + ")";
            }
            ++n;
        }
        return stringArray;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (this.sourceMatrix == null) {
            return false;
        }
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n2) {
                return this.sourceMatrix.isMissing(n, i) || this.sourceMatrix.getValue(n, i) + this.constant <= 0.0;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void reverseTransformationLocal(final AbstractDataMatrix abstractDataMatrix, Matrix matrix, boolean bl) throws Exception {
        if (this.isAdded) {
            return;
        }
        final byte[] byArray = this.getIncludedData();
        int n = abstractDataMatrix.getK();
        final int n2 = abstractDataMatrix.getN();
        if (n > 0 && n2 > 0) {
            Threader threader = new Threader(this){
                final /* synthetic */ Logarithm this$0;
                {
                    this.this$0 = logarithm;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        if (byArray != null && byArray[i] <= 0) continue;
                        int n3 = abstractDataMatrix.getMissingCountForColumn(i);
                        for (int j = 0; j < n2; ++j) {
                            double d;
                            if (n3 != 0 && abstractDataMatrix.isMissing(j, i) || !((d = abstractDataMatrix.getValue(j, i)) > 0.0)) continue;
                            if (this.this$0.convertToLog10) {
                                d /= this.this$0.toLog10;
                            }
                            abstractDataMatrix.setValue(j, i, Math.exp(d) - this.this$0.constant);
                        }
                    }
                }
            };
            threader.execute(n);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("src", this.sourceMatrix);
        randomOutputStream.writePropertyInt("rsize", this.size);
        randomOutputStream.writePropertyDouble("const", this.constant);
        randomOutputStream.writePropertyBoolean("added", this.isAdded);
        randomOutputStream.writePropertyBoolean("includeAll", this.includeAll);
        randomOutputStream.writePropertyBoolean("log10", this.convertToLog10);
    }

    @Override
    public double scaleValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, double d) {
        if (this.isIncluded(n2)) {
            double d2 = d + this.constant;
            if (d2 <= 0.0) {
                return 0.0;
            }
            double d3 = Math.log(d2);
            if (this.convertToLog10) {
                d3 *= this.toLog10;
            }
            return d3;
        }
        return d;
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (properties != null) {
            if (ScriptHelper.hasValue(properties, "variable", "new")) {
                if (this.addButton != null) {
                    this.addButton.setSelected(true);
                }
                this.isAdded = true;
            }
            if (properties.containsKey("constant")) {
                this.constant = ScriptHelper.getPropertyDouble(properties, "constant");
                this.constantField.setText(String.valueOf(this.constant));
            }
            if (properties.containsKey("includeAll")) {
                this.includeAll = true;
            }
            if (properties.containsKey("log10")) {
                this.convertToLog10 = ScriptHelper.getPropertyBool(properties, "log10");
            }
        } else {
            super.setExtraArgument(properties);
        }
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.isIncluded(n4)) {
            double d2 = d + this.constant;
            if (d2 <= 0.0) {
                return 0.0;
            }
            double d3 = Math.log(d2);
            if (this.convertToLog10) {
                d3 *= this.toLog10;
            }
            return d3;
        }
        return d;
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected void createSourceMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.size = 0;
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!this.isIncluded(i)) continue;
            ++this.size;
        }
        this.sourceMatrix = abstractDataMatrix;
    }

    @Override
    protected void initiateGUILocal() {
        int n = 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)new JLabel("Enter constant C ( log(X + C) )"), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.constantField, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        if (this.constant != 0.0) {
            this.constantField.setText(Double.toString(this.constant));
        } else {
            this.constantField.setText("");
        }
        this.constantField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = Logarithm.this.isCorrectInput() || Logarithm.this.constantField.getText().length() == 0;
                Logarithm.this.constantField.setForeground(bl ? Color.BLACK : Color.RED);
                if (bl) {
                    Logarithm.this.dataInfo.triggerEvent(new DataInfoEvent(Logarithm.this.dataInfo, 8, Logarithm.this));
                    Logarithm.this.constant = Logarithm.this.getConstant();
                    Logarithm.this.constantField.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.initButtons();
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Add logarithm as:"));
        jPanel2.add(this.updateButton);
        jPanel2.add(this.addButton);
    }

    @Override
    protected void setIcDefault() {
        this.setIcDefault(this.includeAll);
    }

    private void initButtons() {
        this.addButton = new JRadioButton("New variable");
        this.addButton.setActionCommand("add");
        this.updateButton = new JRadioButton("Update of variable");
        this.updateButton.setActionCommand("update");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.addButton);
        this.buttonGroup.add(this.updateButton);
        if (this.isAdded) {
            this.addButton.setSelected(true);
        } else {
            this.updateButton.setSelected(true);
        }
        ActionListener actionListener = actionEvent -> {
            if (actionEvent.getActionCommand().equals("add")) {
                if (this.isAdded) {
                    return;
                }
                this.isAdded = true;
            } else {
                if (!this.isAdded) {
                    return;
                }
                this.isAdded = false;
            }
            this.dataInfo.triggerGlobalEvent(new DataInfoEvent(this.dataInfo, 6, this));
        };
        this.addButton.addActionListener(actionListener);
        this.updateButton.addActionListener(actionListener);
    }

    private boolean isCorrectInput() {
        try {
            Double.parseDouble(this.constantField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

