/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.msc;

import java.io.IOException;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.QR;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class MscTransform
extends AbstractDataTransform {
    private final double[] cacheResult = new double[2];
    private int cacheRow = -1;
    private AbstractDataMatrix cacheMatrix;

    public MscTransform(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public MscTransform(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public MscTransform(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
    }

    @Override
    public boolean appliesToY() {
        return false;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, final Matrix matrix, final ProgressManager progressManager) throws Exception {
        int n = abstractDataMatrix.getN();
        final int n2 = abstractDataMatrix.getK();
        final int[] nArray = abstractDataMatrix.getMissingCountForRows(false);
        final byte[] byArray = this.getIncludedData();
        Threader threader = new Threader(this){
            final /* synthetic */ MscTransform this$0;
            {
                this.this$0 = mscTransform;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doOp(boolean bl, int n, int n22) {
                DenseMatrix denseMatrix = new DenseMatrix(n2, 2);
                DenseMatrix denseMatrix2 = new DenseMatrix(2, 1);
                DenseMatrix denseMatrix3 = new DenseMatrix(n2, 1);
                for (int i = n; i < n22; ++i) {
                    int n3;
                    int n4;
                    int n5 = nArray != null ? nArray[i] : 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        denseMatrix.set(n4, 1, 1.0);
                    }
                    for (n4 = denseMatrix.numColumns() - 2; n4 >= 0; --n4) {
                        for (n3 = 0; n3 < n2; ++n3) {
                            denseMatrix.set(n3, n4, this.this$0.intermediateMatrix.getValue(n3, 0) * denseMatrix.get(n3, n4 + 1));
                        }
                    }
                    if (n2 > 1) {
                        QR qR;
                        1 var10_13 = this;
                        synchronized (var10_13) {
                            qR = QR.factorize((Matrix)denseMatrix);
                        }
                        var10_13 = qR.getQ();
                        int n6 = var10_13.numColumns();
                        int n7 = var10_13.numRows();
                        DenseMatrix denseMatrix4 = new DenseMatrix(n6, 1);
                        for (int j = 0; j < n6; ++j) {
                            double d = 0.0;
                            for (int k = 0; k < n7; ++k) {
                                d += var10_13.get(k, j) * matrix.get(i, k);
                            }
                            denseMatrix4.set(j, 0, d);
                        }
                        try {
                            qR.getR().solve((Matrix)denseMatrix4, (Matrix)denseMatrix2);
                        }
                        catch (Exception exception) {
                            System.out.println("MSC transform, cannot solve: " + exception.getMessage());
                        }
                    } else {
                        for (n4 = 0; n4 < n2; ++n4) {
                            denseMatrix3.set(n4, 0, matrix.get(i, n4));
                        }
                        denseMatrix.solve((Matrix)denseMatrix3, (Matrix)denseMatrix2);
                    }
                    double[] dArray = denseMatrix2.getData();
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (byArray != null && byArray[n3] <= 0 || n5 != 0 && abstractDataMatrix.isMissing(i, n3)) continue;
                        double d = matrix.get(i, n3) - dArray[1];
                        double d2 = dArray[0];
                        if (Double.compare(d2, 0.0) == 0) {
                            matrix.set(i, n3, 0.0);
                            continue;
                        }
                        matrix.set(i, n3, d / d2);
                    }
                    if (progressManager == null) continue;
                    progressManager.incStep(n2);
                }
            }
        };
        threader.execute(n);
        return abstractDataMatrix;
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.cacheMatrix = null;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new MscTransform(transformations, this);
    }

    @Override
    public String getName() {
        return "MSC Transform";
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public String getShortName() {
        return "MSC";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    public void reverseTransformationLocal(AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
        int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        byte[] byArray = this.getIncludedData();
        for (int i = 0; i < n2; ++i) {
            int n3 = abstractDataMatrix.getMissingCountForRow(i);
            double[] dArray = abstractDataMatrix.polyFitRow(i, this.intermediateMatrix, 1, null);
            for (int j = 0; j < n; ++j) {
                if (byArray != null && byArray[j] <= 0 || n3 != 0 && abstractDataMatrix.isMissing(i, j)) continue;
                double d = abstractDataMatrix.getValue(i, j) * dArray[0] + dArray[1];
                abstractDataMatrix.setValue(i, j, d);
            }
        }
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.isIncluded(n4)) {
            if (abstractDataMatrix != this.cacheMatrix || n != this.cacheRow) {
                this.cacheMatrix = abstractDataMatrix;
                this.cacheRow = n;
                double[] dArray = abstractDataMatrix.polyFitRow(n, this.intermediateMatrix, 1, this);
                this.cacheResult[0] = dArray[0];
                this.cacheResult[1] = dArray[1];
            }
            return (d - this.cacheResult[1]) / this.cacheResult[0];
        }
        return d;
    }

    @Override
    protected void calculateIntermediateMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
        int n = abstractDataMatrix.getK();
        if (bl || this.intermediateMatrix == null || this.intermediateMatrix.getN() < n) {
            this.createIntermediateMatrix(abstractDataMatrix, "Mean spectrum of X Training");
            abstractDataMatrix.calculateColumnMean(progressManager, this.intermediateMatrix);
        }
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected String getWorkflowName() {
        return "MSC";
    }

    @Override
    protected String getWorkflowTransformName() {
        return "centervalues";
    }
}

