/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.quadterm;

import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class QuadTerm
extends AbstractDataTransform {
    private AbstractDataMatrix sourceMatrix;
    private int size;

    public QuadTerm(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public QuadTerm(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.sourceMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "src");
        this.size = mapProperty.getPropertyInt("rsize");
    }

    public QuadTerm(Transformations transformations, QuadTerm quadTerm) {
        super(transformations, quadTerm);
        if (quadTerm.sourceMatrix != null) {
            this.sourceMatrix = quadTerm.sourceMatrix;
            this.size = quadTerm.size;
        }
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new QuadTerm(transformations, this);
    }

    @Override
    public int getColumnCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.size;
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n) {
                return this.sourceMatrix.getColumnDescription(i, 0) + "^2";
            }
            ++n3;
        }
        return "";
    }

    @Override
    public String getName() {
        return "Quad Term";
    }

    @Override
    public int getRowCount() {
        if (this.sourceMatrix == null) {
            return 0;
        }
        return this.sourceMatrix.getN();
    }

    @Override
    public String getShortName() {
        return "Quad";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public double getValue(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (abstractDataMatrix == null) {
            return 0.0;
        }
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n2) {
                double d = this.sourceMatrix.getValue(n, i);
                return d * d;
            }
            ++n3;
        }
        return 0.0;
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.sourceMatrix == null) {
            return 0.0;
        }
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n2) {
                double d = this.sourceMatrix.getValue(n, i);
                return d * d;
            }
            ++n3;
        }
        return 0.0;
    }

    @Override
    public String[] getVarDescriptionArray() {
        String[] stringArray = new String[this.size];
        int n = 0;
        int n2 = this.getColumnSize();
        for (int i = 0; i < n2 && n < this.size; ++i) {
            if (!this.isIncluded(i)) continue;
            stringArray[n] = this.sourceMatrix.getColumnDescription(i, 0) + "^2";
            ++n;
        }
        return stringArray;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        if (this.sourceMatrix == null) {
            return false;
        }
        int n3 = 0;
        int n4 = this.getColumnSize();
        for (int i = 0; i < n4; ++i) {
            if (!this.isIncluded(i)) continue;
            if (n3 == n2) {
                return this.sourceMatrix.isMissing(n, i);
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("src", this.sourceMatrix);
        randomOutputStream.writePropertyInt("rsize", this.size);
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected void createSourceMatrix(AbstractDataMatrix abstractDataMatrix) {
        this.size = 0;
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!this.isIncluded(i)) continue;
            ++this.size;
        }
        this.sourceMatrix = abstractDataMatrix;
    }

    @Override
    protected void setIcDefault() {
        this.setIcDefault(false);
    }
}

