/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.reduce;

import java.util.Vector;
import javax.swing.JComponent;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransformInfo;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.DataTransformSettingsPanel;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceSettingsPanel;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceToAverage;

public class ReduceInfo
extends AbstractDataTransformInfo {
    private ReduceSettingsPanel settingsPanel = null;

    @Override
    public boolean appliesToObservations() {
        return true;
    }

    @Override
    public boolean appliesToVariables() {
        return false;
    }

    @Override
    public AbstractTransform createTransform(AbstractDataMatrix abstractDataMatrix, boolean bl, AbstractDataInfo abstractDataInfo) {
        ReduceToAverage reduceToAverage = new ReduceToAverage(abstractDataInfo, bl);
        this.applySettingsToTransform(reduceToAverage);
        reduceToAverage.setSettingsPanel(this.settingsPanel, abstractDataMatrix);
        return reduceToAverage;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = super.createWizard();
        this.settingsPanel = new ReduceSettingsPanel();
        vector.add(this.settingsPanel);
        return vector;
    }

    public Vector<JComponent> createWizard(DataSet dataSet, AbstractDataInfo abstractDataInfo, AbstractDataInfo abstractDataInfo2) {
        Vector<JComponent> vector = super.createWizard();
        DataTransformSettingsPanel dataTransformSettingsPanel = (DataTransformSettingsPanel)vector.remove(0);
        this.settingsPanel = new ReduceSettingsPanel(dataTransformSettingsPanel, dataSet, abstractDataInfo, abstractDataInfo2);
        vector.add(this.settingsPanel);
        return vector;
    }

    @Override
    public AbstractTransform.Type getType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public String getWizardInfo() {
        return "This transformation reduces groups of a given size to their average.";
    }

    @Override
    public boolean hasPages() {
        return true;
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        AbstractDataMatrix abstractDataMatrix = null;
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
        } else if (dataTreeInterface instanceof DataSet) {
            abstractDataMatrix = ((DataSet)dataTreeInterface).getOriginalMatrix();
        }
        return abstractDataMatrix != null;
    }

    @Override
    public String toString() {
        return "Reduce to Average";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.settingsPanel != null) {
            this.settingsPanel.cleanUp();
            this.settingsPanel = null;
        }
    }
}

