/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.reduce;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.DataTransformSettingsPanel;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.register.RegisterKeyManager;

public class ReduceSettingsPanel
extends WizardPageClass {
    private final JTextFieldButtonUppDown groupSize = new JTextFieldButtonUppDown(2.0, 2.147483647E9, false);
    private final JRadioButton allCheckBox = new JRadioButton("All active observations as a single group");
    private final JRadioButton groupCheckBox = new JRadioButton("Groups of size");
    private final JRadioButton classCheckBox = new JRadioButton("Category");
    private final JRadioButton rowCheckBox = new JRadioButton("By row");
    private final JRadioButton columnCheckBox = new JRadioButton("By column");
    private final JComboBox comboBoxClass = new JComboBox();
    private DataSet dataSet;

    public ReduceSettingsPanel() {
        this(null, null, null, null);
    }

    public ReduceSettingsPanel(DataTransformSettingsPanel dataTransformSettingsPanel, DataSet dataSet, AbstractDataInfo abstractDataInfo, AbstractDataInfo abstractDataInfo2) {
        this.dataSet = dataSet;
        dataTransformSettingsPanel.setIncludeBy(3);
        this.jbinit(dataTransformSettingsPanel);
    }

    public int getGroupSize() {
        if (this.allCheckBox.isSelected() && !this.groupCheckBox.isSelected()) {
            return 1;
        }
        return (int)this.groupSize.getNumber();
    }

    public byte getGroupType() {
        if (this.classCheckBox.isSelected()) {
            return 2;
        }
        if (this.groupCheckBox.isSelected()) {
            return 1;
        }
        if (this.rowCheckBox.isSelected()) {
            return 3;
        }
        if (this.columnCheckBox.isSelected()) {
            return 4;
        }
        return 0;
    }

    public InnerColumnClass getSelectedClass() {
        if (this.comboBoxClass.getSelectedItem() == null) {
            this.updateClasses();
        }
        return (InnerColumnClass)this.comboBoxClass.getSelectedItem();
    }

    @Override
    public void pageShown() {
        SwingUtilities.invokeLater(() -> {});
    }

    public void updateClasses() {
        this.comboBoxClass.removeAllItems();
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        if (observationInfo != null) {
            Transformations transformations = observationInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                this.comboBoxClass.addItem(transformations.getInnerColumn(i));
            }
            PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
            if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
                for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                    this.comboBoxClass.addItem(predictionClasses.getInnerColumn(i));
                }
            }
        }
        this.classCheckBox.setEnabled(this.comboBoxClass.getItemCount() > 0);
    }

    @Override
    protected void cleanUpChild() {
        this.dataSet = null;
    }

    private void jbinit(DataTransformSettingsPanel dataTransformSettingsPanel) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.updateClasses();
        this.groupSize.setEnabled(false);
        this.comboBoxClass.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.groupCheckBox);
        buttonGroup.add(this.allCheckBox);
        buttonGroup.add(this.classCheckBox);
        buttonGroup.add(this.rowCheckBox);
        buttonGroup.add(this.columnCheckBox);
        this.allCheckBox.setSelected(true);
        CItemListener cItemListener = new CItemListener();
        this.allCheckBox.addItemListener(cItemListener);
        this.groupCheckBox.addItemListener(cItemListener);
        this.classCheckBox.addItemListener(cItemListener);
        this.comboBoxClass.addItemListener(cItemListener);
        this.rowCheckBox.addItemListener(cItemListener);
        this.columnCheckBox.addItemListener(cItemListener);
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Reduce to Average Settings"));
        jPanel.add((Component)new JLabel("Calculate averages from"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(24, 12, 0, 6), 0, 0));
        jPanel.add((Component)this.allCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(24, 36, 0, 24), 0, 0));
        jPanel.add((Component)this.groupCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(24, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.groupSize, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(24, 12, 0, 24), 0, 0));
        jPanel.add((Component)this.classCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(24, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.comboBoxClass, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(24, 12, 6, 36), 0, 0));
        if (RegisterKeyManager.isPredikteraLicense()) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Image Specific"));
            jPanel2.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
            jPanel2.add((Component)this.rowCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
            jPanel2.add((Component)this.columnCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        }
        jPanel.add((Component)new JLabel(""), new GridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)dataTransformSettingsPanel, "North");
        this.add((Component)jPanel, "Center");
    }

    private void setEnabled() {
        this.groupSize.setEnabled(this.groupCheckBox.isSelected());
        this.comboBoxClass.setEnabled(this.classCheckBox.isSelected());
    }

    class CItemListener
    implements ItemListener {
        CItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ReduceSettingsPanel.this.setEnabled();
        }
    }
}

