/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.reduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.util.Properties;
import javax.swing.SwingUtilities;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceSettingsPanel;
import se.prediktera.map.datasetcontainer.transform.reduce.SettingsPanel;
import se.prediktera.map.main.script.ScriptHelper;

public class ReduceToAverage
extends AbstractDataTransform {
    private SettingsPanel settingsPanel = new SettingsPanel(this);
    private int foldN;
    public boolean calcFastAverage = false;

    public ReduceToAverage(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public ReduceToAverage(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.settingsPanel.LoadProperty(randomInputStream, mapProperty);
    }

    public ReduceToAverage(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        int n;
        final int n2 = this.settingsPanel.getGroupSize();
        final int n3 = abstractDataMatrix.getN();
        int n4 = abstractDataMatrix.getK();
        final int[] nArray = abstractDataMatrix.getNref();
        abstractDataMatrix.beginCalculations();
        final byte by = this.settingsPanel.getGroupType();
        final InnerColumnClass innerColumnClass = this.settingsPanel.getSelectedClass();
        if (by == 1) {
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if (!this.isIncluded(i)) continue;
                ++n5;
            }
            n = (int)Math.ceil((double)n5 / (double)n2);
        } else if (by == 2) {
            n = innerColumnClass.getObject().size();
        } else if (by == 3 || by == 4) {
            FoldMatrix foldMatrix = new FoldMatrix(abstractDataMatrix);
            n = by == 3 ? foldMatrix.getN() : foldMatrix.getK();
            this.foldN = foldMatrix.getFoldN();
            foldMatrix.cleanUp();
        } else {
            n = 1;
        }
        final String[] stringArray = new String[n];
        if (by == 0) {
            stringArray[0] = "Average all";
        } else if (by == 2) {
            ClassTypes classTypes = innerColumnClass.getObject();
            for (var13_18 = 0; var13_18 < classTypes.size(); ++var13_18) {
                stringArray[var13_18] = "Avg (" + classTypes.getTypeDescription(var13_18) + ")";
            }
        } else if (by == 3 || by == 4) {
            String string = by == 3 ? "row" : "column";
            for (var13_18 = 0; var13_18 < n; ++var13_18) {
                stringArray[var13_18] = "Avg (" + string + ": " + (var13_18 + 1) + ")";
            }
        }
        final InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        final int[][] nArray2 = new int[n4][n];
        if (this.isObs) {
            this.createResults(n, n4);
            this.results.beginCalculations();
            final boolean bl = abstractDataMatrix.hasMissing();
            final Matrix matrix2 = this.results.getInternalMatrixPublic();
            if (this.calcFastAverage && !bl && by == 0 && n == 1) {
                this.fastRowAverage(n3, n4, innerColumnBoolean, abstractDataMatrix);
            } else {
                Threader threader = new Threader(this){
                    final /* synthetic */ ReduceToAverage this$0;
                    {
                        this.this$0 = reduceToAverage;
                    }

                    @Override
                    protected void doOp(boolean bl2, int n7, int n22) {
                        for (int i = n7; i < n22; ++i) {
                            int n32;
                            int n4 = 0;
                            int n5 = 0;
                            for (n32 = 0; n32 < n3; ++n32) {
                                if (innerColumnBoolean == null || !innerColumnBoolean.getValueBool(n32)) continue;
                                ++n4;
                                if (bl && abstractDataMatrix.isMissing(n32, i)) continue;
                                double d = abstractDataMatrix.getValue(n32, i);
                                if (by == 2) {
                                    n5 = innerColumnClass.getValueShort(nArray != null ? nArray[n32] : n32);
                                } else if (bl2 && by == 1) {
                                    stringArray[n5] = "Avg (" + abstractDataMatrix.getRowDescription(n32, 0) + ")";
                                } else if (by == 3) {
                                    n5 = n32 % this.this$0.foldN;
                                } else if (by == 4) {
                                    n5 = n32 / this.this$0.foldN;
                                }
                                matrix2.add(n5, i, d);
                                int[] nArray3 = nArray2[i];
                                int n6 = n5++;
                                nArray3[n6] = nArray3[n6] + 1;
                                if (by != 1 || n4 < n2) continue;
                                n4 = 0;
                            }
                            for (n32 = 0; n32 < n; ++n32) {
                                if (nArray2[i][n32] == 0) {
                                    this.this$0.results.setValue(n32, i, 0.0, true);
                                    continue;
                                }
                                matrix2.set(n32, i, matrix2.get(n32, i) / (double)nArray2[i][n32]);
                            }
                        }
                    }
                };
                threader.execute(n4);
            }
            this.setObsDescription(this.results, stringArray);
        } else {
            this.createResults(n3, n);
            this.results.beginCalculations();
            Threader threader = new Threader(this){
                final /* synthetic */ ReduceToAverage this$0;
                {
                    this.this$0 = reduceToAverage;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = 0; i < n3; ++i) {
                        int n32 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        double d = 0.0;
                        for (int j = n; j < n22; ++j) {
                            if (!innerColumnBoolean.getValueBool(j)) continue;
                            if (abstractDataMatrix.isMissing(i, j)) {
                                ++n4;
                            }
                            d += abstractDataMatrix.getValue(i, j);
                            ++n32;
                            if (bl && stringArray[n5] == null) {
                                stringArray[n5] = abstractDataMatrix.getColumnDescription(j, 0) + " - Avg";
                            }
                            if (n32 < n2) continue;
                            if (n32 == n4) {
                                this.this$0.results.setValue(i, n5, 0.0, true);
                            } else {
                                this.this$0.results.setValue(i, n5, d /= (double)(n32 - n4));
                            }
                            ++n5;
                            n32 = 0;
                            d = 0.0;
                        }
                        if (n32 <= 0) continue;
                        if (n32 == n4) {
                            this.this$0.results.setValue(i, n5, 0.0, true);
                            continue;
                        }
                        this.this$0.results.setValue(i, n5, d /= (double)(n32 - n4));
                    }
                }
            };
            threader.execute(n3);
            this.setVarDescription(this.results, stringArray);
        }
        this.results.endCalculations();
        abstractDataMatrix.endCalculations();
        return this.results;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new ReduceToAverage(transformations, this);
    }

    @Override
    public String getName() {
        return "Reduce to Average";
    }

    @Override
    public String getShortName() {
        return "Reduce";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 12;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        this.settingsPanel.SaveProperty(randomOutputStream);
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "grouptype")) {
                this.settingsPanel.setGroupType(ScriptHelper.getProperty(properties, "grouptype"));
            }
            if (ScriptHelper.hasKey(properties, "category")) {
                this.settingsPanel.setCategory(ScriptHelper.getProperty(properties, "category"));
            }
            if (ScriptHelper.hasKey(properties, "groupsize")) {
                this.settingsPanel.setGroupSize(ScriptHelper.getPropertyInt(properties, "groupsize"));
            }
        } else {
            super.setExtraArgument(properties);
        }
    }

    public void setSettingsPanel(ReduceSettingsPanel reduceSettingsPanel, AbstractDataMatrix abstractDataMatrix) {
        boolean bl = this.settingsPanel.getDoEvent();
        this.settingsPanel.setDoEvent(false);
        this.settingsPanel.setGroupType(reduceSettingsPanel.getGroupType());
        this.settingsPanel.setGroupSize(reduceSettingsPanel.getGroupSize());
        this.settingsPanel.setSelectedClass(reduceSettingsPanel.getSelectedClass());
        this.settingsPanel.setDoEvent(bl);
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        return d;
    }

    @Override
    public void workDone(ProgressManager progressManager) {
        byte by;
        super.workDone(progressManager);
        if (progressManager != null && (by = this.settingsPanel.getGroupType()) == 2) {
            SwingUtilities.invokeLater(() -> this.settingsPanel.finishTransformation());
        }
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.settingsPanel != null) {
            this.settingsPanel.cleanUp();
            this.settingsPanel = null;
        }
    }

    @Override
    protected boolean hasResultMatrix() {
        return true;
    }

    @Override
    protected void initiateGUILocal() {
        this.mainPanel.add((Component)this.settingsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    protected void setIcDefault() {
        this.setIcDefault(false);
    }

    private void fastRowAverage(final int n, int n2, InnerColumnBoolean innerColumnBoolean, final AbstractDataMatrix abstractDataMatrix) {
        final boolean[] blArray = new boolean[n];
        if (innerColumnBoolean != null) {
            for (int i = 0; i < n; ++i) {
                blArray[i] = innerColumnBoolean.getValueBool(i);
            }
        }
        final Matrix matrix = this.results.getInternalMatrixPublic();
        Threader threader = new Threader(this){
            final /* synthetic */ ReduceToAverage this$0;
            {
                this.this$0 = reduceToAverage;
            }

            @Override
            protected void doOp(boolean bl, int n4, int n2) {
                for (int i = n4; i < n2; ++i) {
                    int n3 = 0;
                    for (int j = 0; j < n; ++j) {
                        if (blArray[j]) continue;
                        double d = abstractDataMatrix.getValue(j, i);
                        matrix.add(0, i, d);
                        ++n3;
                    }
                    if (n3 == 0) {
                        this.this$0.results.setValue(0, i, 0.0, true);
                        continue;
                    }
                    matrix.set(0, i, matrix.get(0, i) / (double)n3);
                }
            }
        };
        threader.execute(n2);
    }
}

