/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.reduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceToAverage;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.register.RegisterKeyManager;

public class SettingsPanel
extends CleanUpPanel
implements JValidateNumberField.NumberChangedInterface {
    public static final byte ALLINONEGROUP = 0;
    public static final byte BYGROUP = 1;
    public static final byte BYCLASS = 2;
    public static final byte BYROW = 3;
    public static final byte BYCOLUMN = 4;
    private ReduceToAverage transformation;
    private final JTextFieldButtonUppDown groupSize = new JTextFieldButtonUppDown(2.0, 2.147483647E9, false);
    private final JRadioButton allCheckBox = new JRadioButton("All included observations");
    private final JCheckBox groupCheckBox = new JCheckBox("By group size");
    private final JRadioButton classCheckBox = new JRadioButton("By category");
    private final JRadioButton rowCheckBox = new JRadioButton("By row");
    private final JRadioButton columnCheckBox = new JRadioButton("By column");
    private final JComboBox comboBoxClass = new JComboBox();
    private boolean doevent = true;

    public SettingsPanel(ReduceToAverage reduceToAverage) {
        super(new GridBagLayout());
        this.transformation = reduceToAverage;
        this.transformation.getDataInfo().addListener(dataInfoEvent -> {
            if (dataInfoEvent.hasClassChanged()) {
                this.updateClasses();
            }
            return true;
        });
        this.updateClasses();
        this.groupSize.setNumberChangedInterface(this);
        this.groupSize.setEnabled(false);
        this.comboBoxClass.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allCheckBox);
        buttonGroup.add(this.classCheckBox);
        buttonGroup.add(this.rowCheckBox);
        buttonGroup.add(this.columnCheckBox);
        this.allCheckBox.setSelected(true);
        CItemListener cItemListener = new CItemListener();
        this.allCheckBox.addItemListener(cItemListener);
        this.groupCheckBox.addItemListener(cItemListener);
        this.classCheckBox.addItemListener(cItemListener);
        this.comboBoxClass.addItemListener(cItemListener);
        this.rowCheckBox.addItemListener(cItemListener);
        this.columnCheckBox.addItemListener(cItemListener);
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Settings"));
        this.add((Component)this.allCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)this.groupCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 0, 6), 0, 0));
        this.add((Component)new JLabel("Group size"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.groupSize, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)this.classCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)new JLabel("Category"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 0, 0), 0, 0));
        this.add((Component)this.comboBoxClass, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        if (RegisterKeyManager.isPredikteraLicense()) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Image Specific"));
            jPanel.setLayout(new GridBagLayout());
            this.add((Component)jPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.rowCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
            jPanel.add((Component)this.columnCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        }
        this.add((Component)new JLabel(""), new GridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void finishTransformation() {
        AbstractDataInfo abstractDataInfo = this.transformation.getDataInfo();
        DataSet dataSet = abstractDataInfo.getDataSet();
        TransformMatrix transformMatrix = dataSet.getResultMatrix();
        InnerColumnClass innerColumnClass = this.getSelectedClass();
        int[] nArray = transformMatrix.getIndexForTransformation(!this.transformation.isObservation(), this.transformation);
        if (nArray != null) {
            int n = innerColumnClass.getSize();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= n) continue;
                innerColumnClass.setValueShort(nArray[i], (short)i);
            }
            abstractDataInfo.triggerGlobalEvent(new DataInfoClassEvent(abstractDataInfo, 2, innerColumnClass.getCategory(), innerColumnClass.getObject(), 3));
        }
    }

    public boolean getDoEvent() {
        return this.doevent;
    }

    public int getGroupSize() {
        if (this.allCheckBox.isSelected() && !this.groupCheckBox.isSelected()) {
            return 1;
        }
        return (int)this.groupSize.getNumber();
    }

    public byte getGroupType() {
        if (this.classCheckBox.isSelected()) {
            return 2;
        }
        if (this.groupCheckBox.isSelected()) {
            return 1;
        }
        if (this.rowCheckBox.isSelected()) {
            return 3;
        }
        if (this.columnCheckBox.isSelected()) {
            return 4;
        }
        return 0;
    }

    public InnerColumnClass getSelectedClass() {
        if (this.comboBoxClass.getSelectedItem() == null) {
            this.updateClasses();
        }
        return (InnerColumnClass)this.comboBoxClass.getSelectedItem();
    }

    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) {
        this.doevent = false;
        byte by = mapProperty.getPropertyByte("groupType", (byte)0);
        if (by == 0 || by == 1) {
            this.allCheckBox.setSelected(true);
        } else {
            this.classCheckBox.setSelected(true);
        }
        this.groupCheckBox.setSelected(by == 1);
        this.groupSize.setNumber(mapProperty.getPropertyInt("groupSize", 2));
        int n = mapProperty.getPropertyInt("classIndex", -1);
        if (n < this.comboBoxClass.getItemCount()) {
            this.comboBoxClass.setSelectedIndex(n);
        }
        this.setEnabled();
        this.doevent = true;
    }

    @Override
    public void NumberChanged(int n, double d) {
        if (this.doevent) {
            this.transformation.triggerEvent();
        }
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyByte("groupType", this.getGroupType());
        randomOutputStream.writePropertyInt("groupSize", (int)this.groupSize.getNumber());
        randomOutputStream.writePropertyInt("classIndex", this.comboBoxClass.getSelectedIndex());
    }

    public void setCategory(String string) {
        for (int i = 0; i < this.comboBoxClass.getItemCount(); ++i) {
            String string2 = String.valueOf(this.comboBoxClass.getItemAt(i));
            if (!string.equalsIgnoreCase(string2 = EvinceScriptCommands.removeSpace(string2))) continue;
            this.comboBoxClass.setSelectedIndex(i);
            break;
        }
    }

    public void setDoEvent(boolean bl) {
        this.doevent = bl;
    }

    public void setGroupSize(int n) {
        if (n < 2) {
            this.allCheckBox.setSelected(true);
        } else {
            this.groupSize.setNumber(n);
        }
    }

    public void setGroupType(byte by) {
        switch (by) {
            case 2: {
                this.classCheckBox.setSelected(true);
                break;
            }
            case 1: {
                this.groupCheckBox.setSelected(true);
                break;
            }
            case 3: {
                this.rowCheckBox.setSelected(true);
                break;
            }
            case 4: {
                this.columnCheckBox.setSelected(true);
            }
        }
    }

    public void setGroupType(String string) {
        if ((string = string.toLowerCase()).equals("all")) {
            this.allCheckBox.setSelected(true);
        } else if (string.equals("group")) {
            this.allCheckBox.setSelected(true);
            this.groupCheckBox.setSelected(true);
        } else if (string.equals("category")) {
            this.classCheckBox.setSelected(true);
        } else if (string.equals("row")) {
            this.rowCheckBox.setSelected(true);
        } else if (string.equals("column")) {
            this.columnCheckBox.setSelected(true);
        }
    }

    public void setSelectedClass(InnerColumnClass innerColumnClass) {
        this.comboBoxClass.setSelectedItem(innerColumnClass);
    }

    public void updateClasses() {
        if (this.transformation != null && this.transformation.isLoaded()) {
            this.doevent = false;
            Object object = this.comboBoxClass.getSelectedItem();
            this.comboBoxClass.removeAllItems();
            AbstractDataInfo abstractDataInfo = this.transformation.getDataInfo();
            if (abstractDataInfo != null) {
                Transformations transformations = abstractDataInfo.getTransformationNode();
                int n = transformations.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    if (transformations.getColumnType(i) != 4) continue;
                    this.comboBoxClass.addItem(transformations.getInnerColumn(i));
                }
                PredictionClasses predictionClasses = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
                if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
                    for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                        this.comboBoxClass.addItem(predictionClasses.getInnerColumn(i));
                    }
                }
            }
            if (object != null) {
                this.comboBoxClass.setSelectedItem(object);
            }
            this.classCheckBox.setEnabled(this.comboBoxClass.getItemCount() > 0);
            this.doevent = true;
        }
    }

    @Override
    protected void cleanUpChild() {
        this.transformation = null;
    }

    private void setEnabled() {
        this.groupSize.setEnabled(this.allCheckBox.isSelected() && this.groupCheckBox.isSelected());
        this.groupCheckBox.setEnabled(!this.classCheckBox.isSelected());
        this.comboBoxClass.setEnabled(this.classCheckBox.isSelected());
    }

    class CItemListener
    implements ItemListener {
        CItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && SettingsPanel.this.doevent) {
                SettingsPanel.this.setEnabled();
                SettingsPanel.this.transformation.triggerEvent();
                if (SettingsPanel.this.getGroupType() == 2) {
                    // empty if block
                }
            }
        }
    }
}

