/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.savitzky;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.util.Properties;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.savitzky.SavitzkySettingsPanel;

public class Savitzky
extends AbstractDataTransform {
    public static final int Version = 2;
    public static final String Name = "Savitzky-Golay Smoothing";
    private SavitzkySettingsPanel settingsPanel = new SavitzkySettingsPanel(this);
    private int usedLeft = -1;
    private int usedRight = -1;
    private int usedPolyOrder = -1;
    private int usedDerivativeOrder = -1;
    private int usedVersion = 2;

    public Savitzky(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public Savitzky(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.usedLeft = mapProperty.getPropertyInt("ul", -1);
        this.usedRight = mapProperty.getPropertyInt("ur", -1);
        this.usedPolyOrder = mapProperty.getPropertyInt("upo", -1);
        this.usedDerivativeOrder = mapProperty.getPropertyInt("udo", -1);
        this.usedVersion = mapProperty.getPropertyInt("vr", 1);
        this.settingsPanel.setLeft(mapProperty.getPropertyInt("sl", 15));
        this.settingsPanel.setRight(mapProperty.getPropertyInt("sr", 15));
        this.settingsPanel.setPolynomOrder(mapProperty.getPropertyInt("spo", 4));
        this.settingsPanel.setDerivativeOrder(mapProperty.getPropertyInt("sdo", 0));
    }

    public Savitzky(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
        Savitzky savitzky = (Savitzky)abstractDataTransform;
        this.usedLeft = savitzky.usedLeft;
        this.usedRight = savitzky.usedRight;
        this.usedPolyOrder = savitzky.usedPolyOrder;
        this.usedDerivativeOrder = savitzky.usedDerivativeOrder;
        this.usedVersion = savitzky.usedVersion;
        this.settingsPanel.setLeft(savitzky.settingsPanel.getLeft());
        this.settingsPanel.setRight(savitzky.settingsPanel.getRight());
        this.settingsPanel.setPolynomOrder(savitzky.settingsPanel.getPolynomOrder());
        this.settingsPanel.setDerivativeOrder(savitzky.settingsPanel.getDerivativeOrder());
        this.settingsPanel.setVersion(savitzky.settingsPanel.getVersion());
    }

    @Override
    public boolean appliesToY() {
        return false;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        this.intermediateMatrix.beginCalculations();
        byte[] byArray = this.getIncludedData();
        boolean bl = !this.intermediateMatrix.isInDiskMode();
        Matrix matrix2 = bl ? this.intermediateMatrix.getInternalMatrixPublic() : null;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray != null && byArray[i] <= 0) continue;
            ++n3;
        }
        DenseVector denseVector = new DenseVector(n3 + this.usedLeft + this.usedRight);
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = this.usedLeft;
            for (int j = 0; j < n; ++j) {
                if (byArray != null && byArray[j] <= 0) continue;
                denseVector.set(n5++, abstractDataMatrix.getValue(i, j));
            }
            double d = denseVector.get(this.usedLeft);
            for (int j = 0; j < this.usedLeft; ++j) {
                denseVector.set(j, d);
            }
            double d2 = denseVector.get(n5 - 1);
            for (n4 = 0; n4 < this.usedRight; ++n4) {
                denseVector.set(n5 + n4, d2);
            }
            n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                if (byArray != null && byArray[n4] == 0) continue;
                double d3 = 0.0;
                if (bl) {
                    double[] dArray = denseVector.getData();
                    for (int j = 0; j < matrix2.numRows(); ++j) {
                        d3 += matrix2.get(j, 0) * dArray[n5 + j];
                    }
                } else {
                    for (int j = 0; j < this.intermediateMatrix.getN(); ++j) {
                        d3 += this.intermediateMatrix.getValue(j, 0) * denseVector.get(n5 + j);
                    }
                }
                abstractDataMatrix.setValue(i, n4, d3);
                ++n5;
            }
        }
        this.intermediateMatrix.endCalculations();
        return abstractDataMatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new Savitzky(transformations, this);
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public String getShortName() {
        return "Savitzky-Golay";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 10;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("ul", this.usedLeft);
        randomOutputStream.writePropertyInt("ur", this.usedRight);
        randomOutputStream.writePropertyInt("upo", this.usedPolyOrder);
        randomOutputStream.writePropertyInt("udo", this.usedDerivativeOrder);
        randomOutputStream.writePropertyInt("sl", this.settingsPanel.getLeft());
        randomOutputStream.writePropertyInt("sr", this.settingsPanel.getRight());
        randomOutputStream.writePropertyInt("spo", this.settingsPanel.getPolynomOrder());
        randomOutputStream.writePropertyInt("sdo", this.settingsPanel.getDerivativeOrder());
        randomOutputStream.writePropertyInt("vr", 2);
    }

    @Override
    public void setExtraArgument(Properties properties) {
        if (properties != null) {
            this.settingsPanel.setProperties(properties);
        } else {
            super.setExtraArgument(properties);
        }
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.usedLeft < 0 || this.usedRight < 0 || this.usedPolyOrder < 0 || this.usedDerivativeOrder < 0) {
            return 0.0;
        }
        int n5 = abstractDataMatrix.getK();
        if (this.isIncluded(n4)) {
            int n6;
            int n7;
            int[] nArray = abstractDataMatrix.getKref();
            DenseVector denseVector = new DenseVector(this.usedLeft + 1 + this.usedRight);
            denseVector.set(this.usedLeft, d);
            int n8 = this.usedLeft + 1;
            for (n7 = n2 + 1; n7 < n5 && n8 < denseVector.size(); ++n7) {
                if (!this.isIncluded(nArray, n7)) continue;
                denseVector.set(n8++, abstractDataMatrix.getValueBefore(this, n, n7));
            }
            if (n8 < denseVector.size()) {
                double d2 = denseVector.get(n8 - 1);
                for (n6 = n8; n6 < denseVector.size(); ++n6) {
                    denseVector.set(n6, d2);
                }
            }
            n8 = this.usedLeft - 1;
            for (n7 = n2 - 1; n7 >= 0 && n8 >= 0; --n7) {
                if (!this.isIncluded(nArray, n7)) continue;
                denseVector.set(n8--, abstractDataMatrix.getValueBefore(this, n, n7));
            }
            if (n8 >= 0) {
                double d3 = denseVector.get(n8 + 1);
                for (n6 = 0; n6 <= n8; ++n6) {
                    denseVector.set(n6, d3);
                }
            }
            n8 = 0;
            double d4 = 0.0;
            for (n6 = 0; n6 < denseVector.size(); ++n6) {
                d4 += this.intermediateMatrix.getValue(n6, 0) * denseVector.get(n6);
            }
            return d4;
        }
        return d;
    }

    @Override
    protected void calculateIntermediateMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, boolean bl) throws Exception {
        int n = this.settingsPanel.getLeft();
        int n2 = this.settingsPanel.getRight();
        int n3 = this.settingsPanel.getDerivativeOrder();
        int n4 = this.settingsPanel.getPolynomOrder();
        if (bl || this.usedLeft != n || this.usedRight != n2 || this.usedDerivativeOrder != n3 || this.usedPolyOrder != n4 || this.intermediateMatrix == null) {
            int n5;
            this.createIntermediateMatrix(abstractDataMatrix, n, n2);
            DenseMatrix denseMatrix = new DenseMatrix(n4 + 1, n4 + 1);
            for (int i = 0; i <= n4 * 2; ++i) {
                double d = i == 0 ? 1.0 : 0.0;
                for (n5 = 1; n5 <= n2; ++n5) {
                    d += Math.pow(n5, i);
                }
                for (n5 = 1; n5 <= n; ++n5) {
                    d += Math.pow(-n5, i);
                }
                n5 = Math.min(i, 2 * n4 - i);
                for (int j = -n5; j <= n5; j += 2) {
                    denseMatrix.set((i + j) / 2, (i - j) / 2, d);
                }
            }
            DenseMatrix denseMatrix2 = new DenseMatrix(n4 + 1, 1);
            denseMatrix2.set(n3, 0, 1.0);
            DenseLU denseLU = DenseLU.factorize((Matrix)denseMatrix);
            denseLU.solve(denseMatrix2);
            int n6 = -n;
            n5 = 0;
            while (n6 <= n2) {
                double d = denseMatrix2.get(0, 0);
                double d2 = n6;
                for (int i = 1; i <= n4; ++i) {
                    d += denseMatrix2.get(i, 0) * d2;
                    d2 *= (double)n6;
                }
                this.intermediateMatrix.setValue(n5, 0, d);
                ++n6;
                ++n5;
            }
            this.usedLeft = n;
            this.usedRight = n2;
            this.usedDerivativeOrder = n3;
            this.usedPolyOrder = n4;
        }
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.settingsPanel = null;
    }

    protected void createIntermediateMatrix(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (this.intermediateMatrix != null) {
            this.removeTreeNode(this.intermediateMatrix);
            this.intermediateMatrix.cleanUp();
        }
        this.intermediateMatrix = new MVmatrix(n + n2 + 1, 1, String.valueOf(this) + " interm");
        this.intermediateMatrix.setName("Savitzky-Golay coefficients");
        this.intermediateMatrix.setMatrixDataSetContainer(abstractDataMatrix.getCase());
        this.intermediateMatrix.setRowDescription(null);
        this.intermediateMatrix.setColumnDescription(null);
        this.addTreeNode(this.intermediateMatrix);
    }

    @Override
    protected void initiateGUILocal() {
        this.mainPanel.add((Component)this.settingsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public int getUsedLeft() {
        return this.usedLeft;
    }

    public int getUsedRight() {
        return this.usedRight;
    }

    public int getUsedPolyOrder() {
        return this.usedPolyOrder;
    }

    public int getUsedDerivativeOrder() {
        return this.usedDerivativeOrder;
    }

    public int getUsedVersion() {
        return this.usedVersion;
    }

    @Override
    public Properties getProperties() {
        return this.settingsPanel.getProperties();
    }

    public double[] createVector() {
        return Savitzky.createVector(this.usedLeft, this.usedRight, this.usedPolyOrder, this.usedDerivativeOrder);
    }

    public static double[] createVector(int n, int n2, int n3, int n4) {
        int n5;
        double[] dArray = new double[n + n2 + 1];
        DenseMatrix denseMatrix = new DenseMatrix(n3 + 1, n3 + 1);
        for (int i = 0; i <= n3 * 2; ++i) {
            double d = i == 0 ? 1.0 : 0.0;
            for (n5 = 1; n5 <= n2; ++n5) {
                d += Math.pow(n5, i);
            }
            for (n5 = 1; n5 <= n; ++n5) {
                d += Math.pow(-n5, i);
            }
            n5 = Math.min(i, 2 * n3 - i);
            for (int j = -n5; j <= n5; j += 2) {
                denseMatrix.set((i + j) / 2, (i - j) / 2, d);
            }
        }
        DenseMatrix denseMatrix2 = new DenseMatrix(n3 + 1, 1);
        denseMatrix2.set(n4, 0, 1.0);
        DenseLU denseLU = DenseLU.factorize((Matrix)denseMatrix);
        denseLU.solve(denseMatrix2);
        int n6 = -n;
        n5 = 0;
        while (n6 <= n2) {
            double d = denseMatrix2.get(0, 0);
            double d2 = n6;
            for (int i = 1; i <= n3; ++i) {
                d += denseMatrix2.get(i, 0) * d2;
                d2 *= (double)n6;
            }
            dArray[n5] = d;
            ++n6;
            ++n5;
        }
        return dArray;
    }
}

