/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.savitzky;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.transform.savitzky.Savitzky;
import se.prediktera.map.main.script.ScriptHelper;

public class SavitzkySettingsPanel
extends JPanel
implements JValidateNumberField.NumberChangedInterface {
    private final JTextFieldButtonUppDown polyOrder = new JTextFieldButtonUppDown(0.0, 2.147483647E9, false);
    private final JTextFieldButtonUppDown derivOrder = new JTextFieldButtonUppDown(0.0, 2.147483647E9, false);
    private final JTextFieldButtonUppDown left = new JTextFieldButtonUppDown(0.0, 2.147483647E9, false);
    private final JTextFieldButtonUppDown right = new JTextFieldButtonUppDown(0.0, 2.147483647E9, false);
    private int version = 2;
    private final Savitzky transformation;

    public SavitzkySettingsPanel(Savitzky savitzky) {
        super(new GridBagLayout());
        this.setup();
        this.transformation = savitzky;
    }

    public int getDerivativeOrder() {
        return (int)this.derivOrder.getNumber();
    }

    public int getLeft() {
        return (int)this.left.getNumber();
    }

    public int getPolynomOrder() {
        return (int)this.polyOrder.getNumber();
    }

    public int getRight() {
        return (int)this.right.getNumber();
    }

    public boolean hasDerivative() {
        return this.derivOrder.getNumber() > 0.0;
    }

    @Override
    public void NumberChanged(int n, double d) {
        this.polyOrder.setMinMax(this.derivOrder.getNumber(), this.left.getNumber() + this.right.getNumber());
        this.derivOrder.setMinMax(0.0, this.left.getNumber() + this.right.getNumber());
        this.transformation.triggerEvent((byte)16);
    }

    public void setDerivativeOrder(int n) {
        this.derivOrder.setNumber(n);
    }

    public void setLeft(int n) {
        this.left.setNumber(n);
    }

    public void setPolynomOrder(int n) {
        this.polyOrder.setNumber(n);
    }

    public void setRight(int n) {
        this.right.setNumber(n);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    private final void setup() {
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Settings"));
        this.add((Component)new JLabel("Polynomial order"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.polyOrder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Derivative order"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.derivOrder, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Left points"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.left, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.add((Component)new JLabel("Right points"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.right, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 12, 6, 6), 0, 0));
        this.polyOrder.setNumber(4.0);
        this.derivOrder.setNumber(0.0);
        this.left.setNumber(15.0);
        this.right.setNumber(15.0);
        this.polyOrder.setNumberChangedInterface(this);
        this.derivOrder.setNumberChangedInterface(this);
        this.left.setNumberChangedInterface(this);
        this.right.setNumberChangedInterface(this);
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "polynomialorder")) {
                this.setPolynomOrder(ScriptHelper.getPropertyInt(properties, "polynomialorder"));
            }
            if (ScriptHelper.hasKey(properties, "derivativeorder")) {
                this.setDerivativeOrder(ScriptHelper.getPropertyInt(properties, "derivativeorder"));
            }
            if (ScriptHelper.hasKey(properties, "leftpoints")) {
                this.setLeft(ScriptHelper.getPropertyInt(properties, "leftpoints"));
            }
            if (ScriptHelper.hasKey(properties, "rightpoints")) {
                this.setRight(ScriptHelper.getPropertyInt(properties, "rightpoints"));
            }
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("polynomialorder", String.valueOf((int)this.polyOrder.getNumber()));
        properties.put("derivativeorder", String.valueOf((int)this.derivOrder.getNumber()));
        properties.put("leftpoints", String.valueOf((int)this.left.getNumber()));
        properties.put("rightpoints", String.valueOf((int)this.right.getNumber()));
        properties.put("version", String.valueOf(this.getVersion()));
        return properties;
    }
}

