/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.transform.snv;

import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class SnvTransform
extends AbstractDataTransform {
    public static final String Name = "Standard Normal Variate correction";
    private final double[] cacheResult = new double[2];
    private int cacheRow;
    private AbstractDataMatrix cacheMatrix;

    public SnvTransform(AbstractDataInfo abstractDataInfo, boolean bl) {
        super(abstractDataInfo, bl);
    }

    public SnvTransform(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public SnvTransform(Transformations transformations, AbstractDataTransform abstractDataTransform) {
        super(transformations, abstractDataTransform);
    }

    @Override
    public boolean appliesToY() {
        return false;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(final AbstractDataMatrix abstractDataMatrix, final Matrix matrix, final ProgressManager progressManager) throws Exception {
        final int n = abstractDataMatrix.getK();
        final double d = 1.0 / (double)n;
        final double d2 = 1.0 / (double)(n - 1);
        int n2 = abstractDataMatrix.getN();
        final byte[] byArray = this.getIncludedData();
        final int[] nArray = abstractDataMatrix.getMissingCountForRows(false);
        final boolean bl = !abstractDataMatrix.hasMissing() && !this.hasUserdefinedValues();
        Threader threader = new Threader(this){
            final /* synthetic */ SnvTransform this$0;
            {
                this.this$0 = snvTransform;
            }

            @Override
            protected void doOp(boolean bl2, int n4, int n2) {
                if (bl) {
                    for (int i = n4; i < n2; ++i) {
                        double d11 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            d11 += matrix.get(i, j);
                        }
                        d11 *= d;
                        double d22 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            double d3 = d11 - matrix.get(i, j);
                            d22 += d3 * d3;
                        }
                        double d4 = Math.sqrt(d22 * d2);
                        if (d4 != 0.0) {
                            double d5 = 1.0 / d4;
                            for (int j = 0; j < n; ++j) {
                                matrix.set(i, j, (matrix.get(i, j) - d11) * d5);
                            }
                        }
                        if (progressManager == null) continue;
                        progressManager.incStep(n);
                    }
                } else {
                    for (int i = n4; i < n2; ++i) {
                        double d12;
                        int n3 = nArray != null ? nArray[i] : 0;
                        double d6 = 0.0;
                        if (n3 > 0) {
                            for (var8_17 = 0; var8_17 < n; ++var8_17) {
                                if (byArray != null && byArray[var8_17] <= 0 || this.this$0.isMissing(i, var8_17)) continue;
                                d6 += matrix.get(i, var8_17);
                            }
                        } else {
                            for (var8_17 = 0; var8_17 < n; ++var8_17) {
                                if (byArray != null && byArray[var8_17] <= 0) continue;
                                d6 += matrix.get(i, var8_17);
                            }
                        }
                        d6 /= (double)(n - n3);
                        double d7 = 0.0;
                        if (n3 > 0) {
                            for (var12_21 = 0; var12_21 < n; ++var12_21) {
                                if (byArray != null && byArray[var12_21] <= 0 || this.this$0.isMissing(i, var12_21)) continue;
                                double d8 = d6 - matrix.get(i, var12_21);
                                d7 += d8 * d8;
                            }
                        } else {
                            for (var12_21 = 0; var12_21 < n; ++var12_21) {
                                if (byArray != null && byArray[var12_21] <= 0) continue;
                                double d9 = d6 - matrix.get(i, var12_21);
                                d7 += d9 * d9;
                            }
                        }
                        if ((d12 = Math.sqrt(d7 / (double)(n - 1 - n3))) != 0.0) {
                            for (int j = 0; j < n; ++j) {
                                if (byArray != null && byArray[j] <= 0 || n3 != 0 && abstractDataMatrix.isMissing(i, j)) continue;
                                double d10 = matrix.get(i, j) - d6;
                                matrix.set(i, j, d10 / d12);
                            }
                        }
                        if (progressManager == null) continue;
                        progressManager.incStep(n);
                    }
                }
            }
        };
        threader.execute(n2);
        return abstractDataMatrix;
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.cacheMatrix = null;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new SnvTransform(transformations, this);
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public String getShortName() {
        return "SNV";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localUpdate;
    }

    @Override
    public byte getTreeType() {
        return 11;
    }

    @Override
    public double transformValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3, int n4, double d) {
        if (this.isIncluded(n4)) {
            if (abstractDataMatrix != this.cacheMatrix || n != this.cacheRow) {
                this.cacheMatrix = abstractDataMatrix;
                this.cacheRow = n;
                InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
                double d2 = abstractDataMatrix.getRowMean(n, innerColumnBoolean, this);
                double d3 = abstractDataMatrix.calculateStd(n, d2, innerColumnBoolean, this);
                this.cacheResult[0] = d2;
                this.cacheResult[1] = d3;
            }
            return (d - this.cacheResult[0]) / this.cacheResult[1];
        }
        return d;
    }

    @Override
    protected byte changeEffects() {
        return 2;
    }

    @Override
    protected String getWorkflowName() {
        return "SNV";
    }
}

